/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.types.request.td;

import es.bsc.compss.components.impl.TaskScheduler;
import es.bsc.compss.types.request.exceptions.ShutdownException;
import es.bsc.compss.types.request.td.TDRequest;
import es.bsc.compss.types.request.td.TDRequestType;
import es.bsc.compss.types.resources.Worker;
import es.bsc.compss.types.resources.WorkerResourceDescription;
import es.bsc.compss.types.resources.updates.ResourceUpdate;

public class WorkerRestartRequest<T extends WorkerResourceDescription>
extends TDRequest {
    private final Worker<T> worker;
    private final ResourceUpdate<T> ru;

    public WorkerRestartRequest(Worker<T> worker, ResourceUpdate<T> update) {
        this.worker = worker;
        this.ru = update;
    }

    public Worker<T> getWorker() {
        return this.worker;
    }

    @Override
    public void process(TaskScheduler ts) throws ShutdownException {
        ts.restartWorker(this.worker, this.ru);
    }

    @Override
    public TDRequestType getType() {
        return TDRequestType.WORKER_RESTART_REQUEST;
    }
}

