/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.util;

import es.bsc.compss.util.Serializer;
import es.bsc.compss.util.TraceEvent;
import es.bsc.compss.util.Tracer;
import java.io.File;
import java.io.IOException;
import java.nio.file.AtomicMoveNotSupportedException;
import java.nio.file.DirectoryNotEmptyException;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.commons.io.FileExistsException;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FileOpsManager {
    private static final Logger LOGGER = LogManager.getLogger("es.bsc.compss.Communication");
    public static final boolean DEBUG = LOGGER.isDebugEnabled();
    private static final ExecutorService HIGH_PRIORITY;
    private static final ExecutorService LOW_PRIORITY;
    private static final FileOpListener IGNORE_LISTENER;

    public static void composedOperationAsync(Runnable composition) {
        FileOpsManager.composedOperationAsync(composition, IGNORE_LISTENER);
    }

    public static void composedOperationAsync(Runnable composition, FileOpListener listener) {
        HIGH_PRIORITY.execute(composition);
    }

    public static void copyAsync(File src, File tgt) {
        FileOpsManager.copyAsync(src, tgt, IGNORE_LISTENER);
    }

    public static void copyAsync(final File src, final File tgt, final FileOpListener listener) {
        if (src != null) {
            LOW_PRIORITY.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        FileOpsManager.copyFile(src, tgt);
                        listener.completed();
                    }
                    catch (IOException ioe) {
                        listener.failed(ioe);
                    }
                }
            });
        }
    }

    public static void copySync(File src, File tgt) throws IOException {
        FileOpsManager.copyFile(src, tgt);
    }

    public static void copyDirAsync(File src, File tgt) {
        FileOpsManager.copyDirAsync(src, tgt, IGNORE_LISTENER);
    }

    public static void copyDirAsync(final File src, final File tgt, final FileOpListener listener) {
        if (src != null) {
            LOW_PRIORITY.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        FileOpsManager.copyDirectory(src, tgt);
                        listener.completed();
                    }
                    catch (IOException ioe) {
                        listener.failed(ioe);
                    }
                }
            });
        }
    }

    public static void copyDirSync(File src, File tgt) throws IOException {
        FileOpsManager.copyDirectory(src, tgt);
    }

    public static void deleteAsync(File file) {
        FileOpsManager.deleteAsync(file, IGNORE_LISTENER);
    }

    public static void deleteAsync(final File file, final FileOpListener listener) {
        if (file != null) {
            LOW_PRIORITY.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        FileOpsManager.deleteFile(file);
                        listener.completed();
                    }
                    catch (IOException ioe) {
                        listener.failed(ioe);
                    }
                }
            });
        }
    }

    public static void deleteSync(File file) throws IOException {
        FileOpsManager.deleteFile(file);
    }

    public static void moveAsync(File src, File tgt) {
        FileOpsManager.moveAsync(src, tgt, IGNORE_LISTENER);
    }

    public static void moveAsync(final File src, final File tgt, final FileOpListener listener) {
        if (src != null) {
            LOW_PRIORITY.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        FileOpsManager.moveFile(src, tgt);
                        listener.completed();
                    }
                    catch (IOException ioe) {
                        listener.failed(ioe);
                    }
                }
            });
        }
    }

    public static void moveSync(File src, File tgt) throws IOException {
        FileOpsManager.moveFile(src, tgt);
    }

    public static void moveDirAsync(File src, File tgt) {
        FileOpsManager.moveDirAsync(src, tgt, IGNORE_LISTENER);
    }

    public static void moveDirAsync(final File src, final File tgt, final FileOpListener listener) {
        if (src != null) {
            LOW_PRIORITY.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        FileOpsManager.moveDirectory(src, tgt);
                        listener.completed();
                    }
                    catch (IOException ioe) {
                        listener.failed(ioe);
                    }
                }
            });
        }
    }

    public static void moveDirSync(File src, File tgt) throws IOException {
        FileOpsManager.moveDirectory(src, tgt);
    }

    public static void serializeAsync(Object o, String tgt) {
        FileOpsManager.serializeAsync(o, tgt, IGNORE_LISTENER);
    }

    public static void serializeAsync(final Object o, final String tgt, final FileOpListener listener) {
        LOW_PRIORITY.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    FileOpsManager.serialize(o, tgt);
                    listener.completed();
                }
                catch (IOException ioe) {
                    listener.failed(ioe);
                }
            }
        });
    }

    public static void serializeSync(Object o, String tgt) throws IOException {
        FileOpsManager.serialize(o, tgt);
    }

    public static void shutdown() {
        LOW_PRIORITY.shutdown();
        HIGH_PRIORITY.shutdown();
    }

    private static void serialize(Object o, String target) throws IOException {
        if (DEBUG) {
            LOGGER.debug("Serializing object to " + target);
        }
        if (Tracer.extraeEnabled()) {
            Tracer.emitEvent(TraceEvent.LOCAL_SERIALIZE.getId(), TraceEvent.LOCAL_SERIALIZE.getType());
        }
        try {
            Serializer.serialize(o, target);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        finally {
            if (Tracer.extraeEnabled()) {
                Tracer.emitEvent(0L, TraceEvent.LOCAL_SERIALIZE.getType());
            }
        }
    }

    private static void copyFile(File source, File target) throws IOException {
        if (DEBUG) {
            LOGGER.debug("Copying file " + source.getAbsolutePath() + " to " + target.getAbsolutePath());
        }
        if (Tracer.extraeEnabled()) {
            Tracer.emitEvent(TraceEvent.LOCAL_COPY.getId(), TraceEvent.LOCAL_COPY.getType());
        }
        Path tgtPath = target.toPath();
        Path sourcePath = source.toPath();
        try {
            if (tgtPath.compareTo(sourcePath) != 0) {
                Files.copy(sourcePath, tgtPath, StandardCopyOption.REPLACE_EXISTING);
                Files.walk(sourcePath, new FileVisitOption[0]).forEach(content -> {
                    try {
                        Path fileDest = tgtPath.resolve(sourcePath.relativize((Path)content));
                        Files.copy(content, fileDest, StandardCopyOption.REPLACE_EXISTING);
                    }
                    catch (IOException e) {
                        LOGGER.error("Exception copying file " + content + " to " + tgtPath);
                    }
                });
            }
        }
        catch (IOException ioe) {
            throw ioe;
        }
        finally {
            if (Tracer.extraeEnabled()) {
                Tracer.emitEvent(0L, TraceEvent.LOCAL_COPY.getType());
            }
        }
    }

    private static void copyDirectory(File source, File target) throws IOException {
        if (DEBUG) {
            LOGGER.debug("Copying directory " + source.getAbsolutePath() + " to " + target.getAbsolutePath());
        }
        if (Tracer.extraeEnabled()) {
            Tracer.emitEvent(TraceEvent.LOCAL_COPY.getId(), TraceEvent.LOCAL_COPY.getType());
        }
        try {
            FileUtils.copyDirectory(source, target);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        finally {
            if (Tracer.extraeEnabled()) {
                Tracer.emitEvent(0L, TraceEvent.LOCAL_COPY.getType());
            }
        }
    }

    private static void deleteFile(File f) throws IOException {
        if (DEBUG) {
            LOGGER.debug("Deleting file " + f.getAbsolutePath());
        }
        if (Tracer.extraeEnabled()) {
            Tracer.emitEvent(TraceEvent.LOCAL_DELETE.getId(), TraceEvent.LOCAL_DELETE.getType());
        }
        try {
            if (!Files.deleteIfExists(f.toPath()) && DEBUG) {
                LOGGER.debug("File " + f.getAbsolutePath() + " not deleted.");
            }
        }
        catch (DirectoryNotEmptyException dne) {
            Path directory = f.toPath();
            try {
                Files.walkFileTree(directory, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult visitFile(Path file, BasicFileAttributes attributes) throws IOException {
                        Files.delete(file);
                        return FileVisitResult.CONTINUE;
                    }

                    @Override
                    public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                        Files.delete(dir);
                        return FileVisitResult.CONTINUE;
                    }
                });
            }
            catch (IOException e) {
                LOGGER.error("Cannot delete directory " + f.getAbsolutePath(), (Throwable)e);
                throw e;
            }
            if (Tracer.extraeEnabled()) {
                Tracer.emitEvent(0L, TraceEvent.LOCAL_DELETE.getType());
            }
        }
        catch (Exception e) {
            LOGGER.error("Cannot delete file " + f.getAbsolutePath(), (Throwable)e);
            throw e;
        }
        finally {
            if (Tracer.extraeEnabled()) {
                Tracer.emitEvent(0L, TraceEvent.LOCAL_DELETE.getType());
            }
        }
    }

    private static void moveFile(File source, File target) throws IOException {
        block12: {
            if (DEBUG) {
                LOGGER.debug("Moving file " + source.getAbsolutePath() + " to " + target.getAbsolutePath());
            }
            if (Tracer.extraeEnabled()) {
                Tracer.emitEvent(TraceEvent.LOCAL_MOVE.getId(), TraceEvent.LOCAL_MOVE.getType());
            }
            Path tgtPath = target.toPath();
            Path sourcePath = source.toPath();
            try {
                if (tgtPath.compareTo(sourcePath) == 0) break block12;
                try {
                    Files.move(sourcePath, tgtPath, StandardCopyOption.ATOMIC_MOVE, StandardCopyOption.REPLACE_EXISTING);
                }
                catch (AtomicMoveNotSupportedException amnse) {
                    LOGGER.warn("WARN: AtomicMoveNotSupportedException. File cannot be atomically moved. Trying to move without atomic");
                    try {
                        Files.move(sourcePath, tgtPath, StandardCopyOption.REPLACE_EXISTING);
                    }
                    catch (DirectoryNotEmptyException dnee) {
                        LOGGER.warn("WARN: Trying to move a directory as a file");
                        FileOpsManager.moveDirectory(source, target);
                    }
                }
            }
            catch (IOException ioe) {
                throw ioe;
            }
            finally {
                if (Tracer.extraeEnabled()) {
                    Tracer.emitEvent(0L, TraceEvent.LOCAL_MOVE.getType());
                }
            }
        }
    }

    private static void moveDirectory(File source, File target) throws IOException {
        if (DEBUG) {
            LOGGER.debug("Moving directory " + source.getAbsolutePath() + " to " + target.getAbsolutePath());
        }
        if (Tracer.extraeEnabled()) {
            Tracer.emitEvent(TraceEvent.LOCAL_MOVE.getId(), TraceEvent.LOCAL_MOVE.getType());
        }
        try {
            FileUtils.moveDirectory(source, target);
        }
        catch (FileExistsException fee) {
            FileOpsManager.deleteFile(target);
            FileUtils.moveDirectory(source, target);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        finally {
            if (Tracer.extraeEnabled()) {
                Tracer.emitEvent(0L, TraceEvent.LOCAL_MOVE.getType());
            }
        }
    }

    static {
        if (Tracer.extraeEnabled() && Tracer.basicModeEnabled()) {
            Tracer.enablePThreads(2);
        }
        LOW_PRIORITY = Executors.newSingleThreadExecutor();
        HIGH_PRIORITY = Executors.newFixedThreadPool(1);
        Future<Object> low = LOW_PRIORITY.submit(new Callable<Object>(){

            @Override
            public Object call() {
                Thread.currentThread().setPriority(1);
                Thread.currentThread().setName("Low priority FS");
                if (Tracer.extraeEnabled()) {
                    if (Tracer.basicModeEnabled()) {
                        Tracer.disablePThreads(1);
                    }
                    Tracer.emitEvent(TraceEvent.LOW_FILE_SYS_THREAD_ID.getId(), TraceEvent.LOW_FILE_SYS_THREAD_ID.getType());
                    TraceEvent teInit = TraceEvent.INIT_FS;
                    Tracer.emitEvent(teInit.getId(), teInit.getType());
                    Tracer.emitEvent(0L, TraceEvent.INIT_FS.getType());
                }
                return new Object();
            }
        });
        Future<Object> high = HIGH_PRIORITY.submit(new Callable<Object>(){

            @Override
            public Object call() {
                Thread.currentThread().setName("High priority FS");
                if (Tracer.extraeEnabled()) {
                    if (Tracer.basicModeEnabled()) {
                        Tracer.disablePThreads(1);
                    }
                    Tracer.emitEvent(TraceEvent.HIGH_FILE_SYS_THREAD_ID.getId(), TraceEvent.HIGH_FILE_SYS_THREAD_ID.getType());
                    TraceEvent teInit = TraceEvent.INIT_FS;
                    Tracer.emitEvent(teInit.getId(), teInit.getType());
                    Tracer.emitEvent(0L, TraceEvent.INIT_FS.getType());
                }
                return new Object();
            }
        });
        try {
            low.get();
            high.get();
        }
        catch (Exception exception) {
            // empty catch block
        }
        IGNORE_LISTENER = new FileOpListener(){

            @Override
            public void completed() {
            }

            @Override
            public void failed(IOException e) {
            }
        };
    }

    public static interface FileOpListener {
        public void completed();

        public void failed(IOException var1);
    }
}

