/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.components.monitor.impl;

import es.bsc.compss.comm.Comm;
import es.bsc.compss.types.Task;
import es.bsc.compss.util.ErrorManager;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.HashSet;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class GraphGenerator {
    private static final boolean monitorEnabled = System.getProperty("compss.monitor") != null && !"0".equals(System.getProperty("compss.monitor"));
    private static final boolean drawGraph = System.getProperty("compss.graph") != null && "true".equals(System.getProperty("compss.graph"));
    private static final boolean graphGeneratorEnabled = monitorEnabled || drawGraph;
    private static final String CURRENT_GRAPH_FILENAME = "current_graph.dot";
    private static final String COMPLETE_GRAPH_FILENAME = "complete_graph.dot";
    private static final String COMPLETE_GRAPH_TMP_FILENAME = "complete_graph.dot.tmp";
    private static final String COMPLETE_LEGEND_TMP_FILENAME = "complete_legend.dot.tmp";
    private static final String MONITOR_DIR_PATH;
    private static final String CURRENT_GRAPH_FILE;
    private static final String COMPLETE_GRAPH_FILE;
    private static final String COMPLETE_GRAPH_TMP_FILE;
    private static final String COMPLETE_LEGEND_TMP_FILE;
    private static BufferedWriter full_graph;
    private static BufferedWriter current_graph;
    private static BufferedWriter legend;
    private static HashSet<Integer> legendTasks;
    private static final Logger logger;
    private static final String ERROR_MONITOR_DIR = "ERROR: Cannot create monitor directory";
    private static final String ERROR_ADDING_DATA = "Error adding task to graph file";
    private static final String ERROR_ADDING_EDGE = "Error adding edge to graph file";
    private static final String ERROR_OPEN_CURRENT_GRAPH = "Error openning current graph file";
    private static final String ERROR_CLOSE_CURRENT_GRAPH = "Error closing current graph file";
    private static final String ERROR_COMMIT_FINAL_GRAPH = "Error commiting full graph to file";

    public static boolean isEnabled() {
        return graphGeneratorEnabled;
    }

    public static String getMonitorDirPath() {
        return MONITOR_DIR_PATH;
    }

    public BufferedWriter getAndOpenCurrentGraph() {
        try {
            current_graph = new BufferedWriter(new FileWriter(CURRENT_GRAPH_FILE));
            GraphGenerator.openGraphFile(current_graph);
        }
        catch (IOException e) {
            logger.error(ERROR_OPEN_CURRENT_GRAPH);
            return null;
        }
        return current_graph;
    }

    public void closeCurrentGraph() {
        try {
            GraphGenerator.closeGraphFile(current_graph);
            current_graph.close();
        }
        catch (IOException e) {
            logger.error(ERROR_CLOSE_CURRENT_GRAPH);
        }
    }

    public void commitGraph() {
        logger.debug("Commiting graph to final location");
        try {
            full_graph.close();
            AbstractInterruptibleChannel sourceChannel = null;
            AbstractInterruptibleChannel destChannel = null;
            try (FileInputStream sourceFIS = new FileInputStream(COMPLETE_GRAPH_TMP_FILE);
                 FileOutputStream destFOS = new FileOutputStream(COMPLETE_GRAPH_FILE);){
                sourceChannel = sourceFIS.getChannel();
                destChannel = destFOS.getChannel();
                ((FileChannel)destChannel).transferFrom((ReadableByteChannel)((Object)sourceChannel), 0L, ((FileChannel)sourceChannel).size());
            }
            catch (IOException ioe) {
                throw ioe;
            }
            finally {
                if (sourceChannel != null) {
                    sourceChannel.close();
                }
                if (destChannel != null) {
                    destChannel.close();
                }
            }
            full_graph = new BufferedWriter(new FileWriter(COMPLETE_GRAPH_TMP_FILE, true));
            BufferedWriter finalGraph = new BufferedWriter(new FileWriter(COMPLETE_GRAPH_FILE, true));
            GraphGenerator.closeDependenceGraph(finalGraph);
            GraphGenerator.openLegend(finalGraph);
            legend.close();
            sourceChannel = null;
            destChannel = null;
            try (FileInputStream sourceFIS = new FileInputStream(COMPLETE_LEGEND_TMP_FILE);
                 FileOutputStream destFOS = new FileOutputStream(COMPLETE_GRAPH_FILE, true);){
                sourceChannel = sourceFIS.getChannel();
                destChannel = destFOS.getChannel();
                ((FileChannel)destChannel).position(((FileChannel)destChannel).size());
                ((FileChannel)sourceChannel).transferTo(0L, ((FileChannel)sourceChannel).size(), (WritableByteChannel)((Object)destChannel));
            }
            catch (IOException ioe) {
                throw ioe;
            }
            finally {
                if (sourceChannel != null) {
                    sourceChannel.close();
                }
                if (destChannel != null) {
                    destChannel.close();
                }
            }
            legend = new BufferedWriter(new FileWriter(COMPLETE_LEGEND_TMP_FILE, true));
            GraphGenerator.closeLegend(finalGraph);
            GraphGenerator.closeGraphFile(finalGraph);
            finalGraph.close();
        }
        catch (IOException e) {
            logger.error(ERROR_COMMIT_FINAL_GRAPH, (Throwable)e);
        }
    }

    public void addSynchroToGraph(int synchId) {
        try {
            full_graph.newLine();
            full_graph.write("Synchro" + synchId + "[label=\"sync\", shape=octagon, style=filled fillcolor=\"#ff0000\" fontcolor=\"#FFFFFF\"];");
        }
        catch (IOException e) {
            logger.error(ERROR_ADDING_DATA, (Throwable)e);
        }
    }

    public void addBarrierToGraph(int synchId) {
        try {
            full_graph.newLine();
            full_graph.write("Synchro" + synchId + "[label=\"barrier\", shape=octagon, style=filled fillcolor=\"#ff0000\" fontcolor=\"#FFFFFF\"];");
        }
        catch (IOException e) {
            logger.error(ERROR_ADDING_DATA, (Throwable)e);
        }
    }

    public void addTaskToGraph(Task task) {
        try {
            full_graph.newLine();
            full_graph.write(task.getDotDescription());
            int taskId = task.getTaskDescription().getId();
            if (!legendTasks.contains(taskId)) {
                legendTasks.add(taskId);
                legend.write(task.getLegendDescription());
            }
        }
        catch (IOException e) {
            logger.error(ERROR_ADDING_DATA, (Throwable)e);
        }
    }

    public void addEdgeToGraph(String src, String tgt, String label) {
        try {
            full_graph.newLine();
            full_graph.write(src + " -> " + tgt + (label.isEmpty() ? ";" : "[ label=\"d" + label + "\" ];"));
        }
        catch (IOException e) {
            logger.error(ERROR_ADDING_EDGE, (Throwable)e);
        }
    }

    public static void removeTemporaryGraph() {
        if (!new File(COMPLETE_GRAPH_TMP_FILE).delete()) {
            logger.error("Cannot remove temporary graph file");
        }
        if (!new File(COMPLETE_LEGEND_TMP_FILE).delete()) {
            logger.error("Cannot remove temporary legend file");
        }
    }

    private static void emptyFullGraph() throws IOException {
        GraphGenerator.openGraphFile(full_graph);
        GraphGenerator.openDependenceGraph(full_graph);
        GraphGenerator.closeDependenceGraph(full_graph);
        GraphGenerator.openLegend(full_graph);
        GraphGenerator.closeLegend(full_graph);
        GraphGenerator.closeGraphFile(full_graph);
    }

    private static void emptyCurrentGraph() throws IOException {
        GraphGenerator.openGraphFile(current_graph);
        GraphGenerator.openDependenceGraph(current_graph);
        GraphGenerator.closeDependenceGraph(current_graph);
        GraphGenerator.closeGraphFile(current_graph);
    }

    private static void openGraphFile(BufferedWriter graph) throws IOException {
        graph.write("digraph {");
        graph.newLine();
        graph.write("  rankdir=TB;");
        graph.newLine();
        graph.write("  labeljust=\"l\";");
        graph.newLine();
        graph.flush();
    }

    private static void openDependenceGraph(BufferedWriter graph) throws IOException {
        graph.write("  subgraph dependence_graph {");
        graph.newLine();
        graph.write("    ranksep=0.20;");
        graph.newLine();
        graph.write("    node[height=0.75];");
        graph.newLine();
        graph.flush();
    }

    private static void openLegend(BufferedWriter graph) throws IOException {
        graph.write("  subgraph legend {");
        graph.newLine();
        graph.write("    rank=sink;");
        graph.newLine();
        graph.write("    node [shape=plaintext, height=0.75];");
        graph.newLine();
        graph.write("    ranksep=0.20;");
        graph.newLine();
        graph.write("    label = \"Legend\";");
        graph.newLine();
        graph.write("    key [label=<");
        graph.newLine();
        graph.write("      <table border=\"0\" cellpadding=\"2\" cellspacing=\"0\" cellborder=\"1\">");
        graph.newLine();
        graph.flush();
    }

    private static void closeGraphFile(BufferedWriter graph) throws IOException {
        graph.write("}");
        graph.newLine();
        graph.flush();
    }

    private static void closeDependenceGraph(BufferedWriter graph) throws IOException {
        graph.write("  }");
        graph.newLine();
        graph.flush();
    }

    private static void closeLegend(BufferedWriter graph) throws IOException {
        graph.write("      </table>");
        graph.newLine();
        graph.write("    >]");
        graph.newLine();
        graph.write("  }");
        graph.newLine();
        graph.flush();
    }

    static {
        logger = LogManager.getLogger("es.bsc.compss.Components");
        if (graphGeneratorEnabled) {
            MONITOR_DIR_PATH = Comm.getAppHost().getAppLogDirPath() + "monitor" + File.separator;
            if (!new File(MONITOR_DIR_PATH).mkdir()) {
                ErrorManager.error(ERROR_MONITOR_DIR);
            }
            CURRENT_GRAPH_FILE = MONITOR_DIR_PATH + CURRENT_GRAPH_FILENAME;
            COMPLETE_GRAPH_FILE = MONITOR_DIR_PATH + COMPLETE_GRAPH_FILENAME;
            COMPLETE_GRAPH_TMP_FILE = MONITOR_DIR_PATH + COMPLETE_GRAPH_TMP_FILENAME;
            COMPLETE_LEGEND_TMP_FILE = MONITOR_DIR_PATH + COMPLETE_LEGEND_TMP_FILENAME;
            try {
                current_graph = new BufferedWriter(new FileWriter(CURRENT_GRAPH_FILE));
                GraphGenerator.emptyCurrentGraph();
                current_graph.close();
            }
            catch (IOException ioe) {
                logger.error("Error generating current graph file", (Throwable)ioe);
            }
            try {
                full_graph = new BufferedWriter(new FileWriter(COMPLETE_GRAPH_FILE));
                GraphGenerator.emptyFullGraph();
                full_graph.close();
            }
            catch (IOException ioe) {
                logger.error("Error generating full graph file", (Throwable)ioe);
            }
            try {
                full_graph = new BufferedWriter(new FileWriter(COMPLETE_GRAPH_TMP_FILE));
                GraphGenerator.openGraphFile(full_graph);
                GraphGenerator.openDependenceGraph(full_graph);
            }
            catch (IOException ioe) {
                logger.error("Error generating graph file", (Throwable)ioe);
            }
            try {
                legend = new BufferedWriter(new FileWriter(COMPLETE_LEGEND_TMP_FILE));
            }
            catch (IOException ioe) {
                logger.error("Error generating full graph working copy file", (Throwable)ioe);
            }
            legendTasks = new HashSet();
        } else {
            MONITOR_DIR_PATH = null;
            CURRENT_GRAPH_FILE = CURRENT_GRAPH_FILENAME;
            COMPLETE_GRAPH_FILE = COMPLETE_GRAPH_FILENAME;
            COMPLETE_GRAPH_TMP_FILE = COMPLETE_GRAPH_TMP_FILENAME;
            COMPLETE_LEGEND_TMP_FILE = COMPLETE_LEGEND_TMP_FILENAME;
        }
    }
}

