/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.types.data;

import es.bsc.compss.comm.Comm;
import es.bsc.compss.types.data.DataVersion;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.TreeMap;

public abstract class DataInfo {
    private static final int FIRST_FILE_ID = 1;
    private static final int FIRST_VERSION_ID = 1;
    protected static int nextDataId = 1;
    protected int dataId = nextDataId++;
    protected DataVersion currentVersion;
    protected int currentVersionId = 1;
    protected TreeMap<Integer, DataVersion> versions = new TreeMap();
    protected int deletionBlocks;
    protected final LinkedList<DataVersion> pendingDeletions;

    public DataInfo() {
        this.currentVersion = new DataVersion(this.dataId, 1);
        Comm.registerData(this.currentVersion.getDataInstanceId().getRenaming());
        this.versions.put(this.currentVersionId, this.currentVersion);
        this.deletionBlocks = 0;
        this.pendingDeletions = new LinkedList();
    }

    public int getDataId() {
        return this.dataId;
    }

    public int getCurrentVersionId() {
        return this.currentVersionId;
    }

    public DataVersion getCurrentDataVersion() {
        return this.currentVersion;
    }

    public DataVersion getPreviousDataVersion() {
        return this.versions.get(this.currentVersionId - 1);
    }

    public void willBeRead() {
        this.currentVersion.willBeRead();
    }

    public boolean isToBeRead() {
        return this.currentVersion.hasPendingLectures();
    }

    public boolean versionHasBeenRead(int versionId) {
        DataVersion readVersion = this.versions.get(versionId);
        if (readVersion.hasBeenRead()) {
            Comm.removeData(readVersion.getDataInstanceId().getRenaming());
            this.versions.remove(versionId);
            return this.versions.isEmpty();
        }
        return false;
    }

    public void willBeWritten() {
        ++this.currentVersionId;
        DataVersion newVersion = new DataVersion(this.dataId, this.currentVersionId);
        Comm.registerData(newVersion.getDataInstanceId().getRenaming());
        newVersion.willBeWritten();
        this.versions.put(this.currentVersionId, newVersion);
        this.currentVersion = newVersion;
    }

    public boolean versionHasBeenWritten(int versionId) {
        DataVersion writtenVersion = this.versions.get(versionId);
        if (writtenVersion.hasBeenWritten()) {
            Comm.removeData(writtenVersion.getDataInstanceId().getRenaming());
            this.versions.remove(versionId);
            return this.versions.isEmpty();
        }
        return false;
    }

    public void blockDeletions() {
        ++this.deletionBlocks;
    }

    public boolean unblockDeletions() {
        --this.deletionBlocks;
        if (this.deletionBlocks == 0) {
            for (DataVersion version : this.pendingDeletions) {
                if (!version.delete()) continue;
                Comm.removeData(version.getDataInstanceId().getRenaming());
                this.versions.remove(version.getDataInstanceId().getVersionId());
            }
            if (this.versions.isEmpty()) {
                return true;
            }
        }
        return false;
    }

    public boolean delete() {
        if (this.deletionBlocks > 0) {
            this.pendingDeletions.addAll(this.versions.values());
        } else {
            LinkedList<Integer> removedVersions = new LinkedList<Integer>();
            for (DataVersion version : this.versions.values()) {
                if (!version.delete()) continue;
                Comm.removeData(version.getDataInstanceId().getRenaming());
                removedVersions.add(version.getDataInstanceId().getVersionId());
            }
            Iterator<DataVersion> iterator = removedVersions.iterator();
            while (iterator.hasNext()) {
                int versionId = (Integer)((Object)iterator.next());
                this.versions.remove(versionId);
            }
            if (this.versions.isEmpty()) {
                return true;
            }
        }
        return false;
    }

    public boolean isCurrentVersionToDelete() {
        return this.currentVersion.isToDelete();
    }

    public DataVersion getFirstVersion() {
        return this.versions.get(1);
    }
}

