/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.types.data;

import es.bsc.compss.types.BindingObject;
import es.bsc.compss.types.data.location.DataLocation;
import java.io.Serializable;

public class AccessParams
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final AccessMode mode;

    public AccessParams(AccessMode mode) {
        this.mode = mode;
    }

    public AccessMode getMode() {
        return this.mode;
    }

    public static class BindingObjectAccessParams
    extends AccessParams {
        private static final long serialVersionUID = 1L;
        private int hashCode;
        private BindingObject bindingObject;

        public BindingObjectAccessParams(AccessMode mode, BindingObject bo, int hashCode) {
            super(mode);
            this.bindingObject = bo;
            this.hashCode = hashCode;
        }

        public BindingObject getBindingObject() {
            return this.bindingObject;
        }

        public int getCode() {
            return this.hashCode;
        }
    }

    public static class ObjectAccessParams
    extends AccessParams {
        private static final long serialVersionUID = 1L;
        private int hashCode;
        private Object value;

        public ObjectAccessParams(AccessMode mode, Object value, int hashCode) {
            super(mode);
            this.value = value;
            this.hashCode = hashCode;
        }

        public Object getValue() {
            return this.value;
        }

        public int getCode() {
            return this.hashCode;
        }
    }

    public static class FileAccessParams
    extends AccessParams {
        private static final long serialVersionUID = 1L;
        private DataLocation loc;

        public FileAccessParams(AccessMode mode, DataLocation loc) {
            super(mode);
            this.loc = loc;
        }

        public DataLocation getLocation() {
            return this.loc;
        }
    }

    public static enum AccessMode {
        R,
        W,
        RW;

    }
}

