/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.api.impl;

import es.bsc.compss.COMPSsConstants;
import es.bsc.compss.api.COMPSsRuntime;
import es.bsc.compss.comm.Comm;
import es.bsc.compss.components.impl.AccessProcessor;
import es.bsc.compss.components.impl.TaskDispatcher;
import es.bsc.compss.components.monitor.impl.GraphGenerator;
import es.bsc.compss.components.monitor.impl.RuntimeMonitor;
import es.bsc.compss.loader.LoaderAPI;
import es.bsc.compss.loader.total.ObjectRegistry;
import es.bsc.compss.scheduler.types.ActionOrchestrator;
import es.bsc.compss.types.BindingObject;
import es.bsc.compss.types.annotations.parameter.DataType;
import es.bsc.compss.types.annotations.parameter.Direction;
import es.bsc.compss.types.annotations.parameter.Stream;
import es.bsc.compss.types.data.AccessParams;
import es.bsc.compss.types.data.location.BindingObjectLocation;
import es.bsc.compss.types.data.location.DataLocation;
import es.bsc.compss.types.data.location.PersistentLocation;
import es.bsc.compss.types.implementations.AbstractMethodImplementation;
import es.bsc.compss.types.implementations.MethodImplementation;
import es.bsc.compss.types.parameter.BasicTypeParameter;
import es.bsc.compss.types.parameter.BindingObjectParameter;
import es.bsc.compss.types.parameter.ExternalPSCOParameter;
import es.bsc.compss.types.parameter.FileParameter;
import es.bsc.compss.types.parameter.ObjectParameter;
import es.bsc.compss.types.parameter.Parameter;
import es.bsc.compss.types.resources.MethodResourceDescription;
import es.bsc.compss.types.resources.Resource;
import es.bsc.compss.types.uri.MultiURI;
import es.bsc.compss.types.uri.SimpleURI;
import es.bsc.compss.util.ErrorManager;
import es.bsc.compss.util.RuntimeConfigManager;
import es.bsc.compss.util.Tracer;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class COMPSsRuntimeImpl
implements COMPSsRuntime,
LoaderAPI {
    private static final String WARN_IT_FILE_NOT_READ = "WARNING: COMPSs Properties file could not be read";
    private static final String WARN_FILE_EMPTY_DEFAULT = "WARNING: COMPSs Properties file is null. Setting default values";
    private static final String WARN_VERSION_PROPERTIES = "WARNING: COMPSs Runtime VERSION-BUILD properties file could not be read";
    private static final String ERROR_FILE_NAME = "ERROR: Cannot parse file name";
    private static final String ERROR_BINDING_OBJECT_PARAMS = "ERROR: Incorrect number of parameters for external objects";
    private static final String WARN_WRONG_DIRECTION = "WARNING: Invalid parameter direction: ";
    private static String COMPSs_VERSION = null;
    private static String COMPSs_BUILDNUMBER = null;
    private static boolean initialized = false;
    private static ObjectRegistry oReg;
    private static AccessProcessor ap;
    private static TaskDispatcher td;
    private static GraphGenerator graphMonitor;
    private static RuntimeMonitor runtimeMonitor;
    private static final Logger LOGGER;

    private static void setPropertiesFromRuntime(RuntimeConfigManager manager) {
        try {
            if (manager != null) {
                if (manager.getDeploymentId() != null && System.getProperty("compss.uuid") == null) {
                    System.setProperty("compss.uuid", manager.getDeploymentId());
                }
                if (manager.getMasterName() != null && System.getProperty("compss.masterName") == null) {
                    System.setProperty("compss.masterName", manager.getMasterName());
                }
                if (manager.getMasterPort() != null && System.getProperty("compss.masterPort") == null) {
                    System.setProperty("compss.masterPort", manager.getMasterPort());
                }
                if (manager.getAppName() != null && System.getProperty("compss.appName") == null) {
                    System.setProperty("compss.appName", manager.getAppName());
                }
                if (manager.getTaskSummary() != null && System.getProperty("compss.summary") == null) {
                    System.setProperty("compss.summary", manager.getTaskSummary());
                }
                if (manager.getCOMPSsBaseLogDir() != null && System.getProperty("compss.baseLogDir") == null) {
                    System.setProperty("compss.baseLogDir", manager.getCOMPSsBaseLogDir());
                }
                if (manager.getSpecificLogDir() != null && System.getProperty("compss.specificLogDir") == null) {
                    System.setProperty("compss.specificLogDir", manager.getSpecificLogDir());
                }
                if (manager.getLog4jConfiguration() != null && System.getProperty("log4j.configurationFile") == null) {
                    System.setProperty("log4j.configurationFile", manager.getLog4jConfiguration());
                }
                if (manager.getResourcesFile() != null && System.getProperty("compss.resources.file") == null) {
                    System.setProperty("compss.resources.file", manager.getResourcesFile());
                }
                if (manager.getResourcesSchema() != null && System.getProperty("compss.resources.schema") == null) {
                    System.setProperty("compss.resources.schema", manager.getResourcesSchema());
                }
                if (manager.getProjectFile() != null && System.getProperty("compss.project.file") == null) {
                    System.setProperty("compss.project.file", manager.getProjectFile());
                }
                if (manager.getProjectSchema() != null && System.getProperty("compss.project.schema") == null) {
                    System.setProperty("compss.project.schema", manager.getProjectSchema());
                }
                if (manager.getScheduler() != null && System.getProperty("compss.scheduler") == null) {
                    System.setProperty("compss.scheduler", manager.getScheduler());
                }
                if (manager.getMonitorInterval() > 0L && System.getProperty("compss.monitor") == null) {
                    System.setProperty("compss.monitor", Long.toString(manager.getMonitorInterval()));
                }
                if (manager.getGATAdaptor() != null && System.getProperty("gat.adaptor.path") == null) {
                    System.setProperty("gat.adaptor.path", manager.getGATAdaptor());
                }
                if (manager.getGATBrokerAdaptor() != null && System.getProperty("gat.broker.adaptor") == null) {
                    System.setProperty("gat.broker.adaptor", manager.getGATBrokerAdaptor());
                }
                if (manager.getGATFileAdaptor() != null && System.getProperty("gat.file.adaptor") == null) {
                    System.setProperty("gat.file.adaptor", manager.getGATFileAdaptor());
                }
                if (manager.getWorkerCP() != null && System.getProperty("compss.worker.cp") == null) {
                    System.setProperty("compss.worker.cp", manager.getWorkerCP());
                }
                if (manager.getWorkerJVMOpts() != null && System.getProperty("compss.worker.jvm_opts") == null) {
                    System.setProperty("compss.worker.jvm_opts", manager.getWorkerJVMOpts());
                }
                if (System.getProperty("compss.worker.cpu_affinity") == null || System.getProperty("compss.worker.cpu_affinity").isEmpty()) {
                    System.setProperty("compss.worker.cpu_affinity", Boolean.toString(manager.isWorkerCPUAffinityEnabled()));
                }
                if (System.getProperty("compss.worker.gpu_affinity") == null || System.getProperty("compss.worker.gpu_affinity").isEmpty()) {
                    System.setProperty("compss.worker.gpu_affinity", Boolean.toString(manager.isWorkerGPUAffinityEnabled()));
                }
                if (manager.getServiceName() != null && System.getProperty("compss.serviceName") == null) {
                    System.setProperty("compss.serviceName", manager.getServiceName());
                }
                if (System.getProperty("compss.comm") == null) {
                    if (manager.getCommAdaptor() != null) {
                        System.setProperty("compss.comm", manager.getCommAdaptor());
                    } else {
                        System.setProperty("compss.comm", "es.bsc.compss.nio.master.NIOAdaptor");
                    }
                }
                if (System.getProperty("compss.conn") == null) {
                    if (manager.getConn() != null) {
                        System.setProperty("compss.conn", manager.getConn());
                    } else {
                        System.setProperty("compss.conn", "es.bsc.compss.connectors.DefaultSSHConnector");
                    }
                }
                if (System.getProperty("gat.debug") == null) {
                    System.setProperty("gat.debug", Boolean.toString(manager.isGATDebug()));
                }
                if (System.getProperty("compss.lang") == null) {
                    System.setProperty("compss.lang", manager.getLang());
                }
                if (System.getProperty("compss.graph") == null) {
                    System.setProperty("compss.graph", Boolean.toString(manager.isGraph()));
                }
                if (System.getProperty("compss.tracing") == null) {
                    System.setProperty("compss.tracing", String.valueOf(manager.getTracing()));
                }
                if (System.getProperty("compss.extrae.file") == null) {
                    System.setProperty("compss.extrae.file", manager.getCustomExtraeFile());
                }
                if (System.getProperty("compss.task.execution") == null || System.getProperty("compss.task.execution").equals("")) {
                    System.setProperty("compss.task.execution", "compss");
                }
                if (manager.getContext() != null) {
                    System.setProperty("compss.context", manager.getContext());
                }
                System.setProperty("compss.to.file", Boolean.toString(manager.isToFile()));
            } else {
                COMPSsRuntimeImpl.setDefaultProperties();
            }
        }
        catch (Exception e) {
            System.err.println(WARN_IT_FILE_NOT_READ);
            e.printStackTrace();
        }
    }

    private static void setDefaultProperties() {
        System.err.println(WARN_FILE_EMPTY_DEFAULT);
        if (System.getProperty("compss.uuid") == null || System.getProperty("compss.uuid").isEmpty()) {
            System.setProperty("compss.uuid", COMPSsConstants.DEFAULT_DEPLOYMENT_ID);
        }
        if (System.getProperty("compss.resources.schema") == null || System.getProperty("compss.resources.schema").isEmpty()) {
            System.setProperty("compss.resources.schema", COMPSsConstants.DEFAULT_RES_SCHEMA);
        }
        if (System.getProperty("compss.project.schema") == null || System.getProperty("compss.project.schema").isEmpty()) {
            System.setProperty("compss.project.schema", COMPSsConstants.DEFAULT_PROJECT_SCHEMA);
        }
        if (System.getProperty("gat.adaptor.path") == null || System.getProperty("gat.adaptor.path").isEmpty()) {
            System.setProperty("gat.adaptor.path", COMPSsConstants.DEFAULT_GAT_ADAPTOR_LOCATION);
        }
        if (System.getProperty("compss.comm") == null || System.getProperty("compss.comm").isEmpty()) {
            System.setProperty("compss.comm", "es.bsc.compss.nio.master.NIOAdaptor");
        }
        if (System.getProperty("compss.conn") == null || System.getProperty("compss.conn").isEmpty()) {
            System.setProperty("compss.conn", "es.bsc.compss.connectors.DefaultSSHConnector");
        }
        if (System.getProperty("compss.scheduler") == null || System.getProperty("compss.scheduler").isEmpty()) {
            System.setProperty("compss.scheduler", "es.bsc.compss.components.impl.TaskScheduler");
        }
        if (System.getProperty("compss.tracing") == null || System.getProperty("compss.tracing").isEmpty()) {
            System.setProperty("compss.tracing", "0");
        }
        if (System.getProperty("compss.extrae.file") == null || System.getProperty("compss.extrae.file").isEmpty()) {
            System.setProperty("compss.extrae.file", "null");
        }
        if (System.getProperty("compss.task.execution") == null || System.getProperty("compss.task.execution").isEmpty()) {
            System.setProperty("compss.task.execution", "compss");
        }
    }

    private static InputStream findPropertiesConfigFile() {
        InputStream stream = COMPSsRuntimeImpl.class.getResourceAsStream("compss.properties");
        if (stream != null) {
            return stream;
        }
        stream = COMPSsRuntimeImpl.class.getResourceAsStream(File.separator + "compss.properties");
        if (stream != null) {
            return stream;
        }
        stream = COMPSsRuntimeImpl.class.getClassLoader().getResourceAsStream("compss.properties");
        if (stream != null) {
            return stream;
        }
        stream = COMPSsRuntimeImpl.class.getClassLoader().getResourceAsStream(File.separator + "compss.properties");
        if (stream != null) {
            return stream;
        }
        stream = ClassLoader.getSystemResourceAsStream("compss.properties");
        if (stream != null) {
            return stream;
        }
        stream = ClassLoader.getSystemResourceAsStream(File.separator + "compss.properties");
        if (stream != null) {
            return stream;
        }
        stream = COMPSsRuntimeImpl.class.getClassLoader().getParent().getResourceAsStream("compss.properties");
        if (stream != null) {
            return stream;
        }
        stream = COMPSsRuntimeImpl.class.getClassLoader().getParent().getResourceAsStream(File.separator + "compss.properties");
        if (stream != null) {
            return stream;
        }
        return null;
    }

    public COMPSsRuntimeImpl() {
        try {
            Properties props = new Properties();
            props.load(this.getClass().getResourceAsStream("/version.properties"));
            COMPSs_VERSION = props.getProperty("compss.version");
            COMPSs_BUILDNUMBER = props.getProperty("compss.build");
        }
        catch (IOException e) {
            LOGGER.warn(WARN_VERSION_PROPERTIES);
        }
        if (COMPSs_VERSION == null) {
            LOGGER.debug("Deploying COMPSs Runtime");
        } else if (COMPSs_BUILDNUMBER == null) {
            LOGGER.debug("Deploying COMPSs Runtime v" + COMPSs_VERSION);
        } else if (COMPSs_BUILDNUMBER.endsWith("rnull")) {
            COMPSs_BUILDNUMBER = COMPSs_BUILDNUMBER.substring(0, COMPSs_BUILDNUMBER.length() - 6);
            LOGGER.debug("Deploying COMPSs Runtime v" + COMPSs_VERSION + " (build " + COMPSs_BUILDNUMBER + ")");
        } else {
            LOGGER.debug("Deploying COMPSs Runtime v" + COMPSs_VERSION + " (build " + COMPSs_BUILDNUMBER + ")");
        }
        ErrorManager.init(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void startIT() {
        if (Tracer.isActivated()) {
            Tracer.emitEvent(0L, Tracer.getRuntimeEventsType());
            Tracer.emitEvent(Tracer.Event.START.getId(), Tracer.Event.START.getType());
        }
        Thread.currentThread().setName("APPLICATION");
        if (COMPSs_VERSION == null) {
            LOGGER.warn("Starting COMPSs Runtime");
        } else if (COMPSs_BUILDNUMBER == null) {
            LOGGER.warn("Starting COMPSs Runtime v" + COMPSs_VERSION);
        } else if (COMPSs_BUILDNUMBER.endsWith("rnull")) {
            COMPSs_BUILDNUMBER = COMPSs_BUILDNUMBER.substring(0, COMPSs_BUILDNUMBER.length() - 6);
            LOGGER.warn("Starting COMPSs Runtime v" + COMPSs_VERSION + " (build " + COMPSs_BUILDNUMBER + ")");
        } else {
            LOGGER.warn("Starting COMPSs Runtime v" + COMPSs_VERSION + " (build " + COMPSs_BUILDNUMBER + ")");
        }
        if (!initialized) {
            COMPSsRuntimeImpl cOMPSsRuntimeImpl = this;
            synchronized (cOMPSsRuntimeImpl) {
                LOGGER.debug("Initializing components");
                td = new TaskDispatcher();
                ap = new AccessProcessor(td);
                if (GraphGenerator.isEnabled()) {
                    graphMonitor = new GraphGenerator();
                    ap.setGM(graphMonitor);
                }
                if (RuntimeMonitor.isEnabled()) {
                    runtimeMonitor = new RuntimeMonitor(ap, td, graphMonitor, Long.parseLong(System.getProperty("compss.monitor")));
                }
                initialized = true;
                LOGGER.debug("Ready to process tasks");
            }
        }
        String className = Thread.currentThread().getStackTrace()[2].getClassName();
        LOGGER.debug("Initializing " + className + "Itf");
        try {
            td.addInterface(Class.forName(className + "Itf"));
        }
        catch (ClassNotFoundException cnfe) {
            ErrorManager.fatal("Error adding interface " + className + "Itf", cnfe);
        }
        if (Tracer.isActivated()) {
            Tracer.emitEvent(0L, Tracer.getRuntimeEventsType());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopIT(boolean terminate) {
        COMPSsRuntimeImpl cOMPSsRuntimeImpl = this;
        synchronized (cOMPSsRuntimeImpl) {
            boolean taskSummaryEnabled;
            if (Tracer.isActivated()) {
                Tracer.emitEvent(Tracer.Event.STOP.getId(), Tracer.Event.STOP.getType());
            }
            boolean bl = taskSummaryEnabled = System.getProperty("compss.summary") != null && !System.getProperty("compss.summary").isEmpty() && Boolean.parseBoolean(System.getProperty("compss.summary"));
            if (taskSummaryEnabled) {
                td.getTaskSummary(LOGGER);
            }
            LOGGER.info("Stop IT reached");
            if (GraphGenerator.isEnabled()) {
                LOGGER.debug("Stopping Graph generation...");
            }
            if (RuntimeMonitor.isEnabled()) {
                LOGGER.debug("Stopping Monitor...");
                runtimeMonitor.shutdown();
            }
            LOGGER.debug("Stopping AP...");
            if (ap != null) {
                ap.shutdown();
            } else {
                LOGGER.debug("AP was not initialized...");
            }
            LOGGER.debug("Stopping TD...");
            if (td != null) {
                td.shutdown();
            } else {
                LOGGER.debug("TD was not initialized...");
            }
            LOGGER.debug("Stopping Comm...");
            Comm.stop();
            LOGGER.debug("Runtime stopped");
        }
        LOGGER.warn("Execution Finished");
    }

    @Override
    public String getApplicationDirectory() {
        return Comm.getAppHost().getAppLogDirPath();
    }

    public static ActionOrchestrator getOrchestrator() {
        return td;
    }

    @Override
    public void registerCoreElement(String coreElementSignature, String implSignature, String implConstraints, String implType, String ... implTypeArgs) {
        AbstractMethodImplementation.MethodType mt;
        LOGGER.info("Registering CoreElement " + coreElementSignature);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("\t - Implementation: " + implSignature);
            LOGGER.debug("\t - Constraints   : " + implConstraints);
            LOGGER.debug("\t - Type          : " + implType);
            LOGGER.debug("\t - ImplTypeArgs  : ");
            for (String implTypeArg : implTypeArgs) {
                LOGGER.debug("\t\t Arg: " + implTypeArg);
            }
        }
        MethodResourceDescription mrd = new MethodResourceDescription(implConstraints);
        switch (implType) {
            case "METHOD": {
                mt = AbstractMethodImplementation.MethodType.METHOD;
                break;
            }
            case "MPI": {
                mt = AbstractMethodImplementation.MethodType.MPI;
                break;
            }
            case "DECAF": {
                mt = AbstractMethodImplementation.MethodType.DECAF;
                break;
            }
            case "BINARY": {
                mt = AbstractMethodImplementation.MethodType.BINARY;
                break;
            }
            case "OMPSS": {
                mt = AbstractMethodImplementation.MethodType.OMPSS;
                break;
            }
            case "OPENCL": {
                mt = AbstractMethodImplementation.MethodType.OPENCL;
                break;
            }
            default: {
                ErrorManager.error("Unrecognised method type " + implType);
                return;
            }
        }
        td.registerNewCoreElement(coreElementSignature, implSignature, mrd, mt, implTypeArgs);
    }

    @Override
    public int executeTask(Long appId, String methodClass, String methodName, boolean isPrioritary, boolean hasTarget, int parameterCount, Object ... parameters) {
        return this.executeTask(appId, false, methodClass, methodName, null, isPrioritary, 1, Boolean.parseBoolean("false"), Boolean.parseBoolean("false"), hasTarget, null, parameterCount, parameters);
    }

    @Override
    public int executeTask(Long appId, String methodClass, String methodName, boolean isPrioritary, int numNodes, boolean isReplicated, boolean isDistributed, boolean hasTarget, int parameterCount, Object ... parameters) {
        return this.executeTask(appId, false, methodClass, methodName, null, isPrioritary, numNodes, isReplicated, isDistributed, hasTarget, null, parameterCount, parameters);
    }

    @Override
    public int executeTask(Long appId, String signature, boolean isPrioritary, int numNodes, boolean isReplicated, boolean isDistributed, boolean hasTarget, Integer numReturns, int parameterCount, Object ... parameters) {
        return this.executeTask(appId, true, null, null, signature, isPrioritary, numNodes, isReplicated, isDistributed, hasTarget, numReturns, parameterCount, parameters);
    }

    private int executeTask(Long appId, boolean hasSignature, String methodClass, String methodName, String signature, boolean isPrioritary, int numNodes, boolean isReplicated, boolean isDistributed, boolean hasTarget, Integer numReturns, int parameterCount, Object ... parameters) {
        if (Tracer.isActivated()) {
            Tracer.emitEvent(Tracer.Event.TASK.getId(), Tracer.Event.TASK.getType());
        }
        if (hasSignature) {
            LOGGER.info("Creating task from method " + signature);
        } else {
            LOGGER.info("Creating task from method " + methodName + " in " + methodClass);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("There " + (parameterCount > 1 ? "are " : "is ") + parameterCount + " parameter" + (parameterCount > 1 ? "s" : ""));
        }
        Parameter[] pars = this.processParameters(parameterCount, parameters);
        COMPSsConstants.Lang l = COMPSsConstants.Lang.JAVA;
        String langProperty = System.getProperty("compss.lang");
        if (langProperty != null) {
            if (langProperty.equalsIgnoreCase(COMPSsConstants.Lang.PYTHON.name())) {
                l = COMPSsConstants.Lang.PYTHON;
            } else if (langProperty.equalsIgnoreCase(COMPSsConstants.Lang.C.name())) {
                l = COMPSsConstants.Lang.C;
            }
        }
        COMPSsConstants.Lang LANG = l;
        boolean hasReturn = false;
        switch (LANG) {
            case PYTHON: 
            case JAVA: {
                hasReturn = this.hasReturn(pars);
                if (numReturns != null) break;
                numReturns = hasReturn ? 1 : 0;
                break;
            }
            case C: {
                if (numReturns <= 0) break;
                hasReturn = true;
            }
        }
        if (!hasSignature) {
            signature = MethodImplementation.getSignature(methodClass, methodName, hasTarget, hasReturn, pars);
        }
        int task = ap.newTask(appId, signature, isPrioritary, numNodes, isReplicated, isDistributed, hasTarget, hasReturn, (int)numReturns, pars);
        if (Tracer.isActivated()) {
            Tracer.emitEvent(0L, Tracer.getRuntimeEventsType());
        }
        return task;
    }

    private boolean hasReturn(Parameter[] parameters) {
        boolean hasReturn = false;
        if (parameters.length != 0) {
            Parameter lastParam = parameters[parameters.length - 1];
            DataType type = lastParam.getType();
            hasReturn = lastParam.getDirection() == Direction.OUT && (type == DataType.OBJECT_T || type == DataType.PSCO_T || type == DataType.EXTERNAL_PSCO_T || type == DataType.BINDING_OBJECT_T);
        }
        return hasReturn;
    }

    @Override
    public int executeTask(Long appId, String namespace, String service, String port, String operation, boolean isPrioritary, int numNodes, boolean isReplicated, boolean isDistributed, boolean hasTarget, int parameterCount, Object ... parameters) {
        Parameter[] pars;
        boolean hasReturn;
        if (Tracer.isActivated()) {
            Tracer.emitEvent(Tracer.Event.TASK.getId(), Tracer.Event.TASK.getType());
        }
        if (numNodes != 1 || isReplicated || isDistributed) {
            ErrorManager.fatal("ERROR: Unsupported feature for Services: multi-node, replicated or distributed");
        }
        LOGGER.info("Creating task from service " + service + ", namespace " + namespace + ", port " + port + ", operation " + operation);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("There " + (parameterCount > 1 ? "are " : "is ") + parameterCount + " parameter" + (parameterCount > 1 ? "s" : ""));
        }
        int numReturns = (hasReturn = this.hasReturn(pars = this.processParameters(parameterCount, parameters))) ? 1 : 0;
        int task = ap.newTask(appId, namespace, service, port, operation, isPrioritary, hasTarget, hasReturn, numReturns, pars);
        if (Tracer.isActivated()) {
            Tracer.emitEvent(0L, Tracer.getRuntimeEventsType());
        }
        return task;
    }

    @Override
    public void noMoreTasks(Long appId) {
        if (Tracer.isActivated()) {
            Tracer.emitEvent(Tracer.Event.NO_MORE_TASKS.getId(), Tracer.Event.NO_MORE_TASKS.getType());
        }
        LOGGER.info("No more tasks for app " + appId);
        ap.noMoreTasks(appId);
        LOGGER.debug("Getting Result Files " + appId);
        ap.getResultFiles(appId);
        if (Tracer.isActivated()) {
            Tracer.emitEvent(0L, Tracer.getRuntimeEventsType());
        }
    }

    @Override
    public void barrier(Long appId) {
        this.barrier(appId, false);
    }

    @Override
    public void barrier(Long appId, boolean noMoreTasks) {
        if (Tracer.isActivated()) {
            Tracer.emitEvent(Tracer.Event.WAIT_FOR_ALL_TASKS.getId(), Tracer.Event.WAIT_FOR_ALL_TASKS.getType());
        }
        LOGGER.info("Barrier for app " + appId + " with noMoreTasks = " + noMoreTasks);
        if (noMoreTasks) {
            this.noMoreTasks(appId);
        } else {
            ap.barrier(appId);
        }
        if (Tracer.isActivated()) {
            Tracer.emitEvent(0L, Tracer.Event.WAIT_FOR_ALL_TASKS.getType());
        }
    }

    @Override
    public boolean deleteFile(String fileName) {
        if (fileName == null || fileName.isEmpty()) {
            return false;
        }
        LOGGER.info("Deleting File " + fileName);
        if (Tracer.isActivated()) {
            Tracer.emitEvent(Tracer.Event.DELETE.getId(), Tracer.Event.DELETE.getType());
        }
        try {
            DataLocation loc = this.createLocation(fileName);
            ap.markForDeletion(loc);
        }
        catch (IOException ioe) {
            ErrorManager.fatal(ERROR_FILE_NAME, ioe);
        }
        finally {
            if (Tracer.isActivated()) {
                Tracer.emitEvent(0L, Tracer.getRuntimeEventsType());
            }
        }
        return true;
    }

    @Override
    public void emitEvent(int type, long id) {
        Tracer.emitEvent(id, type);
    }

    @Override
    public String getFile(String fileName, String destDir) {
        DataLocation sourceLocation;
        if (Tracer.isActivated()) {
            Tracer.emitEvent(Tracer.Event.GET_FILE.getId(), Tracer.Event.GET_FILE.getType());
        }
        if (!destDir.endsWith(File.separator)) {
            destDir = destDir + File.separator;
        }
        try {
            sourceLocation = this.createLocation(fileName);
        }
        catch (IOException ioe) {
            ErrorManager.fatal(ERROR_FILE_NAME, ioe);
            return null;
        }
        if (sourceLocation == null) {
            ErrorManager.fatal(ERROR_FILE_NAME);
            return null;
        }
        String finalPath = this.mainAccessToFile(fileName, sourceLocation, AccessParams.AccessMode.R, destDir);
        if (Tracer.isActivated()) {
            Tracer.emitEvent(0L, Tracer.getRuntimeEventsType());
        }
        return finalPath;
    }

    @Override
    public Object getObject(Object obj, int hashCode, String destDir) {
        if (Tracer.isActivated()) {
            Tracer.emitEvent(Tracer.Event.GET_OBJECT.getId(), Tracer.Event.GET_OBJECT.getType());
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Getting object with hash code " + hashCode);
        }
        Object oUpdated = this.mainAccessToObject(obj, hashCode);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Object obtained " + (oUpdated == null ? oUpdated : Integer.valueOf(oUpdated.hashCode())));
        }
        if (Tracer.isActivated()) {
            Tracer.emitEvent(0L, Tracer.getRuntimeEventsType());
        }
        return oUpdated;
    }

    @Override
    public void serializeObject(Object o, int hashCode, String destDir) {
    }

    @Override
    public void setObjectRegistry(ObjectRegistry oReg) {
        COMPSsRuntimeImpl.oReg = oReg;
    }

    @Override
    public String getTempDir() {
        return Comm.getAppHost().getTempDirPath();
    }

    @Override
    public String openFile(String fileName, Direction mode) {
        String finalPath;
        DataLocation loc;
        LOGGER.info("Opening " + fileName + " in mode " + (Object)((Object)mode));
        if (Tracer.isActivated()) {
            Tracer.emitEvent(Tracer.Event.OPEN_FILE.getId(), Tracer.Event.OPEN_FILE.getType());
        }
        try {
            loc = this.createLocation(fileName);
        }
        catch (IOException ioe) {
            ErrorManager.fatal(ERROR_FILE_NAME, ioe);
            return null;
        }
        AccessParams.AccessMode am = null;
        switch (mode) {
            case IN: {
                am = AccessParams.AccessMode.R;
                break;
            }
            case OUT: {
                am = AccessParams.AccessMode.W;
                break;
            }
            case INOUT: {
                am = AccessParams.AccessMode.RW;
            }
        }
        switch (loc.getType()) {
            case PRIVATE: 
            case SHARED: {
                finalPath = this.mainAccessToFile(fileName, loc, am, null);
                if (!LOGGER.isDebugEnabled()) break;
                LOGGER.debug("File target Location: " + finalPath);
                break;
            }
            case PERSISTENT: {
                finalPath = this.mainAccessToExternalPSCO(fileName, loc);
                if (!LOGGER.isDebugEnabled()) break;
                LOGGER.debug("External PSCO target Location: " + finalPath);
                break;
            }
            default: {
                finalPath = null;
                ErrorManager.error("ERROR: Unrecognised protocol requesting openFile " + fileName);
            }
        }
        if (Tracer.isActivated()) {
            Tracer.emitEvent(0L, Tracer.getRuntimeEventsType());
        }
        return finalPath;
    }

    @Override
    public void closeFile(String fileName, Direction mode) {
        DataLocation loc;
        LOGGER.info("Closing " + fileName + " in mode " + (Object)((Object)mode));
        try {
            loc = this.createLocation(fileName);
        }
        catch (Exception e) {
            ErrorManager.fatal(ERROR_FILE_NAME, e);
            return;
        }
        AccessParams.AccessMode am = null;
        switch (mode) {
            case IN: {
                am = AccessParams.AccessMode.R;
                break;
            }
            case OUT: {
                am = AccessParams.AccessMode.W;
                break;
            }
            case INOUT: {
                am = AccessParams.AccessMode.RW;
            }
        }
        switch (loc.getType()) {
            case PRIVATE: 
            case SHARED: {
                this.finishAccessToFile(fileName, loc, am, null);
                if (!LOGGER.isDebugEnabled()) break;
                LOGGER.debug("Closing file " + loc.getPath());
                break;
            }
            case PERSISTENT: {
                ErrorManager.warn("WARN: Cannot close file " + fileName + " with PSCO protocol");
                break;
            }
            case BINDING: {
                ErrorManager.warn("WARN: Cannot close binding object " + fileName + " with PSCO protocol");
                break;
            }
            default: {
                ErrorManager.error("ERROR: Unrecognised protocol requesting closeFile " + fileName);
            }
        }
    }

    @Override
    public String getBindingObject(String fileName) {
        LOGGER.debug(" Calling get binding object : " + fileName);
        BindingObjectLocation sourceLocation = new BindingObjectLocation(Comm.getAppHost(), BindingObject.generate(fileName));
        String finalPath = this.mainAccessToBindingObject(fileName, sourceLocation);
        LOGGER.debug(" Returning binding object as id: " + finalPath);
        return finalPath;
    }

    @Override
    public boolean deleteBindingObject(String fileName) {
        if (fileName == null || fileName.isEmpty()) {
            return false;
        }
        LOGGER.info("Deleting BindingObject " + fileName);
        if (Tracer.isActivated()) {
            Tracer.emitEvent(Tracer.Event.DELETE.getId(), Tracer.Event.DELETE.getType());
        }
        BindingObjectLocation loc = new BindingObjectLocation(Comm.getAppHost(), BindingObject.generate(fileName));
        ap.markForBindingObjectDeletion(loc);
        if (Tracer.isActivated()) {
            Tracer.emitEvent(0L, Tracer.getRuntimeEventsType());
        }
        return true;
    }

    private Parameter[] processParameters(int parameterCount, Object[] parameters) {
        Parameter[] pars = new Parameter[parameterCount];
        int i = 0;
        for (int npar = 0; npar < parameterCount; ++npar) {
            DataType type = (DataType)((Object)parameters[i + 1]);
            Direction direction = (Direction)((Object)parameters[i + 2]);
            Stream stream = (Stream)((Object)parameters[i + 3]);
            String prefix = (String)parameters[i + 4];
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("  Parameter " + (npar + 1) + " has type " + type.name());
            }
            switch (type) {
                case FILE_T: {
                    try {
                        String fileName = (String)parameters[i];
                        String originalName = new File(fileName).getName();
                        DataLocation location = this.createLocation((String)parameters[i]);
                        pars[npar] = new FileParameter(direction, stream, prefix, location, originalName);
                    }
                    catch (Exception e) {
                        LOGGER.error(ERROR_FILE_NAME, (Throwable)e);
                        ErrorManager.fatal(ERROR_FILE_NAME, e);
                    }
                    break;
                }
                case PSCO_T: 
                case OBJECT_T: {
                    pars[npar] = new ObjectParameter(direction, stream, prefix, parameters[i], oReg.newObjectParameter(parameters[i]));
                    break;
                }
                case EXTERNAL_PSCO_T: {
                    String id = (String)parameters[i];
                    pars[npar] = new ExternalPSCOParameter(direction, stream, prefix, id, this.externalObjectHashcode(id));
                    break;
                }
                case BINDING_OBJECT_T: {
                    String value = (String)parameters[i];
                    if (value.contains(":")) {
                        String[] fields = value.split(":");
                        if (fields.length == 3) {
                            String extObjectId = fields[0];
                            int extObjectType = Integer.parseInt(fields[1]);
                            int extObjectElements = Integer.parseInt(fields[2]);
                            pars[npar] = new BindingObjectParameter(direction, stream, prefix, new BindingObject(extObjectId, extObjectType, extObjectElements), this.externalObjectHashcode(extObjectId));
                            break;
                        }
                        LOGGER.error("ERROR: Incorrect number of parameters for external objects received value is " + value);
                        ErrorManager.fatal("ERROR: Incorrect number of parameters for external objects received value is " + value);
                        break;
                    }
                    LOGGER.error("ERROR: Incorrect number of parameters for external objects received value is " + value);
                    ErrorManager.fatal("ERROR: Incorrect number of parameters for external objects received value is " + value);
                    break;
                }
                default: {
                    if (direction != Direction.IN) {
                        LOGGER.warn("WARNING: Invalid parameter direction: Parameter " + npar + " is a basic type, therefore it must have IN direction");
                    }
                    pars[npar] = new BasicTypeParameter(type, Direction.IN, stream, prefix, parameters[i]);
                }
            }
            i += 5;
        }
        return pars;
    }

    private int externalObjectHashcode(String id) {
        int hashCode = 7;
        for (int i = 0; i < id.length(); ++i) {
            hashCode = hashCode * 31 + id.charAt(i);
        }
        return hashCode;
    }

    private void finishAccessToFile(String fileName, DataLocation loc, AccessParams.AccessMode am, String destDir) {
        AccessParams.FileAccessParams fap = new AccessParams.FileAccessParams(am, loc);
        ap.finishAccessToFile(loc, fap, destDir);
    }

    private String mainAccessToFile(String fileName, DataLocation loc, AccessParams.AccessMode am, String destDir) {
        DataLocation finalLocation;
        AccessParams.FileAccessParams fap = new AccessParams.FileAccessParams(am, loc);
        DataLocation targetLocation = ap.mainAccessToFile(loc, fap, destDir);
        String path = targetLocation == null ? fileName : targetLocation.getPath();
        DataLocation dataLocation = finalLocation = targetLocation == null ? loc : targetLocation;
        if (finalLocation == null) {
            ErrorManager.fatal(ERROR_FILE_NAME);
            return null;
        }
        MultiURI u = finalLocation.getURIInHost(Comm.getAppHost());
        String finalPath = u != null ? u.getPath() : path;
        return finalPath;
    }

    private Object mainAccessToObject(Object obj, int hashCode) {
        boolean validValue = ap.isCurrentRegisterValueValid(hashCode);
        if (validValue) {
            return null;
        }
        return ap.mainAcessToObject(obj, hashCode);
    }

    private String mainAccessToExternalPSCO(String fileName, DataLocation loc) {
        String id = ((PersistentLocation)loc).getId();
        int hashCode = this.externalObjectHashcode(id);
        boolean validValue = ap.isCurrentRegisterValueValid(hashCode);
        if (validValue) {
            return fileName;
        }
        return ap.mainAcessToExternalPSCO(id, hashCode);
    }

    private String mainAccessToBindingObject(String fileName, BindingObjectLocation loc) {
        String id = loc.getId();
        int hashCode = this.externalObjectHashcode(id);
        boolean validValue = ap.isCurrentRegisterValueValid(hashCode);
        if (validValue) {
            return fileName;
        }
        return ap.mainAcessToBindingObject(loc.getBindingObject(), hashCode);
    }

    private DataLocation createLocation(String fileName) throws IOException {
        SimpleURI uri = new SimpleURI(fileName);
        if (uri.getSchema().isEmpty()) {
            String canonicalPath = new File(fileName).getCanonicalPath();
            uri = new SimpleURI(DataLocation.Protocol.FILE_URI.getSchema() + canonicalPath);
        }
        Resource host = Comm.getAppHost();
        String hostName = uri.getHost();
        if (hostName != null && !hostName.isEmpty() && (host = Resource.getResource(hostName)) == null) {
            ErrorManager.error("Host " + hostName + " not found when creating data location.");
        }
        return DataLocation.createLocation(host, uri);
    }

    @Override
    public void deregisterObject(Long appId, Object o) {
        oReg.delete(o);
    }

    @Override
    public void removeObject(Object o, int hashcode) {
        ap.deregisterObject(o);
    }

    static {
        LOGGER = LogManager.getLogger("es.bsc.compss.API");
        String propertiesLoc = System.getProperty("compss.properties.location");
        if (propertiesLoc == null) {
            InputStream stream = COMPSsRuntimeImpl.findPropertiesConfigFile();
            if (stream != null) {
                try {
                    COMPSsRuntimeImpl.setPropertiesFromRuntime(new RuntimeConfigManager(stream));
                }
                catch (Exception e) {
                    System.err.println(WARN_IT_FILE_NOT_READ);
                    e.printStackTrace();
                }
            } else {
                COMPSsRuntimeImpl.setDefaultProperties();
            }
        } else {
            try {
                COMPSsRuntimeImpl.setPropertiesFromRuntime(new RuntimeConfigManager(propertiesLoc));
            }
            catch (Exception e) {
                System.err.println(WARN_IT_FILE_NOT_READ);
                e.printStackTrace();
            }
        }
        Comm.init();
    }
}

