/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.types.implementations;

import es.bsc.compss.types.implementations.AbstractMethodImplementation;
import es.bsc.compss.types.resources.MethodResourceDescription;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class MethodImplementation
extends AbstractMethodImplementation
implements Externalizable {
    private String declaringClass;
    private String alternativeMethod;

    public MethodImplementation() {
    }

    public MethodImplementation(String methodClass, String altMethodName, Integer coreId, Integer implementationId, MethodResourceDescription requirements) {
        super(coreId, implementationId, requirements);
        this.declaringClass = methodClass;
        this.alternativeMethod = altMethodName;
    }

    public String getDeclaringClass() {
        return this.declaringClass;
    }

    public void setDeclaringClass(String declaringClass) {
        this.declaringClass = declaringClass;
    }

    public String getAlternativeMethodName() {
        return this.alternativeMethod;
    }

    public void setAlternativeMethodName(String alternativeMethod) {
        this.alternativeMethod = alternativeMethod;
    }

    @Override
    public AbstractMethodImplementation.MethodType getMethodType() {
        return AbstractMethodImplementation.MethodType.METHOD;
    }

    @Override
    public String getMethodDefinition() {
        StringBuilder sb = new StringBuilder();
        sb.append("[DECLARING CLASS=").append(this.declaringClass);
        sb.append(", METHOD NAME=").append(this.alternativeMethod);
        sb.append("]");
        return sb.toString();
    }

    @Override
    public String toString() {
        return super.toString() + " Method declared in class " + this.declaringClass + "." + this.alternativeMethod + ": " + this.requirements.toString();
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.declaringClass = (String)in.readObject();
        this.alternativeMethod = (String)in.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeObject(this.declaringClass);
        out.writeObject(this.alternativeMethod);
    }
}

