/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.types.request.td;

import es.bsc.compss.components.impl.TaskScheduler;
import es.bsc.compss.scheduler.types.AllocatableAction;
import es.bsc.compss.types.Task;
import es.bsc.compss.types.allocatableactions.ExecutionAction;
import es.bsc.compss.types.request.exceptions.ShutdownException;
import es.bsc.compss.types.request.td.TDRequest;
import es.bsc.compss.types.resources.Worker;
import es.bsc.compss.types.resources.WorkerResourceDescription;
import es.bsc.compss.util.ResourceManager;
import java.io.BufferedWriter;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.PriorityQueue;
import java.util.concurrent.Semaphore;

public class PrintCurrentGraphRequest
extends TDRequest {
    private static final String ERROR_PRINT_CURRENT_GRAPH = "ERROR: Cannot print current graph state";
    private Semaphore sem;
    private BufferedWriter graph;

    public PrintCurrentGraphRequest(Semaphore sem, BufferedWriter graph) {
        this.sem = sem;
        this.graph = graph;
    }

    public Semaphore getSemaphore() {
        return this.sem;
    }

    public void setSemaphore(Semaphore sem) {
        this.sem = sem;
    }

    @Override
    public void process(TaskScheduler ts) throws ShutdownException {
        try {
            PriorityQueue<Task> pending = new PriorityQueue<Task>();
            HashSet<Object> tasks = new HashSet<Object>();
            String prefix = "  ";
            this.graph.write(prefix + "outputorder=\"edgesfirst\";");
            this.graph.newLine();
            this.graph.write(prefix + "compound=true;");
            this.graph.newLine();
            this.graph.write(prefix + "subgraph cluster1 {");
            this.graph.newLine();
            this.graph.write(prefix + prefix + "color=white");
            this.graph.newLine();
            int roomIndex = 1;
            this.graph.write(prefix + prefix + "subgraph cluster_room" + roomIndex + " {");
            ++roomIndex;
            this.graph.newLine();
            this.graph.write(prefix + prefix + prefix + "ranksep=0.20;");
            this.graph.newLine();
            this.graph.write(prefix + prefix + prefix + "node[height=0.75];");
            this.graph.newLine();
            this.graph.write(prefix + prefix + prefix + "label = \"Blocked\"");
            this.graph.newLine();
            this.graph.write(prefix + prefix + prefix + "color=red");
            this.graph.newLine();
            List<AllocatableAction> blockedActions = ts.getBlockedActions();
            for (AllocatableAction allocatableAction : blockedActions) {
                if (!(allocatableAction instanceof ExecutionAction)) continue;
                ExecutionAction executionAction = (ExecutionAction)allocatableAction;
                Task t = executionAction.getTask();
                this.graph.write(prefix + prefix + prefix + t.getDotDescription());
                this.graph.newLine();
                pending.addAll(t.getSuccessors());
                tasks.add(t);
            }
            this.graph.write(prefix + prefix + "}");
            this.graph.newLine();
            this.graph.write(prefix + prefix + "subgraph cluster_room" + roomIndex + " {");
            ++roomIndex;
            this.graph.newLine();
            this.graph.write(prefix + prefix + prefix + "ranksep=0.20;");
            this.graph.newLine();
            this.graph.write(prefix + prefix + prefix + "node[height=0.75];");
            this.graph.newLine();
            this.graph.write(prefix + prefix + prefix + "label = \"No Assigned\"");
            this.graph.newLine();
            this.graph.write(prefix + prefix + prefix + "color=orange");
            this.graph.newLine();
            List<AllocatableAction> unassignedActions = ts.getUnassignedActions();
            for (AllocatableAction allocatableAction : unassignedActions) {
                if (!(allocatableAction instanceof ExecutionAction)) continue;
                ExecutionAction se = (ExecutionAction)allocatableAction;
                AllocatableAction[] t = se.getTask();
                this.graph.write(prefix + prefix + prefix + t.getDotDescription());
                this.graph.newLine();
                pending.addAll(t.getSuccessors());
                tasks.add(t);
            }
            this.graph.write(prefix + prefix + "}");
            this.graph.newLine();
            for (Worker<? extends WorkerResourceDescription> worker : ResourceManager.getAllWorkers()) {
                AllocatableAction[] hostedActions;
                this.graph.write(prefix + prefix + "subgraph cluster_room" + roomIndex + " {");
                this.graph.newLine();
                this.graph.write(prefix + prefix + prefix + "label = \"" + worker.getName() + "\"");
                this.graph.newLine();
                this.graph.write(prefix + prefix + prefix + "color=black");
                this.graph.newLine();
                this.graph.write(prefix + prefix + prefix + "subgraph cluster_box" + roomIndex + "1 {");
                this.graph.newLine();
                this.graph.write(prefix + prefix + prefix + prefix + "label = \"Running\"");
                this.graph.newLine();
                this.graph.write(prefix + prefix + prefix + prefix + "ranksep=0.20;");
                this.graph.newLine();
                this.graph.write(prefix + prefix + prefix + prefix + "node[height=0.75];");
                this.graph.newLine();
                this.graph.write(prefix + prefix + prefix + prefix + "color=green");
                this.graph.newLine();
                for (AllocatableAction action : hostedActions = ts.getHostedActions(worker)) {
                    if (!(action instanceof ExecutionAction)) continue;
                    ExecutionAction se = (ExecutionAction)action;
                    Task t = se.getTask();
                    this.graph.write(prefix + prefix + prefix + prefix + t.getDotDescription());
                    this.graph.newLine();
                    pending.addAll(t.getSuccessors());
                    tasks.add(t);
                }
                this.graph.write(prefix + prefix + prefix + "}");
                this.graph.newLine();
                this.graph.write(prefix + prefix + prefix + "subgraph cluster_box" + roomIndex + "2 {");
                this.graph.newLine();
                this.graph.write(prefix + prefix + prefix + prefix + "label = \"Resource Blocked\"");
                this.graph.newLine();
                this.graph.write(prefix + prefix + prefix + prefix + "ranksep=0.20;");
                this.graph.newLine();
                this.graph.write(prefix + prefix + prefix + prefix + "node[height=0.75];");
                this.graph.newLine();
                this.graph.write(prefix + prefix + prefix + prefix + "color=red");
                this.graph.newLine();
                PriorityQueue<AllocatableAction> blockedActionsOnResource = ts.getBlockedActionsOnResource(worker);
                for (AllocatableAction action : blockedActionsOnResource) {
                    if (!(action instanceof ExecutionAction)) continue;
                    ExecutionAction se = (ExecutionAction)action;
                    Task t = se.getTask();
                    this.graph.write(prefix + prefix + prefix + prefix + t.getDotDescription());
                    this.graph.newLine();
                    pending.addAll(t.getSuccessors());
                    tasks.add(t);
                }
                this.graph.write(prefix + prefix + prefix + "}");
                this.graph.newLine();
                this.graph.write(prefix + prefix + "}");
                this.graph.newLine();
                ++roomIndex;
            }
            this.graph.write(prefix + "}");
            this.graph.newLine();
            this.graph.write(prefix + "subgraph cluster2 {");
            this.graph.newLine();
            this.graph.write(prefix + prefix + "label = \"Pending\"");
            this.graph.newLine();
            this.graph.write(prefix + prefix + "ranksep=0.20;");
            this.graph.newLine();
            this.graph.write(prefix + prefix + "node[height=0.75];");
            this.graph.newLine();
            this.graph.write(prefix + prefix + "color=blue");
            this.graph.newLine();
            while (!pending.isEmpty()) {
                Task task = (Task)pending.poll();
                if (tasks.contains(task)) continue;
                this.graph.write(prefix + prefix + task.getDotDescription());
                this.graph.newLine();
                tasks.add(task);
                pending.addAll(task.getSuccessors());
            }
            this.graph.write(prefix + "}");
            this.graph.newLine();
            for (Task task : tasks) {
                HashSet<Task> successors = new HashSet<Task>();
                successors.addAll(task.getSuccessors());
                for (Task t2 : successors) {
                    this.graph.write(prefix + task.getId() + " -> " + t2.getId() + ";");
                    this.graph.newLine();
                }
            }
            this.graph.flush();
        }
        catch (IOException e) {
            LOGGER.error(ERROR_PRINT_CURRENT_GRAPH);
        }
        this.sem.release();
    }

    @Override
    public TDRequest.TDRequestType getType() {
        return TDRequest.TDRequestType.PRINT_CURRENT_GRAPH;
    }
}

