/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.invokers;

import es.bsc.compss.executor.utils.ResourceManager;
import es.bsc.compss.invokers.Invoker;
import es.bsc.compss.types.annotations.parameter.DataType;
import es.bsc.compss.types.execution.Invocation;
import es.bsc.compss.types.execution.InvocationContext;
import es.bsc.compss.types.execution.InvocationParam;
import es.bsc.compss.types.execution.exceptions.JobExecutionException;
import es.bsc.compss.types.implementations.MethodImplementation;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import storage.StubItf;

public class JavaInvoker
extends Invoker {
    public static final String ERROR_CLASS_REFLECTION = "Cannot get class by reflection";
    public static final String ERROR_METHOD_REFLECTION = "Cannot get method by reflection";
    private final String className;
    private final String methodName;
    protected final Method method;

    public JavaInvoker(InvocationContext context, Invocation invocation, File taskSandboxWorkingDir, ResourceManager.InvocationResources assignedResources) throws JobExecutionException {
        super(context, invocation, taskSandboxWorkingDir, assignedResources);
        MethodImplementation methodImpl = null;
        try {
            methodImpl = (MethodImplementation)invocation.getMethodImplementation();
        }
        catch (Exception e) {
            throw new JobExecutionException("Incorrect method definition for task of type " + (Object)((Object)invocation.getMethodImplementation().getMethodType()), e);
        }
        this.className = methodImpl.getDeclaringClass();
        this.methodName = methodImpl.getAlternativeMethodName();
        this.method = this.getMethod();
    }

    private Method getMethod() throws JobExecutionException {
        Class<?> methodClass = null;
        try {
            methodClass = Class.forName(this.className);
        }
        catch (ClassNotFoundException e) {
            throw new JobExecutionException(ERROR_CLASS_REFLECTION, e);
        }
        try {
            List<? extends InvocationParam> params = this.invocation.getParams();
            Class[] types = new Class[params.size()];
            int paramIdx = 0;
            for (InvocationParam invocationParam : params) {
                types[paramIdx++] = invocationParam.getValueClass();
            }
            return methodClass.getMethod(this.methodName, types);
        }
        catch (NoSuchMethodException | SecurityException e) {
            throw new JobExecutionException(ERROR_METHOD_REFLECTION, e);
        }
    }

    @Override
    public void invokeMethod() throws JobExecutionException {
        Object retValue = this.runMethod();
        for (InvocationParam invocationParam : this.invocation.getParams()) {
            this.checkSCOPersistence(invocationParam);
        }
        if (this.invocation.getTarget() != null) {
            this.checkSCOPersistence(this.invocation.getTarget());
        }
        for (InvocationParam invocationParam : this.invocation.getResults()) {
            invocationParam.setValue(retValue);
            invocationParam.setValueClass(retValue.getClass());
            this.checkSCOPersistence(invocationParam);
        }
    }

    /*
     * WARNING - void declaration
     */
    protected Object runMethod() throws JobExecutionException {
        List<? extends InvocationParam> params = this.invocation.getParams();
        Object[] values = new Object[params.size()];
        int paramIdx = 0;
        for (InvocationParam invocationParam : params) {
            values[paramIdx++] = invocationParam.getValue();
        }
        InvocationParam targetParam = this.invocation.getTarget();
        Object var5_6 = null;
        if (targetParam != null) {
            Object object = targetParam.getValue();
        }
        Object retValue = null;
        try {
            void var5_8;
            LOGGER.info("Invoked " + this.method.getName() + (var5_8 == null ? "" : " on object " + var5_8) + " in " + this.context.getHostName());
            retValue = this.method.invoke((Object)var5_8, values);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            throw new JobExecutionException("ERROR: Exception executing task (user code)", e);
        }
        return retValue;
    }

    private void checkSCOPersistence(InvocationParam np) {
        boolean potentialPSCO;
        boolean bl = potentialPSCO = np.getType().equals((Object)DataType.OBJECT_T) || np.getType().equals((Object)DataType.PSCO_T);
        if (np.isWriteFinalValue() && potentialPSCO) {
            Object obj = np.getValue();
            String id = null;
            try {
                StubItf psco = (StubItf)obj;
                id = psco.getID();
            }
            catch (Exception e) {
                id = null;
            }
            if (id != null) {
                np.setType(DataType.PSCO_T);
            }
        }
    }
}

