/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.loader.total;

import es.bsc.compss.loader.LoaderConstants;
import es.bsc.compss.loader.LoaderUtils;
import es.bsc.compss.types.annotations.Parameter;
import es.bsc.compss.types.annotations.SchedulerHints;
import es.bsc.compss.types.annotations.parameter.DataType;
import es.bsc.compss.types.annotations.parameter.Direction;
import es.bsc.compss.types.annotations.parameter.Stream;
import es.bsc.compss.types.annotations.parameter.Type;
import es.bsc.compss.types.annotations.task.Binary;
import es.bsc.compss.types.annotations.task.Decaf;
import es.bsc.compss.types.annotations.task.MPI;
import es.bsc.compss.types.annotations.task.Method;
import es.bsc.compss.types.annotations.task.OmpSs;
import es.bsc.compss.types.annotations.task.OpenCL;
import es.bsc.compss.types.annotations.task.Service;
import es.bsc.compss.types.annotations.task.repeatables.Services;
import es.bsc.compss.util.EnvironmentLoader;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.PrintStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Modifier;
import javassist.CannotCompileException;
import javassist.CtClass;
import javassist.CtField;
import javassist.CtMethod;
import javassist.NotFoundException;
import javassist.expr.ExprEditor;
import javassist.expr.FieldAccess;
import javassist.expr.MethodCall;
import javassist.expr.NewExpr;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ITAppEditor
extends ExprEditor {
    private java.lang.reflect.Method[] remoteMethods;
    private CtMethod[] instrCandidates;
    private String itApiVar;
    private String itSRVar;
    private String itORVar;
    private String itAppIdVar;
    private CtClass appClass;
    private static final String GET_INTERNAL_OBJECT = ".getInternalObject(";
    private static final String NEW_OBJECT_ACCESS = ".newObjectAccess(";
    private static final String SERIALIZE_LOCALLY = ".serializeLocally(";
    private static final String NEW_FILTER_STREAM = ".newFilterStream(";
    private static final String STREAM_CLOSED = ".streamClosed(";
    private static final String GET_CANONICAL_PATH = ".getCanonicalPath(";
    private static final String ADD_TASK_FILE = ".addTaskFile(";
    private static final String IS_TASK_FILE = ".isTaskFile(";
    private static final String OPEN_FILE = ".openFile(";
    private static final String DELETE_FILE = ".deleteFile(";
    private static final String EXECUTE_TASK = ".executeTask(";
    private static final String PROCEED = "$_ = $proceed(";
    private static final String DATA_TYPES = DataType.class.getCanonicalName();
    private static final String DATA_DIRECTION = Direction.class.getCanonicalName();
    private static final String DATA_STREAM = Stream.class.getCanonicalName();
    private static final String CHECK_SCO_TYPE = "LoaderUtils.checkSCOType(";
    private static final String RUN_METHOD_ON_OBJECT = "LoaderUtils.runMethodOnObject(";
    private static final Logger LOGGER = LogManager.getLogger("es.bsc.compss.Loader");
    private static final boolean DEBUG = LOGGER.isDebugEnabled();
    private static final String ERROR_NO_EMPTY_CONSTRUCTOR = "ERROR: No empty constructor on object class ";

    public ITAppEditor(java.lang.reflect.Method[] remoteMethods, CtMethod[] instrCandidates, String itApiVar, String itSRVar, String itORVar, String itAppIdVar, CtClass appClass) {
        this.remoteMethods = remoteMethods;
        this.instrCandidates = instrCandidates;
        this.itApiVar = itApiVar;
        this.itSRVar = itSRVar;
        this.itORVar = itORVar;
        this.itAppIdVar = itAppIdVar;
        this.appClass = appClass;
    }

    public CtClass getAppClass() {
        return this.appClass;
    }

    @Override
    public void edit(NewExpr ne) throws CannotCompileException {
        String fullName = ne.getClassName();
        boolean isInternal = fullName.startsWith("es.bsc.compss.");
        boolean isIO = fullName.startsWith("java.io.");
        if (!isInternal) {
            StringBuilder modifiedExpr = new StringBuilder();
            StringBuilder callPars = new StringBuilder();
            StringBuilder toSerialize = new StringBuilder();
            try {
                CtClass[] paramTypes = ne.getConstructor().getParameterTypes();
                if (paramTypes.length > 0) {
                    int i = 1;
                    for (CtClass parType : paramTypes) {
                        if (i > 1) {
                            callPars.append(',');
                        }
                        String parId = "$" + i++;
                        if (parType.isPrimitive()) {
                            callPars.append(parId);
                            continue;
                        }
                        if (DEBUG) {
                            LOGGER.debug("Parameter " + (i - 1) + " of constructor " + ne.getConstructor() + " is an object, adding access");
                        }
                        String internalObject = this.itORVar + GET_INTERNAL_OBJECT + parId + ")";
                        modifiedExpr.insert(0, this.itORVar + NEW_OBJECT_ACCESS + parId + ");");
                        callPars.append(internalObject).append(" == null ? ").append(parId).append(" : ").append("(" + parType.getName() + ")").append(internalObject);
                        toSerialize.append(this.itORVar).append(SERIALIZE_LOCALLY).append(parId).append(");");
                    }
                }
            }
            catch (NotFoundException e) {
                throw new CannotCompileException(e);
            }
            if (isIO) {
                String className = fullName.substring(8);
                modifiedExpr.append(this.inspectCreation(className, callPars));
            } else {
                modifiedExpr.append(PROCEED).append((CharSequence)callPars).append(");");
                modifiedExpr.append((CharSequence)toSerialize);
            }
            if (DEBUG) {
                LOGGER.debug("Replacing regular constructor call of class " + fullName + " by " + modifiedExpr.toString());
            }
            ne.replace(modifiedExpr.toString());
        }
    }

    private String inspectCreation(String className, StringBuilder callPars) {
        String modifiedExpr = "";
        if (DEBUG) {
            LOGGER.debug("Inspecting the creation of an object of class " + className);
        }
        boolean found = false;
        for (String streamClass : LoaderConstants.SUPPORTED_STREAM_TYPES) {
            if (!className.equals(streamClass)) continue;
            modifiedExpr = "$_ = " + this.itSRVar + ".new" + streamClass + "(" + callPars + ");";
            found = true;
            break;
        }
        if (!found) {
            String internalObject = this.itORVar + GET_INTERNAL_OBJECT + "$1)";
            String par1 = internalObject + " == null ? (Object)$1 : " + internalObject;
            modifiedExpr = PROCEED + callPars + "); " + "if ($_ instanceof " + FilterInputStream.class.getCanonicalName() + " || $_ instanceof " + FilterOutputStream.class.getCanonicalName() + ") {" + this.itSRVar + NEW_FILTER_STREAM + par1 + ", (Object)$_); }";
        }
        return modifiedExpr;
    }

    @Override
    public void edit(MethodCall mc) throws CannotCompileException {
        LOGGER.debug("---- BEGIN EDIT METHOD CALL " + mc.getMethodName() + " ----");
        java.lang.reflect.Method declaredMethod = null;
        CtMethod calledMethod = null;
        try {
            calledMethod = mc.getMethod();
            declaredMethod = LoaderUtils.checkRemote(calledMethod, this.remoteMethods);
        }
        catch (NotFoundException e) {
            throw new CannotCompileException(e);
        }
        if (declaredMethod != null) {
            if (DEBUG) {
                LOGGER.debug("Replacing task method call " + mc.getMethodName());
            }
            String executeTask = this.replaceTaskMethodCall(mc.getMethodName(), mc.getClassName(), declaredMethod, calledMethod);
            if (DEBUG) {
                LOGGER.debug("Replacing task method call by " + executeTask);
            }
            mc.replace(executeTask);
        } else if (LoaderUtils.isStreamClose(mc)) {
            if (DEBUG) {
                LOGGER.debug("Replacing close on a stream of class " + mc.getClassName());
            }
            String streamClose = this.replaceCloseStream();
            if (DEBUG) {
                LOGGER.debug("Replacing stream close by " + streamClose);
            }
            mc.replace(streamClose);
        } else if (LoaderUtils.isFileDelete(mc)) {
            if (DEBUG) {
                LOGGER.debug("Replacing delete file");
            }
            String deleteFile = this.replaceDeleteFile();
            if (DEBUG) {
                LOGGER.debug("Replacing delete file by " + deleteFile);
            }
            mc.replace(deleteFile);
        } else if (mc.getClassName().equals(LoaderConstants.CLASS_COMPSS_API)) {
            if (DEBUG) {
                LOGGER.debug("Replacing API call " + mc.getMethodName());
            }
            String modifiedAPICall = this.replaceAPICall(mc.getMethodName(), calledMethod);
            if (DEBUG) {
                LOGGER.debug("Replacing API call by " + modifiedAPICall);
            }
            mc.replace(modifiedAPICall);
        } else if (!LoaderUtils.contains(this.instrCandidates, calledMethod)) {
            if (DEBUG) {
                LOGGER.debug("Replacing regular method call " + mc.getMethodName());
            }
            String modifiedCall = this.replaceBlackBox(mc.getMethodName(), mc.getClassName(), calledMethod);
            if (DEBUG) {
                LOGGER.debug("Replacing regular method call by " + modifiedCall);
            }
            mc.replace(modifiedCall);
        } else if (DEBUG) {
            LOGGER.debug("Skipping instrumented method " + mc.getMethodName());
        }
        LOGGER.debug("---- END EDIT METHOD CALL ----");
    }

    private String replaceTaskMethodCall(String methodName, String className, java.lang.reflect.Method declaredMethod, CtMethod calledMethod) throws CannotCompileException {
        boolean isMethod;
        if (DEBUG) {
            LOGGER.debug("Found call to remote method " + methodName);
        }
        Class<?> retType = declaredMethod.getReturnType();
        boolean isVoid = retType.equals(Void.TYPE);
        boolean isStatic = Modifier.isStatic(calledMethod.getModifiers());
        Class<?>[] paramTypes = declaredMethod.getParameterTypes();
        int numParams = paramTypes.length;
        if (!isStatic) {
            ++numParams;
        }
        if (!isVoid) {
            ++numParams;
        }
        StringBuilder executeTask = new StringBuilder();
        executeTask.append(this.itApiVar).append(EXECUTE_TASK);
        executeTask.append(this.itAppIdVar).append(',');
        boolean isPrioritary = Boolean.parseBoolean("false");
        int numNodes = 1;
        boolean isReplicated = Boolean.parseBoolean("false");
        boolean isDistributed = Boolean.parseBoolean("false");
        if (declaredMethod.isAnnotationPresent(SchedulerHints.class)) {
            SchedulerHints schedAnnot = declaredMethod.getAnnotation(SchedulerHints.class);
            isReplicated = Boolean.parseBoolean(EnvironmentLoader.loadFromEnvironment(schedAnnot.isReplicated()));
            isDistributed = Boolean.parseBoolean(EnvironmentLoader.loadFromEnvironment(schedAnnot.isDistributed()));
        }
        boolean bl = isMethod = !declaredMethod.isAnnotationPresent(Service.class) && !declaredMethod.isAnnotationPresent(Services.class);
        if (isMethod) {
            String numNodesSTR;
            if (declaredMethod.isAnnotationPresent(Method.class)) {
                Method methodAnnot = declaredMethod.getAnnotation(Method.class);
                isPrioritary = Boolean.parseBoolean(EnvironmentLoader.loadFromEnvironment(methodAnnot.priority()));
            } else if (declaredMethod.isAnnotationPresent(MPI.class)) {
                MPI mpiAnnot = declaredMethod.getAnnotation(MPI.class);
                isPrioritary = Boolean.parseBoolean(EnvironmentLoader.loadFromEnvironment(mpiAnnot.priority()));
                numNodesSTR = EnvironmentLoader.loadFromEnvironment(mpiAnnot.computingNodes());
                numNodes = numNodesSTR != null && !numNodesSTR.isEmpty() && !numNodesSTR.equals("[unassigned]") ? Integer.valueOf(numNodesSTR) : 1;
            } else if (declaredMethod.isAnnotationPresent(Decaf.class)) {
                Decaf decafAnnot = declaredMethod.getAnnotation(Decaf.class);
                isPrioritary = Boolean.parseBoolean(EnvironmentLoader.loadFromEnvironment(decafAnnot.priority()));
                numNodesSTR = EnvironmentLoader.loadFromEnvironment(decafAnnot.computingNodes());
                numNodes = numNodesSTR != null && !numNodesSTR.isEmpty() && !numNodesSTR.equals("[unassigned]") ? Integer.valueOf(numNodesSTR) : 1;
            } else if (declaredMethod.isAnnotationPresent(OmpSs.class)) {
                OmpSs ompssAnnot = declaredMethod.getAnnotation(OmpSs.class);
                isPrioritary = Boolean.parseBoolean(EnvironmentLoader.loadFromEnvironment(ompssAnnot.priority()));
            } else if (declaredMethod.isAnnotationPresent(OpenCL.class)) {
                OpenCL openCLAnnot = declaredMethod.getAnnotation(OpenCL.class);
                isPrioritary = Boolean.parseBoolean(EnvironmentLoader.loadFromEnvironment(openCLAnnot.priority()));
            } else if (declaredMethod.isAnnotationPresent(Binary.class)) {
                Binary binaryAnnot = declaredMethod.getAnnotation(Binary.class);
                isPrioritary = Boolean.parseBoolean(EnvironmentLoader.loadFromEnvironment(binaryAnnot.priority()));
            }
            executeTask.append("\"").append(className).append("\"").append(',');
            executeTask.append("\"").append(methodName).append("\"").append(',');
        } else {
            Service serviceAnnot = declaredMethod.getAnnotation(Service.class);
            executeTask.append("\"").append(serviceAnnot.namespace()).append("\"").append(',');
            executeTask.append("\"").append(serviceAnnot.name()).append("\"").append(',');
            executeTask.append("\"").append(serviceAnnot.port()).append("\"").append(',');
            executeTask.append("\"").append(methodName).append("\"").append(',');
        }
        executeTask.append(isPrioritary).append(',');
        executeTask.append(numNodes).append(",");
        executeTask.append(isReplicated).append(',');
        executeTask.append(isDistributed).append(',');
        executeTask.append(!isStatic).append(',');
        executeTask.append(numParams);
        if (numParams == 0) {
            executeTask.append(",null);");
        } else {
            Annotation[][] paramAnnot = declaredMethod.getParameterAnnotations();
            CallInformation callInformation = this.processParameters(declaredMethod, paramAnnot, paramTypes, isVoid, isStatic, isMethod, numParams, retType);
            executeTask.append(callInformation.getToAppend());
            executeTask.insert(0, callInformation.getToPrepend());
        }
        return executeTask.toString();
    }

    private CallInformation processParameters(java.lang.reflect.Method declaredMethod, Annotation[][] paramAnnot, Class<?>[] paramTypes, boolean isVoid, boolean isStatic, boolean isMethod, int numParams, Class<?> retType) throws CannotCompileException {
        StringBuilder toAppend = new StringBuilder("");
        StringBuilder toPrepend = new StringBuilder("");
        toAppend.append(",new Object[]{");
        for (int i = 0; i < paramAnnot.length; ++i) {
            Class<?> formalType = paramTypes[i];
            Parameter par = (Parameter)paramAnnot[i][0];
            ParameterInformation infoParam = this.processParameterValue(i, par, formalType);
            toAppend.append(infoParam.getToAppend());
            toPrepend.insert(0, infoParam.getToPrepend());
            toAppend.append(infoParam.getType()).append(",");
            toAppend.append(infoParam.getDirection()).append(",");
            toAppend.append(infoParam.getStream()).append(",");
            toAppend.append(infoParam.getPrefix() + ",");
            toAppend.append("\"\"");
            if (i >= paramAnnot.length - 1) continue;
            toAppend.append(",");
        }
        String targetObject = this.processTargetObject(declaredMethod, isStatic, numParams, isVoid, isMethod);
        toAppend.append(targetObject);
        ReturnInformation returnInfo = this.processReturnParameter(isVoid, numParams, retType);
        toAppend.append(returnInfo.getToAppend());
        toPrepend.insert(0, returnInfo.getToPrepend());
        toAppend.append("});");
        toAppend.append(returnInfo.getAfterExecution());
        CallInformation callInformation = new CallInformation(toAppend.toString(), toPrepend.toString());
        return callInformation;
    }

    private ParameterInformation processParameterValue(int paramIndex, Parameter par, Class<?> formalType) {
        Type annotType = par.type();
        Direction paramDirection = par.direction();
        Stream paramStream = par.stream();
        String paramPrefix = par.prefix();
        StringBuilder infoToAppend = new StringBuilder("");
        StringBuilder infoToPrepend = new StringBuilder("");
        String type = "";
        if (annotType.equals((Object)Type.FILE)) {
            type = DATA_TYPES + ".FILE_T";
            infoToAppend.append('$').append(paramIndex + 1).append(',');
            infoToPrepend.insert(0, this.itSRVar + ADD_TASK_FILE + "$" + (paramIndex + 1) + ");");
        } else if (annotType.equals((Object)Type.STRING)) {
            type = DATA_TYPES + ".STRING_T";
            infoToAppend.append('$').append(paramIndex + 1).append(',');
        } else if (formalType.isPrimitive()) {
            if (formalType.equals(Boolean.TYPE)) {
                type = DATA_TYPES + ".BOOLEAN_T";
                infoToAppend.append("new Boolean(").append("$").append(paramIndex + 1).append("),");
            } else if (formalType.equals(Character.TYPE)) {
                type = DATA_TYPES + ".CHAR_T";
                infoToAppend.append("new Character(").append("$").append(paramIndex + 1).append("),");
            } else if (formalType.equals(Byte.TYPE)) {
                type = DATA_TYPES + ".BYTE_T";
                infoToAppend.append("new Byte(").append("$").append(paramIndex + 1).append("),");
            } else if (formalType.equals(Short.TYPE)) {
                type = DATA_TYPES + ".SHORT_T";
                infoToAppend.append("new Short(").append("$").append(paramIndex + 1).append("),");
            } else if (formalType.equals(Integer.TYPE)) {
                type = DATA_TYPES + ".INT_T";
                infoToAppend.append("new Integer(").append("$").append(paramIndex + 1).append("),");
            } else if (formalType.equals(Long.TYPE)) {
                type = DATA_TYPES + ".LONG_T";
                infoToAppend.append("new Long(").append("$").append(paramIndex + 1).append("),");
            } else if (formalType.equals(Float.TYPE)) {
                type = DATA_TYPES + ".FLOAT_T";
                infoToAppend.append("new Float(").append("$").append(paramIndex + 1).append("),");
            } else if (formalType.equals(Double.TYPE)) {
                type = DATA_TYPES + ".DOUBLE_T";
                infoToAppend.append("new Double(").append("$").append(paramIndex + 1).append("),");
            }
        } else {
            type = "LoaderUtils.checkSCOType($" + (paramIndex + 1) + ")";
            infoToAppend.append("$").append(paramIndex + 1).append(",");
        }
        ParameterInformation infoParam = new ParameterInformation(infoToAppend.toString(), infoToPrepend.toString(), type, paramDirection, paramStream, paramPrefix);
        return infoParam;
    }

    private String processTargetObject(java.lang.reflect.Method declaredMethod, boolean isStatic, int numParams, boolean isVoid, boolean isMethod) {
        StringBuilder targetObj = new StringBuilder("");
        if (!isStatic) {
            int numRealParams;
            int n = numRealParams = isVoid ? numParams : numParams - 1;
            if (numRealParams > 1) {
                targetObj.append(',');
            }
            targetObj.append("$0,");
            targetObj.append("LoaderUtils.checkSCOType($0)");
            if (isMethod) {
                Method methodAnnot = declaredMethod.getAnnotation(Method.class);
                boolean isModifier = Boolean.parseBoolean(EnvironmentLoader.loadFromEnvironment(methodAnnot.isModifier()));
                if (isModifier) {
                    targetObj.append(',').append(DATA_DIRECTION + ".INOUT");
                } else {
                    targetObj.append(',').append(DATA_DIRECTION + ".IN");
                }
            } else {
                targetObj.append(',').append(DATA_DIRECTION + ".INOUT");
            }
            targetObj.append(',').append(DATA_STREAM + "." + (Object)((Object)Stream.UNSPECIFIED));
            targetObj.append(',').append("\"").append("null").append("\"");
            targetObj.append(',').append("\"").append("\"");
        }
        return targetObj.toString();
    }

    private ReturnInformation processReturnParameter(boolean isVoid, int numParams, Class<?> retType) throws CannotCompileException {
        StringBuilder infoToAppend = new StringBuilder("");
        StringBuilder infoToPrepend = new StringBuilder("");
        StringBuilder afterExecute = new StringBuilder("");
        if (!isVoid) {
            String typeName;
            if (numParams > 1) {
                infoToAppend.append(',');
            }
            if (retType.isPrimitive()) {
                String converterMethod;
                String cast;
                String tempRetVar = "ret" + System.nanoTime();
                infoToAppend.append(tempRetVar).append(',').append(DATA_TYPES + ".OBJECT_T").append(',').append(DATA_DIRECTION + ".OUT").append(',').append(DATA_STREAM + "." + (Object)((Object)Stream.UNSPECIFIED)).append(',').append("\"").append("null").append("\"").append(",").append("\"").append("\"");
                String retValueCreation = "Object " + tempRetVar + " = ";
                if (retType.isAssignableFrom(Boolean.TYPE)) {
                    retValueCreation = retValueCreation + "new Boolean(false);";
                    cast = "(Boolean)";
                    converterMethod = "booleanValue()";
                } else if (retType.isAssignableFrom(Character.TYPE)) {
                    retValueCreation = retValueCreation + "new Character(Character.MIN_VALUE);";
                    cast = "(Character)";
                    converterMethod = "charValue()";
                } else if (retType.isAssignableFrom(Byte.TYPE)) {
                    retValueCreation = retValueCreation + "new Byte(Byte.MIN_VALUE);";
                    cast = "(Byte)";
                    converterMethod = "byteValue()";
                } else if (retType.isAssignableFrom(Short.TYPE)) {
                    retValueCreation = retValueCreation + "new Short(Short.MIN_VALUE);";
                    cast = "(Short)";
                    converterMethod = "shortValue()";
                } else if (retType.isAssignableFrom(Integer.TYPE)) {
                    retValueCreation = retValueCreation + "new Integer(Integer.MIN_VALUE);";
                    cast = "(Integer)";
                    converterMethod = "intValue()";
                } else if (retType.isAssignableFrom(Long.TYPE)) {
                    retValueCreation = retValueCreation + "new Long(Long.MIN_VALUE);";
                    cast = "(Long)";
                    converterMethod = "longValue()";
                } else if (retType.isAssignableFrom(Float.TYPE)) {
                    retValueCreation = retValueCreation + "new Float(Float.MIN_VALUE);";
                    cast = "(Float)";
                    converterMethod = "floatValue()";
                } else {
                    retValueCreation = retValueCreation + "new Double(Double.MIN_VALUE);";
                    cast = "(Double)";
                    converterMethod = "doubleValue()";
                }
                infoToPrepend.insert(0, retValueCreation);
                afterExecute.append(this.itORVar).append(NEW_OBJECT_ACCESS).append(tempRetVar).append(");");
                afterExecute.append("$_ = (").append(cast).append(this.itORVar).append(GET_INTERNAL_OBJECT).append(tempRetVar).append(")).").append(converterMethod).append(";");
            } else if (retType.isArray()) {
                typeName = retType.getName();
                Class<?> compType = retType.getComponentType();
                int numDim = typeName.lastIndexOf(91);
                String dims = "[0]";
                while (numDim-- > 0) {
                    dims = dims + "[]";
                }
                while (compType.getComponentType() != null) {
                    compType = compType.getComponentType();
                }
                String compTypeName = compType.getName();
                infoToPrepend.insert(0, "$_ = new " + compTypeName + dims + ';');
                infoToAppend.append("$_,").append(DATA_TYPES + ".OBJECT_T");
                infoToAppend.append(',').append(DATA_DIRECTION + ".OUT");
                infoToAppend.append(',').append(DATA_STREAM + ".UNSPECIFIED");
                infoToAppend.append(',').append("\"").append("null").append("\"");
                infoToAppend.append(',').append("\"").append("\"");
            } else {
                if (retType.isAssignableFrom(Boolean.class)) {
                    infoToPrepend.insert(0, "$_ = new Boolean(false);");
                } else if (retType.isAssignableFrom(Character.class)) {
                    infoToPrepend.insert(0, "$_ = new Character(Character.MIN_VALUE);");
                } else if (retType.isAssignableFrom(Byte.class)) {
                    infoToPrepend.insert(0, "$_ = new Byte(Byte.MIN_VALUE);");
                } else if (retType.isAssignableFrom(Short.class)) {
                    infoToPrepend.insert(0, "$_ = new Short(Short.MIN_VALUE);");
                } else if (retType.isAssignableFrom(Integer.class)) {
                    infoToPrepend.insert(0, "$_ = new Integer(Integer.MIN_VALUE);");
                } else if (retType.isAssignableFrom(Long.class)) {
                    infoToPrepend.insert(0, "$_ = new Long(Long.MIN_VALUE);");
                } else if (retType.isAssignableFrom(Float.class)) {
                    infoToPrepend.insert(0, "$_ = new Float(Float.MIN_VALUE);");
                } else if (retType.isAssignableFrom(Double.class)) {
                    infoToPrepend.insert(0, "$_ = new Double(Double.MIN_VALUE);");
                } else {
                    typeName = retType.getName();
                    try {
                        Class.forName(typeName).getConstructor(new Class[0]);
                    }
                    catch (ClassNotFoundException | NoSuchMethodException | SecurityException e) {
                        throw new CannotCompileException(ERROR_NO_EMPTY_CONSTRUCTOR + typeName);
                    }
                    infoToPrepend.insert(0, "$_ = new " + typeName + "();");
                }
                infoToAppend.append("$_,").append("LoaderUtils.checkSCOType($_)");
                infoToAppend.append(',').append(DATA_DIRECTION + ".OUT");
                infoToAppend.append(',').append(DATA_STREAM + ".UNSPECIFIED");
                infoToAppend.append(',').append("\"").append("null").append("\"");
                infoToAppend.append(',').append("\"").append("\"");
            }
        }
        ReturnInformation returnInfo = new ReturnInformation(infoToAppend.toString(), infoToPrepend.toString(), afterExecute.toString());
        return returnInfo;
    }

    private String replaceCloseStream() {
        String streamClose = "$_ = $proceed($$); " + this.itSRVar + STREAM_CLOSED + "$0);";
        return streamClose;
    }

    private String replaceDeleteFile() {
        String deleteFile = "$_ = " + this.itApiVar + DELETE_FILE + "$0" + GET_CANONICAL_PATH + "));";
        return deleteFile;
    }

    private String replaceAPICall(String methodName, CtMethod method) throws CannotCompileException {
        boolean isVoid = false;
        boolean hasArgs = false;
        try {
            Class<?> retType = method.getReturnType().getClass();
            isVoid = retType.equals(Void.TYPE);
            hasArgs = method.getParameterTypes().length != 0;
        }
        catch (NotFoundException e) {
            throw new CannotCompileException(e);
        }
        StringBuilder apiCall = new StringBuilder("");
        if (isVoid) {
            apiCall.append("$_ = ").append(this.itApiVar);
        } else {
            apiCall.append(this.itApiVar);
        }
        apiCall.append(".").append(methodName).append("(").append(this.itAppIdVar);
        if (hasArgs) {
            apiCall.append(", $$");
        }
        apiCall.append(");");
        return apiCall.toString();
    }

    private String replaceBlackBox(String methodName, String className, CtMethod method) throws CannotCompileException {
        if (DEBUG) {
            LOGGER.debug("Inspecting method call to black-box method " + methodName + ", looking for objects");
        }
        StringBuilder modifiedCall = new StringBuilder();
        StringBuilder toSerialize = new StringBuilder();
        boolean isArrayWatch = method.getDeclaringClass().getName().equals(LoaderConstants.CLASS_ARRAY_ACCESS_WATCHER);
        modifiedCall.append(this.itORVar).append(".newObjectAccess($0);");
        toSerialize.append(this.itORVar).append(".serializeLocally($0);");
        String redirectedCallPars = null;
        try {
            CtClass[] paramTypes = method.getParameterTypes();
            if (paramTypes.length > 0) {
                int i = 1;
                StringBuilder aux1 = new StringBuilder("new Object[] {");
                for (CtClass parType : paramTypes) {
                    if (i > 1) {
                        aux1.append(',');
                    }
                    String parId = "$" + i;
                    if (parType.isPrimitive()) {
                        if (parType.equals(CtClass.booleanType)) {
                            aux1.append("new Boolean(").append(parId).append(')');
                        } else if (parType.equals(CtClass.charType)) {
                            aux1.append("new Character(").append(parId).append(')');
                        } else if (parType.equals(CtClass.byteType)) {
                            aux1.append("new Byte(").append(parId).append(')');
                        } else if (parType.equals(CtClass.shortType)) {
                            aux1.append("new Short(").append(parId).append(')');
                        } else if (parType.equals(CtClass.intType)) {
                            aux1.append("new Integer(").append(parId).append(')');
                        } else if (parType.equals(CtClass.longType)) {
                            aux1.append("new Long(").append(parId).append(')');
                        } else if (parType.equals(CtClass.floatType)) {
                            aux1.append("new Float(").append(parId).append(')');
                        } else {
                            aux1.append("new Double(").append(parId).append(')');
                        }
                    } else if (parType.getName().equals(String.class.getName())) {
                        if (DEBUG) {
                            LOGGER.debug("Parameter " + i + " of black-box method " + methodName + " is an String, adding File/object access");
                        }
                        if (isArrayWatch && i == 3) {
                            aux1.append(parId);
                        } else {
                            String internalObject;
                            String calledClass = className;
                            if (calledClass.equals(PrintStream.class.getName()) || calledClass.equals(StringBuilder.class.getName())) {
                                internalObject = this.itORVar + GET_INTERNAL_OBJECT + parId + ')';
                                modifiedCall.insert(0, this.itORVar + NEW_OBJECT_ACCESS + parId + ");");
                                aux1.append(internalObject).append(" == null ? ").append(parId).append(" : ").append("(" + parType.getName() + ")").append(internalObject);
                                toSerialize.append(this.itORVar).append(SERIALIZE_LOCALLY).append(parId).append(");");
                            } else {
                                internalObject = this.itORVar + GET_INTERNAL_OBJECT + parId + ')';
                                String taskFile = this.itSRVar + IS_TASK_FILE + parId + ")";
                                String apiOpenFile = this.itApiVar + OPEN_FILE + parId + ", " + DATA_DIRECTION + ".INOUT)";
                                modifiedCall.insert(0, this.itORVar + NEW_OBJECT_ACCESS + parId + ");");
                                aux1.append(taskFile).append(" ? ").append(apiOpenFile).append(" : ").append(internalObject).append(" == null ? ").append(parId).append(" : ").append("(" + parType.getName() + ")").append(internalObject);
                                toSerialize.append(this.itORVar).append(SERIALIZE_LOCALLY).append(parId).append(");");
                            }
                        }
                    } else {
                        if (DEBUG) {
                            LOGGER.debug("Parameter " + i + " of black-box method " + methodName + " is an object, adding access");
                        }
                        if (isArrayWatch && i == 3) {
                            aux1.append(parId);
                        } else {
                            String internalObject = this.itORVar + GET_INTERNAL_OBJECT + parId + ')';
                            modifiedCall.insert(0, this.itORVar + NEW_OBJECT_ACCESS + parId + ");");
                            aux1.append(internalObject).append(" == null ? ").append(parId).append(" : ").append("(" + parType.getName() + ")").append(internalObject);
                            toSerialize.append(this.itORVar).append(SERIALIZE_LOCALLY).append(parId).append(");");
                        }
                    }
                    ++i;
                }
                aux1.append("}");
                redirectedCallPars = aux1.toString();
            }
        }
        catch (NotFoundException e) {
            throw new CannotCompileException(e);
        }
        String internalObject = this.itORVar + GET_INTERNAL_OBJECT + "$0)";
        modifiedCall.append("if (").append(internalObject).append(" != null) {").append("$_ = ($r)LoaderUtils.runMethodOnObject(").append(internalObject).append(",$class,\"").append(methodName).append("\",").append(redirectedCallPars).append(",$sig);").append("}else { $_ = ($r)LoaderUtils.runMethodOnObject($0,$class,\"").append(methodName).append("\",").append(redirectedCallPars).append(",$sig); }");
        modifiedCall.append((CharSequence)toSerialize);
        return modifiedCall.toString();
    }

    @Override
    public void edit(FieldAccess fa) throws CannotCompileException {
        CtField field = null;
        try {
            field = fa.getField();
            if (Modifier.isStatic(field.getModifiers())) {
                return;
            }
        }
        catch (NotFoundException e) {
            throw new CannotCompileException(e);
        }
        String fieldName = field.getName();
        if (DEBUG) {
            LOGGER.debug("Keeping track of access to field " + fieldName + " of class " + field.getDeclaringClass().getName());
        }
        boolean isWriter = fa.isWriter();
        StringBuilder toInclude = new StringBuilder();
        toInclude.append(this.itORVar).append(NEW_OBJECT_ACCESS).append("$0,").append(isWriter).append(");");
        String internalObject = this.itORVar + GET_INTERNAL_OBJECT + "$0)";
        String objectClass = fa.getClassName();
        toInclude.append("if (").append(internalObject).append(" != null) {");
        if (isWriter) {
            toInclude.append("((").append(objectClass).append(')').append(internalObject).append(").").append(fieldName).append(" = $1;");
            toInclude.append("} else { $_ = $proceed($$); }");
            toInclude.append(this.itORVar).append(".serializeLocally($0);");
        } else {
            toInclude.append("$_ = ((").append(objectClass).append(')').append(internalObject).append(").").append(fieldName).append(';');
            toInclude.append("} else { $_ = $proceed($$); }");
        }
        fa.replace(toInclude.toString());
        if (DEBUG) {
            LOGGER.debug("Replaced regular field access by " + toInclude.toString());
        }
    }

    private class CallInformation {
        private final String toAppend;
        private final String toPrepend;

        public CallInformation(String toAppend, String toPrepend) {
            this.toAppend = toAppend;
            this.toPrepend = toPrepend;
        }

        public String getToAppend() {
            return this.toAppend;
        }

        public String getToPrepend() {
            return this.toPrepend;
        }
    }

    private class ReturnInformation {
        private final String toAppend;
        private final String toPrepend;
        private final String afterExecution;

        public ReturnInformation(String toAppend, String toPrepend, String afterExecution) {
            this.toAppend = toAppend;
            this.toPrepend = toPrepend;
            this.afterExecution = afterExecution;
        }

        public String getToAppend() {
            return this.toAppend;
        }

        public String getToPrepend() {
            return this.toPrepend;
        }

        public String getAfterExecution() {
            return this.afterExecution;
        }
    }

    private class ParameterInformation {
        private final String toAppend;
        private final String toPrepend;
        private final String type;
        private final Direction direction;
        private final Stream stream;
        private final String prefix;

        public ParameterInformation(String toAppend, String toPrepend, String type, Direction direction, Stream stream, String prefix) {
            this.toAppend = toAppend;
            this.toPrepend = toPrepend;
            this.type = type;
            this.direction = direction;
            this.stream = stream;
            this.prefix = prefix;
        }

        public String getToAppend() {
            return this.toAppend;
        }

        public String getToPrepend() {
            return this.toPrepend;
        }

        public String getType() {
            return this.type;
        }

        public String getDirection() {
            return DATA_DIRECTION + "." + this.direction.name();
        }

        public String getStream() {
            return DATA_STREAM + "." + this.stream.name();
        }

        public String getPrefix() {
            return "\"" + this.prefix + "\"";
        }
    }
}

