/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.types.request.td;

import es.bsc.compss.components.impl.TaskScheduler;
import es.bsc.compss.types.implementations.AbstractMethodImplementation;
import es.bsc.compss.types.implementations.BinaryImplementation;
import es.bsc.compss.types.implementations.COMPSsImplementation;
import es.bsc.compss.types.implementations.DecafImplementation;
import es.bsc.compss.types.implementations.Implementation;
import es.bsc.compss.types.implementations.MPIImplementation;
import es.bsc.compss.types.implementations.MethodImplementation;
import es.bsc.compss.types.implementations.OmpSsImplementation;
import es.bsc.compss.types.implementations.OpenCLImplementation;
import es.bsc.compss.types.request.td.TDRequest;
import es.bsc.compss.types.resources.MethodResourceDescription;
import es.bsc.compss.util.CoreManager;
import es.bsc.compss.util.EnvironmentLoader;
import es.bsc.compss.util.ErrorManager;
import es.bsc.compss.util.ResourceManager;
import java.util.LinkedList;
import java.util.concurrent.Semaphore;

public class CERegistration
extends TDRequest {
    private final String coreElementSignature;
    private final String implSignature;
    private final MethodResourceDescription implConstraints;
    private final AbstractMethodImplementation.MethodType implType;
    private final String[] implTypeArgs;
    private final Semaphore sem;

    public CERegistration(String coreElementSignature, String implSignature, MethodResourceDescription implConstraints, AbstractMethodImplementation.MethodType implType, String[] implTypeArgs, Semaphore sem) {
        this.coreElementSignature = coreElementSignature;
        this.implSignature = implSignature;
        this.implConstraints = implConstraints;
        this.implType = implType;
        this.implTypeArgs = implTypeArgs;
        this.sem = sem;
    }

    public Semaphore getSemaphore() {
        return this.sem;
    }

    @Override
    public void process(TaskScheduler ts) {
        Integer coreId = CoreManager.registerNewCoreElement(this.coreElementSignature);
        if (coreId == null) {
            coreId = CoreManager.getCoreId(this.coreElementSignature);
        }
        Integer implId = CoreManager.getNumberCoreImplementations(coreId);
        AbstractMethodImplementation m = null;
        switch (this.implType) {
            case METHOD: {
                if (this.implTypeArgs.length != 2) {
                    ErrorManager.error("Incorrect parameters for type METHOD on " + this.coreElementSignature);
                }
                String declaringClass = EnvironmentLoader.loadFromEnvironment(this.implTypeArgs[0]);
                String methodName = EnvironmentLoader.loadFromEnvironment(this.implTypeArgs[1]);
                if (declaringClass == null || declaringClass.isEmpty()) {
                    ErrorManager.error("Empty declaringClass annotation for method " + this.coreElementSignature);
                }
                if (methodName == null || methodName.isEmpty()) {
                    ErrorManager.error("Empty methodName annotation for method " + this.coreElementSignature);
                }
                m = new MethodImplementation(declaringClass, methodName, coreId, implId, this.implConstraints);
                break;
            }
            case BINARY: {
                if (this.implTypeArgs.length != 2) {
                    ErrorManager.error("Incorrect parameters for type BINARY on " + this.coreElementSignature);
                }
                String binary = EnvironmentLoader.loadFromEnvironment(this.implTypeArgs[0]);
                String binaryWorkingDir = EnvironmentLoader.loadFromEnvironment(this.implTypeArgs[1]);
                if (binary == null || binary.isEmpty()) {
                    ErrorManager.error("Empty binary annotation for BINARY method " + this.coreElementSignature);
                }
                m = new BinaryImplementation(binary, binaryWorkingDir, coreId, implId, this.implConstraints);
                break;
            }
            case MPI: {
                if (this.implTypeArgs.length != 3) {
                    ErrorManager.error("Incorrect parameters for type MPI on " + this.coreElementSignature);
                }
                String mpiBinary = EnvironmentLoader.loadFromEnvironment(this.implTypeArgs[0]);
                String mpiWorkingDir = EnvironmentLoader.loadFromEnvironment(this.implTypeArgs[1]);
                String mpiRunner = EnvironmentLoader.loadFromEnvironment(this.implTypeArgs[2]);
                if (mpiRunner == null || mpiRunner.isEmpty()) {
                    ErrorManager.error("Empty mpiRunner annotation for MPI method " + this.coreElementSignature);
                }
                if (mpiBinary == null || mpiBinary.isEmpty()) {
                    ErrorManager.error("Empty binary annotation for MPI method " + this.coreElementSignature);
                }
                m = new MPIImplementation(mpiBinary, mpiWorkingDir, mpiRunner, coreId, implId, this.implConstraints);
                break;
            }
            case COMPSs: {
                if (this.implTypeArgs.length != 4) {
                    ErrorManager.error("Incorrect parameters for type MPI on " + this.coreElementSignature);
                }
                String runcompss = EnvironmentLoader.loadFromEnvironment(this.implTypeArgs[0]);
                String flags = EnvironmentLoader.loadFromEnvironment(this.implTypeArgs[1]);
                String appName = EnvironmentLoader.loadFromEnvironment(this.implTypeArgs[2]);
                String compssWorkingDir = EnvironmentLoader.loadFromEnvironment(this.implTypeArgs[3]);
                if (appName == null || appName.isEmpty()) {
                    ErrorManager.error("Empty appName annotation for COMPSs method " + this.coreElementSignature);
                }
                m = new COMPSsImplementation(runcompss, flags, appName, compssWorkingDir, coreId, implId, this.implConstraints);
                break;
            }
            case DECAF: {
                if (this.implTypeArgs.length != 5) {
                    ErrorManager.error("Incorrect parameters for type DECAF on " + this.coreElementSignature);
                }
                String dfScript = EnvironmentLoader.loadFromEnvironment(this.implTypeArgs[0]);
                String dfExecutor = EnvironmentLoader.loadFromEnvironment(this.implTypeArgs[1]);
                String dfLib = EnvironmentLoader.loadFromEnvironment(this.implTypeArgs[2]);
                String decafWorkingDir = EnvironmentLoader.loadFromEnvironment(this.implTypeArgs[3]);
                String decafRunner = EnvironmentLoader.loadFromEnvironment(this.implTypeArgs[4]);
                if (decafRunner == null || decafRunner.isEmpty()) {
                    ErrorManager.error("Empty mpiRunner annotation for DECAF method " + this.coreElementSignature);
                }
                if (dfScript == null || dfScript.isEmpty()) {
                    ErrorManager.error("Empty dfScript annotation for DECAF method " + this.coreElementSignature);
                }
                m = new DecafImplementation(dfScript, dfExecutor, dfLib, decafWorkingDir, decafRunner, coreId, implId, this.implConstraints);
                break;
            }
            case OMPSS: {
                if (this.implTypeArgs.length != 2) {
                    ErrorManager.error("Incorrect parameters for type OMPSS on " + this.coreElementSignature);
                }
                String ompssBinary = EnvironmentLoader.loadFromEnvironment(this.implTypeArgs[0]);
                String ompssWorkingDir = EnvironmentLoader.loadFromEnvironment(this.implTypeArgs[1]);
                if (ompssBinary == null || ompssBinary.isEmpty()) {
                    ErrorManager.error("Empty binary annotation for OmpSs method " + this.coreElementSignature);
                }
                m = new OmpSsImplementation(ompssBinary, ompssWorkingDir, coreId, implId, this.implConstraints);
                break;
            }
            case OPENCL: {
                if (this.implTypeArgs.length != 2) {
                    ErrorManager.error("Incorrect parameters for type OPENCL on " + this.coreElementSignature);
                }
                String openclKernel = EnvironmentLoader.loadFromEnvironment(this.implTypeArgs[0]);
                String openclWorkingDir = EnvironmentLoader.loadFromEnvironment(this.implTypeArgs[1]);
                if (openclKernel == null || openclKernel.isEmpty()) {
                    ErrorManager.error("Empty kernel annotation for OpenCL method " + this.coreElementSignature);
                }
                m = new OpenCLImplementation(openclKernel, openclWorkingDir, coreId, implId, this.implConstraints);
            }
        }
        LinkedList<Implementation> newImpls = new LinkedList<Implementation>();
        newImpls.add(m);
        LinkedList<String> newSignatures = new LinkedList<String>();
        newSignatures.add(this.implSignature);
        CoreManager.registerNewImplementations(coreId, newImpls, newSignatures);
        LinkedList<Integer> newCores = new LinkedList<Integer>();
        newCores.add(coreId);
        ResourceManager.coreElementUpdates(newCores);
        ts.coreElementsUpdated();
        LOGGER.debug("Data structures resized and CE-resources links updated");
        this.sem.release();
    }

    @Override
    public TDRequest.TDRequestType getType() {
        return TDRequest.TDRequestType.CE_REGISTRATION;
    }
}

