/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.util.parsers;

import es.bsc.compss.types.annotations.Constraints;
import es.bsc.compss.types.annotations.Parameter;
import es.bsc.compss.types.annotations.SchedulerHints;
import es.bsc.compss.types.annotations.parameter.Direction;
import es.bsc.compss.types.annotations.parameter.Stream;
import es.bsc.compss.types.annotations.parameter.Type;
import es.bsc.compss.types.annotations.task.Binary;
import es.bsc.compss.types.annotations.task.COMPSs;
import es.bsc.compss.types.annotations.task.Decaf;
import es.bsc.compss.types.annotations.task.MPI;
import es.bsc.compss.types.annotations.task.Method;
import es.bsc.compss.types.annotations.task.OmpSs;
import es.bsc.compss.types.annotations.task.OpenCL;
import es.bsc.compss.types.annotations.task.Service;
import es.bsc.compss.types.annotations.task.repeatables.Binaries;
import es.bsc.compss.types.annotations.task.repeatables.Decafs;
import es.bsc.compss.types.annotations.task.repeatables.MPIs;
import es.bsc.compss.types.annotations.task.repeatables.Methods;
import es.bsc.compss.types.annotations.task.repeatables.MultiCOMPSs;
import es.bsc.compss.types.annotations.task.repeatables.MultiOmpSs;
import es.bsc.compss.types.annotations.task.repeatables.OpenCLs;
import es.bsc.compss.types.annotations.task.repeatables.Services;
import es.bsc.compss.types.implementations.AbstractMethodImplementation;
import es.bsc.compss.types.implementations.BinaryImplementation;
import es.bsc.compss.types.implementations.COMPSsImplementation;
import es.bsc.compss.types.implementations.DecafImplementation;
import es.bsc.compss.types.implementations.Implementation;
import es.bsc.compss.types.implementations.MPIImplementation;
import es.bsc.compss.types.implementations.MethodImplementation;
import es.bsc.compss.types.implementations.OmpSsImplementation;
import es.bsc.compss.types.implementations.OpenCLImplementation;
import es.bsc.compss.types.implementations.ServiceImplementation;
import es.bsc.compss.types.resources.MethodResourceDescription;
import es.bsc.compss.util.CoreManager;
import es.bsc.compss.util.EnvironmentLoader;
import es.bsc.compss.util.ErrorManager;
import java.lang.annotation.Annotation;
import java.util.LinkedList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ITFParser {
    private static final Logger LOGGER = LogManager.getLogger("es.bsc.compss.Components.TaskDispatcher.TaskScheduler");
    private static final boolean debug = LOGGER.isDebugEnabled();

    public static List<Integer> parseITFMethods(Class<?> annotItfClass) {
        LinkedList<Integer> updatedMethods = new LinkedList<Integer>();
        int coreCount = annotItfClass.getDeclaredMethods().length;
        if (debug) {
            LOGGER.debug("Detected methods " + coreCount);
        }
        for (java.lang.reflect.Method m : annotItfClass.getDeclaredMethods()) {
            Integer methodId = ITFParser.parseITFMethod(m);
            updatedMethods.add(methodId);
        }
        return updatedMethods;
    }

    private static Integer parseITFMethod(java.lang.reflect.Method m) {
        LOGGER.info("Evaluating method " + m.getName());
        StringBuilder calleeMethodSignature = new StringBuilder();
        String methodName = m.getName();
        calleeMethodSignature.append(methodName).append("(");
        ITFParser.checkMethodAnnotation(m);
        boolean hasNonNative = ITFParser.checkNonNativeAnnotation(m);
        boolean[] hasAnnotations = ITFParser.constructSignatureAndCheckParameters(m, hasNonNative, calleeMethodSignature);
        boolean hasStreams = hasAnnotations[0];
        boolean hasPrefixes = hasAnnotations[1];
        Integer methodId = CoreManager.registerNewCoreElement(calleeMethodSignature.toString());
        if (debug) {
            LOGGER.debug("   * Method methodId = " + methodId + " has " + m.getAnnotations().length + " annotations");
        }
        LinkedList<Implementation> implementations = new LinkedList<Implementation>();
        LinkedList<String> signatures = new LinkedList<String>();
        ITFParser.checkDefinedImplementations(m, methodId, calleeMethodSignature, hasStreams, hasPrefixes, implementations, signatures);
        String ERROR_ITF = "[ERROR] Impossible to parse the method '" + methodName + "' check your Itf file.";
        try {
            CoreManager.registerNewImplementations(methodId, implementations, signatures);
        }
        catch (RuntimeException e) {
            ErrorManager.fatal(ERROR_ITF, e);
        }
        return methodId;
    }

    private static void checkMethodAnnotation(java.lang.reflect.Method m) {
        for (Annotation annot : m.getAnnotations()) {
            if (annot.annotationType().getName().equals(Constraints.class.getName()) || annot.annotationType().getName().equals(Method.class.getName()) || annot.annotationType().getName().equals(Service.class.getName()) || annot.annotationType().getName().equals(MPI.class.getName()) || annot.annotationType().getName().equals(Decaf.class.getName()) || annot.annotationType().getName().equals(COMPSs.class.getName()) || annot.annotationType().getName().equals(OmpSs.class.getName()) || annot.annotationType().getName().equals(OpenCL.class.getName()) || annot.annotationType().getName().equals(Binary.class.getName()) || annot.annotationType().getName().equals(Methods.class.getName()) || annot.annotationType().getName().equals(Services.class.getName()) || annot.annotationType().getName().equals(Decafs.class.getName()) || annot.annotationType().getName().equals(MultiCOMPSs.class.getName()) || annot.annotationType().getName().equals(MultiOmpSs.class.getName()) || annot.annotationType().getName().equals(OpenCLs.class.getName()) || annot.annotationType().getName().equals(Binaries.class.getName()) || annot.annotationType().getName().equals(SchedulerHints.class.getName())) continue;
            ErrorManager.warn("Unrecognised annotation " + annot.annotationType().getName() + " . SKIPPING");
        }
    }

    private static boolean checkNonNativeAnnotation(java.lang.reflect.Method m) {
        for (Annotation annot : m.getAnnotations()) {
            if (!annot.annotationType().getName().equals(MPI.class.getName()) && !annot.annotationType().getName().equals(Decaf.class.getName()) && !annot.annotationType().getName().equals(COMPSs.class.getName()) && !annot.annotationType().getName().equals(OmpSs.class.getName()) && !annot.annotationType().getName().equals(OpenCL.class.getName()) && !annot.annotationType().getName().equals(Binary.class.getName()) && !annot.annotationType().getName().equals(MPIs.class.getName()) && !annot.annotationType().getName().equals(Decafs.class.getName()) && !annot.annotationType().getName().equals(MultiCOMPSs.class.getName()) && !annot.annotationType().getName().equals(MultiOmpSs.class.getName()) && !annot.annotationType().getName().equals(OpenCLs.class.getName()) && !annot.annotationType().getName().equals(Binaries.class.getName())) continue;
            return true;
        }
        return false;
    }

    private static boolean[] constructSignatureAndCheckParameters(java.lang.reflect.Method m, boolean hasNonNative, StringBuilder calleeMethodSignature) {
        boolean hasStreams = false;
        boolean hasPrefixes = false;
        String methodName = m.getName();
        boolean hasSTDIN = false;
        boolean hasSTDOUT = false;
        boolean hasSTDERR = false;
        int numPars = m.getParameterAnnotations().length;
        if (numPars > 0) {
            for (int i = 0; i < numPars; ++i) {
                Parameter par = (Parameter)m.getParameterAnnotations()[i][0];
                Class<?> parType = m.getParameterTypes()[i];
                Type annotType = par.type();
                String type = ITFParser.inferType(parType, annotType);
                if (i >= 1) {
                    calleeMethodSignature.append(",");
                }
                calleeMethodSignature.append(type);
                switch (par.stream()) {
                    case STDIN: {
                        if (hasSTDIN) {
                            ErrorManager.error("Method " + methodName + " has more than one parameter annotated has Stream.STDIN");
                        }
                        hasSTDIN = true;
                        break;
                    }
                    case STDOUT: {
                        if (hasSTDOUT) {
                            ErrorManager.error("Method " + methodName + " has more than one parameter annotated has Stream.STDOUT");
                        }
                        hasSTDOUT = true;
                        break;
                    }
                    case STDERR: {
                        if (hasSTDERR) {
                            ErrorManager.error("Method " + methodName + " has more than one parameter annotated has Stream.STDERR");
                        }
                        hasSTDERR = true;
                        break;
                    }
                }
                hasStreams = hasStreams || !par.stream().equals((Object)Stream.UNSPECIFIED);
                hasPrefixes = hasPrefixes || !par.prefix().equals("null");
                ITFParser.checkParameterAnnotation(m, par, i, hasNonNative);
            }
        }
        calleeMethodSignature.append(")");
        boolean[] hasAnnotation = new boolean[]{hasStreams, hasPrefixes};
        return hasAnnotation;
    }

    private static String inferType(Class<?> formalType, Type annotType) {
        if (annotType.equals((Object)Type.UNSPECIFIED)) {
            if (formalType.isPrimitive()) {
                if (formalType.equals(Boolean.TYPE)) {
                    return "BOOLEAN_T";
                }
                if (formalType.equals(Character.TYPE)) {
                    return "CHAR_T";
                }
                if (formalType.equals(Byte.TYPE)) {
                    return "BYTE_T";
                }
                if (formalType.equals(Short.TYPE)) {
                    return "SHORT_T";
                }
                if (formalType.equals(Integer.TYPE)) {
                    return "INT_T";
                }
                if (formalType.equals(Long.TYPE)) {
                    return "LONG_T";
                }
                if (formalType.equals(Float.TYPE)) {
                    return "FLOAT_T";
                }
                return "DOUBLE_T";
            }
            return "OBJECT_T";
        }
        return (Object)((Object)annotType) + "_T";
    }

    private static void checkParameterAnnotation(java.lang.reflect.Method m, Parameter par, int i, boolean hasNonNative) {
        String WARNING_LOCATION = "In parameter number " + (i + 1) + " of method '" + m.getName() + "' in interface '" + m.getDeclaringClass().toString().replace("interface ", "") + "'.";
        Type annotType = par.type();
        Direction annotDirection = par.direction();
        Stream stream = par.stream();
        boolean isOut = annotDirection.equals((Object)Direction.OUT);
        boolean isInOut = annotDirection.equals((Object)Direction.INOUT);
        if (annotType.equals((Object)Type.STRING)) {
            if (isOut || isInOut) {
                ErrorManager.warn("Can't specify a String with direction OUT/INOUT since they are immutable.\r\n" + WARNING_LOCATION + "\r\n" + "Using direction=IN instead.");
            }
        } else if (m.getParameterTypes()[i].isPrimitive()) {
            if (isOut || isInOut) {
                String primType = m.getParameterTypes()[i].getName();
                ErrorManager.warn("Can't specify a primitive type ('" + primType + "') with direction OUT/INOUT, " + "since they are always passed by value. " + "\r\n" + WARNING_LOCATION + "\r\n" + "Using direction=IN instead.");
            }
        } else if (annotType.equals((Object)Type.OBJECT) && isOut) {
            ErrorManager.warn("Can't specify an Object with direction OUT.\r\n" + WARNING_LOCATION + "\r\n" + "Using direction=INOUT instead.");
        }
        if (hasNonNative && !annotType.equals((Object)Type.FILE) && (isOut || isInOut)) {
            ErrorManager.error("Non-Native tasks only supports " + annotType.name() + " types in mode IN" + "\r\n" + WARNING_LOCATION);
        }
        if (!stream.equals((Object)Stream.UNSPECIFIED)) {
            if (!annotType.equals((Object)Type.FILE)) {
                ErrorManager.error("Can't specify an Stream with type different than File.\r\n" + WARNING_LOCATION);
            }
            switch (stream) {
                case STDIN: {
                    if (!isOut && !isInOut) break;
                    ErrorManager.error("Stream STDIN must have direction IN\r\n" + WARNING_LOCATION);
                    break;
                }
                case STDOUT: {
                    if (isOut || isInOut) break;
                    ErrorManager.error("Stream STDOUT must have direction OUT or INOUT\r\n" + WARNING_LOCATION);
                    break;
                }
                case STDERR: {
                    if (isOut || isInOut) break;
                    ErrorManager.error("Stream STDERR must have direction OUT or INOUT\r\n" + WARNING_LOCATION);
                    break;
                }
            }
        }
    }

    private static void checkDefinedImplementations(java.lang.reflect.Method m, Integer methodId, StringBuilder calleeMethodSignature, boolean hasStreams, boolean hasPrefixes, List<Implementation> implementations, List<String> signatures) {
        AbstractMethodImplementation impl;
        MethodResourceDescription implConstraints;
        String workingDir;
        String workingDir2;
        String binary;
        MethodResourceDescription defaultConstraints = MethodResourceDescription.EMPTY_FOR_CONSTRAINTS.copy();
        if (m.isAnnotationPresent(Constraints.class)) {
            defaultConstraints = new MethodResourceDescription(m.getAnnotation(Constraints.class));
        }
        String methodName = m.getName();
        int implId = 0;
        for (Method method : (Method[])m.getAnnotationsByType(Method.class)) {
            LOGGER.debug("   * Processing @Method annotation");
            if (hasStreams) {
                ErrorManager.warn("Java method " + methodName + " does not support stream annotations. SKIPPING stream annotation");
            }
            if (hasPrefixes) {
                ErrorManager.warn("Java method " + methodName + " does not support prefix annotations. SKIPPING prefix annotation");
            }
            String declaringClass = method.declaringClass();
            String methodSignature = calleeMethodSignature.toString() + declaringClass;
            signatures.add(methodSignature);
            MethodResourceDescription implConstraints2 = defaultConstraints;
            if (method.constraints() != null) {
                implConstraints2 = new MethodResourceDescription(method.constraints());
                implConstraints2.mergeMultiConstraints(defaultConstraints);
            }
            MethodImplementation impl2 = new MethodImplementation(declaringClass, methodName, methodId, implId, implConstraints2);
            ++implId;
            implementations.add(impl2);
        }
        for (Annotation annotation2 : (Service[])m.getAnnotationsByType(Service.class)) {
            LOGGER.debug("   * Processing @Service annotation");
            if (hasStreams) {
                ErrorManager.warn("Java service " + methodName + " does not support stream annotations. SKIPPING stream annotation");
            }
            calleeMethodSignature.append(annotation2.namespace()).append(',');
            calleeMethodSignature.append(annotation2.name()).append(',');
            calleeMethodSignature.append(annotation2.port());
            String serviceSignature = calleeMethodSignature.toString();
            signatures.add(serviceSignature);
            ServiceImplementation impl3 = new ServiceImplementation(methodId, annotation2.namespace(), annotation2.name(), annotation2.port(), annotation2.operation());
            ++implId;
            implementations.add(impl3);
        }
        for (Annotation annotation3 : (MPI[])m.getAnnotationsByType(MPI.class)) {
            LOGGER.debug("   * Processing @MPI annotation");
            binary = EnvironmentLoader.loadFromEnvironment(annotation3.binary());
            String workingDir22 = EnvironmentLoader.loadFromEnvironment(annotation3.workingDir());
            String mpiRunner = EnvironmentLoader.loadFromEnvironment(annotation3.mpiRunner());
            if (mpiRunner == null || mpiRunner.isEmpty()) {
                ErrorManager.error("Empty mpiRunner annotation for method " + m.getName());
            }
            if (binary == null || binary.isEmpty()) {
                ErrorManager.error("Empty binary annotation for method " + m.getName());
            }
            LOGGER.debug("Binary: " + binary);
            LOGGER.debug("mpiRunner: " + mpiRunner);
            String mpiSignature = calleeMethodSignature.toString() + "mpi.MPI";
            signatures.add(mpiSignature);
            MethodResourceDescription implConstraints3 = defaultConstraints;
            if (annotation3.constraints() != null) {
                implConstraints3 = new MethodResourceDescription(annotation3.constraints());
                implConstraints3.mergeMultiConstraints(defaultConstraints);
            }
            MPIImplementation impl4 = new MPIImplementation(binary, workingDir22, mpiRunner, methodId, implId, implConstraints3);
            ++implId;
            implementations.add(impl4);
        }
        for (Annotation annotation4 : (Decaf[])m.getAnnotationsByType(Decaf.class)) {
            LOGGER.debug("   * Processing @DECAF annotation");
            String dfScript = EnvironmentLoader.loadFromEnvironment(annotation4.dfScript());
            String dfExecutor = EnvironmentLoader.loadFromEnvironment(annotation4.dfExecutor());
            String dfLib = EnvironmentLoader.loadFromEnvironment(annotation4.dfLib());
            workingDir2 = EnvironmentLoader.loadFromEnvironment(annotation4.workingDir());
            String mpiRunner = EnvironmentLoader.loadFromEnvironment(annotation4.mpiRunner());
            if (mpiRunner == null || mpiRunner.isEmpty()) {
                ErrorManager.error("Empty mpiRunner annotation for method " + m.getName());
            }
            if (dfScript == null || dfScript.isEmpty()) {
                ErrorManager.error("Empty binary annotation for method " + m.getName());
            }
            LOGGER.debug("DF Script: " + dfScript);
            LOGGER.debug("DF Executor: " + dfExecutor);
            LOGGER.debug("DF Lib: " + dfLib);
            LOGGER.debug("mpiRunner: " + mpiRunner);
            String mpiSignature = calleeMethodSignature.toString() + "decaf.DECAF";
            signatures.add(mpiSignature);
            MethodResourceDescription implConstraints4 = defaultConstraints;
            if (annotation4.constraints() != null) {
                implConstraints4 = new MethodResourceDescription(annotation4.constraints());
                implConstraints4.mergeMultiConstraints(defaultConstraints);
            }
            DecafImplementation impl5 = new DecafImplementation(dfScript, dfExecutor, dfLib, workingDir2, mpiRunner, methodId, implId, implConstraints4);
            ++implId;
            implementations.add(impl5);
        }
        for (Annotation annotation5 : (COMPSs[])m.getAnnotationsByType(COMPSs.class)) {
            LOGGER.debug("   * Processing @COMPSs annotation");
            String runcompss = EnvironmentLoader.loadFromEnvironment(annotation5.runcompss());
            String flags = EnvironmentLoader.loadFromEnvironment(annotation5.flags());
            String appName = EnvironmentLoader.loadFromEnvironment(annotation5.appName());
            workingDir2 = EnvironmentLoader.loadFromEnvironment(annotation5.workingDir());
            if (appName == null || appName.isEmpty()) {
                ErrorManager.error("Empty appName in COMPSs annotation for method " + m.getName());
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("runcompss: " + runcompss);
                LOGGER.debug("flags: " + flags);
                LOGGER.debug("appName: " + appName);
            }
            String compssSignature = calleeMethodSignature.toString() + "compss.NESTED";
            signatures.add(compssSignature);
            MethodResourceDescription implConstraints5 = defaultConstraints;
            if (annotation5.constraints() != null) {
                implConstraints5 = new MethodResourceDescription(annotation5.constraints());
                implConstraints5.mergeMultiConstraints(defaultConstraints);
            }
            COMPSsImplementation impl6 = new COMPSsImplementation(runcompss, flags, appName, workingDir2, methodId, implId, implConstraints5);
            ++implId;
            implementations.add(impl6);
        }
        for (Annotation annotation6 : (OmpSs[])m.getAnnotationsByType(OmpSs.class)) {
            LOGGER.debug("   * Processing @OmpSs annotation");
            binary = EnvironmentLoader.loadFromEnvironment(annotation6.binary());
            workingDir = EnvironmentLoader.loadFromEnvironment(annotation6.workingDir());
            if (binary == null || binary.isEmpty()) {
                ErrorManager.error("Empty binary annotation for method " + m.getName());
            }
            String ompssSignature = calleeMethodSignature.toString() + "ompss.OMPSS";
            signatures.add(ompssSignature);
            implConstraints = defaultConstraints;
            if (annotation6.constraints() != null) {
                implConstraints = new MethodResourceDescription(annotation6.constraints());
                implConstraints.mergeMultiConstraints(defaultConstraints);
            }
            impl = new OmpSsImplementation(binary, workingDir, methodId, implId, implConstraints);
            ++implId;
            implementations.add(impl);
        }
        for (Annotation annotation7 : (OpenCL[])m.getAnnotationsByType(OpenCL.class)) {
            LOGGER.debug("   * Processing @OpenCL annotation");
            String kernel = EnvironmentLoader.loadFromEnvironment(annotation7.kernel());
            workingDir = EnvironmentLoader.loadFromEnvironment(annotation7.workingDir());
            if (kernel == null || kernel.isEmpty()) {
                ErrorManager.error("Empty kernel annotation for method " + m.getName());
            }
            String openclSignature = calleeMethodSignature.toString() + "opencl.OPENCL";
            signatures.add(openclSignature);
            implConstraints = defaultConstraints;
            if (annotation7.constraints() != null) {
                implConstraints = new MethodResourceDescription(annotation7.constraints());
                implConstraints.mergeMultiConstraints(defaultConstraints);
            }
            impl = new OpenCLImplementation(kernel, workingDir, methodId, implId, implConstraints);
            ++implId;
            implementations.add(impl);
        }
        for (Annotation annotation8 : (Binary[])m.getAnnotationsByType(Binary.class)) {
            LOGGER.debug("   * Processing @Binary annotation");
            binary = EnvironmentLoader.loadFromEnvironment(annotation8.binary());
            workingDir = EnvironmentLoader.loadFromEnvironment(annotation8.workingDir());
            if (binary == null || binary.isEmpty()) {
                ErrorManager.error("Empty binary annotation for method " + m.getName());
            }
            String binarySignature = calleeMethodSignature.toString() + "binary.BINARY";
            signatures.add(binarySignature);
            implConstraints = defaultConstraints;
            if (annotation8.constraints() != null) {
                implConstraints = new MethodResourceDescription(annotation8.constraints());
                implConstraints.mergeMultiConstraints(defaultConstraints);
            }
            impl = new BinaryImplementation(binary, workingDir, methodId, implId, implConstraints);
            ++implId;
            implementations.add(impl);
        }
    }
}

