/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.loader;

import es.bsc.compss.loader.LoaderConstants;
import es.bsc.compss.loader.exceptions.NameNotFoundException;
import es.bsc.compss.util.ErrorManager;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import javassist.CannotCompileException;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtMethod;
import javassist.NotFoundException;
import javassist.bytecode.AnnotationsAttribute;
import javassist.bytecode.ClassFile;
import javassist.bytecode.ConstPool;
import javassist.bytecode.annotation.Annotation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AddOrchestration {
    private static final Logger logger = LogManager.getLogger("es.bsc.compss.Loader");

    public static void main(String[] args) throws NotFoundException, NameNotFoundException, CannotCompileException, IOException {
        if (args.length < 2) {
            ErrorManager.fatal("Error: missing arguments for loader");
        }
        String className = args[0];
        String classPackage = AddOrchestration.getPackage(className);
        ClassPool pool = ClassPool.getDefault();
        if (classPackage != null && classPackage.trim().length() > 0) {
            pool.importPackage(classPackage);
        }
        CtClass cc = pool.getCtClass(className);
        ClassFile ccFile = cc.getClassFile();
        ConstPool constpool = ccFile.getConstPool();
        for (int i = 1; i < args.length; ++i) {
            CtClass[] params;
            String methodLabel = args[i];
            String methodName = AddOrchestration.getMethodName(methodLabel);
            CtMethod methodDescriptor = cc.getDeclaredMethod(methodName, params = AddOrchestration.getParamClasses(methodLabel, pool));
            AnnotationsAttribute attr = (AnnotationsAttribute)methodDescriptor.getMethodInfo().getAttribute("RuntimeVisibleAnnotations");
            if (attr == null) {
                attr = new AnnotationsAttribute(constpool, "RuntimeVisibleAnnotations");
            }
            Annotation annot = new Annotation(LoaderConstants.CLASS_ANNOTATIONS_ORCHESTRATION, constpool);
            attr.addAnnotation(annot);
            methodDescriptor.getMethodInfo().addAttribute(attr);
        }
        cc.writeFile();
    }

    private static CtClass[] getParamClasses(String label, ClassPool pool) throws NotFoundException, NameNotFoundException {
        LinkedList<CtClass> classes = new LinkedList<CtClass>();
        List<String> params = AddOrchestration.getParametersTypeFromLabel(label);
        if (params != null && params.size() > 0) {
            for (String className : params) {
                String pack = AddOrchestration.getPackage(className);
                if (pack != null) {
                    pool.importPackage(pack);
                }
                classes.add(pool.getCtClass(className));
            }
            return classes.toArray(new CtClass[classes.size()]);
        }
        return new CtClass[0];
    }

    public static List<String> getParametersTypeFromLabel(String label) throws NameNotFoundException {
        int begin = label.indexOf("(");
        int end = label.indexOf(")");
        if (begin > 0 && end > 0 && end > begin) {
            String[] parametersArray;
            String parsString = label.substring(begin + 1, end);
            if (logger.isDebugEnabled()) {
                logger.debug("Parameters: " + parsString);
            }
            LinkedList<String> parameters = new LinkedList<String>();
            if (parsString != null && parsString.trim().length() > 0 && (parametersArray = parsString.split(", ")) != null && parametersArray.length > 0) {
                for (String parameter : parametersArray) {
                    parameters.add(parameter);
                }
            }
            return parameters;
        }
        throw new NameNotFoundException("Error incorrect label " + label);
    }

    private static String getMethodName(String label) throws NameNotFoundException {
        int i = label.indexOf("(");
        if (i > 0) {
            return label.substring(0, i);
        }
        throw new NameNotFoundException("Error method name from label " + label);
    }

    private static String getPackage(String className) throws NameNotFoundException {
        if (className != null && className.trim().length() > 0) {
            int i = className.lastIndexOf(".");
            if (i >= 0) {
                return className.substring(i + 1).trim();
            }
            return null;
        }
        throw new NameNotFoundException("ClassName is null");
    }
}

