/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.invokers;

import es.bsc.compss.executor.types.InvocationResources;
import es.bsc.compss.invokers.Invoker;
import es.bsc.compss.types.annotations.parameter.DataType;
import es.bsc.compss.types.execution.Invocation;
import es.bsc.compss.types.execution.InvocationContext;
import es.bsc.compss.types.execution.InvocationParam;
import es.bsc.compss.types.execution.exceptions.JobExecutionException;
import es.bsc.compss.types.implementations.MethodImplementation;
import es.bsc.compss.types.implementations.MultiNodeImplementation;
import java.io.File;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.List;
import storage.StubItf;

public class JavaInvoker
extends Invoker {
    public static final String ERROR_CLASS_REFLECTION = "Cannot get class by reflection";
    public static final String ERROR_METHOD_REFLECTION = "Cannot get method by reflection";
    private final String className;
    private final String methodName;
    protected final Method method;

    public JavaInvoker(InvocationContext context, Invocation invocation, File taskSandboxWorkingDir, InvocationResources assignedResources) throws JobExecutionException {
        super(context, invocation, taskSandboxWorkingDir, assignedResources);
        switch (invocation.getMethodImplementation().getMethodType()) {
            case METHOD: {
                MethodImplementation methodImpl = (MethodImplementation)invocation.getMethodImplementation();
                this.className = methodImpl.getDeclaringClass();
                this.methodName = methodImpl.getAlternativeMethodName();
                break;
            }
            case MULTI_NODE: {
                MultiNodeImplementation multiNodeImpl = (MultiNodeImplementation)invocation.getMethodImplementation();
                this.className = multiNodeImpl.getDeclaringClass();
                this.methodName = multiNodeImpl.getMethodName();
                break;
            }
            default: {
                throw new JobExecutionException("Incorrect method definition for task of type " + (Object)((Object)invocation.getMethodImplementation().getMethodType()));
            }
        }
        this.method = this.findMethod();
    }

    /*
     * WARNING - void declaration
     */
    private Method findMethod() throws JobExecutionException {
        Class<?> methodClass = null;
        try {
            methodClass = Class.forName(this.className);
        }
        catch (ClassNotFoundException e) {
            throw new JobExecutionException(ERROR_CLASS_REFLECTION, e);
        }
        try {
            Method method;
            block13: {
                method = null;
                List<? extends InvocationParam> params = this.invocation.getParams();
                try {
                    Class[] types = new Class[params.size()];
                    int paramIdx = 0;
                    for (InvocationParam invocationParam : params) {
                        types[paramIdx++] = invocationParam.getValueClass();
                    }
                    method = methodClass.getMethod(this.methodName, types);
                }
                catch (NoSuchMethodException | SecurityException e) {
                    void var7_14;
                    Method[] methodArray = methodClass.getDeclaredMethods();
                    int n = methodArray.length;
                    boolean bl = false;
                    while (var7_14 < n) {
                        Parameter[] reflectionParams;
                        boolean arbitraryParamCount;
                        Method m = methodArray[var7_14];
                        if (m.getName().equals(this.methodName) && !((arbitraryParamCount = (reflectionParams = m.getParameters()).length > 0 ? reflectionParams[reflectionParams.length - 1].isVarArgs() : false) ? params.size() < m.getParameterCount() - 1 : params.size() != m.getParameterCount())) {
                            boolean isMatch = true;
                            for (int paramId = 0; paramId < reflectionParams.length && isMatch; ++paramId) {
                                Parameter reflectionParam = reflectionParams[paramId];
                                if (arbitraryParamCount && paramId == reflectionParams.length - 1) {
                                    Class<?> componentType = reflectionParam.getType().getComponentType();
                                    while (paramId < params.size() && isMatch) {
                                        Object paramValue = params.get(paramId).getValue();
                                        isMatch = this.areTypesMatching(componentType, paramValue);
                                        ++paramId;
                                    }
                                    continue;
                                }
                                Object paramValue = params.get(paramId).getValue();
                                isMatch = this.areTypesMatching(reflectionParam.getType(), paramValue);
                            }
                            if (isMatch) {
                                method = m;
                            }
                        }
                        ++var7_14;
                    }
                    if (method != null) break block13;
                    throw new JobExecutionException(ERROR_METHOD_REFLECTION, e);
                }
            }
            return method;
        }
        catch (SecurityException e) {
            throw new JobExecutionException(ERROR_METHOD_REFLECTION, e);
        }
    }

    private boolean areTypesMatching(Class<?> reflectionParam, Object paramValue) {
        boolean isMatch = true;
        if (reflectionParam.isPrimitive()) {
            if (reflectionParam != paramValue.getClass()) {
                switch (reflectionParam.getCanonicalName()) {
                    case "byte": {
                        isMatch = paramValue.getClass().getCanonicalName().equals("java.lang.Byte");
                        break;
                    }
                    case "char": {
                        isMatch = paramValue.getClass().getCanonicalName().equals("java.lang.Char");
                        break;
                    }
                    case "short": {
                        isMatch = paramValue.getClass().getCanonicalName().equals("java.lang.Short");
                        break;
                    }
                    case "int": {
                        isMatch = paramValue.getClass().getCanonicalName().equals("java.lang.Integer");
                        break;
                    }
                    case "long": {
                        isMatch = paramValue.getClass().getCanonicalName().equals("java.lang.Long");
                        break;
                    }
                    case "float": {
                        isMatch = paramValue.getClass().getCanonicalName().equals("java.lang.Float");
                        break;
                    }
                    case "double": {
                        isMatch = paramValue.getClass().getCanonicalName().equals("java.lang.Double");
                        break;
                    }
                    case "boolean": {
                        isMatch = paramValue.getClass().getCanonicalName().equals("java.lang.Boolean");
                    }
                }
            }
        } else {
            try {
                reflectionParam.cast(paramValue);
            }
            catch (ClassCastException cce) {
                isMatch = false;
            }
        }
        return isMatch;
    }

    @Override
    public void invokeMethod() throws JobExecutionException {
        Object retValue = this.runMethod();
        for (InvocationParam invocationParam : this.invocation.getParams()) {
            this.checkSCOPersistence(invocationParam);
        }
        if (this.invocation.getTarget() != null) {
            this.checkSCOPersistence(this.invocation.getTarget());
        }
        for (InvocationParam invocationParam : this.invocation.getResults()) {
            invocationParam.setValue(retValue);
            if (retValue != null) {
                invocationParam.setValueClass(retValue.getClass());
            } else {
                invocationParam.setValueClass(null);
            }
            this.checkSCOPersistence(invocationParam);
        }
    }

    /*
     * WARNING - void declaration
     */
    protected Object runMethod() throws JobExecutionException {
        Object[] values;
        List<? extends InvocationParam> params = this.invocation.getParams();
        int paramCount = this.method.getParameterCount();
        Object[] paramDest = values = new Object[paramCount];
        int paramIdx = 0;
        for (InvocationParam invocationParam : params) {
            if (paramIdx != paramCount - 1) {
                paramDest[paramIdx++] = invocationParam.getValue();
                continue;
            }
            Parameter reflectionParam = this.method.getParameters()[paramIdx];
            Class<?> paramClass = this.method.getParameters()[paramIdx].getType();
            if (reflectionParam.isVarArgs()) {
                int varArgsCount = params.size() - paramCount + 1;
                paramDest[paramIdx] = Array.newInstance(paramClass.getComponentType(), varArgsCount);
                paramDest = (Object[])paramDest[paramIdx];
                paramIdx = 0;
                paramDest[paramIdx++] = invocationParam.getValue();
                continue;
            }
            paramDest[paramIdx++] = invocationParam.getValue();
        }
        InvocationParam targetParam = this.invocation.getTarget();
        Object var7_8 = null;
        if (targetParam != null) {
            Object object = targetParam.getValue();
        }
        Object retValue = null;
        try {
            void var7_10;
            LOGGER.info("Invoked " + this.method.getName() + (var7_10 == null ? "" : " on object " + var7_10) + " in " + this.context.getHostName());
            retValue = this.method.invoke((Object)var7_10, values);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            throw new JobExecutionException("ERROR: Exception executing task (user code)", e);
        }
        return retValue;
    }

    private void checkSCOPersistence(InvocationParam np) {
        boolean potentialPSCO;
        boolean bl = potentialPSCO = np.getType().equals((Object)DataType.OBJECT_T) || np.getType().equals((Object)DataType.PSCO_T);
        if (np.isWriteFinalValue() && potentialPSCO) {
            Object obj = np.getValue();
            String id = null;
            try {
                StubItf psco = (StubItf)obj;
                id = psco.getID();
            }
            catch (Exception e) {
                id = null;
            }
            if (id != null) {
                np.setType(DataType.PSCO_T);
            }
        }
    }
}

