/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.types;

import es.bsc.compss.types.Task;
import es.bsc.compss.worker.COMPSsException;
import java.util.LinkedList;
import java.util.List;

public class TaskGroup
implements AutoCloseable {
    private final List<Task> tasks = new LinkedList<Task>();
    private String name;
    private boolean graphDrawn = false;
    private COMPSsException exception;
    private boolean implicitBarrier;

    public TaskGroup(String groupName, boolean barrier) {
        this.name = groupName;
        this.implicitBarrier = barrier;
    }

    public List<Task> getTasks() {
        return this.tasks;
    }

    public String getName() {
        return this.name;
    }

    public void addTask(Task task) {
        this.tasks.add(task);
    }

    public void setGraphDrawn() {
        this.graphDrawn = true;
    }

    public boolean getGraphDrawn() {
        return this.graphDrawn;
    }

    public void removeTask(Task t) {
        this.tasks.remove(t);
    }

    public boolean hasPendingTasks() {
        return !this.tasks.isEmpty();
    }

    @Override
    public void close() throws Exception {
    }

    public boolean hasException() {
        return this.exception != null;
    }

    public COMPSsException getException() {
        return this.exception;
    }

    public void setException(COMPSsException e) {
        this.exception = e;
    }

    public boolean hasImplicitBarrier() {
        return this.implicitBarrier;
    }
}

