/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.types.request.ap;

import es.bsc.compss.components.impl.AccessProcessor;
import es.bsc.compss.components.impl.DataInfoProvider;
import es.bsc.compss.components.impl.TaskAnalyser;
import es.bsc.compss.components.impl.TaskDispatcher;
import es.bsc.compss.types.data.accessparams.AccessParams;
import es.bsc.compss.types.request.ap.APRequest;
import es.bsc.compss.types.request.ap.APRequestType;
import java.util.concurrent.Semaphore;

public class WaitForConcurrentRequest
extends APRequest {
    private final int dataId;
    private final Semaphore sem;
    private final Semaphore semTask;
    private final AccessParams.AccessMode am;
    private int numWaits;

    public WaitForConcurrentRequest(int dataId, AccessParams.AccessMode mode, Semaphore sem, Semaphore semTasks) {
        this.dataId = dataId;
        this.sem = sem;
        this.semTask = semTasks;
        this.am = mode;
    }

    public Semaphore getSemaphore() {
        return this.sem;
    }

    public int getDataId() {
        return this.dataId;
    }

    public Semaphore getTaskSemaphore() {
        return this.semTask;
    }

    public AccessParams.AccessMode getAccessMode() {
        return this.am;
    }

    public int getNumWaitedTasks() {
        return this.numWaits;
    }

    public void setNumWaitedTasks(int n) {
        this.numWaits = n;
    }

    @Override
    public void process(AccessProcessor ap, TaskAnalyser ta, DataInfoProvider dip, TaskDispatcher td) {
        ta.findWaitedConcurrent(this);
    }

    @Override
    public APRequestType getRequestType() {
        return APRequestType.WAIT_FOR_CONCURRENT;
    }
}

