/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.scheduler.types;

import es.bsc.compss.components.impl.ResourceScheduler;
import es.bsc.compss.scheduler.types.AllocatableAction;
import es.bsc.compss.types.resources.WorkerResourceDescription;
import es.bsc.compss.util.CoreManager;
import es.bsc.compss.util.ErrorManager;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public class SchedulingInformation {
    private static final List<List<ResourceScheduler<? extends WorkerResourceDescription>>> CORE_TO_WORKERS = new ArrayList<List<ResourceScheduler<? extends WorkerResourceDescription>>>();
    private final List<AllocatableAction> constrainingPredecessors = new LinkedList<AllocatableAction>();
    private final ResourceScheduler<? extends WorkerResourceDescription> enforcedTargetResource;

    public static void updateCoreCount(int newCoreCount) {
        for (int currentCoreCount = CORE_TO_WORKERS.size(); currentCoreCount < newCoreCount; ++currentCoreCount) {
            CORE_TO_WORKERS.add(new LinkedList());
        }
    }

    public static <T extends WorkerResourceDescription> void changesOnWorker(ResourceScheduler<T> ui) {
        for (List<ResourceScheduler<? extends WorkerResourceDescription>> coreToWorker : CORE_TO_WORKERS) {
            if (coreToWorker != null) {
                coreToWorker.remove(ui);
                continue;
            }
            ErrorManager.warn("Worker for CE is null.");
        }
        SchedulingInformation.updateCoreCount(CoreManager.getCoreCount());
        List<Integer> executableCores = ui.getExecutableCores();
        for (int coreId : executableCores) {
            List<ResourceScheduler<? extends WorkerResourceDescription>> workersList = CORE_TO_WORKERS.get(coreId);
            if (workersList == null) {
                ErrorManager.warn("CE with id " + coreId + " does not exists in the Core to workers list. Creating a new one");
                workersList = new LinkedList<ResourceScheduler<? extends WorkerResourceDescription>>();
                CORE_TO_WORKERS.add(coreId, workersList);
            }
            workersList.add(ui);
        }
    }

    public static List<ResourceScheduler<? extends WorkerResourceDescription>> getCoreElementExecutors(int coreId) {
        LinkedList<ResourceScheduler<? extends WorkerResourceDescription>> res = new LinkedList<ResourceScheduler<? extends WorkerResourceDescription>>();
        for (ResourceScheduler<? extends WorkerResourceDescription> rs : CORE_TO_WORKERS.get(coreId)) {
            res.add(rs);
        }
        return res;
    }

    public <T extends WorkerResourceDescription> SchedulingInformation(ResourceScheduler<T> enforcedTargetResource) {
        this.enforcedTargetResource = enforcedTargetResource;
    }

    public final void addResourceConstraint(AllocatableAction predecessor) {
        this.constrainingPredecessors.add(predecessor);
    }

    public final List<AllocatableAction> getConstrainingPredecessors() {
        return this.constrainingPredecessors;
    }

    public boolean isExecutable() {
        return true;
    }

    public final ResourceScheduler<? extends WorkerResourceDescription> getEnforcedTargetResource() {
        return this.enforcedTargetResource;
    }
}

