/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.types.allocatableactions;

import es.bsc.compss.types.allocatableactions.MultiNodeExecutionAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MultiNodeGroup {
    public static final int MASTER_GROUP_ID = 1;
    public static final int UNASSIGNED_ID = -1;
    private static final Logger LOGGER = LogManager.getLogger("es.bsc.compss.Components.TaskDispatcher.TaskScheduler");
    private final int groupSize;
    private int nextProcessId;
    private final HashMap<Integer, MultiNodeExecutionAction> registeredSlaves;
    private MultiNodeExecutionAction registeredMaster;

    public MultiNodeGroup(int groupSize) {
        LOGGER.debug("[MultiNodeGroup] Creating new group of size " + groupSize);
        this.groupSize = groupSize;
        this.nextProcessId = groupSize;
        this.registeredSlaves = new HashMap();
        this.registeredMaster = null;
    }

    public int registerProcess(MultiNodeExecutionAction action) {
        int actionId;
        if ((actionId = this.nextProcessId--) == 1) {
            LOGGER.debug("[MultiNodeGroup] Register action " + action.getId() + " as master of group " + this);
            this.registeredMaster = action;
        } else {
            LOGGER.debug("[MultiNodeGroup] Register action " + action.getId() + " as slave of group " + this);
            this.registeredSlaves.put(actionId, action);
        }
        return actionId;
    }

    public int getGroupSize() {
        return this.groupSize;
    }

    public MultiNodeExecutionAction getMasterAction() {
        return this.registeredMaster;
    }

    public List<String> getSlavesNames() {
        ArrayList<String> slavesNames = new ArrayList<String>();
        for (Map.Entry<Integer, MultiNodeExecutionAction> slave : this.registeredSlaves.entrySet()) {
            slavesNames.add(slave.getValue().getAssignedResource().getName());
        }
        if (LOGGER.isDebugEnabled()) {
            StringBuilder sb = new StringBuilder();
            sb.append("[MultiNodeGroup] SlaveNames of group ").append(this).append(" are:");
            for (String slaveName : slavesNames) {
                sb.append(" ").append(slaveName);
            }
            LOGGER.debug(sb.toString());
        }
        return slavesNames;
    }

    public void actionCompletion() {
        LOGGER.debug("[MultiNodeGroup] Notify action completion to all slaves of group " + this);
        for (Map.Entry<Integer, MultiNodeExecutionAction> entry : this.registeredSlaves.entrySet()) {
            entry.getValue().notifyCompleted();
        }
    }

    public void actionError() {
        LOGGER.debug("[MultiNodeGroup] Notify action error to all slaves of group " + this);
        for (Map.Entry<Integer, MultiNodeExecutionAction> entry : this.registeredSlaves.entrySet()) {
            entry.getValue().notifyError();
        }
    }

    public String toString() {
        return "MultiNodeGroup@" + this.hashCode();
    }
}

