/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.types.request.ap;

import es.bsc.compss.components.impl.AccessProcessor;
import es.bsc.compss.components.impl.DataInfoProvider;
import es.bsc.compss.components.impl.TaskAnalyser;
import es.bsc.compss.components.impl.TaskDispatcher;
import es.bsc.compss.types.data.ResultFile;
import es.bsc.compss.types.data.operation.ResultListener;
import es.bsc.compss.types.request.ap.APRequest;
import es.bsc.compss.types.request.ap.APRequestType;
import java.util.LinkedList;
import java.util.TreeSet;
import java.util.concurrent.Semaphore;

public class GetResultFilesRequest
extends APRequest {
    private final Long appId;
    private final Semaphore sem;
    private final LinkedList<ResultFile> blockedData;

    public GetResultFilesRequest(Long appId, Semaphore sem) {
        this.appId = appId;
        this.sem = sem;
        this.blockedData = new LinkedList();
    }

    public Long getAppId() {
        return this.appId;
    }

    public Semaphore getSemaphore() {
        return this.sem;
    }

    public LinkedList<ResultFile> getBlockedData() {
        return this.blockedData;
    }

    @Override
    public void process(AccessProcessor ap, TaskAnalyser ta, DataInfoProvider dip, TaskDispatcher td) {
        ResultListener listener = new ResultListener(this.sem);
        TreeSet<Integer> writtenDataIds = ta.getAndRemoveWrittenFiles(this.appId);
        if (writtenDataIds != null) {
            for (int dataId : writtenDataIds) {
                ResultFile rf = dip.blockDataAndGetResultFile(dataId, listener);
                if (rf == null) continue;
                this.blockedData.add(rf);
            }
            listener.enable();
        } else {
            this.sem.release();
        }
    }

    @Override
    public APRequestType getRequestType() {
        return APRequestType.BLOCK_AND_GET_RESULT_FILES;
    }
}

