/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.local;

import es.bsc.compss.COMPSsConstants;
import es.bsc.compss.local.LocalParameter;
import es.bsc.compss.types.COMPSsMaster;
import es.bsc.compss.types.TaskDescription;
import es.bsc.compss.types.execution.Invocation;
import es.bsc.compss.types.execution.InvocationParam;
import es.bsc.compss.types.implementations.AbstractMethodImplementation;
import es.bsc.compss.types.implementations.Implementation;
import es.bsc.compss.types.implementations.MethodImplementation;
import es.bsc.compss.types.implementations.MultiNodeImplementation;
import es.bsc.compss.types.implementations.TaskType;
import es.bsc.compss.types.job.Job;
import es.bsc.compss.types.job.JobListener;
import es.bsc.compss.types.parameter.Parameter;
import es.bsc.compss.types.resources.MethodResourceDescription;
import es.bsc.compss.types.resources.Resource;
import es.bsc.compss.types.resources.ResourceDescription;
import es.bsc.compss.util.ErrorManager;
import java.util.LinkedList;
import java.util.List;

public class LocalJob
extends Job<COMPSsMaster>
implements Invocation {
    private final List<LocalParameter> arguments;
    private LocalParameter target;
    private LinkedList<LocalParameter> results;
    private MethodResourceDescription reqs;
    private final List<String> slaveWorkersNodeNames;

    public LocalJob(int taskId, TaskDescription task, Implementation impl, Resource res, List<String> slaveWorkersNodeNames, JobListener listener) {
        super(taskId, task, impl, res, listener);
        Parameter p;
        boolean hasTarget = this.taskParams.hasTargetObject();
        int numReturns = this.taskParams.getNumReturns();
        this.arguments = new LinkedList<LocalParameter>();
        this.results = new LinkedList();
        List<Parameter> params = task.getParameters();
        int paramsCount = params.size();
        if (super.getLang().equals((Object)COMPSsConstants.Lang.PYTHON)) {
            if (hasTarget) {
                Parameter p2 = params.get(params.size() - 1);
                this.target = new LocalParameter(p2);
                --paramsCount;
            }
            for (int rIdx = 0; rIdx < numReturns; ++rIdx) {
                p = params.get(params.size() - (hasTarget ? 1 : 0) - numReturns + rIdx);
                this.results.addFirst(new LocalParameter(p));
            }
            paramsCount -= numReturns;
        } else {
            for (int rIdx = 0; rIdx < numReturns; ++rIdx) {
                p = params.get(params.size() - numReturns + rIdx);
                this.results.addFirst(new LocalParameter(p));
            }
            paramsCount -= numReturns;
            if (hasTarget) {
                Parameter p3 = params.get(params.size() - numReturns - 1);
                this.target = new LocalParameter(p3);
                --paramsCount;
            }
        }
        for (int paramIdx = 0; paramIdx < paramsCount; ++paramIdx) {
            this.arguments.add(new LocalParameter(params.get(paramIdx)));
        }
        this.slaveWorkersNodeNames = slaveWorkersNodeNames;
        AbstractMethodImplementation absMethodImpl = (AbstractMethodImplementation)this.impl;
        this.reqs = absMethodImpl.getRequirements();
    }

    @Override
    public void submit() throws Exception {
        ((COMPSsMaster)this.getResourceNode()).runJob(this);
    }

    @Override
    public void cancelJob() throws Exception {
    }

    @Override
    public String getHostName() {
        return ((COMPSsMaster)this.getResourceNode()).getName();
    }

    @Override
    public TaskType getType() {
        return TaskType.METHOD;
    }

    @Override
    public TaskType getTaskType() {
        return TaskType.METHOD;
    }

    @Override
    public String toString() {
        String className;
        AbstractMethodImplementation absMethodImpl = (AbstractMethodImplementation)this.impl;
        switch (absMethodImpl.getMethodType()) {
            case METHOD: {
                MethodImplementation method = (MethodImplementation)this.impl;
                className = method.getDeclaringClass();
                break;
            }
            case MULTI_NODE: {
                MultiNodeImplementation multiNodeMethod = (MultiNodeImplementation)this.impl;
                className = multiNodeMethod.getDeclaringClass();
                break;
            }
            default: {
                ErrorManager.error("ERROR: Unrecognised methodtype " + (Object)((Object)absMethodImpl.getMethodType()) + " on local adaptor");
                return null;
            }
        }
        String methodName = this.taskParams.getName();
        return "LocalJob JobId" + this.jobId + " for method " + methodName + " at class " + className;
    }

    @Override
    public AbstractMethodImplementation getMethodImplementation() {
        AbstractMethodImplementation absMethodImpl = (AbstractMethodImplementation)this.impl;
        switch (absMethodImpl.getMethodType()) {
            case METHOD: {
                return (MethodImplementation)this.impl;
            }
            case MULTI_NODE: {
                return (MultiNodeImplementation)this.impl;
            }
        }
        ErrorManager.error("ERROR: Unrecognised methodtype " + (Object)((Object)absMethodImpl.getMethodType()) + " on local adaptor");
        return null;
    }

    @Override
    public boolean isDebugEnabled() {
        return DEBUG;
    }

    @Override
    public List<? extends InvocationParam> getParams() {
        return this.arguments;
    }

    @Override
    public InvocationParam getTarget() {
        return this.target;
    }

    @Override
    public List<? extends InvocationParam> getResults() {
        return this.results;
    }

    @Override
    public ResourceDescription getRequirements() {
        return this.reqs;
    }

    @Override
    public List<String> getSlaveNodesNames() {
        return this.slaveWorkersNodeNames;
    }
}

