/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.types;

import es.bsc.compss.scheduler.types.AllocatableAction;
import es.bsc.compss.types.Task;
import es.bsc.compss.types.request.ap.BarrierGroupRequest;
import es.bsc.compss.worker.COMPSsException;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Semaphore;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TaskGroup
implements AutoCloseable {
    private final List<Task> tasks = new LinkedList<Task>();
    private String name;
    private boolean graphDrawn;
    private COMPSsException exception;
    private LinkedList<Semaphore> barrierSemaphores;
    private boolean closed;
    private BarrierGroupRequest request;
    private boolean barrierDrawn;
    private int lastTaskId;
    private long appId;
    private static final Logger LOGGER = LogManager.getLogger("es.bsc.compss.Components.TaskProcessor");

    public TaskGroup(String groupName, Long appId) {
        this.appId = appId;
        this.graphDrawn = false;
        this.name = groupName;
        this.barrierSemaphores = new LinkedList();
        this.closed = false;
        this.request = null;
        this.barrierDrawn = false;
        this.lastTaskId = 0;
    }

    public List<Task> getTasks() {
        return this.tasks;
    }

    public String getName() {
        return this.name;
    }

    public long getAppId() {
        return this.appId;
    }

    public void addTask(Task task) {
        this.tasks.add(task);
        this.lastTaskId = task.getId();
    }

    public int getLastTaskId() {
        return this.lastTaskId;
    }

    public void setGraphDrawn() {
        this.graphDrawn = true;
    }

    public boolean getGraphDrawn() {
        return this.graphDrawn;
    }

    public void setBarrierDrawn() {
        this.barrierDrawn = true;
    }

    public boolean getBarrierDrawn() {
        return this.barrierDrawn;
    }

    public void removeTask(Task t) {
        this.tasks.remove(t);
    }

    public boolean hasPendingTasks() {
        return !this.tasks.isEmpty();
    }

    @Override
    public void close() throws Exception {
    }

    public boolean hasException() {
        return this.exception != null;
    }

    public COMPSsException getException() {
        return this.exception;
    }

    public void setException(COMPSsException e) {
        LOGGER.debug("Exception set for group " + this.name);
        this.exception = e;
        if (this.request != null) {
            this.request.setException(e);
        }
    }

    public boolean hasBarrier() {
        return !this.barrierSemaphores.isEmpty();
    }

    public void addBarrier(BarrierGroupRequest request) {
        LOGGER.debug("Added barrier for group " + this.name);
        this.barrierSemaphores.push(request.getSemaphore());
        this.request = request;
    }

    public void releaseBarrier() {
        for (Semaphore s : this.barrierSemaphores) {
            s.release();
        }
    }

    public void setClosed() {
        this.closed = true;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public void cancelTasks() {
        LOGGER.debug("Cancelling " + this.tasks.size() + " tasks.");
        for (Task t : this.tasks) {
            for (AllocatableAction aa : t.getExecutions()) {
                aa.canceled();
            }
        }
        LOGGER.debug("All the application tasks have been cancelled.");
    }

    public boolean isAppGroup(Long appId) {
        return this.name.equals("App" + appId);
    }
}

