/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.types.allocatableactions;

import es.bsc.compss.components.impl.ResourceScheduler;
import es.bsc.compss.scheduler.exceptions.BlockedActionException;
import es.bsc.compss.scheduler.exceptions.FailedActionException;
import es.bsc.compss.scheduler.exceptions.UnassignedActionException;
import es.bsc.compss.scheduler.types.ActionOrchestrator;
import es.bsc.compss.scheduler.types.AllocatableAction;
import es.bsc.compss.scheduler.types.SchedulingInformation;
import es.bsc.compss.scheduler.types.Score;
import es.bsc.compss.types.annotations.parameter.DataType;
import es.bsc.compss.types.annotations.parameter.OnFailure;
import es.bsc.compss.types.data.DataAccessId;
import es.bsc.compss.types.data.LogicalData;
import es.bsc.compss.types.data.Transferable;
import es.bsc.compss.types.data.accessid.RAccessId;
import es.bsc.compss.types.data.accessid.RWAccessId;
import es.bsc.compss.types.data.accessid.WAccessId;
import es.bsc.compss.types.data.listener.EventListener;
import es.bsc.compss.types.data.operation.DataOperation;
import es.bsc.compss.types.implementations.Implementation;
import es.bsc.compss.types.implementations.MethodImplementation;
import es.bsc.compss.types.parameter.CollectionParameter;
import es.bsc.compss.types.parameter.DependencyParameter;
import es.bsc.compss.types.parameter.ExternalPSCOParameter;
import es.bsc.compss.types.parameter.Parameter;
import es.bsc.compss.types.resources.Worker;
import es.bsc.compss.types.resources.WorkerResourceDescription;
import es.bsc.compss.util.ErrorManager;
import es.bsc.compss.worker.COMPSsException;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TransferValueAction<T extends WorkerResourceDescription>
extends AllocatableAction {
    private static final Logger JOB_LOGGER = LogManager.getLogger("es.bsc.compss.Components.TaskDispatcher.FileTransferManager");
    private static final Implementation DUMMY_IMPL = new MethodImplementation("", "", null, null, "", null);
    private final DependencyParameter dataToTransfer;
    private final ResourceScheduler<T> receiver;

    public TransferValueAction(SchedulingInformation schedulingInformation, ActionOrchestrator orchestrator, DependencyParameter dp, ResourceScheduler<T> receiver) {
        super(schedulingInformation, orchestrator);
        this.receiver = receiver;
        this.dataToTransfer = dp;
    }

    @Override
    public boolean isToReserveResources() {
        return false;
    }

    @Override
    public boolean isToReleaseResources() {
        return false;
    }

    @Override
    public boolean isToStopResource() {
        return false;
    }

    @Override
    protected void doAction() {
        JOB_LOGGER.info("Ordering transfers of " + this.dataToTransfer.getName() + " to " + this.receiver.getName());
        ObtainDataListener listener = new ObtainDataListener();
        this.transferData(this.dataToTransfer, listener);
        listener.enable();
    }

    private void transferData(DependencyParameter dataToTransfer, ObtainDataListener listener) {
        String srcName;
        if (dataToTransfer.getType() == DataType.COLLECTION_T) {
            CollectionParameter cp = (CollectionParameter)dataToTransfer;
            JOB_LOGGER.debug("Detected CollectionParameter " + cp);
            for (Parameter p : cp.getParameters()) {
                DependencyParameter dp = (DependencyParameter)p;
                this.transferData(dp, listener);
            }
        }
        Worker<? extends WorkerResourceDescription> w = this.getAssignedResource().getResource();
        DataAccessId access = dataToTransfer.getDataAccessId();
        if (access instanceof WAccessId) {
            String tgtName = ((WAccessId)access).getWrittenDataInstance().getRenaming();
            if (dataToTransfer instanceof ExternalPSCOParameter) {
                ExternalPSCOParameter epp = (ExternalPSCOParameter)dataToTransfer;
                tgtName = epp.getId();
            }
            if (DEBUG) {
                JOB_LOGGER.debug("Setting data target job transfer: " + w.getCompleteRemotePath(dataToTransfer.getType(), tgtName));
            }
            dataToTransfer.setDataTarget(w.getCompleteRemotePath(dataToTransfer.getType(), tgtName).getPath());
            return;
        }
        listener.addOperation();
        if (access instanceof RAccessId) {
            srcName = ((RAccessId)access).getReadDataInstance().getRenaming();
            w.getData(srcName, srcName, (Transferable)dataToTransfer, (EventListener)listener);
        } else {
            srcName = ((RWAccessId)access).getReadDataInstance().getRenaming();
            String tgtName = ((RWAccessId)access).getWrittenDataInstance().getRenaming();
            w.getData(srcName, tgtName, (LogicalData)null, (Transferable)dataToTransfer, (EventListener)listener);
        }
    }

    public void flushCopies() {
        Worker<? extends WorkerResourceDescription> w = this.getAssignedResource().getResource();
        FlushCopyListener listener = new FlushCopyListener();
        w.enforceDataObtaning(this.dataToTransfer, listener);
    }

    public final void completedTransfer() {
        this.notifyCompleted();
    }

    @Override
    protected void doCompleted() {
    }

    @Override
    protected void doError() throws FailedActionException {
        throw new FailedActionException();
    }

    @Override
    protected void doAbort() {
    }

    @Override
    protected void doFailed() {
        ErrorManager.warn("Transfer of data " + this.dataToTransfer.getName() + " to " + this.receiver + " has failed.");
    }

    @Override
    protected void doCanceled() {
        ErrorManager.warn("Transfer of data " + this.dataToTransfer.getName() + " to " + this.receiver + " has been cancelled.");
    }

    @Override
    protected void doFailIgnored() {
        ErrorManager.warn("Transfer of data " + this.dataToTransfer.getName() + " to " + this.receiver + " has failed.");
    }

    @Override
    protected void doException(COMPSsException e) {
        ErrorManager.warn("Transfer of data " + this.dataToTransfer.getName() + " to " + this.receiver + " has raised a COMPSs Exception.");
    }

    @Override
    public final List<ResourceScheduler<? extends WorkerResourceDescription>> getCompatibleWorkers() {
        LinkedList<ResourceScheduler<? extends WorkerResourceDescription>> compatible = new LinkedList<ResourceScheduler<? extends WorkerResourceDescription>>();
        compatible.add(this.receiver);
        return compatible;
    }

    @Override
    public final Implementation[] getImplementations() {
        return new Implementation[]{DUMMY_IMPL};
    }

    @Override
    public <W extends WorkerResourceDescription> boolean isCompatible(Worker<W> r) {
        return r == this.receiver.getResource();
    }

    public final <W extends WorkerResourceDescription> List<Implementation> getCompatibleImplementations(ResourceScheduler<W> r) {
        LinkedList<Implementation> impls = new LinkedList<Implementation>();
        impls.add(DUMMY_IMPL);
        return impls;
    }

    @Override
    public final Integer getCoreId() {
        return null;
    }

    @Override
    public final int getPriority() {
        return 1;
    }

    @Override
    public OnFailure getOnFailure() {
        return OnFailure.IGNORE;
    }

    public final <W extends WorkerResourceDescription> Score schedulingScore(ResourceScheduler<W> targetWorker, Score actionScore) {
        if (targetWorker == this.receiver) {
            return actionScore;
        }
        return null;
    }

    @Override
    public void schedule(Score actionScore) throws BlockedActionException, UnassignedActionException {
        this.schedule((ResourceScheduler<R>)this.receiver, DUMMY_IMPL);
    }

    public <R extends WorkerResourceDescription> void schedule(ResourceScheduler<R> targetWorker, Score actionScore) throws BlockedActionException, UnassignedActionException {
        this.schedule(targetWorker, DUMMY_IMPL);
    }

    public <R extends WorkerResourceDescription> void schedule(ResourceScheduler<R> targetWorker, Implementation impl) throws BlockedActionException, UnassignedActionException {
        if (targetWorker != this.receiver) {
            throw new UnassignedActionException();
        }
        this.assignResource(targetWorker);
        this.assignImplementation(impl);
        targetWorker.scheduleAction(this);
    }

    @Override
    public String toString() {
        return "TransferAction ( Data " + this.dataToTransfer.getName() + ", receiver " + this.receiver.getName() + ")";
    }

    @Override
    public boolean taskIsReadyForExecution() {
        return false;
    }

    @Override
    protected void treatDependencyFreeAction(List<AllocatableAction> freeTasks) {
    }

    @Override
    public boolean checkIfCanceled(AllocatableAction aa) {
        return false;
    }

    @Override
    protected void stopAction() throws Exception {
    }

    @Override
    public List<ResourceScheduler<?>> tryToSchedule(Score actionScore, Set<ResourceScheduler<?>> availableWorkers) throws BlockedActionException, UnassignedActionException {
        return null;
    }

    private class FlushCopyListener
    extends EventListener {
        private FlushCopyListener() {
        }

        @Override
        public void notifyEnd(DataOperation d) {
            TransferValueAction.this.completedTransfer();
        }

        @Override
        public void notifyFailure(DataOperation d, Exception excptn) {
            TransferValueAction.this.notifyError();
        }
    }

    private class ObtainDataListener
    extends EventListener {
        private int operation = 0;
        private int errors = 0;
        private boolean enabled = false;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void notifyEnd(DataOperation d) {
            boolean enabled;
            boolean failed;
            boolean finished;
            ObtainDataListener obtainDataListener = this;
            synchronized (obtainDataListener) {
                --this.operation;
                finished = this.operation == 0;
                failed = this.errors > 0;
                enabled = this.enabled;
            }
            if (finished && enabled) {
                if (failed) {
                    TransferValueAction.this.notifyError();
                } else {
                    TransferValueAction.this.flushCopies();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void notifyFailure(DataOperation d, Exception excptn) {
            boolean enabled;
            boolean finished;
            ErrorManager.warn("Transfer for data " + TransferValueAction.this.dataToTransfer + " to " + TransferValueAction.this.receiver.getName() + " has failed.");
            ObtainDataListener obtainDataListener = this;
            synchronized (obtainDataListener) {
                ++this.errors;
                --this.operation;
                finished = this.operation == 0;
                enabled = this.enabled;
            }
            if (enabled && finished) {
                TransferValueAction.this.notifyError();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void enable() {
            boolean failed;
            boolean finished;
            ObtainDataListener obtainDataListener = this;
            synchronized (obtainDataListener) {
                this.enabled = true;
                finished = this.operation == 0;
                failed = this.errors > 0;
            }
            if (finished) {
                if (failed) {
                    TransferValueAction.this.notifyError();
                } else {
                    TransferValueAction.this.flushCopies();
                }
            }
        }

        public synchronized void addOperation() {
            ++this.operation;
        }
    }
}

