/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.types.request.ap;

import es.bsc.compss.components.impl.AccessProcessor;
import es.bsc.compss.components.impl.DataInfoProvider;
import es.bsc.compss.components.impl.TaskAnalyser;
import es.bsc.compss.components.impl.TaskDispatcher;
import es.bsc.compss.types.data.ObjectInfo;
import es.bsc.compss.types.request.ap.APRequest;
import es.bsc.compss.types.request.exceptions.ShutdownException;

public class DeregisterObject
extends APRequest {
    private int hash_code;

    public DeregisterObject(Object o) {
        this.hash_code = o.hashCode();
    }

    @Override
    public APRequest.APRequestType getRequestType() {
        return APRequest.APRequestType.DEREGISTER_OBJECT;
    }

    @Override
    public void process(AccessProcessor ap, TaskAnalyser ta, DataInfoProvider dip, TaskDispatcher td) throws ShutdownException {
        ObjectInfo objectInfo = (ObjectInfo)dip.deleteData(this.hash_code);
        if (objectInfo == null) {
            LOGGER.info("The object with code: " + String.valueOf(this.hash_code) + " is not used by any task");
            return;
        }
        LOGGER.info("Data of : " + String.valueOf(this.hash_code) + " deleted");
        ta.deleteData(objectInfo);
    }
}

