/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.types.request.ap;

import es.bsc.compss.components.impl.AccessProcessor;
import es.bsc.compss.components.impl.DataInfoProvider;
import es.bsc.compss.components.impl.TaskAnalyser;
import es.bsc.compss.components.impl.TaskDispatcher;
import es.bsc.compss.types.data.AccessParams;
import es.bsc.compss.types.request.ap.APRequest;
import java.util.concurrent.Semaphore;

public class WaitForConcurrentRequest
extends APRequest {
    private int dataId;
    private Semaphore sem;
    private Semaphore semTask;
    private int numWaits;
    private final AccessParams.AccessMode am;

    public WaitForConcurrentRequest(int dataId, AccessParams.AccessMode mode, Semaphore sem, Semaphore semTasks) {
        this.dataId = dataId;
        this.sem = sem;
        this.semTask = semTasks;
        this.am = mode;
    }

    public int getDataId() {
        return this.dataId;
    }

    public void setDataId(int dataId) {
        this.dataId = dataId;
    }

    @Override
    public void process(AccessProcessor ap, TaskAnalyser ta, DataInfoProvider dip, TaskDispatcher td) {
        ta.findWaitedConcurrent(this);
    }

    @Override
    public APRequest.APRequestType getRequestType() {
        return APRequest.APRequestType.WAIT_FOR_CONCURRENT;
    }

    public int getNumWaitedTasks() {
        return this.numWaits;
    }

    public void setNumWaitedTasks(int n) {
        this.numWaits = n;
    }

    public Semaphore getSemaphore() {
        return this.sem;
    }

    public Semaphore getTaskSemaphore() {
        return this.semTask;
    }

    public AccessParams.AccessMode getAccessMode() {
        return this.am;
    }
}

