/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.types.request.ap;

import es.bsc.compss.components.impl.AccessProcessor;
import es.bsc.compss.components.impl.DataInfoProvider;
import es.bsc.compss.components.impl.TaskAnalyser;
import es.bsc.compss.components.impl.TaskDispatcher;
import es.bsc.compss.types.data.location.DataLocation;
import es.bsc.compss.types.request.ap.APRequest;
import java.util.concurrent.Semaphore;

public class WaitForDataReadyToDeleteRequest
extends APRequest {
    private final DataLocation loc;
    private final Semaphore sem;
    private final Semaphore semWait;
    private int nPermits;

    public WaitForDataReadyToDeleteRequest(DataLocation loc, Semaphore sem, Semaphore semWait) {
        this.loc = loc;
        this.sem = sem;
        this.semWait = semWait;
        this.nPermits = 0;
    }

    public DataLocation getLocation() {
        return this.loc;
    }

    public int getNumPermits() {
        return this.nPermits;
    }

    @Override
    public void process(AccessProcessor ap, TaskAnalyser ta, DataInfoProvider dip, TaskDispatcher td) {
        LOGGER.info("[WaitForDataReadyToDelete] Notifying waiting data " + this.loc.getPath() + "to DIP...");
        this.nPermits = dip.waitForDataReadyToDelete(this.loc, this.semWait);
        this.sem.release();
    }

    @Override
    public APRequest.APRequestType getRequestType() {
        return APRequest.APRequestType.DELETE_FILE;
    }
}

