/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.components.impl;

import es.bsc.compss.comm.Comm;
import es.bsc.compss.exceptions.ExternalPropertyException;
import es.bsc.compss.types.BindingObject;
import es.bsc.compss.types.data.CollectionInfo;
import es.bsc.compss.types.data.DataAccessId;
import es.bsc.compss.types.data.DataInfo;
import es.bsc.compss.types.data.DataInstanceId;
import es.bsc.compss.types.data.DataVersion;
import es.bsc.compss.types.data.FileInfo;
import es.bsc.compss.types.data.LogicalData;
import es.bsc.compss.types.data.ObjectInfo;
import es.bsc.compss.types.data.ResultFile;
import es.bsc.compss.types.data.StreamInfo;
import es.bsc.compss.types.data.Transferable;
import es.bsc.compss.types.data.accessid.RAccessId;
import es.bsc.compss.types.data.accessid.RWAccessId;
import es.bsc.compss.types.data.accessid.WAccessId;
import es.bsc.compss.types.data.accessparams.AccessParams;
import es.bsc.compss.types.data.listener.EventListener;
import es.bsc.compss.types.data.location.BindingObjectLocation;
import es.bsc.compss.types.data.location.DataLocation;
import es.bsc.compss.types.data.location.PersistentLocation;
import es.bsc.compss.types.data.location.ProtocolType;
import es.bsc.compss.types.data.operation.BindingObjectTransferable;
import es.bsc.compss.types.data.operation.FileTransferable;
import es.bsc.compss.types.data.operation.ObjectTransferable;
import es.bsc.compss.types.data.operation.OneOpWithSemListener;
import es.bsc.compss.types.data.operation.ResultListener;
import es.bsc.compss.types.parameter.CollectionParameter;
import es.bsc.compss.types.request.ap.TransferBindingObjectRequest;
import es.bsc.compss.types.request.ap.TransferObjectRequest;
import es.bsc.compss.types.uri.MultiURI;
import es.bsc.compss.types.uri.SimpleURI;
import es.bsc.compss.util.ErrorManager;
import es.bsc.compss.util.ExternalStreamHandler;
import es.bsc.compss.util.Serializer;
import es.bsc.compss.util.TraceEvent;
import es.bsc.compss.util.Tracer;
import es.bsc.distrostreamlib.api.DistroStream;
import es.bsc.distrostreamlib.client.DistroStreamClient;
import es.bsc.distrostreamlib.requests.AddStreamWriterRequest;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.Semaphore;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import storage.StorageException;
import storage.StorageItf;

public class DataInfoProvider {
    private static final String RES_FILE_TRANSFER_ERR = "Error transferring result files";
    private TreeMap<String, Integer> nameToId = new TreeMap();
    private TreeMap<String, Integer> collectionToId = new TreeMap();
    private TreeMap<Integer, Integer> codeToId = new TreeMap();
    private TreeMap<Integer, DataInfo> idToData = new TreeMap();
    private TreeMap<String, Object> renamingToValue = new TreeMap();
    private static final Logger LOGGER = LogManager.getLogger("es.bsc.compss.Components.TaskProcessor.DataInfoProvider");
    private static final boolean DEBUG = LOGGER.isDebugEnabled();

    public DataInfoProvider() {
        LOGGER.info("Initialization finished");
    }

    public void registerRemoteObjectSources(int code, String data) {
        Integer aoId = this.codeToId.get(code);
        if (aoId == null) {
            if (DEBUG) {
                LOGGER.debug("Registering Remote object on DIP with code " + code);
            }
            ObjectInfo oInfo = new ObjectInfo(code, data);
            aoId = oInfo.getDataId();
            this.codeToId.put(code, aoId);
            this.idToData.put(aoId, oInfo);
        }
    }

    public DataAccessId registerDataAccess(AccessParams access) {
        return access.register();
    }

    public DataAccessId registerFileAccess(AccessParams.AccessMode mode, DataLocation location) {
        DataInfo fileInfo;
        String locationKey = location.getLocationKey();
        Integer fileId = this.nameToId.get(locationKey);
        if (fileId == null) {
            if (DEBUG) {
                LOGGER.debug("FIRST access to file " + location.getLocationKey());
            }
            fileInfo = new FileInfo(location);
            fileId = fileInfo.getDataId();
            this.nameToId.put(locationKey, fileId);
            this.idToData.put(fileId, fileInfo);
            if (mode != AccessParams.AccessMode.W) {
                DataInstanceId lastDID = fileInfo.getCurrentDataVersion().getDataInstanceId();
                String renaming = lastDID.getRenaming();
                Comm.registerLocation(renaming, location);
            }
        } else {
            if (DEBUG) {
                LOGGER.debug("Another access to file " + location.getLocationKey());
            }
            fileInfo = this.idToData.get(fileId);
        }
        return this.willAccess(mode, fileInfo);
    }

    public DataAccessId registerObjectAccess(AccessParams.AccessMode mode, Object value, int code) {
        DataInfo oInfo;
        Integer aoId = this.codeToId.get(code);
        if (aoId == null) {
            if (DEBUG) {
                LOGGER.debug("FIRST access to object " + code);
            }
            oInfo = new ObjectInfo(code);
            aoId = oInfo.getDataId();
            this.codeToId.put(code, aoId);
            this.idToData.put(aoId, oInfo);
            DataInstanceId lastDID = oInfo.getCurrentDataVersion().getDataInstanceId();
            String renaming = lastDID.getRenaming();
            if (mode != AccessParams.AccessMode.W) {
                Comm.registerValue(renaming, value);
            }
        } else {
            if (DEBUG) {
                LOGGER.debug("Another access to object " + code);
            }
            oInfo = this.idToData.get(aoId);
        }
        return this.willAccess(mode, oInfo);
    }

    public DataAccessId registerStreamAccess(AccessParams.AccessMode mode, Object value, int code) {
        DataInfo oInfo;
        Integer aoId = this.codeToId.get(code);
        if (aoId == null) {
            if (DEBUG) {
                LOGGER.debug("FIRST access to stream " + code);
            }
            oInfo = new StreamInfo(code);
            aoId = oInfo.getDataId();
            this.codeToId.put(code, aoId);
            this.idToData.put(aoId, oInfo);
            DataInstanceId lastDID = oInfo.getCurrentDataVersion().getDataInstanceId();
            String renaming = lastDID.getRenaming();
            Comm.registerValue(renaming, value);
        } else {
            if (DEBUG) {
                LOGGER.debug("Another access to stream " + code);
            }
            oInfo = this.idToData.get(aoId);
        }
        if (mode != AccessParams.AccessMode.R) {
            DistroStream ds = (DistroStream)value;
            String streamId = ds.getId();
            if (DEBUG) {
                LOGGER.debug("Registering writer for stream " + streamId);
            }
            AddStreamWriterRequest req = new AddStreamWriterRequest(streamId);
            DistroStreamClient.request(req);
        }
        return this.willAccess(mode, oInfo);
    }

    public DataAccessId registerExternalStreamAccess(AccessParams.AccessMode mode, DataLocation location) {
        DataInfo externalStreamInfo;
        int locationKey = location.getLocationKey().hashCode();
        Integer externalStreamId = this.codeToId.get(locationKey);
        if (externalStreamId == null) {
            if (DEBUG) {
                LOGGER.debug("FIRST access to external stream " + locationKey);
            }
            externalStreamInfo = new StreamInfo(locationKey);
            externalStreamId = externalStreamInfo.getDataId();
            this.codeToId.put(locationKey, externalStreamId);
            this.idToData.put(externalStreamId, externalStreamInfo);
            DataInstanceId lastDID = externalStreamInfo.getCurrentDataVersion().getDataInstanceId();
            String renaming = lastDID.getRenaming();
            Comm.registerLocation(renaming, location);
        } else {
            if (DEBUG) {
                LOGGER.debug("Another access to external stream " + locationKey);
            }
            externalStreamInfo = this.idToData.get(externalStreamId);
        }
        if (mode != AccessParams.AccessMode.R) {
            String filePath = location.getPath();
            try {
                String pythonInterpreter = System.getProperty("compss.python.interpreter");
                if (pythonInterpreter == null || pythonInterpreter.isEmpty() || pythonInterpreter.equals("null")) {
                    pythonInterpreter = "python";
                }
                String streamId = ExternalStreamHandler.getExternalStreamProperty(pythonInterpreter, filePath, "id");
                if (DEBUG) {
                    LOGGER.debug("Registering writer for stream " + streamId);
                }
                AddStreamWriterRequest req = new AddStreamWriterRequest(streamId);
                DistroStreamClient.request(req);
            }
            catch (ExternalPropertyException e) {
                LOGGER.error("ERROR: Cannot retrieve external property. Not adding stream writer", (Throwable)e);
            }
        }
        return this.willAccess(mode, externalStreamInfo);
    }

    public DataAccessId registerBindingObjectAccess(AccessParams.AccessMode mode, BindingObject bo, int code) {
        DataInfo oInfo;
        Integer aoId = this.codeToId.get(code);
        if (aoId == null) {
            if (DEBUG) {
                LOGGER.debug("FIRST access to external object " + code);
            }
            oInfo = new ObjectInfo(code);
            aoId = oInfo.getDataId();
            this.codeToId.put(code, aoId);
            this.idToData.put(aoId, oInfo);
            DataInstanceId lastDID = oInfo.getCurrentDataVersion().getDataInstanceId();
            String renaming = lastDID.getRenaming();
            if (mode != AccessParams.AccessMode.W) {
                Comm.registerBindingObject(renaming, bo);
            }
        } else {
            if (DEBUG) {
                LOGGER.debug("Another access to external object " + code);
            }
            oInfo = this.idToData.get(aoId);
        }
        return this.willAccess(mode, oInfo);
    }

    public DataAccessId registerExternalPSCOAccess(AccessParams.AccessMode mode, String pscoId, int code) {
        DataInfo oInfo;
        Integer aoId = this.codeToId.get(code);
        if (aoId == null) {
            if (DEBUG) {
                LOGGER.debug("FIRST access to external object " + code);
            }
            oInfo = new ObjectInfo(code);
            aoId = oInfo.getDataId();
            this.codeToId.put(code, aoId);
            this.idToData.put(aoId, oInfo);
            DataInstanceId lastDID = oInfo.getCurrentDataVersion().getDataInstanceId();
            String renaming = lastDID.getRenaming();
            if (mode != AccessParams.AccessMode.W) {
                Comm.registerExternalPSCO(renaming, pscoId);
            }
        } else {
            if (DEBUG) {
                LOGGER.debug("Another access to external object " + code);
            }
            oInfo = this.idToData.get(aoId);
        }
        return this.willAccess(mode, oInfo);
    }

    public void finishFileAccess(AccessParams.AccessMode mode, DataLocation location) {
        String locationKey = location.getLocationKey();
        Integer fileId = this.nameToId.get(locationKey);
        if (fileId == null) {
            LOGGER.warn("File " + location.getLocationKey() + " has not been accessed before");
            return;
        }
        DataInfo fileInfo = this.idToData.get(fileId);
        DataAccessId daid = this.getAccess(mode, fileInfo);
        if (daid == null) {
            LOGGER.warn("File " + location.getLocationKey() + " has not been accessed before");
            return;
        }
        this.dataHasBeenAccessed(daid);
    }

    public void finishBindingObjectAccess(AccessParams.AccessMode mode, int code) {
        Integer aoId = this.codeToId.get(code);
        if (aoId == null) {
            LOGGER.warn("Binding Object " + code + " has not been accessed before");
            return;
        }
        DataInfo boInfo = this.idToData.get(aoId);
        DataAccessId daid = this.getAccess(mode, boInfo);
        if (daid == null) {
            LOGGER.warn("Binding Object " + code + " has not been accessed before");
            return;
        }
        this.dataHasBeenAccessed(daid);
    }

    private DataAccessId willAccess(AccessParams.AccessMode mode, DataInfo di) {
        DataAccessId daId = null;
        switch (mode) {
            case C: 
            case R: {
                di.willBeRead();
                daId = new RAccessId(di.getCurrentDataVersion());
                if (!DEBUG) break;
                StringBuilder sb = new StringBuilder("");
                sb.append("Access:").append("\n");
                sb.append("  * Type: R").append("\n");
                sb.append("  * Read Datum: d").append(daId.getDataId()).append("v").append(((RAccessId)daId).getRVersionId()).append("\n");
                LOGGER.debug(sb.toString());
                break;
            }
            case W: {
                di.willBeWritten();
                daId = new WAccessId(di.getCurrentDataVersion());
                if (!DEBUG) break;
                StringBuilder sb = new StringBuilder("");
                sb.append("Access:").append("\n");
                sb.append("  * Type: W").append("\n");
                sb.append("  * Write Datum: d").append(daId.getDataId()).append("v").append(((WAccessId)daId).getWVersionId()).append("\n");
                LOGGER.debug(sb.toString());
                break;
            }
            case CV: 
            case RW: {
                di.willBeRead();
                DataVersion readInstance = di.getCurrentDataVersion();
                di.willBeWritten();
                DataVersion writtenInstance = di.getCurrentDataVersion();
                daId = new RWAccessId(readInstance, writtenInstance);
                if (!DEBUG) break;
                StringBuilder sb = new StringBuilder("");
                sb.append("Access:").append("\n");
                sb.append("  * Type: RW").append("\n");
                sb.append("  * Read Datum: d").append(daId.getDataId()).append("v").append(((RWAccessId)daId).getRVersionId()).append("\n");
                sb.append("  * Write Datum: d").append(daId.getDataId()).append("v").append(((RWAccessId)daId).getWVersionId()).append("\n");
                LOGGER.debug(sb.toString());
            }
        }
        return daId;
    }

    private DataAccessId getAccess(AccessParams.AccessMode mode, DataInfo di) {
        DataAccessId daId = null;
        DataVersion currentInstance = di.getCurrentDataVersion();
        if (currentInstance != null) {
            switch (mode) {
                case C: 
                case R: {
                    daId = new RAccessId(currentInstance);
                    break;
                }
                case W: {
                    daId = new WAccessId(di.getCurrentDataVersion());
                    break;
                }
                case CV: 
                case RW: {
                    DataVersion readInstance = di.getPreviousDataVersion();
                    if (readInstance != null) {
                        daId = new RWAccessId(readInstance, currentInstance);
                        break;
                    }
                    LOGGER.warn("Previous instance for data" + di.getDataId() + " is null.");
                }
            }
        } else {
            LOGGER.warn("Current instance for data" + di.getDataId() + " is null.");
        }
        return daId;
    }

    public void dataAccessHasBeenCanceled(DataAccessId dAccId) {
        Integer dataId = dAccId.getDataId();
        DataInfo di = this.idToData.get(dataId);
        boolean deleted = false;
        switch (dAccId.getDirection()) {
            case C: 
            case R: {
                Integer rVersionId = ((RAccessId)dAccId).getReadDataInstance().getVersionId();
                deleted = di.versionHasBeenRead(rVersionId);
                break;
            }
            case CV: 
            case RW: {
                Integer rVersionId = ((RWAccessId)dAccId).getReadDataInstance().getVersionId();
                di.versionHasBeenRead(rVersionId);
                Integer wVersionId = ((RWAccessId)dAccId).getWrittenDataInstance().getVersionId();
                di.canceledVersion(wVersionId);
                break;
            }
            default: {
                Integer wVersionId = ((WAccessId)dAccId).getWrittenDataInstance().getVersionId();
                di.canceledVersion(wVersionId);
            }
        }
        if (deleted) {
            this.idToData.remove(dataId);
        }
    }

    public void dataHasBeenAccessed(DataAccessId dAccId) {
        Integer dataId = dAccId.getDataId();
        DataInfo di = this.idToData.get(dataId);
        boolean deleted = false;
        switch (dAccId.getDirection()) {
            case C: 
            case R: {
                Integer rVersionId = ((RAccessId)dAccId).getReadDataInstance().getVersionId();
                deleted = di.versionHasBeenRead(rVersionId);
                break;
            }
            case RW: {
                Integer rVersionId = ((RWAccessId)dAccId).getReadDataInstance().getVersionId();
                di.versionHasBeenRead(rVersionId);
                di.tryRemoveVersion(rVersionId);
                Integer wVersionId = ((RWAccessId)dAccId).getWrittenDataInstance().getVersionId();
                deleted = di.versionHasBeenWritten(wVersionId);
                break;
            }
            default: {
                Integer wVersionId = ((WAccessId)dAccId).getWrittenDataInstance().getVersionId();
                deleted = di.versionHasBeenWritten(wVersionId);
            }
        }
        if (deleted) {
            this.idToData.remove(dataId);
        }
    }

    public boolean alreadyAccessed(DataLocation loc) {
        LOGGER.debug("Check already accessed: " + loc.getLocationKey());
        String locationKey = loc.getLocationKey();
        Integer fileId = this.nameToId.get(locationKey);
        return fileId != null;
    }

    public String getLastRenaming(int code) {
        Integer aoId = this.codeToId.get(code);
        DataInfo oInfo = this.idToData.get(aoId);
        return oInfo.getCurrentDataVersion().getDataInstanceId().getRenaming();
    }

    public DataLocation getOriginalLocation(int fileId) {
        FileInfo info = (FileInfo)this.idToData.get(fileId);
        return info.getOriginalLocation();
    }

    public void setObjectVersionValue(String renaming, Object value) {
        this.renamingToValue.put(renaming, value);
        Comm.registerValue(renaming, value);
    }

    public boolean isHere(DataInstanceId dId) {
        return this.renamingToValue.get(dId.getRenaming()) != null;
    }

    public Object getObject(String renaming) {
        return this.renamingToValue.get(renaming);
    }

    public void newVersionSameValue(String rRenaming, String wRenaming) {
        this.renamingToValue.put(wRenaming, this.renamingToValue.get(rRenaming));
    }

    public DataInstanceId getLastDataAccess(int code) {
        Integer aoId = this.codeToId.get(code);
        DataInfo oInfo = this.idToData.get(aoId);
        return oInfo.getCurrentDataVersion().getDataInstanceId();
    }

    public List<DataInstanceId> getLastVersions(TreeSet<Integer> dataIds) {
        ArrayList<DataInstanceId> versionIds = new ArrayList<DataInstanceId>(dataIds.size());
        for (Integer dataId : dataIds) {
            DataInfo dataInfo = this.idToData.get(dataId);
            if (dataInfo != null) {
                versionIds.add(dataInfo.getCurrentDataVersion().getDataInstanceId());
                continue;
            }
            versionIds.add(null);
        }
        return versionIds;
    }

    public void unblockDataId(Integer dataId) {
        DataInfo dataInfo = this.idToData.get(dataId);
        dataInfo.unblockDeletions();
    }

    public int waitForDataReadyToDelete(DataLocation loc, Semaphore semWait) {
        LOGGER.debug("Waiting for data to be ready for deletion: " + loc.getPath());
        String locationKey = loc.getLocationKey();
        Integer dataId = this.nameToId.get(locationKey);
        if (dataId == null) {
            LOGGER.debug("No data id found for this data location" + loc.getPath());
            semWait.release();
            return 0;
        }
        DataInfo dataInfo = this.idToData.get(dataId);
        int nPermits = dataInfo.waitForDataReadyToDelete(semWait);
        return nPermits;
    }

    public DataInfo getLocationDataInfo(DataLocation loc) {
        String locationKey = loc.getLocationKey();
        if (this.nameToId.containsKey(locationKey)) {
            Integer dataId = this.nameToId.get(locationKey);
            DataInfo dataInfo = this.idToData.get(dataId);
            return dataInfo;
        }
        return null;
    }

    public DataInfo deleteData(DataLocation loc, boolean noReuse) {
        LOGGER.debug("Deleting Data location: " + loc.getPath());
        String locationKey = loc.getLocationKey();
        Integer dataId = this.nameToId.get(locationKey);
        if (dataId == null) {
            LOGGER.debug("No data id found for this data location" + loc.getPath());
            return null;
        }
        DataInfo dataInfo = this.idToData.get(dataId);
        this.nameToId.remove(locationKey);
        if (dataInfo.delete(noReuse)) {
            this.idToData.remove(dataId);
        }
        return dataInfo;
    }

    public DataInfo deleteData(int code, boolean noReuse) {
        LOGGER.debug("Deleting Data associated with code: " + String.valueOf(code));
        Integer id = this.codeToId.get(code);
        DataInfo dataInfo = this.idToData.get(id);
        if (dataInfo.delete(noReuse)) {
            this.idToData.remove(id);
        }
        return dataInfo;
    }

    public void transferObjectValue(TransferObjectRequest toRequest) {
        LogicalData ld;
        Semaphore sem = toRequest.getSemaphore();
        DataAccessId daId = toRequest.getDaId();
        RWAccessId rwaId = (RWAccessId)daId;
        String sourceName = rwaId.getReadDataInstance().getRenaming();
        if (DEBUG) {
            LOGGER.debug("Requesting getting object " + sourceName);
        }
        if ((ld = Comm.getData(sourceName)) == null) {
            ErrorManager.error("Unregistered data " + sourceName);
            return;
        }
        if (ld.isInMemory()) {
            Object value = null;
            if (!rwaId.isPreserveSourceData()) {
                value = ld.getValue();
                ld.removeValue();
            } else {
                try {
                    ld.writeToStorage();
                }
                catch (Exception e) {
                    ErrorManager.error("Exception writing object to file.", e);
                }
                for (DataLocation loc : ld.getLocations()) {
                    if (loc.getProtocol() == ProtocolType.OBJECT_URI) continue;
                    MultiURI mu = loc.getURIInHost(Comm.getAppHost());
                    String path = mu.getPath();
                    try {
                        value = Serializer.deserialize(path);
                        break;
                    }
                    catch (IOException | ClassNotFoundException e) {
                        ErrorManager.error("Exception writing object to file.", e);
                    }
                }
            }
            toRequest.setResponse(value);
            toRequest.setTargetData(ld);
            sem.release();
        } else {
            if (DEBUG) {
                LOGGER.debug("Object " + sourceName + " not in memory. Requesting tranfers to " + Comm.getAppHost().getName());
            }
            DataLocation targetLocation = null;
            String path = ProtocolType.FILE_URI.getSchema() + Comm.getAppHost().getTempDirPath() + sourceName;
            try {
                SimpleURI uri = new SimpleURI(path);
                targetLocation = DataLocation.createLocation(Comm.getAppHost(), uri);
            }
            catch (Exception e) {
                ErrorManager.error("ERROR: Invalid location URI " + path, e);
            }
            toRequest.setTargetData(ld);
            Comm.getAppHost().getData(sourceName, targetLocation, (Transferable)new ObjectTransferable(), (EventListener)new OneOpWithSemListener(sem));
        }
    }

    public LogicalData transferBindingObject(TransferBindingObjectRequest toRequest) {
        DataAccessId daId = toRequest.getDaId();
        RAccessId rwaId = (RAccessId)daId;
        String sourceName = rwaId.getReadDataInstance().getRenaming();
        if (DEBUG) {
            LOGGER.debug("[DataInfoProvider] Requesting getting object " + sourceName);
        }
        LogicalData srcLd = Comm.getData(sourceName);
        if (DEBUG) {
            LOGGER.debug("[DataInfoProvider] Logical data for binding object is:" + srcLd);
        }
        if (srcLd == null) {
            ErrorManager.error("Unregistered data " + sourceName);
            return null;
        }
        if (DEBUG) {
            LOGGER.debug("Requesting tranfers binding object " + sourceName + " to " + Comm.getAppHost().getName());
        }
        Semaphore sem = toRequest.getSemaphore();
        BindingObject srcBO = BindingObject.generate(srcLd.getURIs().get(0).getPath());
        BindingObject tgtBO = new BindingObject(sourceName, srcBO.getType(), srcBO.getElements());
        LogicalData tgtLd = srcLd;
        BindingObjectLocation targetLocation = new BindingObjectLocation(Comm.getAppHost(), tgtBO);
        BindingObjectTransferable transfer = new BindingObjectTransferable(toRequest);
        Comm.getAppHost().getData(srcLd, (DataLocation)targetLocation, tgtLd, (Transferable)transfer, (EventListener)new OneOpWithSemListener(sem));
        if (DEBUG) {
            LOGGER.debug(" Setting tgtName " + transfer.getDataTarget() + " in " + Comm.getAppHost().getName());
        }
        return srcLd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultFile blockDataAndGetResultFile(int dataId, ResultListener listener) {
        FileInfo fileInfo;
        if (DEBUG) {
            LOGGER.debug("Get Result file for data " + dataId);
        }
        if ((fileInfo = (FileInfo)this.idToData.get(dataId)) != null && fileInfo.hasBeenCanceled()) {
            if (!fileInfo.isCurrentVersionToDelete()) {
                String[] splitPath = fileInfo.getOriginalLocation().getPath().split(File.separator);
                String origName = splitPath[splitPath.length - 1];
                if (origName.startsWith("compss-serialized-obj_")) {
                    if (DEBUG) {
                        LOGGER.debug("Discarding file " + origName + " as a result");
                    }
                    return null;
                }
                fileInfo.blockDeletions();
                DataInstanceId lastVersion = fileInfo.getCurrentDataVersion().getDataInstanceId();
                ResultFile rf = new ResultFile(lastVersion, fileInfo.getOriginalLocation());
                DataInstanceId fId = rf.getFileInstanceId();
                String renaming = fId.getRenaming();
                while (renaming != null && !Comm.existsData(renaming)) {
                    renaming = DataInstanceId.previousVersionRenaming(renaming);
                }
                if (renaming == null) {
                    LOGGER.error("Error transferring result files: Cannot transfer file " + fId.getRenaming() + " nor any of its previous versions");
                    return null;
                }
                for (DataLocation loc : Comm.getData(renaming).getLocations()) {
                    if (!(loc instanceof PersistentLocation)) continue;
                    String pscoId = ((PersistentLocation)loc).getId();
                    if (Tracer.extraeEnabled()) {
                        Tracer.emitEvent(TraceEvent.STORAGE_CONSOLIDATE.getId(), TraceEvent.STORAGE_CONSOLIDATE.getType());
                    }
                    try {
                        StorageItf.consolidateVersion(pscoId);
                    }
                    catch (StorageException e) {
                        LOGGER.error("Cannot consolidate PSCO " + pscoId, (Throwable)e);
                    }
                    finally {
                        if (Tracer.extraeEnabled()) {
                            Tracer.emitEvent(0L, TraceEvent.STORAGE_CONSOLIDATE.getType());
                        }
                    }
                    LOGGER.debug("Returned because persistent object");
                    return rf;
                }
                if (rf.getOriginalLocation().getProtocol() == ProtocolType.BINDING_URI) {
                    if (DEBUG) {
                        LOGGER.debug("Discarding data d" + dataId + " as a result beacuse it is a binding object");
                    }
                } else {
                    listener.addOperation();
                    Comm.getAppHost().getData(renaming, rf.getOriginalLocation(), (Transferable)new FileTransferable(), (EventListener)listener);
                }
                return rf;
            }
            if (fileInfo.isCurrentVersionToDelete()) {
                if (DEBUG) {
                    String[] splitPath = fileInfo.getOriginalLocation().getPath().split(File.separator);
                    String origName = splitPath[splitPath.length - 1];
                    LOGGER.debug("Trying to delete file " + origName);
                }
                if (fileInfo.delete(true)) {
                    this.idToData.remove(dataId);
                }
            }
        }
        return null;
    }

    public void shutdown() {
    }

    public DataAccessId registerCollectionAccess(AccessParams.AccessMode am, CollectionParameter cp) {
        CollectionInfo cInfo;
        String collectionId = cp.getCollectionId();
        Integer oId = this.collectionToId.get(collectionId);
        if (oId == null) {
            cInfo = new CollectionInfo(collectionId);
            oId = cInfo.getDataId();
            this.collectionToId.put(collectionId, oId);
            this.idToData.put(oId, cInfo);
            DataInstanceId lastDID = cInfo.getCurrentDataVersion().getDataInstanceId();
            String renaming = lastDID.getRenaming();
            if (am != AccessParams.AccessMode.W) {
                if (DEBUG) {
                    LOGGER.debug("Collection " + collectionId + " contains " + cp.getParameters().size() + " accesses");
                }
                Comm.registerCollection(renaming, null);
            }
        } else {
            cInfo = (CollectionInfo)this.idToData.get(oId);
        }
        return this.willAccess(am, cInfo);
    }
}

