/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.types.request.ap;

import es.bsc.compss.api.TaskMonitor;
import es.bsc.compss.components.impl.AccessProcessor;
import es.bsc.compss.components.impl.DataInfoProvider;
import es.bsc.compss.components.impl.TaskAnalyser;
import es.bsc.compss.components.impl.TaskDispatcher;
import es.bsc.compss.types.Task;
import es.bsc.compss.types.request.ap.APRequest;
import es.bsc.compss.types.request.ap.APRequestType;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TaskAnalysisRequest
extends APRequest {
    private static final Logger TIMER_LOGGER = LogManager.getLogger("es.bsc.compss.Timers");
    private static final boolean IS_TIMER_COMPSS_ENABLED;
    private final Task task;

    public TaskAnalysisRequest(Task task) {
        this.task = task;
    }

    public Task getTask() {
        return this.task;
    }

    @Override
    public void process(AccessProcessor ap, TaskAnalyser ta, DataInfoProvider dip, TaskDispatcher td) {
        if (IS_TIMER_COMPSS_ENABLED) {
            long startTime = System.nanoTime();
            ta.processTask(this.task);
            long endTime = System.nanoTime();
            float elapsedTime = (float)(endTime - startTime) / 1000000.0f;
            TIMER_LOGGER.info("[TIMER] TA Process of task " + this.task.getId() + ": " + elapsedTime + " ms");
        } else {
            ta.processTask(this.task);
        }
        td.executeTask(ap, this.task);
        TaskMonitor monitor = this.task.getTaskMonitor();
        monitor.onAccessesProcessed();
    }

    @Override
    public APRequestType getRequestType() {
        return APRequestType.ANALYSE_TASK;
    }

    static {
        String isTimerCOMPSsEnabledProperty = System.getProperty("compss.timers");
        IS_TIMER_COMPSS_ENABLED = isTimerCOMPSsEnabledProperty == null || isTimerCOMPSsEnabledProperty.isEmpty() || isTimerCOMPSsEnabledProperty.equals("null") ? false : Boolean.valueOf(isTimerCOMPSsEnabledProperty);
    }
}

