/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.types.resources;

import es.bsc.compss.exceptions.AnnounceException;
import es.bsc.compss.types.COMPSsNode;
import es.bsc.compss.types.COMPSsWorker;
import es.bsc.compss.types.implementations.Implementation;
import es.bsc.compss.types.resources.ResourceImpl;
import es.bsc.compss.types.resources.WorkerResourceDescription;
import es.bsc.compss.types.resources.configuration.Configuration;
import es.bsc.compss.util.CoreManager;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class Worker<T extends WorkerResourceDescription>
extends ResourceImpl {
    protected static final Logger LOGGER = LogManager.getLogger("es.bsc.compss.Components.ResourceManager");
    protected static final boolean DEBUG = LOGGER.isDebugEnabled();
    protected final T description;
    private List<Integer> executableCores;
    private List<Implementation>[] executableImpls;
    private int[][] implSimultaneousTasks;
    private int[] coreSimultaneousTasks;
    private int[] idealSimultaneousTasks;

    public Worker(String name, T description, COMPSsNode worker, int limitOfTasks, Map<String, String> sharedDisks) {
        super(worker, sharedDisks);
        int coreCount = CoreManager.getCoreCount();
        this.coreSimultaneousTasks = new int[coreCount];
        this.idealSimultaneousTasks = new int[coreCount];
        this.executableCores = new LinkedList<Integer>();
        this.implSimultaneousTasks = new int[coreCount][];
        this.executableImpls = new LinkedList[coreCount];
        for (int coreId = 0; coreId < coreCount; ++coreId) {
            this.executableImpls[coreId] = new LinkedList<Implementation>();
            this.implSimultaneousTasks[coreId] = new int[CoreManager.getNumberCoreImplementations(coreId)];
        }
        this.description = description;
    }

    public Worker(String name, T description, Configuration config, Map<String, String> sharedDisks) {
        super(name, config, sharedDisks);
        int coreCount = CoreManager.getCoreCount();
        this.coreSimultaneousTasks = new int[coreCount];
        this.idealSimultaneousTasks = new int[coreCount];
        this.executableCores = new LinkedList<Integer>();
        this.implSimultaneousTasks = new int[coreCount][];
        this.executableImpls = new LinkedList[coreCount];
        for (int coreId = 0; coreId < coreCount; ++coreId) {
            this.executableImpls[coreId] = new LinkedList<Implementation>();
            this.implSimultaneousTasks[coreId] = new int[CoreManager.getNumberCoreImplementations(coreId)];
        }
        this.description = description;
    }

    public Worker(Worker<T> w) {
        super(w);
        this.coreSimultaneousTasks = w.coreSimultaneousTasks;
        this.idealSimultaneousTasks = w.idealSimultaneousTasks;
        this.executableCores = w.executableCores;
        this.implSimultaneousTasks = w.implSimultaneousTasks;
        this.executableImpls = w.executableImpls;
        this.description = w.description;
    }

    public T getDescription() {
        return this.description;
    }

    public void resetUsedTaskCounts() {
    }

    public void updatedCoreElements(List<Integer> updatedCoreIds) {
        if (DEBUG) {
            LOGGER.debug("Update coreElements on Worker " + this.getName());
        }
        int coreCount = CoreManager.getCoreCount();
        boolean[] coresToUpdate = new boolean[coreCount];
        for (int coreId : updatedCoreIds) {
            coresToUpdate[coreId] = true;
        }
        boolean[] wasExecutable = new boolean[coreCount];
        for (int coreId : this.executableCores) {
            wasExecutable[coreId] = true;
        }
        this.executableCores.clear();
        LinkedList[] executableImpls = new LinkedList[coreCount];
        int[][] implSimultaneousTasks = new int[coreCount][];
        int[] coreSimultaneousTasks = new int[coreCount];
        int[] idealSimultaneousTasks = new int[coreCount];
        for (int coreId = 0; coreId < coreCount; ++coreId) {
            if (!coresToUpdate[coreId]) {
                executableImpls[coreId] = this.executableImpls[coreId];
                implSimultaneousTasks[coreId] = this.implSimultaneousTasks[coreId];
                coreSimultaneousTasks[coreId] = this.coreSimultaneousTasks[coreId];
                idealSimultaneousTasks[coreId] = this.idealSimultaneousTasks[coreId];
                if (!wasExecutable[coreId]) continue;
                this.executableCores.add(coreId);
                continue;
            }
            boolean executableCore = false;
            List<Implementation> impls = CoreManager.getCoreImplementations(coreId);
            implSimultaneousTasks[coreId] = new int[impls.size()];
            executableImpls[coreId] = new LinkedList();
            for (Implementation impl : impls) {
                if (!this.canRun(impl)) continue;
                int simultaneousCapacity = this.simultaneousCapacity(impl);
                idealSimultaneousTasks[coreId] = Math.max(idealSimultaneousTasks[coreId], simultaneousCapacity);
                implSimultaneousTasks[coreId][impl.getImplementationId().intValue()] = simultaneousCapacity;
                if (implSimultaneousTasks[coreId][impl.getImplementationId()] <= 0) continue;
                executableImpls[coreId].add(impl);
                executableCore = true;
            }
            if (!executableCore) continue;
            this.executableCores.add(coreId);
        }
        this.executableImpls = executableImpls;
        this.implSimultaneousTasks = implSimultaneousTasks;
        this.coreSimultaneousTasks = coreSimultaneousTasks;
        this.idealSimultaneousTasks = idealSimultaneousTasks;
    }

    public void updatedFeatures() {
        int coreCount = CoreManager.getCoreCount();
        this.executableCores.clear();
        this.executableImpls = new LinkedList[coreCount];
        this.implSimultaneousTasks = new int[coreCount][];
        this.coreSimultaneousTasks = new int[coreCount];
        this.idealSimultaneousTasks = new int[coreCount];
        for (int coreId = 0; coreId < coreCount; ++coreId) {
            boolean executableCore = false;
            List<Implementation> impls = CoreManager.getCoreImplementations(coreId);
            this.implSimultaneousTasks[coreId] = new int[impls.size()];
            this.executableImpls[coreId] = new LinkedList<Implementation>();
            for (Implementation impl : impls) {
                if (!this.canRun(impl)) continue;
                int simultaneousCapacity = this.simultaneousCapacity(impl);
                this.idealSimultaneousTasks[coreId] = Math.max(this.idealSimultaneousTasks[coreId], simultaneousCapacity);
                this.implSimultaneousTasks[coreId][impl.getImplementationId().intValue()] = simultaneousCapacity;
                if (simultaneousCapacity <= 0) continue;
                this.executableImpls[coreId].add(impl);
                executableCore = true;
            }
            if (!executableCore) continue;
            this.coreSimultaneousTasks[coreId] = this.limitIdealSimultaneousTasks(this.idealSimultaneousTasks[coreId]);
            this.executableCores.add(coreId);
        }
    }

    protected int limitIdealSimultaneousTasks(int ideal) {
        return ideal;
    }

    public List<Integer> getExecutableCores() {
        return this.executableCores;
    }

    public List<Implementation>[] getExecutableImpls() {
        return this.executableImpls;
    }

    public List<Implementation> getExecutableImpls(int coreId) {
        return this.executableImpls[coreId];
    }

    public int[] getIdealSimultaneousTasks() {
        return this.idealSimultaneousTasks;
    }

    public int[] getSimultaneousTasks() {
        return this.coreSimultaneousTasks;
    }

    public Integer simultaneousCapacity(Implementation impl) {
        return this.fitCount(impl);
    }

    public String getResourceLinks(String prefix) {
        int i;
        StringBuilder sb = new StringBuilder();
        sb.append(prefix).append("NAME = ").append(this.getName()).append("\n");
        sb.append(prefix).append("EXEC_CORES = ").append(this.executableCores).append("\n");
        sb.append(prefix).append("CORE_SIMTASKS = [").append("\n");
        for (i = 0; i < this.coreSimultaneousTasks.length; ++i) {
            sb.append(prefix).append("\t").append("CORE = [").append("\n");
            sb.append(prefix).append("\t").append("\t").append("COREID = ").append(i).append("\n");
            sb.append(prefix).append("\t").append("\t").append("SIM_TASKS = ").append(this.coreSimultaneousTasks[i]).append("\n");
            sb.append(prefix).append("\t").append("]").append("\n");
        }
        sb.append(prefix).append("]").append("\n");
        sb.append(prefix).append("IMPL_SIMTASKS = [").append("\n");
        for (i = 0; i < this.implSimultaneousTasks.length; ++i) {
            for (int j = 0; j < this.implSimultaneousTasks[i].length; ++j) {
                sb.append(prefix).append("\t").append("IMPLEMENTATION = [").append("\n");
                sb.append(prefix).append("\t").append("\t").append("COREID = ").append(i).append("\n");
                sb.append(prefix).append("\t").append("\t").append("IMPLID = ").append(j).append("\n");
                sb.append(prefix).append("\t").append("\t").append("SIM_TASKS = ").append(this.implSimultaneousTasks[i][j]).append("\n");
                sb.append(prefix).append("\t").append("]").append("\n");
            }
        }
        sb.append(prefix).append("]").append("\n");
        return sb.toString();
    }

    public List<Integer> getRunnableCores() {
        LinkedList<Integer> cores = new LinkedList<Integer>();
        int coreCount = CoreManager.getCoreCount();
        for (int coreId = 0; coreId < coreCount; ++coreId) {
            if (this.getRunnableImplementations(coreId).isEmpty()) continue;
            cores.add(coreId);
        }
        return cores;
    }

    public List<Implementation>[] getRunnableImplementations() {
        int coreCount = CoreManager.getCoreCount();
        LinkedList[] runnable = new LinkedList[coreCount];
        for (int coreId = 0; coreId < coreCount; ++coreId) {
            runnable[coreId] = this.getRunnableImplementations(coreId);
        }
        return runnable;
    }

    public List<Implementation> getRunnableImplementations(int coreId) {
        LinkedList<Implementation> runnable = new LinkedList<Implementation>();
        for (Implementation impl : this.executableImpls[coreId]) {
            if (!this.canRunNow(impl.getRequirements())) continue;
            runnable.add(impl);
        }
        return runnable;
    }

    public final boolean canRunSomething() {
        int coreCount = CoreManager.getCoreCount();
        for (int coreId = 0; coreId < coreCount; ++coreId) {
            if (this.getRunnableImplementations(coreId).isEmpty()) continue;
            return true;
        }
        return false;
    }

    public boolean canRun(int coreId) {
        return this.idealSimultaneousTasks[coreId] > 0;
    }

    public abstract boolean canRun(Implementation var1);

    public List<Implementation> canRunNow(LinkedList<Implementation> candidates) {
        LinkedList<Implementation> runnable = new LinkedList<Implementation>();
        for (Implementation impl : candidates) {
            if (!this.canRunNow(impl.getRequirements())) continue;
            runnable.add(impl);
        }
        return runnable;
    }

    public boolean canRunNow(T consumption) {
        return this.hasAvailable(consumption);
    }

    public T runTask(T consumption) {
        return this.reserveResource(consumption);
    }

    public void endTask(T consumption) {
        if (DEBUG) {
            LOGGER.debug("End task received. Releasing resource " + this.getName());
        }
        this.releaseResource(consumption);
    }

    public abstract String getMonitoringData(String var1);

    public abstract Integer fitCount(Implementation var1);

    public abstract boolean hasAvailable(T var1);

    public abstract boolean hasAvailableSlots();

    public abstract T reserveResource(T var1);

    public abstract void releaseResource(T var1);

    public abstract void releaseAllResources();

    public void announceCreation() throws AnnounceException {
        COMPSsWorker w = (COMPSsWorker)this.getNode();
        w.announceCreation();
    }

    public void announceDestruction() throws AnnounceException {
        COMPSsWorker w = (COMPSsWorker)this.getNode();
        w.announceDestruction();
    }

    public abstract Worker<T> getSchedulingCopy();

    public String toString() {
        return "Worker " + this.name + " with the following description " + this.description;
    }
}

