/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.types.data.location;

import es.bsc.compss.types.BindingObject;
import es.bsc.compss.types.data.location.BindingObjectLocation;
import es.bsc.compss.types.data.location.LocationType;
import es.bsc.compss.types.data.location.PersistentLocation;
import es.bsc.compss.types.data.location.PrivateLocation;
import es.bsc.compss.types.data.location.ProtocolType;
import es.bsc.compss.types.data.location.SharedLocation;
import es.bsc.compss.types.resources.Resource;
import es.bsc.compss.types.uri.MultiURI;
import es.bsc.compss.types.uri.SimpleURI;
import es.bsc.compss.util.SharedDiskManager;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class DataLocation
implements Comparable<DataLocation> {
    protected static final Logger LOGGER = LogManager.getLogger("es.bsc.compss.Communication");
    public static final String ERROR_INVALID_LOCATION = "ERROR: Invalid location URI";
    public static final String ERROR_UNSTARTED_NODE = "ERROR: Cannot retrieve URIs from an unstarted node";

    public static DataLocation createLocation(Resource host, SimpleURI uri) throws IOException {
        ProtocolType protocol = ProtocolType.getBySchema(uri.getSchema());
        if (protocol == null) {
            LOGGER.warn("WARN: Unrecognised protocol [ " + uri.getSchema() + " ] for createLocation. Switching to " + ProtocolType.ANY_URI.getSchema());
            protocol = ProtocolType.ANY_URI;
        }
        DataLocation loc = null;
        switch (protocol) {
            case FILE_URI: {
                String canonicalPath = null;
                try {
                    canonicalPath = new URI(uri.getPath()).normalize().getPath();
                    if ('/' != canonicalPath.charAt(0)) {
                        canonicalPath = new File(uri.getPath()).getCanonicalPath();
                    }
                }
                catch (URISyntaxException e) {
                    canonicalPath = new File(uri.getPath()).getCanonicalPath();
                }
                LOGGER.debug("Creating new FileLocation: " + protocol.getSchema() + host.getName() + "@" + canonicalPath);
                loc = DataLocation.createLocation(ProtocolType.FILE_URI, host, canonicalPath);
                break;
            }
            case SHARED_URI: {
                int splitIndex = uri.getPath().indexOf(File.separator);
                String diskName = uri.getPath().substring(0, splitIndex);
                String path = uri.getPath().substring(splitIndex + 1);
                LOGGER.debug("Creating new SharedLocation: " + protocol.getSchema() + "@" + diskName + path);
                loc = new SharedLocation(ProtocolType.SHARED_URI, diskName, path);
                break;
            }
            case OBJECT_URI: {
                String objectName = uri.getPath();
                LOGGER.debug("Creating new ObjectLocation: " + protocol.getSchema() + host.getName() + "@" + objectName);
                loc = DataLocation.createLocation(ProtocolType.OBJECT_URI, host, objectName);
                break;
            }
            case STREAM_URI: {
                String streamName = uri.getPath();
                LOGGER.debug("Creating new StreamLocation: " + protocol.getSchema() + host.getName() + "@" + streamName);
                loc = DataLocation.createLocation(ProtocolType.STREAM_URI, host, streamName);
                break;
            }
            case EXTERNAL_STREAM_URI: {
                String streamCompletePath = null;
                try {
                    streamCompletePath = new URI(uri.getPath()).normalize().getPath();
                    if ('/' != streamCompletePath.charAt(0)) {
                        streamCompletePath = new File(uri.getPath()).getCanonicalPath();
                    }
                }
                catch (URISyntaxException e) {
                    streamCompletePath = new File(uri.getPath()).getCanonicalPath();
                }
                LOGGER.debug("Creating new ExternalStreamLocation: " + protocol.getSchema() + host.getName() + "@" + streamCompletePath);
                loc = DataLocation.createLocation(ProtocolType.EXTERNAL_STREAM_URI, host, streamCompletePath);
                break;
            }
            case PERSISTENT_URI: {
                String id = uri.getPath();
                LOGGER.debug("Creating new PersistentLocation: " + id);
                loc = new PersistentLocation(id);
                break;
            }
            case BINDING_URI: {
                LOGGER.debug("Creating Binding URI from path");
                BindingObject bo = BindingObject.generate(uri.getPath());
                LOGGER.debug("Creating new BindingObjectLocation: " + protocol.getSchema() + host.getName() + "@" + bo);
                loc = new BindingObjectLocation(host, bo);
                break;
            }
            case ANY_URI: {
                LOGGER.debug("Creating new AnyLocation: " + ProtocolType.ANY_URI.getSchema() + host.getName() + "@" + uri.getPath());
                loc = DataLocation.createLocation(ProtocolType.ANY_URI, host, uri.getPath());
            }
        }
        return loc;
    }

    private static DataLocation createLocation(ProtocolType protocol, Resource host, String path) {
        String diskName = SharedDiskManager.getSharedName(host, path);
        if (diskName != null) {
            String mountpoint = SharedDiskManager.getMounpoint(host, diskName);
            SharedLocation sharLoc = new SharedLocation(protocol, diskName, path.substring(mountpoint.length()));
            return sharLoc;
        }
        PrivateLocation privLoc = new PrivateLocation(protocol, host, path);
        return privLoc;
    }

    public abstract LocationType getType();

    public abstract ProtocolType getProtocol();

    public abstract List<MultiURI> getURIs();

    public abstract String getSharedDisk();

    public abstract List<Resource> getHosts();

    public abstract String getPath();

    public abstract void modifyPath(String var1);

    public abstract MultiURI getURIInHost(Resource var1);

    public abstract boolean isTarget(DataLocation var1);

    public abstract String getLocationKey();
}

