/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.types.request.td;

import es.bsc.compss.components.impl.TaskScheduler;
import es.bsc.compss.types.request.exceptions.ShutdownException;
import es.bsc.compss.types.request.td.TDRequest;
import es.bsc.compss.types.request.td.TDRequestType;
import es.bsc.compss.util.JobDispatcher;
import es.bsc.compss.util.ResourceManager;
import java.util.concurrent.Semaphore;

public class ShutdownRequest
extends TDRequest {
    private final Semaphore semaphore;

    public ShutdownRequest(Semaphore sem) {
        this.semaphore = sem;
    }

    public Semaphore getSemaphore() {
        return this.semaphore;
    }

    @Override
    public void process(TaskScheduler ts) throws ShutdownException {
        LOGGER.debug("Processing ShutdownRequest request...");
        JobDispatcher.shutdown();
        ts.shutdown();
        ResourceManager.stopNodes();
        throw new ShutdownException(this.semaphore);
    }

    @Override
    public TDRequestType getType() {
        return TDRequestType.TD_SHUTDOWN;
    }
}

