/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.types.allocatableactions;

import es.bsc.compss.api.TaskMonitor;
import es.bsc.compss.comm.Comm;
import es.bsc.compss.components.impl.ResourceScheduler;
import es.bsc.compss.components.impl.TaskProducer;
import es.bsc.compss.scheduler.exceptions.BlockedActionException;
import es.bsc.compss.scheduler.exceptions.FailedActionException;
import es.bsc.compss.scheduler.exceptions.UnassignedActionException;
import es.bsc.compss.scheduler.types.ActionOrchestrator;
import es.bsc.compss.scheduler.types.AllocatableAction;
import es.bsc.compss.scheduler.types.SchedulingInformation;
import es.bsc.compss.scheduler.types.Score;
import es.bsc.compss.types.AbstractTask;
import es.bsc.compss.types.CommutativeGroupTask;
import es.bsc.compss.types.CoreElement;
import es.bsc.compss.types.Task;
import es.bsc.compss.types.TaskDescription;
import es.bsc.compss.types.TaskGroup;
import es.bsc.compss.types.TaskState;
import es.bsc.compss.types.annotations.parameter.DataType;
import es.bsc.compss.types.annotations.parameter.Direction;
import es.bsc.compss.types.annotations.parameter.OnFailure;
import es.bsc.compss.types.data.DataAccessId;
import es.bsc.compss.types.data.DataInstanceId;
import es.bsc.compss.types.data.LogicalData;
import es.bsc.compss.types.data.Transferable;
import es.bsc.compss.types.data.accessid.RAccessId;
import es.bsc.compss.types.data.accessid.RWAccessId;
import es.bsc.compss.types.data.accessid.WAccessId;
import es.bsc.compss.types.data.listener.EventListener;
import es.bsc.compss.types.data.location.DataLocation;
import es.bsc.compss.types.data.location.ProtocolType;
import es.bsc.compss.types.data.operation.JobTransfersListener;
import es.bsc.compss.types.implementations.Implementation;
import es.bsc.compss.types.job.Job;
import es.bsc.compss.types.job.JobEndStatus;
import es.bsc.compss.types.job.JobHistory;
import es.bsc.compss.types.job.JobStatusListener;
import es.bsc.compss.types.parameter.CollectionParameter;
import es.bsc.compss.types.parameter.DependencyParameter;
import es.bsc.compss.types.parameter.Parameter;
import es.bsc.compss.types.resources.Worker;
import es.bsc.compss.types.resources.WorkerResourceDescription;
import es.bsc.compss.types.uri.SimpleURI;
import es.bsc.compss.util.ErrorManager;
import es.bsc.compss.util.JobDispatcher;
import es.bsc.compss.worker.COMPSsException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ExecutionAction
extends AllocatableAction {
    private static final int TRANSFER_CHANCES = 2;
    private static final int SUBMISSION_CHANCES = 2;
    private static final int SCHEDULING_CHANCES = 2;
    private static final Logger JOB_LOGGER = LogManager.getLogger("es.bsc.compss.Components.TaskDispatcher.JobManager");
    protected final TaskProducer producer;
    protected final Task task;
    private final LinkedList<Integer> jobs;
    private int transferErrors = 0;
    protected int executionErrors = 0;
    private Job<?> currentJob;
    boolean cancelledBeforeSubmit = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExecutionAction(SchedulingInformation schedulingInformation, ActionOrchestrator orchestrator, TaskProducer producer, Task task) {
        super(schedulingInformation, orchestrator);
        this.producer = producer;
        this.task = task;
        this.jobs = new LinkedList();
        this.transferErrors = 0;
        this.executionErrors = 0;
        this.task.addExecution(this);
        Task task2 = this.task;
        synchronized (task2) {
            List<AbstractTask> predecessors = this.task.getPredecessors();
            for (AbstractTask predecessor : predecessors) {
                if (!(predecessor instanceof CommutativeGroupTask)) {
                    for (AllocatableAction e : predecessor.getExecutions()) {
                        if (e == null || !e.isPending()) continue;
                        this.addDataPredecessor(e);
                    }
                    continue;
                }
                LOGGER.debug("Task has a commutative group as a predecessor");
                for (Task t : ((CommutativeGroupTask)predecessor).getCommutativeTasks()) {
                    for (AllocatableAction com : t.getExecutions()) {
                        if (com.getDataPredecessors().contains(this)) continue;
                        this.addDataPredecessor(com);
                    }
                }
            }
        }
        task2 = this.task;
        synchronized (task2) {
            for (AbstractTask predecessor : this.task.getStreamProducers()) {
                for (AllocatableAction e : ((Task)predecessor).getExecutions()) {
                    if (e == null || !e.isPending()) continue;
                    this.addStreamProducer(e);
                }
            }
        }
        Task resourceConstraintTask = this.task.getEnforcingTask();
        if (resourceConstraintTask != null) {
            for (AllocatableAction e : resourceConstraintTask.getExecutions()) {
                this.addResourceConstraint((ExecutionAction)e);
            }
        }
    }

    public final Task getTask() {
        return this.task;
    }

    @Override
    public boolean isToReserveResources() {
        return true;
    }

    @Override
    public boolean isToReleaseResources() {
        return true;
    }

    @Override
    public boolean isToStopResource() {
        return false;
    }

    @Override
    protected void doAction() {
        JOB_LOGGER.info("Ordering transfers to " + this.getAssignedResource() + " to run task: " + this.task.getId());
        this.transferErrors = 0;
        this.executionErrors = 0;
        TaskMonitor monitor = this.task.getTaskMonitor();
        monitor.onSubmission();
        this.doInputTransfers();
        for (CommutativeGroupTask com : this.getTask().getCommutativeGroupList()) {
            com.taskBeingExecuted(this.getTask().getId());
        }
    }

    @Override
    public boolean taskIsReadyForExecution() {
        return this.task.canBeExecuted();
    }

    @Override
    public boolean checkIfCanceled(AllocatableAction aa) {
        return aa instanceof ExecutionAction && ((ExecutionAction)aa).getTask().getStatus() == TaskState.CANCELED;
    }

    private void doInputTransfers() {
        JobTransfersListener listener = new JobTransfersListener(this);
        this.transferInputData(listener);
        listener.enable();
    }

    private void transferInputData(JobTransfersListener listener) {
        TaskDescription taskDescription = this.task.getTaskDescription();
        for (Parameter p : taskDescription.getParameters()) {
            if (DEBUG) {
                JOB_LOGGER.debug("    * " + p);
            }
            if (!(p instanceof DependencyParameter)) continue;
            DependencyParameter dp = (DependencyParameter)p;
            switch (taskDescription.getType()) {
                case METHOD: {
                    this.transferJobData(dp, listener);
                    break;
                }
                case SERVICE: {
                    if (dp.getDirection() == Direction.INOUT) break;
                    this.transferJobData(dp, listener);
                }
            }
        }
    }

    private void transferJobData(DependencyParameter param, JobTransfersListener listener) {
        switch (param.getType()) {
            case COLLECTION_T: {
                CollectionParameter cp = (CollectionParameter)param;
                JOB_LOGGER.debug("Detected CollectionParameter " + cp);
                for (Parameter p : cp.getParameters()) {
                    DependencyParameter dp = (DependencyParameter)p;
                    this.transferJobData(dp, listener);
                }
                this.transferSingleParameter(param, listener);
                break;
            }
            case STREAM_T: 
            case EXTERNAL_STREAM_T: {
                this.transferStreamParameter(param, listener);
                break;
            }
            default: {
                this.transferSingleParameter(param, listener);
            }
        }
    }

    private void transferSingleParameter(DependencyParameter param, JobTransfersListener listener) {
        Worker<? extends WorkerResourceDescription> w = this.getAssignedResource().getResource();
        DataAccessId access = param.getDataAccessId();
        if (access instanceof WAccessId) {
            String dataTarget = w.getOutputDataTargetPath(((WAccessId)access).getWrittenDataInstance().getRenaming(), param);
            param.setDataTarget(dataTarget);
        } else if (access instanceof RAccessId) {
            listener.addOperation();
            String srcName = ((RAccessId)access).getReadDataInstance().getRenaming();
            w.getData(srcName, srcName, (Transferable)param, (EventListener)listener);
        } else {
            listener.addOperation();
            String srcName = ((RWAccessId)access).getReadDataInstance().getRenaming();
            String tgtName = ((RWAccessId)access).getWrittenDataInstance().getRenaming();
            LogicalData tmpData = Comm.registerData("tmp" + tgtName);
            w.getData(srcName, tgtName, tmpData, (Transferable)param, (EventListener)listener);
        }
    }

    private void transferStreamParameter(DependencyParameter param, JobTransfersListener listener) {
        String target;
        String source;
        DataAccessId access = param.getDataAccessId();
        if (access instanceof WAccessId) {
            WAccessId wAccess = (WAccessId)access;
            target = source = wAccess.getWrittenDataInstance().getRenaming();
        } else if (access instanceof RAccessId) {
            RAccessId rAccess = (RAccessId)access;
            target = source = rAccess.getReadDataInstance().getRenaming();
        } else {
            RWAccessId rwAccess = (RWAccessId)access;
            source = rwAccess.getReadDataInstance().getRenaming();
            target = rwAccess.getWrittenDataInstance().getRenaming();
        }
        Worker<? extends WorkerResourceDescription> w = this.getAssignedResource().getResource();
        if (DEBUG) {
            JOB_LOGGER.debug("Requesting stream transfer from " + source + " to " + target + " at " + w.getName());
        }
        listener.addOperation();
        w.getData(source, target, (Transferable)param, (EventListener)listener);
    }

    public final void failedTransfers(int failedtransfers) {
        JOB_LOGGER.debug("Received a notification for the transfers for task " + this.task.getId() + " with state FAILED");
        ++this.transferErrors;
        if (this.transferErrors < 2 && this.task.getOnFailure() == OnFailure.RETRY) {
            JOB_LOGGER.debug("Resubmitting input files for task " + this.task.getId() + " to host " + this.getAssignedResource().getName() + " since " + failedtransfers + " transfers failed.");
            this.doInputTransfers();
        } else {
            ErrorManager.warn("Transfers for running task " + this.task.getId() + " on worker " + this.getAssignedResource().getName() + " have failed.");
            this.notifyError();
            this.removeJobTempData();
        }
    }

    public final void doSubmit(int transferGroupId) {
        JOB_LOGGER.debug("Received a notification for the transfers of task " + this.task.getId() + " with state DONE");
        JobStatusListener listener = new JobStatusListener(this);
        Job<?> job = this.submitJob(transferGroupId, listener);
        if (!this.cancelledBeforeSubmit) {
            this.jobs.add(job.getJobId());
            JOB_LOGGER.info((this.getExecutingResources().size() > 1 ? "Rescheduled" : "New") + " Job " + job.getJobId() + " (Task: " + this.task.getId() + ")");
            JOB_LOGGER.info("  * Method name: " + this.task.getTaskDescription().getName());
            JOB_LOGGER.info("  * Target host: " + this.getAssignedResource().getName());
            this.profile.start();
            JobDispatcher.dispatch(job);
            JOB_LOGGER.info("Submitted Task: " + this.task.getId() + " Job: " + job.getJobId() + " Method: " + this.task.getTaskDescription().getName() + " Resource: " + this.getAssignedResource().getName());
        } else {
            JOB_LOGGER.info("Job" + job.getJobId() + " cancelled before submission.");
        }
    }

    private void removeJobTempData() {
        TaskDescription taskDescription = this.task.getTaskDescription();
        for (Parameter p : taskDescription.getParameters()) {
            if (DEBUG) {
                JOB_LOGGER.debug("    * " + p);
            }
            if (!(p instanceof DependencyParameter)) continue;
            DependencyParameter dp = (DependencyParameter)p;
            switch (taskDescription.getType()) {
                case METHOD: {
                    this.removeTmpData(dp);
                    break;
                }
                case SERVICE: {
                    if (dp.getDirection() == Direction.INOUT) break;
                    this.removeTmpData(dp);
                }
            }
        }
    }

    private void removeTmpData(DependencyParameter param) {
        if (param.getType() != DataType.STREAM_T && param.getType() != DataType.EXTERNAL_STREAM_T) {
            DataAccessId access;
            if (param.getType() == DataType.COLLECTION_T) {
                CollectionParameter cp = (CollectionParameter)param;
                JOB_LOGGER.debug("Detected CollectionParameter " + cp);
                for (Parameter p : cp.getParameters()) {
                    DependencyParameter dp = (DependencyParameter)p;
                    this.removeTmpData(dp);
                }
            }
            if ((access = param.getDataAccessId()) instanceof RWAccessId) {
                String tgtName = "tmp" + ((RWAccessId)access).getWrittenDataInstance().getRenaming();
                Comm.removeDataKeepingValue(tgtName);
            }
        }
    }

    protected Job<?> submitJob(int transferGroupId, JobStatusListener listener) {
        if (DEBUG) {
            LOGGER.debug(this.toString() + " starts job creation");
        }
        Worker<? extends WorkerResourceDescription> w = this.getAssignedResource().getResource();
        ArrayList<String> slaveNames = new ArrayList<String>();
        Job<?> job = w.newJob(this.task.getId(), this.task.getTaskDescription(), this.getAssignedImplementation(), slaveNames, listener);
        this.currentJob = job;
        job.setTransferGroupId(transferGroupId);
        job.setHistory(JobHistory.NEW);
        return job;
    }

    @Override
    protected void stopAction() throws Exception {
        if (DEBUG) {
            LOGGER.debug("Task " + this.task.getId() + " starts cancelling running job");
        }
        if (this.currentJob != null) {
            this.currentJob.cancelJob();
            this.doOutputTransfers(this.currentJob);
        } else {
            this.cancelledBeforeSubmit = true;
        }
    }

    public final void exceptionJob(Job<?> job, COMPSsException e) {
        this.profile.end();
        int jobId = job.getJobId();
        JOB_LOGGER.error("Received an exception notification for job " + jobId);
        if (e instanceof COMPSsException && this.task.hasTaskGroups()) {
            for (TaskGroup t : this.task.getTaskGroupList()) {
                t.setException(e);
            }
        }
        this.removeJobTempData();
        this.doOutputTransfers(job);
        this.notifyException(e);
    }

    public final void failedJob(Job<?> job, JobEndStatus endStatus) {
        this.profile.end();
        this.removeJobTempData();
        if (this.isCancelling()) {
            JOB_LOGGER.debug("Received a notification for cancelled job " + job.getJobId());
            this.doOutputTransfers(job);
            this.notifyError();
        } else {
            int jobId = job.getJobId();
            JOB_LOGGER.error("Received a notification for job " + jobId + " with state FAILED");
            ++this.executionErrors;
            if (this.transferErrors + this.executionErrors < 2 && this.task.getOnFailure() == OnFailure.RETRY) {
                JOB_LOGGER.error("Job " + job.getJobId() + " for running task " + this.task.getId() + " on worker " + this.getAssignedResource().getName() + " has failed; resubmitting task to the same worker.");
                ErrorManager.warn("Job " + job.getJobId() + " for running task " + this.task.getId() + " on worker " + this.getAssignedResource().getName() + " has failed; resubmitting task to the same worker.");
                job.setHistory(JobHistory.RESUBMITTED);
                this.profile.start();
                JobDispatcher.dispatch(job);
            } else {
                if (this.task.getOnFailure() == OnFailure.IGNORE) {
                    this.doOutputTransfers(job);
                }
                this.notifyError();
            }
        }
    }

    public final void completedJob(Job<?> job) {
        this.profile.end();
        this.removeJobTempData();
        int jobId = job.getJobId();
        JOB_LOGGER.info("Received a notification for job " + jobId + " with state OK (avg. duration: " + this.profile.getAverageExecutionTime() + ")");
        this.doOutputTransfers(job);
        this.notifyCompleted();
    }

    private final void doOutputTransfers(Job<?> job) {
        switch (job.getType()) {
            case METHOD: {
                this.doMethodOutputTransfers(job);
                break;
            }
            case SERVICE: {
                this.doServiceOutputTransfers(job);
            }
        }
    }

    private final void doMethodOutputTransfers(Job<?> job) {
        Worker<? extends WorkerResourceDescription> w = this.getAssignedResource().getResource();
        TaskMonitor monitor = this.task.getTaskMonitor();
        List<Parameter> params = job.getTaskParams().getParameters();
        for (int i = 0; i < params.size(); ++i) {
            Parameter p = params.get(i);
            String dataName = this.getOuputRename(p);
            if (dataName == null) continue;
            DataLocation outLoc = this.storeOutputParameter(job, w, dataName, (DependencyParameter)p);
            monitor.valueGenerated(i, p.getName(), p.getType(), dataName, outLoc);
        }
    }

    private String getOuputRename(Parameter p) {
        String name = null;
        if (p instanceof DependencyParameter) {
            DependencyParameter dp = (DependencyParameter)p;
            DataInstanceId dId = null;
            switch (p.getDirection()) {
                case CONCURRENT: 
                case IN: {
                    return null;
                }
                case OUT: {
                    dId = ((WAccessId)dp.getDataAccessId()).getWrittenDataInstance();
                    break;
                }
                case COMMUTATIVE: {
                    CommutativeGroupTask cgt = this.getTask().getCommutativeGroup(((DependencyParameter)p).getDataAccessId().getDataId());
                    cgt.getCommutativeTasks().remove(this.getTask());
                    cgt.nextVersion();
                    dId = ((RWAccessId)dp.getDataAccessId()).getWrittenDataInstance();
                    break;
                }
                case INOUT: {
                    dId = ((RWAccessId)dp.getDataAccessId()).getWrittenDataInstance();
                    Comm.removeDataKeepingValue("tmp" + dId);
                }
            }
            name = dId.getRenaming();
        }
        return name;
    }

    private final DataLocation storeOutputParameter(Job<?> job, Worker<? extends WorkerResourceDescription> w, String dataName, DependencyParameter p) {
        String targetProtocol;
        DependencyParameter dp = p;
        switch (dp.getType()) {
            case FILE_T: {
                targetProtocol = ProtocolType.FILE_URI.getSchema();
                break;
            }
            case OBJECT_T: {
                targetProtocol = ProtocolType.OBJECT_URI.getSchema();
                break;
            }
            case STREAM_T: 
            case EXTERNAL_STREAM_T: {
                return null;
            }
            case COLLECTION_T: {
                targetProtocol = ProtocolType.OBJECT_URI.getSchema();
                CollectionParameter cp = (CollectionParameter)p;
                for (Parameter elem : cp.getParameters()) {
                    String elemOutRename = this.getOuputRename(elem);
                    if (elemOutRename == null) continue;
                    this.storeOutputParameter(job, w, elemOutRename, (DependencyParameter)elem);
                }
                break;
            }
            case PSCO_T: {
                targetProtocol = ProtocolType.PERSISTENT_URI.getSchema();
                break;
            }
            case EXTERNAL_PSCO_T: {
                targetProtocol = ProtocolType.PERSISTENT_URI.getSchema();
                break;
            }
            case BINDING_OBJECT_T: {
                targetProtocol = ProtocolType.BINDING_URI.getSchema();
                break;
            }
            default: {
                targetProtocol = ProtocolType.ANY_URI.getSchema();
            }
        }
        DataLocation outLoc = null;
        try {
            String dataTarget = dp.getType().equals((Object)DataType.PSCO_T) || dp.getType().equals((Object)DataType.EXTERNAL_PSCO_T) ? dp.getDataTarget() : w.getOutputDataTargetPath(dataName, dp);
            if (DEBUG) {
                JOB_LOGGER.debug("Proposed URI for storing output param: " + targetProtocol + dataTarget);
            }
            SimpleURI targetURI = new SimpleURI(targetProtocol + dataTarget);
            outLoc = DataLocation.createLocation(w, targetURI);
        }
        catch (Exception e) {
            ErrorManager.error("ERROR: Invalid location URI " + dp.getDataTarget(), e);
        }
        Comm.registerLocation(dataName, outLoc);
        return outLoc;
    }

    private final void doServiceOutputTransfers(Job<?> job) {
        TaskMonitor monitor = this.task.getTaskMonitor();
        List<Parameter> params = job.getTaskParams().getParameters();
        block4: for (int i = params.size() - 1; i >= 0; --i) {
            Parameter p = params.get(i);
            if (!(p instanceof DependencyParameter)) continue;
            DataInstanceId dId = null;
            DependencyParameter dp = (DependencyParameter)p;
            switch (p.getDirection()) {
                case CONCURRENT: 
                case IN: 
                case COMMUTATIVE: 
                case INOUT: {
                    continue block4;
                }
                case OUT: {
                    dId = ((WAccessId)dp.getDataAccessId()).getWrittenDataInstance();
                }
                default: {
                    String name = dId.getRenaming();
                    Object value = job.getReturnValue();
                    LogicalData ld = Comm.registerValue(name, value);
                    Set<DataLocation> locations = ld.getLocations();
                    if (!locations.isEmpty()) {
                        for (DataLocation loc : ld.getLocations()) {
                            if (loc == null) continue;
                            monitor.valueGenerated(i, p.getName(), p.getType(), name, loc);
                        }
                    }
                    return;
                }
            }
        }
    }

    @Override
    protected void doCompleted() {
        this.getAssignedResource().profiledExecution(this.getAssignedImplementation(), this.profile);
        TaskMonitor monitor = this.task.getTaskMonitor();
        monitor.onSuccesfulExecution();
        for (CommutativeGroupTask com : this.getTask().getCommutativeGroupList()) {
            com.taskEndedExecution();
        }
        this.task.decreaseExecutionCount();
        this.task.setStatus(TaskState.FINISHED);
        this.producer.notifyTaskEnd(this.task);
    }

    @Override
    protected void doError() throws FailedActionException {
        TaskMonitor monitor = this.task.getTaskMonitor();
        monitor.onErrorExecution();
        if (this.task.getOnFailure() == OnFailure.RETRY) {
            if (this.getExecutingResources().size() >= 2) {
                LOGGER.warn("Task " + this.task.getId() + " has already been rescheduled; notifying task failure.");
                ErrorManager.warn("Task " + this.task.getId() + " has already been rescheduled; notifying task failure.");
                throw new FailedActionException();
            }
        } else {
            LOGGER.warn("Notifying task " + this.task.getId() + " failure");
            ErrorManager.warn("Notifying task " + this.task.getId() + " failure. " + this.generateJobFileCheckMessage());
            throw new FailedActionException();
        }
        ErrorManager.warn("Task " + this.task.getId() + " execution on worker " + this.getAssignedResource().getName() + " has failed; rescheduling task execution. (changing worker)");
        LOGGER.warn("Task " + this.task.getId() + " execution on worker " + this.getAssignedResource().getName() + " has failed; rescheduling task execution. (changing worker)");
    }

    @Override
    protected void doAbort() {
        TaskMonitor monitor = this.task.getTaskMonitor();
        monitor.onAbortedExecution();
    }

    @Override
    protected void doFailed() {
        String taskName = this.task.getTaskDescription().getName();
        StringBuilder sb = new StringBuilder();
        sb.append("Task '").append(taskName).append("' TOTALLY FAILED.\n");
        sb.append("Possible causes:\n");
        sb.append("     -Exception thrown by task '").append(taskName).append("'.\n");
        sb.append("     -Expected output files not generated by task '").append(taskName).append("'.\n");
        sb.append("     -Could not provide nor retrieve needed data between master and worker.\n");
        sb.append("\n");
        sb.append(this.generateJobFileCheckMessage());
        sb.append(" \n");
        ErrorManager.warn(sb.toString());
        TaskMonitor monitor = this.task.getTaskMonitor();
        monitor.onFailedExecution();
        this.task.decreaseExecutionCount();
        this.task.setStatus(TaskState.FAILED);
        this.producer.notifyTaskEnd(this.task);
    }

    private String generateJobFileCheckMessage() {
        StringBuilder sb = new StringBuilder();
        sb.append("Check files '").append(Comm.getAppHost().getJobsDirPath());
        if (this.jobs.size() > 1) {
            sb.append("job[");
        } else {
            sb.append("job");
        }
        Iterator j = this.jobs.iterator();
        while (j.hasNext()) {
            sb.append(j.next());
            if (!j.hasNext()) break;
            sb.append("|");
        }
        if (this.jobs.size() > 1) {
            sb.append("]_*' to find out the error.\n");
        } else {
            sb.append("_*' to find out the error.\n");
        }
        return sb.toString();
    }

    @Override
    protected void doException(COMPSsException e) {
        LinkedList<TaskGroup> taskGroups = this.task.getTaskGroupList();
        for (TaskGroup group2 : taskGroups) {
            if (group2.getName().equals("App" + this.task.getAppId())) continue;
            group2.setException(e);
            for (Task t : group2.getTasks()) {
                if (t.getId() == this.getTask().getId()) continue;
                for (AllocatableAction aa : t.getExecutions()) {
                    if (aa == null || !aa.isPending()) continue;
                    this.addGroupMember(aa);
                }
            }
        }
        String taskName = this.task.getTaskDescription().getName();
        StringBuilder sb = new StringBuilder();
        sb.append("COMPSs Exception raised : Task ").append(taskName).append(" has raised an exception with message ").append(e.getMessage()).append(". Members of the containing groups will be cancelled.\n");
        sb.append("\n");
        ErrorManager.warn(sb.toString());
        TaskMonitor monitor = this.task.getTaskMonitor();
        monitor.onException();
        this.task.decreaseExecutionCount();
        this.task.setStatus(TaskState.FINISHED);
        this.producer.notifyTaskEnd(this.task);
    }

    @Override
    protected void doCanceled() {
        String taskName = this.task.getTaskDescription().getName();
        ErrorManager.warn("Task " + taskName + " has been cancelled.");
        this.task.decreaseExecutionCount();
        this.task.setStatus(TaskState.CANCELED);
        this.producer.notifyTaskEnd(this.task);
    }

    @Override
    protected void doFailIgnored() {
        String taskName = this.task.getTaskDescription().getName();
        StringBuilder sb = new StringBuilder();
        sb.append("Task failure: Task ").append(taskName).append(" has failed. Successors keep running.\n");
        sb.append("\n");
        ErrorManager.warn(sb.toString());
        TaskMonitor monitor = this.task.getTaskMonitor();
        monitor.onFailedExecution();
        this.task.decreaseExecutionCount();
        this.task.setStatus(TaskState.FINISHED);
        this.producer.notifyTaskEnd(this.task);
    }

    @Override
    public final List<ResourceScheduler<? extends WorkerResourceDescription>> getCompatibleWorkers() {
        return this.getCoreElementExecutors(this.task.getTaskDescription().getCoreElement().getCoreId());
    }

    @Override
    public final Implementation[] getImplementations() {
        CoreElement ce = this.task.getTaskDescription().getCoreElement();
        List<Implementation> coreImpls = ce.getImplementations();
        int coreImplsSize = coreImpls.size();
        Implementation[] impls = new Implementation[coreImplsSize];
        for (int i = 0; i < coreImplsSize; ++i) {
            impls[i] = coreImpls.get(i);
        }
        return impls;
    }

    @Override
    public <W extends WorkerResourceDescription> boolean isCompatible(Worker<W> r) {
        return r.canRun(this.task.getTaskDescription().getCoreElement().getCoreId());
    }

    @Override
    public final <T extends WorkerResourceDescription> List<Implementation> getCompatibleImplementations(ResourceScheduler<T> r) {
        return r.getExecutableImpls(this.task.getTaskDescription().getCoreElement().getCoreId());
    }

    @Override
    public final Integer getCoreId() {
        return this.task.getTaskDescription().getCoreElement().getCoreId();
    }

    @Override
    public final int getPriority() {
        return this.task.getTaskDescription().hasPriority() ? 1 : 0;
    }

    @Override
    public long getGroupPriority() {
        return Long.MAX_VALUE;
    }

    @Override
    public OnFailure getOnFailure() {
        return this.task.getOnFailure();
    }

    @Override
    public final <T extends WorkerResourceDescription> Score schedulingScore(ResourceScheduler<T> targetWorker, Score actionScore) {
        Score computedScore = targetWorker.generateResourceScore(this, this.task.getTaskDescription(), actionScore);
        return computedScore;
    }

    @Override
    public final List<ResourceScheduler<?>> tryToSchedule(Score actionScore, Set<ResourceScheduler<?>> availableResources) throws BlockedActionException, UnassignedActionException {
        LinkedList<ResourceScheduler<? extends WorkerResourceDescription>> candidates = new LinkedList<ResourceScheduler<? extends WorkerResourceDescription>>();
        LinkedList uselessWorkers = new LinkedList();
        if (this.isTargetResourceEnforced()) {
            candidates.add(this.getEnforcedTargetResource());
        } else if (this.isSchedulingConstrained()) {
            for (AllocatableAction a : this.getConstrainingPredecessors()) {
                candidates.add(a.getAssignedResource());
            }
        } else {
            List<ResourceScheduler<? extends WorkerResourceDescription>> compatibleCandidates = this.getCompatibleWorkers();
            if (compatibleCandidates.size() == 0) {
                throw new BlockedActionException();
            }
            for (ResourceScheduler<?> currentWorker : availableResources) {
                if (currentWorker.getResource().canRunSomething()) {
                    if (!compatibleCandidates.contains(currentWorker)) continue;
                    candidates.add(currentWorker);
                    continue;
                }
                uselessWorkers.add(currentWorker);
            }
            if (candidates.size() == 0) {
                throw new UnassignedActionException();
            }
        }
        Collections.shuffle(candidates);
        this.schedule(actionScore, candidates);
        return uselessWorkers;
    }

    @Override
    public final void schedule(Score actionScore) throws BlockedActionException, UnassignedActionException {
        LinkedList<ResourceScheduler<? extends WorkerResourceDescription>> candidates = new LinkedList<ResourceScheduler<? extends WorkerResourceDescription>>();
        if (this.isTargetResourceEnforced()) {
            candidates.add(this.getEnforcedTargetResource());
        } else if (this.isSchedulingConstrained()) {
            for (AllocatableAction a : this.getConstrainingPredecessors()) {
                candidates.add(a.getAssignedResource());
            }
        } else {
            candidates = this.getCompatibleWorkers();
        }
        this.schedule(actionScore, candidates);
    }

    private <T extends WorkerResourceDescription> void schedule(Score actionScore, List<ResourceScheduler<? extends WorkerResourceDescription>> candidates) throws BlockedActionException, UnassignedActionException {
        StringBuilder debugString = new StringBuilder("Scheduling " + this + " execution:\n");
        ResourceScheduler<? extends WorkerResourceDescription> bestWorker = null;
        Implementation bestImpl = null;
        Score bestScore = null;
        int usefulResources = 0;
        for (ResourceScheduler<? extends WorkerResourceDescription> worker : candidates) {
            if (this.getExecutingResources().contains(worker)) {
                if (DEBUG) {
                    LOGGER.debug("Task " + this.task.getId() + " already ran on worker " + worker.getName());
                }
                if (candidates.size() > 1) continue;
                LOGGER.debug("No more candidate resources for task " + this.task.getId() + ". Trying to use worker " + worker.getName() + " again ... ");
            }
            Score resourceScore = worker.generateResourceScore(this, this.task.getTaskDescription(), actionScore);
            ++usefulResources;
            if (resourceScore == null) continue;
            for (Implementation impl : this.getCompatibleImplementations(worker)) {
                Score implScore = worker.generateImplementationScore(this, this.task.getTaskDescription(), impl, resourceScore);
                if (DEBUG) {
                    debugString.append(" Resource ").append(worker.getName()).append(" ").append(" Implementation ").append(impl.getImplementationId()).append(" ").append(" Score ").append(implScore).append("\n");
                }
                if (!Score.isBetter(implScore, bestScore)) continue;
                bestWorker = worker;
                bestImpl = impl;
                bestScore = implScore;
            }
        }
        if (DEBUG) {
            LOGGER.debug(debugString.toString());
        }
        if (bestWorker == null) {
            if (usefulResources == 0) {
                LOGGER.warn("No worker can run " + this);
                throw new BlockedActionException();
            }
            throw new UnassignedActionException();
        }
        this.schedule(bestWorker, bestImpl);
    }

    @Override
    public final <T extends WorkerResourceDescription> void schedule(ResourceScheduler<T> targetWorker, Score actionScore) throws BlockedActionException, UnassignedActionException {
        if (targetWorker == null || !targetWorker.getResource().canRun(this.task.getTaskDescription().getCoreElement().getCoreId()) || this.getExecutingResources().contains(targetWorker)) {
            String message = "Worker " + (targetWorker == null ? "null" : targetWorker.getName()) + " has not available resources to run " + this;
            LOGGER.warn(message);
            throw new UnassignedActionException();
        }
        Implementation bestImpl = null;
        Score bestScore = null;
        Score resourceScore = targetWorker.generateResourceScore(this, this.task.getTaskDescription(), actionScore);
        for (Implementation impl : this.getCompatibleImplementations(targetWorker)) {
            Score implScore = targetWorker.generateImplementationScore(this, this.task.getTaskDescription(), impl, resourceScore);
            if (!Score.isBetter(implScore, bestScore)) continue;
            bestImpl = impl;
            bestScore = implScore;
        }
        this.schedule(targetWorker, bestImpl);
    }

    @Override
    public final <T extends WorkerResourceDescription> void schedule(ResourceScheduler<T> targetWorker, Implementation impl) throws BlockedActionException, UnassignedActionException {
        if (targetWorker == null || impl == null) {
            throw new UnassignedActionException();
        }
        if (DEBUG) {
            LOGGER.debug("Scheduling " + this + " on worker " + (targetWorker == null ? "null" : targetWorker.getName()) + " with implementation " + (impl == null ? "null" : impl.getImplementationId()));
        }
        if (!targetWorker.getResource().canRun(impl) || this.getExecutingResources().contains(targetWorker)) {
            LOGGER.debug("Worker " + targetWorker.getName() + " has not available resources to run " + this);
            throw new UnassignedActionException();
        }
        LOGGER.info("Assigning action " + this + " to worker " + targetWorker.getName() + " with implementation " + impl.getImplementationId());
        this.assignImplementation(impl);
        this.assignResource(targetWorker);
        targetWorker.scheduleAction(this);
        TaskMonitor monitor = this.task.getTaskMonitor();
        monitor.onSchedule();
    }

    @Override
    public String toString() {
        return "ExecutionAction ( Task " + this.task.getId() + ", CE name " + this.task.getTaskDescription().getName() + ")";
    }

    @Override
    protected void treatDependencyFreeAction(List<AllocatableAction> freeTasks) {
        for (CommutativeGroupTask cgt : this.getTask().getCommutativeGroupList()) {
            for (Task t : cgt.getCommutativeTasks()) {
                if (t.getStatus() != TaskState.TO_EXECUTE) continue;
                for (AllocatableAction aa : t.getExecutions()) {
                    if (aa.hasDataPredecessors() || freeTasks.contains(aa)) continue;
                    freeTasks.add(aa);
                }
            }
        }
    }
}

