/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.types.resources;

import es.bsc.compss.comm.Comm;
import es.bsc.compss.exceptions.InitNodeException;
import es.bsc.compss.exceptions.UnstartedNodeException;
import es.bsc.compss.types.BindingObject;
import es.bsc.compss.types.COMPSsNode;
import es.bsc.compss.types.TaskDescription;
import es.bsc.compss.types.annotations.parameter.DataType;
import es.bsc.compss.types.data.LogicalData;
import es.bsc.compss.types.data.Transferable;
import es.bsc.compss.types.data.listener.EventListener;
import es.bsc.compss.types.data.listener.SafeCopyListener;
import es.bsc.compss.types.data.listener.TracingCopyListener;
import es.bsc.compss.types.data.listener.WorkersDebugInformationListener;
import es.bsc.compss.types.data.location.DataLocation;
import es.bsc.compss.types.data.location.LocationType;
import es.bsc.compss.types.data.location.ProtocolType;
import es.bsc.compss.types.data.transferable.SafeCopyTransferable;
import es.bsc.compss.types.data.transferable.TracingCopyTransferable;
import es.bsc.compss.types.data.transferable.WorkersDebugInfoCopyTransferable;
import es.bsc.compss.types.implementations.Implementation;
import es.bsc.compss.types.job.Job;
import es.bsc.compss.types.job.JobListener;
import es.bsc.compss.types.parameter.DependencyParameter;
import es.bsc.compss.types.resources.ExecutorShutdownListener;
import es.bsc.compss.types.resources.Resource;
import es.bsc.compss.types.resources.ResourceType;
import es.bsc.compss.types.resources.ResourcesPool;
import es.bsc.compss.types.resources.ShutdownListener;
import es.bsc.compss.types.resources.configuration.Configuration;
import es.bsc.compss.types.uri.MultiURI;
import es.bsc.compss.types.uri.SimpleURI;
import es.bsc.compss.util.ErrorManager;
import es.bsc.compss.util.SharedDiskManager;
import es.bsc.compss.util.Tracer;
import java.io.File;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Semaphore;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class ResourceImpl
implements Comparable<Resource>,
Resource {
    protected static final Logger LOGGER = LogManager.getLogger("es.bsc.compss.Communication");
    public static final boolean DEBUG = LOGGER.isDebugEnabled();
    protected final String name;
    private final COMPSsNode node;
    protected Map<String, String> sharedDisks;
    private final List<LogicalData> obsoletes = new LinkedList<LogicalData>();
    private final Set<LogicalData> privateFiles = new HashSet<LogicalData>();

    public ResourceImpl(String name, Configuration conf, Map<String, String> sharedDisks) {
        this.name = name;
        this.node = Comm.initWorker(conf);
        this.sharedDisks = sharedDisks;
        SharedDiskManager.addMachine(this);
        ResourcesPool.add(this);
    }

    public ResourceImpl(COMPSsNode node, Map<String, String> sharedDisks) {
        this.name = node.getName();
        this.node = node;
        this.sharedDisks = sharedDisks;
        SharedDiskManager.addMachine(this);
        ResourcesPool.add(this);
    }

    public ResourceImpl(ResourceImpl clone) {
        this.name = clone.name;
        this.node = clone.node;
        ResourcesPool.add(this);
    }

    @Override
    public void start() throws InitNodeException {
        this.node.start();
        if (this.sharedDisks != null) {
            for (Map.Entry<String, String> disk : this.sharedDisks.entrySet()) {
                SharedDiskManager.addSharedToMachine(disk.getKey(), disk.getValue(), this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<LogicalData> getAllDataFromHost() {
        HashSet<LogicalData> data = new HashSet<LogicalData>();
        List<String> sharedDisks = SharedDiskManager.getAllSharedNames(this);
        for (String diskName : sharedDisks) {
            Set<LogicalData> sharedData = SharedDiskManager.getAllSharedFiles(diskName);
            if (sharedData == null) continue;
            Set<LogicalData> set = sharedData;
            synchronized (set) {
                data.addAll(sharedData);
            }
        }
        Set<LogicalData> set = this.privateFiles;
        synchronized (set) {
            data.addAll(this.privateFiles);
        }
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addLogicalData(LogicalData ld) {
        Set<LogicalData> set = this.privateFiles;
        synchronized (set) {
            this.privateFiles.add(ld);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeLogicalData(LogicalData ld) {
        Set<LogicalData> set = this.privateFiles;
        synchronized (set) {
            this.privateFiles.remove(ld);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void addObsolete(LogicalData obsolete) {
        if (this.getType() == ResourceType.WORKER) {
            List<LogicalData> list = this.obsoletes;
            synchronized (list) {
                this.obsoletes.add(obsolete);
            }
        }
        this.removeLogicalData(obsolete);
        List<String> sharedDisks = SharedDiskManager.getAllSharedNames(this);
        for (String diskName : sharedDisks) {
            SharedDiskManager.removeLogicalData(diskName, obsolete);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final List<MultiURI> pollObsoletes() {
        LogicalData[] obs = null;
        List<LogicalData> list = this.obsoletes;
        synchronized (list) {
            obs = this.obsoletes.toArray(new LogicalData[this.obsoletes.size()]);
            this.obsoletes.clear();
        }
        LinkedList<MultiURI> obsoleteRenamings = new LinkedList<MultiURI>();
        if (obs != null) {
            for (LogicalData ld : obs) {
                for (MultiURI u : ld.getURIsInHost(this)) {
                    if (u == null) continue;
                    obsoleteRenamings.add(u);
                }
            }
        }
        return obsoleteRenamings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void clearObsoletes() {
        List<LogicalData> list = this.obsoletes;
        synchronized (list) {
            this.obsoletes.clear();
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public COMPSsNode getNode() {
        return this.node;
    }

    @Override
    public void setInternalURI(MultiURI u) throws UnstartedNodeException {
        this.node.setInternalURI(u);
    }

    @Override
    public Job<?> newJob(int taskId, TaskDescription taskParams, Implementation impl, List<String> slaveWorkersNodeNames, JobListener listener) {
        return this.node.newJob(taskId, taskParams, impl, this, slaveWorkersNodeNames, listener);
    }

    @Override
    public void getData(String dataId, String tgtDataId, Transferable reason, EventListener listener) {
        LogicalData srcData = Comm.getData(dataId);
        LogicalData tgtData = null;
        if (tgtDataId != null) {
            tgtData = Comm.getData(tgtDataId);
        }
        this.getData(srcData, dataId, tgtData, reason, listener);
    }

    @Override
    public void getData(LogicalData ld, LogicalData tgtData, Transferable reason, EventListener listener) {
        this.getData(ld, ld.getName(), tgtData, reason, listener);
    }

    @Override
    public void getData(String dataId, String newName, String tgtDataId, Transferable reason, EventListener listener) {
        LogicalData srcData = Comm.getData(dataId);
        LogicalData tgtData = Comm.getData(tgtDataId);
        this.getData(srcData, newName, tgtData, reason, listener);
    }

    @Override
    public void getData(String dataId, String newName, LogicalData tgtData, Transferable reason, EventListener listener) {
        LogicalData ld = Comm.getData(dataId);
        this.getData(ld, newName, tgtData, reason, listener);
    }

    @Override
    public void getData(LogicalData ld, String newName, LogicalData tgtData, Transferable reason, EventListener listener) {
        if (reason.getType() == DataType.BINDING_OBJECT_T) {
            BindingObject bo;
            if (ld.getValue() == null) {
                LOGGER.warn("[Resource] Getting data: " + newName + ", source logical data value is null. Trying with data target from reason ");
                bo = BindingObject.generate(reason.getDataTarget());
                newName = newName + "#" + bo.getType() + "#" + bo.getElements();
            } else {
                bo = BindingObject.generate((String)ld.getValue());
                newName = newName + "#" + bo.getType() + "#" + bo.getElements();
            }
        }
        SimpleURI workingPath = this.node.getCompletePath(reason.getType(), newName);
        DataLocation target = null;
        try {
            target = DataLocation.createLocation(this, workingPath);
        }
        catch (Exception e) {
            ErrorManager.error("ERROR: Invalid location URI " + workingPath.toString(), e);
        }
        this.getData(ld, target, tgtData, reason, listener);
    }

    @Override
    public void getData(String dataId, DataLocation target, Transferable reason, EventListener listener) {
        LogicalData srcData = Comm.getData(dataId);
        this.getData(srcData, target, srcData, reason, listener);
    }

    @Override
    public void getData(String dataId, DataLocation target, String tgtDataId, Transferable reason, EventListener listener) {
        LogicalData srcData = Comm.getData(dataId);
        LogicalData tgtData = Comm.getData(tgtDataId);
        this.getData(srcData, target, tgtData, reason, listener);
    }

    @Override
    public void getData(String dataId, DataLocation target, LogicalData tgtData, Transferable reason, EventListener listener) {
        LogicalData ld = Comm.getData(dataId);
        this.getData(ld, target, tgtData, reason, listener);
    }

    @Override
    public void getData(LogicalData srcData, DataLocation target, LogicalData tgtData, Transferable reason, EventListener listener) {
        this.node.obtainData(srcData, null, target, tgtData, reason, listener);
    }

    @Override
    public void enforceDataObtaning(Transferable t, EventListener listener) {
        this.node.enforceDataObtaining(t, listener);
    }

    @Override
    public SimpleURI getCompleteRemotePath(DataType type, String name) {
        return this.node.getCompletePath(type, name);
    }

    public String getOutputDataTargetPath(String tgtName, DependencyParameter param) {
        return this.node.getOutputDataTarget(tgtName, param);
    }

    @Override
    public void retrieveUniqueDataValues() {
        COMPSsNode masterNode = Comm.getAppHost().getNode();
        if (this.getNode().compareTo(masterNode) == 0) {
            if (DEBUG) {
                LOGGER.debug("The resource is part of the master process. No need to retrieve any data value.");
            }
            return;
        }
        if (DEBUG) {
            LOGGER.debug("Retrieving data resource " + this.getName());
        }
        Semaphore sem = new Semaphore(0);
        SafeCopyListener listener = new SafeCopyListener(sem);
        Set<LogicalData> lds = this.getAllDataFromHost();
        Map<String, String> disks = SharedDiskManager.terminate(this);
        for (LogicalData ld : lds) {
            if (ld.getCopiesInProgress().size() > 0) {
                ld.notifyToInProgressCopiesEnd(listener);
            }
            ld.lockHostRemoval();
            DataLocation lastLoc = ld.removeHostAndCheckLocationToSave(this, disks);
            ld.releaseHostRemoval();
            if (lastLoc == null) continue;
            listener.addOperation();
            DataLocation safeLoc = null;
            String safePath = null;
            boolean isBindingData = false;
            if (lastLoc.getType().equals((Object)LocationType.BINDING)) {
                BindingObject bo = BindingObject.generate(lastLoc.getPath());
                safePath = ProtocolType.BINDING_URI.getSchema() + Comm.getAppHost().getTempDirPath() + ld.getName() + "#" + bo.getType() + "#" + bo.getElements();
            } else {
                safePath = ProtocolType.FILE_URI.getSchema() + Comm.getAppHost().getTempDirPath() + ld.getName();
            }
            try {
                SimpleURI uri = new SimpleURI(safePath);
                safeLoc = DataLocation.createLocation(Comm.getAppHost(), uri);
            }
            catch (Exception e) {
                ErrorManager.error("ERROR: Invalid location URI " + safePath, e);
            }
            if (isBindingData) {
                masterNode.obtainData(ld, lastLoc, safeLoc, ld, new SafeCopyTransferable(DataType.BINDING_OBJECT_T), listener);
                continue;
            }
            masterNode.obtainData(ld, lastLoc, safeLoc, ld, new SafeCopyTransferable(), listener);
        }
        if (DEBUG) {
            LOGGER.debug("Waiting for finishing saving copies for " + this.getName());
        }
        if (listener.getOperations() > 0) {
            listener.enable();
            try {
                sem.acquire();
            }
            catch (InterruptedException ex) {
                LOGGER.error("Error waiting for files in resource " + this.getName() + " to get saved");
            }
        }
        if (DEBUG) {
            LOGGER.debug("Unique files saved for " + this.getName());
        }
    }

    @Override
    public void retrieveTracingAndDebugData() {
        if ((Tracer.extraeEnabled() || Tracer.scorepEnabled() || Tracer.mapEnabled()) && this.node.generatePackage()) {
            this.getTracingPackageToMaster();
            if (DEBUG) {
                LOGGER.debug("Tracing package obtained for " + this.getName());
            }
        }
        if (DEBUG && this.node.generateWorkersDebugInfo()) {
            this.getWorkersDebugInfo();
            LOGGER.debug("Workers Debug files obtained for " + this.getName());
        }
    }

    @Override
    public void deleteIntermediate() {
        this.node.deleteTemporary();
    }

    @Override
    public void disableExecution() {
        if (DEBUG) {
            LOGGER.debug("Shutting down Execution Manager on Resource " + this.getName());
        }
        Semaphore sem = new Semaphore(0);
        ExecutorShutdownListener executorShutdownListener = new ExecutorShutdownListener(sem);
        executorShutdownListener.addOperation();
        this.node.shutdownExecutionManager(executorShutdownListener);
        executorShutdownListener.enable();
        if (DEBUG) {
            LOGGER.debug("Waiting for shutting down the execution manager of " + this.getName());
        }
        try {
            sem.acquire();
        }
        catch (InterruptedException ex) {
            LOGGER.error("Error waiting for execution manager in resource " + this.getName() + " to stop");
        }
        if (DEBUG) {
            LOGGER.debug("Execution manager of " + this.getName() + " stopped");
        }
    }

    @Override
    public void stop(ShutdownListener sl) {
        this.deleteIntermediate();
        sl.addOperation();
        this.node.stop(sl);
    }

    private void getTracingPackageToMaster() {
        DataLocation tgt;
        DataLocation source;
        Semaphore sem = new Semaphore(0);
        String fileName = this.getName() + "_compss_trace.tar.gz";
        SimpleURI fileOriginURI = this.node.getCompletePath(DataType.FILE_T, fileName);
        if (DEBUG) {
            LOGGER.debug("Copying tracing package from : " + fileOriginURI.getPath() + ",to : " + Comm.getAppHost().getAppLogDirPath() + "trace" + File.separator + fileName);
        }
        TracingCopyListener tracingListener = new TracingCopyListener(sem);
        tracingListener.addOperation();
        try {
            source = DataLocation.createLocation(this, fileOriginURI);
        }
        catch (Exception e) {
            ErrorManager.error("ERROR: Invalid location URI " + fileOriginURI.getPath(), e);
            return;
        }
        String targetPath = ProtocolType.FILE_URI.getSchema() + Comm.getAppHost().getAppLogDirPath() + "trace" + File.separator + fileName;
        try {
            SimpleURI uri = new SimpleURI(targetPath);
            tgt = DataLocation.createLocation(Comm.getAppHost(), uri);
        }
        catch (Exception e) {
            ErrorManager.error("ERROR: Invalid location URI " + targetPath);
            return;
        }
        COMPSsNode masterNode = Comm.getAppHost().getNode();
        masterNode.obtainData(new LogicalData("tracing" + this.getName()), source, tgt, new LogicalData("tracing" + this.getName()), new TracingCopyTransferable(), tracingListener);
        tracingListener.enable();
        try {
            sem.acquire();
        }
        catch (InterruptedException ex) {
            LOGGER.error("Error waiting for tracing files in resource " + this.getName() + " to get saved");
        }
        if (DEBUG) {
            LOGGER.debug("Removing " + this.getName() + " tracing temporary files");
        }
        File f = null;
        try {
            f = new File(source.getPath());
            if (!f.delete()) {
                LOGGER.error("Unable to remove tracing temporary files of node " + this.getName());
            }
        }
        catch (Exception e) {
            LOGGER.error("Unable to remove tracing temporary files of node " + this.getName(), (Throwable)e);
        }
    }

    private void getWorkersDebugInfo() {
        if (DEBUG) {
            LOGGER.debug("Copying Workers Information");
        }
        Semaphore sem = new Semaphore(0);
        WorkersDebugInformationListener wdil = new WorkersDebugInformationListener(sem);
        wdil.addOperation();
        String outFileName = "worker_" + this.getName() + ".out";
        SimpleURI outFileOrigin = this.node.getCompletePath(DataType.FILE_T, "log" + File.separator + "static_" + outFileName);
        String outFileTarget = ProtocolType.FILE_URI.getSchema() + Comm.getAppHost().getWorkersDirPath() + File.separator + outFileName;
        DataLocation outSource = null;
        try {
            outSource = DataLocation.createLocation(this, outFileOrigin);
        }
        catch (Exception e) {
            ErrorManager.error("ERROR: Invalid location URI " + outFileOrigin.toString(), e);
        }
        DataLocation outTarget = null;
        try {
            SimpleURI uri = new SimpleURI(outFileTarget);
            outTarget = DataLocation.createLocation(Comm.getAppHost(), uri);
        }
        catch (Exception e) {
            ErrorManager.error("ERROR: Invalid location URI " + outFileTarget);
        }
        LOGGER.debug("- Source: " + outFileOrigin);
        LOGGER.debug("- Target: " + outFileTarget);
        COMPSsNode masterNode = Comm.getAppHost().getNode();
        masterNode.obtainData(new LogicalData("workerOut" + this.getName()), outSource, outTarget, new LogicalData("workerOut" + this.getName()), new WorkersDebugInfoCopyTransferable(), wdil);
        wdil.addOperation();
        String errFileName = "worker_" + this.getName() + ".err";
        SimpleURI errFileOrigin = this.node.getCompletePath(DataType.FILE_T, "log" + File.separator + "static_" + errFileName);
        String errFileTarget = ProtocolType.FILE_URI.getSchema() + Comm.getAppHost().getWorkersDirPath() + File.separator + errFileName;
        DataLocation errSource = null;
        try {
            errSource = DataLocation.createLocation(this, errFileOrigin);
        }
        catch (Exception e) {
            ErrorManager.error("ERROR: Invalid location URI " + errFileOrigin.toString(), e);
        }
        DataLocation errTarget = null;
        try {
            SimpleURI uri = new SimpleURI(errFileTarget);
            errTarget = DataLocation.createLocation(Comm.getAppHost(), uri);
        }
        catch (Exception e) {
            ErrorManager.error("ERROR: Invalid location URI " + errFileTarget);
        }
        LOGGER.debug("- Source: " + errFileOrigin);
        LOGGER.debug("- Target: " + errFileTarget);
        masterNode.obtainData(new LogicalData("workerErr" + this.getName()), errSource, errTarget, new LogicalData("workerErr" + this.getName()), new WorkersDebugInfoCopyTransferable(), wdil);
        wdil.enable();
        try {
            sem.acquire();
        }
        catch (InterruptedException ex) {
            LOGGER.error("Error waiting for worker debug files in resource " + this.getName() + " to get saved");
        }
        LOGGER.debug("Worker files from resource " + this.getName() + "received");
    }
}

