/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.invokers.util;

import es.bsc.compss.exceptions.ExternalPropertyException;
import es.bsc.compss.exceptions.InvokeExecutionException;
import es.bsc.compss.exceptions.StreamCloseException;
import es.bsc.compss.invokers.util.StdIOStream;
import es.bsc.compss.types.execution.InvocationParam;
import es.bsc.compss.util.ExternalStreamHandler;
import es.bsc.compss.util.StreamGobbler;
import es.bsc.distrostreamlib.api.DistroStream;
import es.bsc.distrostreamlib.api.files.FileDistroStream;
import es.bsc.distrostreamlib.api.objects.ObjectDistroStream;
import es.bsc.distrostreamlib.client.DistroStreamClient;
import es.bsc.distrostreamlib.requests.CloseStreamRequest;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.logging.log4j.LogManager;

public class BinaryRunner {
    private static final String ERROR_PARAM_NOT_STRING = "ERROR: Binary parameter cannot be serialized to string";
    private static final String ERROR_STREAM = "ERROR: Object and PSCO streams are not supported in non-native tasks";
    private static final String ERROR_OUTPUTREADER = "ERROR: Cannot retrieve command output";
    private static final String ERROR_ERRORREADER = "ERROR: Cannot retrieve command error";
    private static final String ERROR_PROC_EXEC = "ERROR: Exception executing Binary command";
    private static final String ERROR_EXIT_VALUE = "ERROR: Exception exit value is not 0";
    private static final String ERROR_EXT_STREAM_BASE_DIR = "ERROR: Cannot retrieve base_dir from External Stream";
    private static final String ERROR_EXT_STREAM_CLOSURE = "ERROR: Cannot close External Stream due to internal error.";
    private static final String ERROR_EXT_STREAM_GET_ID = "ERROR: Cannot close External Stream due to innvalid Id";
    private static final int PB_KILL_SIGNAL = 15;
    private Process process = null;

    public static ArrayList<String> createCMDParametersFromValues(List<? extends InvocationParam> parameters, InvocationParam target, StdIOStream streamValues, String pythonInterpreter) throws InvokeExecutionException {
        ArrayList<String> binaryParams = new ArrayList<String>();
        for (InvocationParam invocationParam : parameters) {
            binaryParams.addAll(BinaryRunner.processParam(invocationParam, streamValues, pythonInterpreter));
        }
        if (target != null) {
            binaryParams.addAll(BinaryRunner.processParam(target, streamValues, pythonInterpreter));
        }
        return binaryParams;
    }

    private static ArrayList<String> processParam(InvocationParam param, StdIOStream streamValues, String pythonInterpreter) throws InvokeExecutionException {
        ArrayList<String> binaryParamFields = new ArrayList<String>();
        switch (param.getStdIOStream()) {
            case STDIN: {
                streamValues.setStdIn((String)param.getValue());
                break;
            }
            case STDOUT: {
                streamValues.setStdOut((String)param.getValue());
                break;
            }
            case STDERR: {
                streamValues.setStdErr((String)param.getValue());
                break;
            }
            case UNSPECIFIED: {
                if (param.getPrefix().equals("#")) break;
                if (param.getValue() != null && param.getValue().getClass().isArray()) {
                    BinaryRunner.addArrayParam(param, binaryParamFields);
                    break;
                }
                if (param.getValue() != null && param.getValue() instanceof Collection) {
                    BinaryRunner.addCollectionParam(param, binaryParamFields);
                    break;
                }
                BinaryRunner.addDirectParam(param, binaryParamFields, pythonInterpreter);
            }
        }
        return binaryParamFields;
    }

    private static void addArrayParam(InvocationParam param, ArrayList<String> binaryParamFields) throws InvokeExecutionException {
        try {
            if (param.getPrefix() != null && !param.getPrefix().isEmpty() && !param.getPrefix().equals("null")) {
                binaryParamFields.add(param.getPrefix());
            }
            binaryParamFields.addAll(BinaryRunner.serializeArrayParam(param.getValue()));
        }
        catch (Exception e) {
            throw new InvokeExecutionException(ERROR_PARAM_NOT_STRING, e);
        }
    }

    private static void addCollectionParam(InvocationParam param, ArrayList<String> binaryParamFields) throws InvokeExecutionException {
        try {
            if (param.getPrefix() != null && !param.getPrefix().isEmpty() && !param.getPrefix().equals("null")) {
                binaryParamFields.add(param.getPrefix());
            }
            binaryParamFields.addAll(BinaryRunner.serializeCollectionParam((Collection)param.getValue()));
        }
        catch (Exception e) {
            throw new InvokeExecutionException(ERROR_PARAM_NOT_STRING, e);
        }
    }

    private static void addDirectParam(InvocationParam param, ArrayList<String> binaryParamFields, String pythonInterpreter) throws InvokeExecutionException {
        if (param.getPrefix() != null && !param.getPrefix().isEmpty() && !param.getPrefix().equals("null")) {
            block2 : switch (param.getType()) {
                case FILE_T: {
                    binaryParamFields.add(param.getPrefix() + param.getOriginalName());
                    break;
                }
                case COLLECTION_T: {
                    binaryParamFields.add(param.getPrefix() + String.valueOf(param.getValue()));
                    break;
                }
                case STREAM_T: {
                    DistroStream ds = (DistroStream)param.getValue();
                    switch (ds.getStreamType()) {
                        case FILE: {
                            FileDistroStream fds = (FileDistroStream)ds;
                            binaryParamFields.add(param.getPrefix() + fds.getBaseDir());
                            break block2;
                        }
                        case OBJECT: {
                            ObjectDistroStream ods = (ObjectDistroStream)ds;
                            binaryParamFields.add(param.getPrefix() + ods.getAlias());
                            break block2;
                        }
                    }
                    throw new InvokeExecutionException(ERROR_STREAM);
                }
                case EXTERNAL_STREAM_T: {
                    String serializedFile = (String)param.getValue();
                    String baseDir = null;
                    try {
                        baseDir = ExternalStreamHandler.getExternalStreamProperty(pythonInterpreter, serializedFile, "base_dir");
                    }
                    catch (ExternalPropertyException epe) {
                        throw new InvokeExecutionException(ERROR_EXT_STREAM_BASE_DIR, epe);
                    }
                    if (baseDir == null || baseDir.isEmpty()) {
                        throw new InvokeExecutionException(ERROR_EXT_STREAM_BASE_DIR);
                    }
                    binaryParamFields.add(param.getPrefix() + baseDir);
                    break;
                }
                default: {
                    binaryParamFields.add(param.getPrefix() + String.valueOf(param.getValue()));
                    break;
                }
            }
        } else {
            block12 : switch (param.getType()) {
                case FILE_T: {
                    binaryParamFields.add(param.getOriginalName());
                    break;
                }
                case COLLECTION_T: {
                    binaryParamFields.add(String.valueOf(param.getValue()));
                    break;
                }
                case STREAM_T: {
                    DistroStream ds = (DistroStream)param.getValue();
                    switch (ds.getStreamType()) {
                        case FILE: {
                            FileDistroStream fds = (FileDistroStream)ds;
                            binaryParamFields.add(fds.getBaseDir());
                            break block12;
                        }
                        case OBJECT: {
                            ObjectDistroStream ods = (ObjectDistroStream)ds;
                            binaryParamFields.add(ods.getAlias());
                            break block12;
                        }
                    }
                    throw new InvokeExecutionException(ERROR_STREAM);
                }
                case EXTERNAL_STREAM_T: {
                    String serializedFile = (String)param.getValue();
                    String baseDir = null;
                    try {
                        baseDir = ExternalStreamHandler.getExternalStreamProperty(pythonInterpreter, serializedFile, "base_dir");
                    }
                    catch (ExternalPropertyException epe) {
                        throw new InvokeExecutionException(ERROR_EXT_STREAM_BASE_DIR, epe);
                    }
                    if (baseDir == null || baseDir.isEmpty()) {
                        throw new InvokeExecutionException(ERROR_EXT_STREAM_BASE_DIR);
                    }
                    binaryParamFields.add(baseDir);
                    break;
                }
                default: {
                    binaryParamFields.add(String.valueOf(param.getValue()));
                }
            }
        }
    }

    private static ArrayList<String> serializeArrayParam(Object value) throws Exception {
        ArrayList<String> serializedValue = new ArrayList<String>();
        if (value instanceof int[]) {
            int[] arrayValues;
            for (int paramValue : arrayValues = (int[])value) {
                serializedValue.add(String.valueOf(paramValue));
            }
        } else if (value instanceof boolean[]) {
            boolean[] arrayValues;
            for (boolean paramValue : arrayValues = (boolean[])value) {
                serializedValue.add(String.valueOf(paramValue));
            }
        } else if (value instanceof byte[]) {
            byte[] arrayValues;
            for (byte paramValue : arrayValues = (byte[])value) {
                serializedValue.add(String.valueOf(paramValue));
            }
        } else if (value instanceof short[]) {
            short[] arrayValues;
            for (short paramValue : arrayValues = (short[])value) {
                serializedValue.add(String.valueOf(paramValue));
            }
        } else if (value instanceof char[]) {
            int[] arrayValues;
            for (int paramValue : arrayValues = (int[])value) {
                serializedValue.add(String.valueOf(paramValue));
            }
        } else if (value instanceof long[]) {
            long[] arrayValues;
            for (long paramValue : arrayValues = (long[])value) {
                serializedValue.add(String.valueOf(paramValue));
            }
        } else if (value instanceof float[]) {
            float[] arrayValues;
            for (float paramValue : arrayValues = (float[])value) {
                serializedValue.add(String.valueOf(paramValue));
            }
        } else if (value instanceof double[]) {
            double[] arrayValues;
            for (double paramValue : arrayValues = (double[])value) {
                serializedValue.add(String.valueOf(paramValue));
            }
        } else if (value instanceof Integer[]) {
            Integer[] arrayValues;
            for (Integer paramValue : arrayValues = (Integer[])value) {
                serializedValue.add(String.valueOf(paramValue));
            }
        } else if (value instanceof Boolean[]) {
            Boolean[] arrayValues;
            for (Boolean paramValue : arrayValues = (Boolean[])value) {
                serializedValue.add(String.valueOf(paramValue));
            }
        } else if (value instanceof Character[]) {
            Character[] arrayValues;
            for (Character paramValue : arrayValues = (Character[])value) {
                serializedValue.add(String.valueOf(paramValue));
            }
        } else if (value instanceof Byte[]) {
            Byte[] arrayValues;
            for (Byte paramValue : arrayValues = (Byte[])value) {
                serializedValue.add(String.valueOf(paramValue));
            }
        } else if (value instanceof Short[]) {
            Short[] arrayValues;
            for (Short paramValue : arrayValues = (Short[])value) {
                serializedValue.add(String.valueOf(paramValue));
            }
        } else if (value instanceof Long[]) {
            Long[] arrayValues;
            for (Long paramValue : arrayValues = (Long[])value) {
                serializedValue.add(String.valueOf(paramValue));
            }
        } else if (value instanceof Float[]) {
            Float[] arrayValues;
            for (Float paramValue : arrayValues = (Float[])value) {
                serializedValue.add(String.valueOf(paramValue));
            }
        } else if (value instanceof Double[]) {
            Double[] arrayValues;
            for (Double paramValue : arrayValues = (Double[])value) {
                serializedValue.add(String.valueOf(paramValue));
            }
        } else if (value instanceof String[]) {
            String[] arrayValues;
            for (String paramValue : arrayValues = (String[])value) {
                serializedValue.add(String.valueOf(paramValue));
            }
        } else if (value instanceof Object[]) {
            Object[] arrayValues;
            for (Object paramValue : arrayValues = (Object[])value) {
                serializedValue.addAll(BinaryRunner.serializeArrayParam(paramValue));
            }
        } else {
            serializedValue.add(String.valueOf(value));
        }
        return serializedValue;
    }

    private static ArrayList<String> serializeCollectionParam(Collection<?> value) throws Exception {
        ArrayList<String> serializedValue = new ArrayList<String>();
        Iterator<?> iterator = value.iterator();
        while (iterator.hasNext()) {
            serializedValue.add(String.valueOf(iterator.next()));
        }
        return serializedValue;
    }

    public Object executeCMD(String[] cmd, StdIOStream stdIOStreamValues, File taskSandboxWorkingDir, PrintStream outLog, PrintStream errLog, String pythonPath, boolean failByEV) throws InvokeExecutionException {
        String fileErrPath;
        String fileOutPath;
        ProcessBuilder builder = new ProcessBuilder(cmd);
        builder.directory(taskSandboxWorkingDir);
        builder.environment().remove("LD_PRELOAD");
        builder.environment().put("COMPSS_HOSTNAMES", System.getProperty("COMPSS_HOSTNAMES"));
        builder.environment().put("COMPSS_NUM_NODES", System.getProperty("COMPSS_NUM_NODES"));
        builder.environment().put("COMPSS_NUM_THREADS", System.getProperty("COMPSS_NUM_THREADS"));
        builder.environment().put("OMP_NUM_THREADS", System.getProperty("OMP_NUM_THREADS"));
        if (pythonPath != null) {
            builder.environment().put("PYTHONPATH", pythonPath);
        }
        int numNodes = Integer.parseInt(System.getProperty("COMPSS_NUM_NODES"));
        int procsPerNode = Integer.parseInt(System.getProperty("COMPSS_NUM_THREADS"));
        String uniqueHostnames = String.join((CharSequence)",", new HashSet<String>(Arrays.asList(System.getProperty("COMPSS_HOSTNAMES").split(","))));
        builder.environment().put("SLURM_NODELIST", uniqueHostnames);
        builder.environment().put("SLURM_JOB_NODELIST", uniqueHostnames);
        builder.environment().put("SLURM_NNODES", System.getProperty("COMPSS_NUM_NODES"));
        builder.environment().put("SLURM_JOB_NUM_NODES", System.getProperty("COMPSS_NUM_NODES"));
        builder.environment().put("SLURM_JOB_CPUS_PER_NODE", procsPerNode + "(x" + System.getProperty("COMPSS_NUM_NODES") + ")");
        builder.environment().put("SLURM_TASKS_PER_NODE", procsPerNode + "(x" + System.getProperty("COMPSS_NUM_NODES") + ")");
        builder.environment().put("SLURM_NPROCS", Integer.toString(procsPerNode * numNodes));
        builder.environment().put("SLURM_NTASKS", Integer.toString(procsPerNode * numNodes));
        builder.environment().remove("SLURM_MEM_PER_CPU");
        builder.environment().remove("SLURM_STEP_NUM_TASKS");
        builder.environment().remove("SLURM_STEP_TASKS_PER_NODE");
        builder.environment().remove("SLURM_STEP_NODELIST");
        builder.environment().remove("SLURM_STEP_NUM_NODES");
        builder.environment().remove("SLURM_STEP_LAUNCHER_PORT");
        builder.environment().remove("SLURM_STEP_RESV_PORTS");
        builder.environment().remove("SLURM_STEP_ID");
        builder.environment().remove("SLURM_STEPID");
        builder.environment().remove("SLURM_NODEID");
        builder.environment().remove("SLURM_LOCALID");
        builder.environment().remove("SLURM_GTIDS");
        builder.environment().remove("SLURM_CPU_BIND");
        builder.environment().remove("SLURM_CPU_BIND_LIST");
        builder.environment().remove("SLURM_CPU_BIND_TYPE");
        builder.environment().remove("SLURM_LAUNCH_NODE_IPADDR");
        builder.environment().remove("SLURM_SRUN_COMM_HOST");
        builder.environment().remove("SLURM_TASK_PID");
        builder.environment().remove("SLURM_DISTRIBUTION");
        builder.environment().remove("SLURM_PROCID");
        String fileInPath = stdIOStreamValues.getStdIn();
        if (fileInPath != null) {
            builder.redirectInput(new File(fileInPath));
        }
        if ((fileOutPath = stdIOStreamValues.getStdOut()) != null) {
            builder.redirectOutput(ProcessBuilder.Redirect.appendTo(new File(fileOutPath)));
        }
        if ((fileErrPath = stdIOStreamValues.getStdErr()) != null) {
            builder.redirectError(ProcessBuilder.Redirect.appendTo(new File(fileErrPath)));
        }
        int exitValue = -1;
        try {
            outLog.println("[BINARY EXECUTION WRAPPER] ------------------------------------");
            outLog.println("[BINARY EXECUTION WRAPPER] Executing binary command");
            this.process = builder.start();
            this.process.getOutputStream().close();
            this.logBinaryExecution(this.process, fileOutPath, fileErrPath, outLog, errLog);
            exitValue = this.process.waitFor();
            outLog.println("[BINARY EXECUTION WRAPPER] ------------------------------------");
            outLog.println("[BINARY EXECUTION WRAPPER] CMD EXIT VALUE: " + exitValue);
            outLog.println("[BINARY EXECUTION WRAPPER] ------------------------------------");
        }
        catch (InvokeExecutionException | IOException | InterruptedException e) {
            errLog.println(ERROR_PROC_EXEC);
            throw new InvokeExecutionException(ERROR_PROC_EXEC, e);
        }
        if (failByEV && exitValue != 0) {
            throw new InvokeExecutionException(ERROR_EXIT_VALUE);
        }
        return exitValue;
    }

    public void closeStreams(List<? extends InvocationParam> parameters, String pythonInterpreter) throws StreamCloseException {
        for (InvocationParam invocationParam : parameters) {
            if (!invocationParam.isWriteFinalValue()) continue;
            switch (invocationParam.getType()) {
                case STREAM_T: {
                    this.closeStream(invocationParam);
                    break;
                }
                case EXTERNAL_STREAM_T: {
                    this.closeExternalStream(invocationParam, pythonInterpreter);
                    break;
                }
            }
        }
    }

    public void cancelProcess() {
        if (this.process != null) {
            if (this.process.getClass().getName().equals("java.lang.UNIXProcess")) {
                try {
                    Field f = this.process.getClass().getDeclaredField("pid");
                    f.setAccessible(true);
                    int pid = f.getInt(this.process);
                    System.out.println("Killing process " + pid);
                    Runtime.getRuntime().exec("kill -15 " + pid);
                }
                catch (Throwable e) {
                    System.err.println("Error geting pid");
                }
            } else {
                this.process.destroy();
            }
        }
    }

    private void logBinaryExecution(Process process, String fileOutPath, String fileErrPath, PrintStream outLog, PrintStream errLog) throws InvokeExecutionException {
        Throwable throwable;
        Thread errorGobbler = null;
        StreamGobbler outputGobbler = null;
        outLog.println("[BINARY EXECUTION WRAPPER] ------------------------------------");
        outLog.println("[BINARY EXECUTION WRAPPER] CMD OUTPUT:");
        if (process != null) {
            if (fileOutPath == null) {
                outputGobbler = new StreamGobbler(process.getInputStream(), outLog, LogManager.getLogger("es.bsc.compss.Worker"));
                outputGobbler.start();
            } else {
                try {
                    throwable = null;
                    try (FileInputStream outputStream = new FileInputStream(fileOutPath);){
                        outputGobbler = new StreamGobbler(outputStream, outLog, LogManager.getLogger("es.bsc.compss.Worker"));
                        outputGobbler.start();
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                }
                catch (IOException ioe) {
                    errLog.println(ERROR_OUTPUTREADER);
                    ioe.printStackTrace(errLog);
                    throw new InvokeExecutionException(ERROR_OUTPUTREADER, ioe);
                }
            }
        }
        errLog.println("[BINARY EXECUTION WRAPPER] ------------------------------------");
        errLog.println("[BINARY EXECUTION WRAPPER] CMD ERROR:");
        if (process != null) {
            if (fileErrPath == null) {
                errorGobbler = new StreamGobbler(process.getErrorStream(), errLog, LogManager.getLogger("es.bsc.compss.Worker"));
                errorGobbler.start();
            } else {
                try {
                    throwable = null;
                    try (FileInputStream errStream = new FileInputStream(fileErrPath);){
                        errorGobbler = new StreamGobbler(errStream, errLog, LogManager.getLogger("es.bsc.compss.Worker"));
                        errorGobbler.start();
                    }
                    catch (Throwable throwable3) {
                        throwable = throwable3;
                        throw throwable3;
                    }
                }
                catch (IOException ioe) {
                    throw new InvokeExecutionException(ERROR_ERRORREADER, ioe);
                }
            }
        }
        if (outputGobbler != null) {
            try {
                outputGobbler.join();
            }
            catch (InterruptedException e) {
                errLog.println("Error waiting for output gobbler to end");
                e.printStackTrace();
            }
        }
        outLog.println("[BINARY EXECUTION WRAPPER] ------------------------------------");
        if (errorGobbler != null) {
            try {
                errorGobbler.join();
            }
            catch (InterruptedException e) {
                errLog.println("Error waiting for error gobbler to end");
                e.printStackTrace();
            }
        }
        errLog.println("[BINARY EXECUTION WRAPPER] ------------------------------------");
    }

    private void closeStream(InvocationParam p) {
        DistroStream ds = (DistroStream)p.getValue();
        ds.close();
    }

    private void closeExternalStream(InvocationParam p, String pythonInterpreter) throws StreamCloseException {
        String serializedFile = p.getValue().toString();
        String streamId = null;
        try {
            streamId = ExternalStreamHandler.getExternalStreamProperty(pythonInterpreter, serializedFile, "id");
        }
        catch (ExternalPropertyException epe) {
            throw new StreamCloseException(ERROR_EXT_STREAM_GET_ID);
        }
        if (streamId != null) {
            CloseStreamRequest req = new CloseStreamRequest(streamId);
            DistroStreamClient.request(req);
            req.waitProcessed();
            int error = req.getErrorCode();
            if (error != 0) {
                String internalError = "ERROR CODE = " + error + " ERROR MESSAGE = " + req.getErrorMessage();
                throw new StreamCloseException(ERROR_EXT_STREAM_CLOSURE + internalError);
            }
        } else {
            throw new StreamCloseException(ERROR_EXT_STREAM_GET_ID);
        }
    }
}

