/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.types.request.ap;

import es.bsc.compss.components.impl.AccessProcessor;
import es.bsc.compss.components.impl.DataInfoProvider;
import es.bsc.compss.components.impl.TaskAnalyser;
import es.bsc.compss.components.impl.TaskDispatcher;
import es.bsc.compss.types.Task;
import es.bsc.compss.types.TaskGroup;
import es.bsc.compss.types.request.ap.APRequest;
import es.bsc.compss.types.request.ap.APRequestType;
import es.bsc.compss.types.request.exceptions.ShutdownException;
import es.bsc.compss.types.request.listener.StaticMultioperationSemaphore;
import es.bsc.compss.worker.COMPSsException;
import java.util.List;
import java.util.concurrent.Semaphore;

public class CancelTaskGroupRequest
extends APRequest {
    private Long appId;
    private String groupName;
    private Semaphore sem;

    public CancelTaskGroupRequest(Long appId, String groupName, Semaphore sem) {
        this.appId = appId;
        this.groupName = groupName;
        this.sem = sem;
    }

    public Semaphore getSemaphore() {
        return this.sem;
    }

    @Override
    public APRequestType getRequestType() {
        return APRequestType.CANCEL_TASK_GROUP;
    }

    @Override
    public void process(AccessProcessor ap, TaskAnalyser ta, DataInfoProvider dip, TaskDispatcher td) throws ShutdownException, COMPSsException {
        LOGGER.debug("Cancelling tasks of group " + this.groupName);
        this.cancelGroup(ta, td);
    }

    protected void cancelGroup(TaskAnalyser ta, TaskDispatcher td) {
        TaskGroup tg = ta.removeTaskGroup(this.appId, this.groupName);
        if (tg != null) {
            List<Task> tasks = tg.getTasks();
            int taskCount = tasks.size();
            StaticMultioperationSemaphore listener = new StaticMultioperationSemaphore(taskCount, this.sem);
            LOGGER.debug("Cancelling " + taskCount + " tasks.");
            for (Task t : tasks) {
                td.cancelTasks(t, listener);
            }
        } else {
            this.sem.release();
        }
    }

    public Long getAppId() {
        return this.appId;
    }

    public String getGroupName() {
        return this.groupName;
    }
}

