/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.types.request.td;

import es.bsc.compss.components.impl.TaskScheduler;
import es.bsc.compss.scheduler.types.AllocatableAction;
import es.bsc.compss.types.Task;
import es.bsc.compss.types.request.exceptions.ShutdownException;
import es.bsc.compss.types.request.listener.RequestListener;
import es.bsc.compss.types.request.td.TDRequest;
import es.bsc.compss.types.request.td.TDRequestType;

public class CancelTaskRequest
extends TDRequest {
    private Task task;
    private final RequestListener listener;

    public CancelTaskRequest(Task task) {
        this.task = task;
        this.listener = null;
    }

    public CancelTaskRequest(Task task, RequestListener listener) {
        this.task = task;
        this.listener = listener;
    }

    @Override
    public TDRequestType getType() {
        return TDRequestType.CANCEL_TASKS;
    }

    @Override
    public void process(TaskScheduler ts) throws ShutdownException {
        for (AllocatableAction aa : this.task.getExecutions()) {
            aa.cancel();
        }
        if (this.listener != null) {
            this.listener.performed();
        }
    }
}

