/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.components.monitor.impl;

import es.bsc.compss.components.impl.AccessProcessor;
import es.bsc.compss.components.impl.TaskDispatcher;
import es.bsc.compss.components.monitor.impl.GraphGenerator;
import es.bsc.compss.util.ResourceManager;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RuntimeMonitor
implements Runnable {
    private static final Logger LOGGER = LogManager.getLogger("es.bsc.compss.Components");
    private static final String ERROR_GENERATING_DATA = "Error generating monitoring data";
    private static final boolean MONITOR_ENABLED = System.getProperty("compss.monitor") != null && !System.getProperty("compss.monitor").equals("0");
    private static final String MONITOR_DIR_PATH = GraphGenerator.getMonitorDirPath();
    private TaskDispatcher td;
    private AccessProcessor ap;
    private GraphGenerator gm;
    private long sleepTime;
    private boolean keepRunning;
    private boolean running;
    private Thread monitor;
    private String installDir;

    public RuntimeMonitor(AccessProcessor ap, TaskDispatcher td, GraphGenerator gm, long sleepTime) {
        this.td = td;
        this.ap = ap;
        this.gm = gm;
        this.keepRunning = true;
        this.sleepTime = sleepTime;
        this.installDir = System.getenv().get("COMPSS_HOME");
        this.monitor = new Thread(this);
        this.monitor.setName("Monitor Thread");
        this.monitor.start();
    }

    @Override
    public void run() {
        this.running = true;
        while (this.keepRunning) {
            try {
                this.getXMLTaskState();
                this.printCurrentGraph();
                this.td.printCurrentState();
                ResourceManager.printResourcesState();
                Thread.sleep(this.sleepTime);
            }
            catch (IOException ioe) {
                LOGGER.error(ERROR_GENERATING_DATA, (Throwable)ioe);
            }
            catch (InterruptedException ie) {
                LOGGER.error(ERROR_GENERATING_DATA, (Throwable)ie);
                Thread.currentThread().interrupt();
            }
        }
        this.running = false;
    }

    public void shutdown() {
        this.keepRunning = false;
        try {
            while (this.running) {
                Thread.sleep(this.sleepTime);
            }
            this.getXMLTaskState();
            this.printCurrentGraph();
        }
        catch (IOException | InterruptedException ioe) {
            LOGGER.error(ERROR_GENERATING_DATA, (Throwable)ioe);
        }
        if (!new File(MONITOR_DIR_PATH + "monitor.xml").delete()) {
            LOGGER.error("Error clearing monitor.xml execution files");
        }
    }

    private void getXMLTaskState() throws IOException {
        StringBuilder sb = new StringBuilder();
        sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>").append("\n");
        sb.append("<?xml-stylesheet type=\"text/xsl\" href=\"").append(this.installDir).append("/xml/monitor/monitor.xsl\"?>").append("\n");
        sb.append("<COMPSsState>").append("\n");
        sb.append(this.ap.getCurrentTaskState());
        sb.append(this.td.getCurrentMonitoringData());
        sb.append("</COMPSsState>");
        BufferedWriter fw = new BufferedWriter(new FileWriter(MONITOR_DIR_PATH + "COMPSs_state.xml"));
        fw.write(sb.toString());
        fw.close();
        fw = null;
    }

    private void printCurrentGraph() {
        BufferedWriter graph = this.gm.getAndOpenCurrentGraph();
        this.td.printCurrentGraph(graph);
        this.gm.closeCurrentGraph();
    }

    public static String getMonitorDirPath() {
        return MONITOR_DIR_PATH;
    }

    public static boolean isEnabled() {
        return MONITOR_ENABLED;
    }
}

