/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.types;

import es.bsc.compss.types.Barrier;
import es.bsc.compss.types.Task;
import es.bsc.compss.types.TaskGroup;
import es.bsc.compss.types.data.DataInfo;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.Stack;
import java.util.TreeMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Application {
    private static final Logger LOGGER = LogManager.getLogger("es.bsc.compss.Components.TaskProcessor");
    private static final Random APP_ID_GENERATOR = new Random();
    private static final TreeMap<Long, Application> APPLICATIONS = new TreeMap();
    private static final Application NO_APPLICATION = new Application(null, null);
    private final Long id;
    private final String parallelismSource;
    private int totalTaskCount;
    private boolean ending = false;
    private TreeMap<String, TaskGroup> taskGroups;
    private Stack<TaskGroup> currentTaskGroups;
    private LinkedList<DataInfo> data;
    private Set<Integer> writtenFileDataIds;
    private Set<Integer> writtenPSCODataIds;

    public static String getTaskStateRequest() {
        StringBuilder sb = new StringBuilder("\t").append("<TasksInfo>").append("\n");
        for (Application app : APPLICATIONS.values()) {
            Long appId = app.getId();
            Integer totalTaskCount = app.totalTaskCount;
            TaskGroup appBaseGroup = (TaskGroup)app.currentTaskGroups.firstElement();
            Integer taskCount = appBaseGroup.getTasks().size();
            int completed = totalTaskCount - taskCount;
            sb.append("\t\t").append("<Application id=\"").append(appId).append("\">").append("\n");
            sb.append("\t\t\t").append("<TotalCount>").append(totalTaskCount).append("</TotalCount>").append("\n");
            sb.append("\t\t\t").append("<InProgress>").append(taskCount).append("</InProgress>").append("\n");
            sb.append("\t\t\t").append("<Completed>").append(completed).append("</Completed>").append("\n");
            sb.append("\t\t").append("</Application>").append("\n");
        }
        sb.append("\t").append("</TasksInfo>").append("\n");
        return sb.toString();
    }

    public static Application registerApplication() {
        return Application.registerApplication((String)null);
    }

    public static Application registerApplication(String parallelismSource) {
        Long appId = APP_ID_GENERATOR.nextLong();
        while (APPLICATIONS.containsKey(appId)) {
            appId = APP_ID_GENERATOR.nextLong();
        }
        return Application.registerApplication(appId, parallelismSource);
    }

    public static Application registerApplication(Long appId) {
        return Application.registerApplication(appId, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Application registerApplication(Long appId, String parallelismSource) {
        Application app;
        if (appId == null) {
            app = NO_APPLICATION;
        } else {
            TreeMap<Long, Application> treeMap = APPLICATIONS;
            synchronized (treeMap) {
                app = APPLICATIONS.get(appId);
                if (app == null) {
                    app = new Application(appId, parallelismSource);
                    System.out.println("Registering application " + appId);
                    APPLICATIONS.put(appId, app);
                }
            }
        }
        return app;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Application deregisterApplication(Long appId) {
        Application app;
        System.out.println("Deregistered application " + appId);
        TreeMap<Long, Application> treeMap = APPLICATIONS;
        synchronized (treeMap) {
            app = APPLICATIONS.remove(appId);
        }
        return app;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeWrittenFileIdFromAllApps(int dataId) {
        TreeMap<Long, Application> treeMap = APPLICATIONS;
        synchronized (treeMap) {
            for (Application app : APPLICATIONS.values()) {
                app.removeWrittenFileId(dataId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeWrittenPSCOIdFromAllApps(int dataId) {
        TreeMap<Long, Application> treeMap = APPLICATIONS;
        synchronized (treeMap) {
            for (Application app : APPLICATIONS.values()) {
                app.removeWrittenPSCOId(dataId);
            }
        }
    }

    private Application(Long appId, String parallelismSource) {
        this.id = appId;
        this.parallelismSource = parallelismSource;
        this.totalTaskCount = 0;
        this.ending = false;
        this.currentTaskGroups = new Stack();
        this.taskGroups = new TreeMap();
        this.stackTaskGroup("App" + appId);
        this.data = new LinkedList();
        this.writtenFileDataIds = new HashSet<Integer>();
        this.writtenPSCODataIds = new HashSet<Integer>();
    }

    public long getId() {
        return this.id;
    }

    public String getParallelismSource() {
        return this.parallelismSource;
    }

    public final TaskGroup stackTaskGroup(String groupName) {
        LOGGER.debug("Adding group " + groupName + " to the current groups stack.");
        TaskGroup tg = new TaskGroup(groupName, this);
        this.currentTaskGroups.push(tg);
        this.taskGroups.put(groupName, tg);
        return tg;
    }

    public TaskGroup popGroup() {
        return this.currentTaskGroups.pop();
    }

    public Iterable<TaskGroup> getCurrentGroups() {
        return this.currentTaskGroups;
    }

    public TaskGroup getGroup(String groupName) {
        return this.taskGroups.get(groupName);
    }

    public TaskGroup removeGroup(String name) {
        return this.taskGroups.remove(name);
    }

    public void newTask(Task task) {
        ++this.totalTaskCount;
    }

    public final void reachesGroupBarrier(TaskGroup tg, Barrier request) {
        if (tg != null) {
            tg.registerBarrier(request);
        } else {
            request.release();
        }
    }

    public final void reachesBarrier(Barrier barrier) {
        TaskGroup baseGroup = (TaskGroup)this.currentTaskGroups.firstElement();
        this.reachesGroupBarrier(baseGroup, barrier);
    }

    public final void endReached(Barrier barrier) {
        this.ending = true;
        this.reachesBarrier(barrier);
    }

    public final boolean isEnding() {
        return this.ending;
    }

    public void addData(DataInfo di) {
        this.data.add(di);
    }

    public void removeData(DataInfo di) {
        this.data.remove(di);
    }

    public List<DataInfo> popAllData() {
        LinkedList<DataInfo> localData = this.data;
        this.data = new LinkedList();
        return localData;
    }

    public void addWrittenFileId(int dataId) {
        this.writtenFileDataIds.add(dataId);
    }

    public void removeWrittenFileId(int dataId) {
        if (this.writtenFileDataIds.remove(dataId)) {
            LOGGER.info(" Removed data " + dataId + " from written files");
        }
    }

    public Set<Integer> getWrittenFileIds() {
        return this.writtenFileDataIds;
    }

    public void addWrittenPSCOId(int dataId) {
        this.writtenPSCODataIds.add(dataId);
    }

    public void removeWrittenPSCOId(int dataId) {
        if (this.writtenPSCODataIds.remove(dataId)) {
            LOGGER.info(" Removed data " + dataId + " from written pscos");
        }
    }
}

