/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.types.implementations;

import es.bsc.compss.types.implementations.AbstractMethodImplementation;
import es.bsc.compss.types.implementations.MethodType;
import es.bsc.compss.types.resources.MethodResourceDescription;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class MPIImplementation
extends AbstractMethodImplementation
implements Externalizable {
    private static final long serialVersionUID = 1L;
    public static final int NUM_PARAMS = 6;
    public static final String SIGNATURE = "mpi.MPI";
    private String mpiRunner;
    private String mpiFlags;
    private String binary;
    private String workingDir;
    private boolean scaleByCU;
    private boolean failByEV;

    public MPIImplementation() {
    }

    public MPIImplementation(String binary, String workingDir, String mpiRunner, String mpiFlags, boolean scaleByCU, boolean failByEV, Integer coreId, Integer implementationId, String signature, MethodResourceDescription annot) {
        super(coreId, implementationId, signature, annot);
        this.mpiRunner = mpiRunner;
        this.mpiFlags = mpiFlags;
        this.workingDir = workingDir;
        this.binary = binary;
        this.scaleByCU = scaleByCU;
        this.failByEV = failByEV;
    }

    public String getBinary() {
        return this.binary;
    }

    public String getWorkingDir() {
        return this.workingDir;
    }

    public String getMpiRunner() {
        return this.mpiRunner;
    }

    public String getMpiFlags() {
        return this.mpiFlags;
    }

    public boolean getScaleByCU() {
        return this.scaleByCU;
    }

    public boolean isFailByEV() {
        return this.failByEV;
    }

    @Override
    public MethodType getMethodType() {
        return MethodType.MPI;
    }

    @Override
    public String getMethodDefinition() {
        StringBuilder sb = new StringBuilder();
        sb.append("[MPI RUNNER=").append(this.mpiRunner);
        sb.append(", MPI_FLAGS=").append(this.mpiFlags);
        sb.append(", BINARY=").append(this.binary);
        sb.append(", IO=").append(this.isIO());
        sb.append("]");
        return sb.toString();
    }

    @Override
    public String toString() {
        return super.toString() + " MPI Method with binary " + this.binary + " and MPIrunner " + this.mpiRunner;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.mpiRunner = (String)in.readObject();
        this.mpiFlags = (String)in.readObject();
        this.binary = (String)in.readObject();
        this.workingDir = (String)in.readObject();
        this.scaleByCU = in.readBoolean();
        this.failByEV = in.readBoolean();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeObject(this.mpiRunner);
        out.writeObject(this.mpiFlags);
        out.writeObject(this.binary);
        out.writeObject(this.workingDir);
        out.writeBoolean(this.scaleByCU);
        out.writeBoolean(this.failByEV);
    }
}

