/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.util;

import java.io.File;
import java.io.IOException;
import java.nio.file.DirectoryNotEmptyException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FileDeleter {
    private static final Logger LOGGER = LogManager.getLogger("es.bsc.compss.Communication");
    private static final ExecutorService DELETE_SERVICE = Executors.newSingleThreadExecutor();

    public static void deleteAsync(final File file) {
        if (file != null) {
            DELETE_SERVICE.execute(new Runnable(){

                @Override
                public void run() {
                    Thread.currentThread().setPriority(1);
                    FileDeleter.deleteFile(file);
                }
            });
        }
    }

    public static void deleteSync(File file) {
        FileDeleter.deleteFile(file);
    }

    public static void shutdown() {
        DELETE_SERVICE.shutdown();
    }

    private static void deleteFile(File f) {
        try {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Deleting file " + f.getAbsolutePath());
            }
            if (!Files.deleteIfExists(f.toPath())) {
                LOGGER.warn("File " + f.getAbsolutePath() + " not deleted.");
            }
        }
        catch (DirectoryNotEmptyException dne) {
            Path directory = f.toPath();
            try {
                Files.walkFileTree(directory, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult visitFile(Path file, BasicFileAttributes attributes) throws IOException {
                        Files.delete(file);
                        return FileVisitResult.CONTINUE;
                    }

                    @Override
                    public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                        Files.delete(dir);
                        return FileVisitResult.CONTINUE;
                    }
                });
            }
            catch (IOException e) {
                LOGGER.error("Cannot delete directory " + f.getAbsolutePath(), (Throwable)e);
            }
        }
        catch (Exception e) {
            LOGGER.error("Cannot delete file " + f.getAbsolutePath(), (Throwable)e);
        }
    }
}

