/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.components.impl;

import es.bsc.compss.COMPSsConstants;
import es.bsc.compss.api.TaskMonitor;
import es.bsc.compss.comm.Comm;
import es.bsc.compss.components.impl.DataInfoProvider;
import es.bsc.compss.components.impl.TaskAnalyser;
import es.bsc.compss.components.impl.TaskDispatcher;
import es.bsc.compss.components.monitor.impl.GraphGenerator;
import es.bsc.compss.exceptions.CannotLoadException;
import es.bsc.compss.types.AbstractTask;
import es.bsc.compss.types.Application;
import es.bsc.compss.types.BindingObject;
import es.bsc.compss.types.Task;
import es.bsc.compss.types.annotations.parameter.OnFailure;
import es.bsc.compss.types.data.DataAccessId;
import es.bsc.compss.types.data.DataInstanceId;
import es.bsc.compss.types.data.LogicalData;
import es.bsc.compss.types.data.ResultFile;
import es.bsc.compss.types.data.accessid.RAccessId;
import es.bsc.compss.types.data.accessid.RWAccessId;
import es.bsc.compss.types.data.accessid.WAccessId;
import es.bsc.compss.types.data.accessparams.AccessParams;
import es.bsc.compss.types.data.accessparams.BindingObjectAccessParams;
import es.bsc.compss.types.data.accessparams.FileAccessParams;
import es.bsc.compss.types.data.accessparams.ObjectAccessParams;
import es.bsc.compss.types.data.location.DataLocation;
import es.bsc.compss.types.data.location.ProtocolType;
import es.bsc.compss.types.parameter.Parameter;
import es.bsc.compss.types.request.ap.APRequest;
import es.bsc.compss.types.request.ap.AlreadyAccessedRequest;
import es.bsc.compss.types.request.ap.BarrierGroupRequest;
import es.bsc.compss.types.request.ap.BarrierRequest;
import es.bsc.compss.types.request.ap.CancelApplicationTasksRequest;
import es.bsc.compss.types.request.ap.CancelTaskGroupRequest;
import es.bsc.compss.types.request.ap.CloseTaskGroupRequest;
import es.bsc.compss.types.request.ap.DeleteAllApplicationDataRequest;
import es.bsc.compss.types.request.ap.DeleteBindingObjectRequest;
import es.bsc.compss.types.request.ap.DeleteFileRequest;
import es.bsc.compss.types.request.ap.DeregisterObject;
import es.bsc.compss.types.request.ap.EndOfAppRequest;
import es.bsc.compss.types.request.ap.FinishDataAccessRequest;
import es.bsc.compss.types.request.ap.GetLastRenamingRequest;
import es.bsc.compss.types.request.ap.GetResultFilesRequest;
import es.bsc.compss.types.request.ap.IsObjectHereRequest;
import es.bsc.compss.types.request.ap.OpenTaskGroupRequest;
import es.bsc.compss.types.request.ap.RegisterDataAccessRequest;
import es.bsc.compss.types.request.ap.RegisterRemoteFileDataRequest;
import es.bsc.compss.types.request.ap.RegisterRemoteObjectDataRequest;
import es.bsc.compss.types.request.ap.SetObjectVersionValueRequest;
import es.bsc.compss.types.request.ap.ShutdownRequest;
import es.bsc.compss.types.request.ap.TaskAnalysisRequest;
import es.bsc.compss.types.request.ap.TaskEndNotification;
import es.bsc.compss.types.request.ap.TasksStateRequest;
import es.bsc.compss.types.request.ap.TransferBindingObjectRequest;
import es.bsc.compss.types.request.ap.TransferObjectRequest;
import es.bsc.compss.types.request.ap.TransferOpenDirectoryRequest;
import es.bsc.compss.types.request.ap.TransferOpenFileRequest;
import es.bsc.compss.types.request.ap.TransferRawFileRequest;
import es.bsc.compss.types.request.ap.UnblockResultFilesRequest;
import es.bsc.compss.types.request.ap.WaitForConcurrentRequest;
import es.bsc.compss.types.request.ap.WaitForDataReadyToDeleteRequest;
import es.bsc.compss.types.request.ap.WaitForTaskRequest;
import es.bsc.compss.types.request.exceptions.ShutdownException;
import es.bsc.compss.types.uri.SimpleURI;
import es.bsc.compss.util.ErrorManager;
import es.bsc.compss.util.Tracer;
import es.bsc.compss.worker.COMPSsException;
import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.Semaphore;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AccessProcessor
implements Runnable {
    private static final Logger LOGGER = LogManager.getLogger("es.bsc.compss.Components.TaskProcessor");
    private static final boolean DEBUG = LOGGER.isDebugEnabled();
    private static final String ERROR_OBJECT_LOAD_FROM_STORAGE = "ERROR: Cannot load object from storage (file or PSCO)";
    private static final String ERROR_QUEUE_OFFER = "ERROR: AccessProcessor queue offer error on ";
    protected TaskDispatcher taskDispatcher;
    protected TaskAnalyser taskAnalyser;
    protected DataInfoProvider dataInfoProvider;
    private static Thread processor;
    private static boolean keepGoing;
    protected LinkedBlockingQueue<APRequest> requestQueue;

    public AccessProcessor(TaskDispatcher td) {
        this.taskDispatcher = td;
        this.taskAnalyser = new TaskAnalyser();
        this.dataInfoProvider = new DataInfoProvider();
        this.taskAnalyser.setCoWorkers(this.dataInfoProvider);
        this.requestQueue = new LinkedBlockingQueue();
        keepGoing = true;
        processor = new Thread(this);
        processor.setName("Access Processor");
        if (Tracer.basicModeEnabled()) {
            Tracer.enablePThreads();
        }
        processor.start();
        if (Tracer.basicModeEnabled()) {
            Tracer.disablePThreads();
        }
    }

    public void setGM(GraphGenerator gm) {
        this.taskAnalyser.setGM(gm);
    }

    @Override
    public void run() {
        while (keepGoing) {
            APRequest request = null;
            try {
                request = this.requestQueue.take();
                if (Tracer.extraeEnabled()) {
                    Tracer.emitEvent(Tracer.getAcessProcessorRequestEvent(request.getRequestType().name()).getId(), Tracer.getRuntimeEventsType());
                }
                request.process(this, this.taskAnalyser, this.dataInfoProvider, this.taskDispatcher);
                if (!Tracer.extraeEnabled()) continue;
                Tracer.emitEvent(0L, Tracer.getRuntimeEventsType());
            }
            catch (ShutdownException se) {
                if (Tracer.extraeEnabled()) {
                    Tracer.emitEvent(0L, Tracer.getRuntimeEventsType());
                }
                se.getSemaphore().release();
                break;
            }
            catch (Exception e) {
                ErrorManager.error("Exception", e);
                if (!Tracer.extraeEnabled()) continue;
                Tracer.emitEvent(0L, Tracer.getRuntimeEventsType());
            }
        }
        LOGGER.info("AccessProcessor shutdown");
    }

    public int newTask(Application app, TaskMonitor monitor, COMPSsConstants.Lang lang, String signature, boolean isPrioritary, int numNodes, boolean isReplicated, boolean isDistributed, boolean hasTarget, int numReturns, List<Parameter> parameters, OnFailure onFailure, long timeOut) {
        Task currentTask = new Task(app, lang, signature, isPrioritary, numNodes, isReplicated, isDistributed, hasTarget, numReturns, parameters, monitor, onFailure, timeOut);
        TaskMonitor registeredMonitor = currentTask.getTaskMonitor();
        registeredMonitor.onCreation();
        LOGGER.debug("Requesting analysis of Task " + currentTask.getId());
        if (!this.requestQueue.offer(new TaskAnalysisRequest(currentTask))) {
            ErrorManager.error("ERROR: AccessProcessor queue offer error on new method task");
        }
        return currentTask.getId();
    }

    public int newTask(Application app, TaskMonitor monitor, String namespace, String service, String port, String operation, boolean priority, boolean hasTarget, int numReturns, List<Parameter> parameters, OnFailure onFailure, long timeOut) {
        Task currentTask = new Task(app, namespace, service, port, operation, priority, hasTarget, numReturns, parameters, monitor, onFailure, timeOut);
        TaskMonitor registeredMonitor = currentTask.getTaskMonitor();
        registeredMonitor.onCreation();
        LOGGER.debug("Requesting analysis of new service Task " + currentTask.getId());
        if (!this.requestQueue.offer(new TaskAnalysisRequest(currentTask))) {
            ErrorManager.error("ERROR: AccessProcessor queue offer error on new service task");
        }
        return currentTask.getId();
    }

    public void notifyTaskEnd(AbstractTask task) {
        if (!this.requestQueue.offer(new TaskEndNotification(task))) {
            ErrorManager.error("ERROR: AccessProcessor queue offer error on notify task end");
        }
    }

    public void finishAccessToFile(DataLocation sourceLocation, FileAccessParams fap, String destDir) {
        boolean alreadyAccessed = this.alreadyAccessed(fap.getApp(), sourceLocation);
        if (!alreadyAccessed) {
            LOGGER.debug("File not accessed before. Nothing to do");
            return;
        }
        this.finishDataAccess(fap);
    }

    private void finishDataAccess(AccessParams fap) {
        if (!this.requestQueue.offer(new FinishDataAccessRequest(fap))) {
            ErrorManager.error("ERROR: AccessProcessor queue offer error on finishing data access");
        }
    }

    public DataLocation mainAccessToFile(Application app, DataLocation sourceLocation, FileAccessParams fap, String destDir) {
        SimpleURI uri;
        String path;
        String rename;
        DataInstanceId daId;
        DataAccessId ra;
        boolean alreadyAccessed = this.alreadyAccessed(app, sourceLocation);
        if (!alreadyAccessed) {
            LOGGER.debug("File not accessed before, returning the same location");
            return sourceLocation;
        }
        DataAccessId faId = this.registerDataAccess(fap);
        DataLocation tgtLocation = sourceLocation;
        if (fap.getMode() != AccessParams.AccessMode.W) {
            LOGGER.debug("File " + faId.getDataId() + " mode contains R, waiting until the last writer has finished");
            this.waitForTask(faId.getDataId(), AccessParams.AccessMode.R);
            if (this.taskAnalyser.dataWasAccessedConcurrent(faId.getDataId())) {
                this.waitForConcurrent(faId.getDataId(), fap.getMode());
                this.taskAnalyser.removeFromConcurrentAccess(faId.getDataId());
            }
            if (destDir == null) {
                tgtLocation = this.transferFileOpen(faId);
            } else {
                if (fap.getMode() == AccessParams.AccessMode.R) {
                    ra = (RAccessId)faId;
                    daId = ((RAccessId)ra).getReadDataInstance();
                } else {
                    ra = (RWAccessId)faId;
                    daId = ((RWAccessId)ra).getReadDataInstance();
                }
                rename = daId.getRenaming();
                path = ProtocolType.FILE_URI.getSchema() + destDir + rename;
                try {
                    uri = new SimpleURI(path);
                    tgtLocation = DataLocation.createLocation(Comm.getAppHost(), uri);
                }
                catch (Exception e) {
                    ErrorManager.error("ERROR: Invalid location URI " + path, e);
                }
                this.transferFileRaw(faId, tgtLocation);
            }
        }
        if (fap.getMode() != AccessParams.AccessMode.R && fap.getMode() != AccessParams.AccessMode.C) {
            LOGGER.debug("File " + faId.getDataId() + " mode contains W, register new writer");
            if (fap.getMode() == AccessParams.AccessMode.RW || fap.getMode() == AccessParams.AccessMode.CV) {
                ra = (RWAccessId)faId;
                daId = ((RWAccessId)ra).getWrittenDataInstance();
            } else {
                ra = (WAccessId)faId;
                daId = ((WAccessId)ra).getWrittenDataInstance();
            }
            rename = daId.getRenaming();
            path = ProtocolType.FILE_URI.getSchema() + Comm.getAppHost().getTempDirPath() + rename;
            try {
                uri = new SimpleURI(path);
                tgtLocation = DataLocation.createLocation(Comm.getAppHost(), uri);
            }
            catch (Exception e) {
                ErrorManager.error("ERROR: Invalid location URI " + path, e);
            }
            Comm.registerLocation(rename, tgtLocation);
        }
        if (DEBUG) {
            LOGGER.debug("File " + faId.getDataId() + " located on " + tgtLocation.toString());
        }
        return tgtLocation;
    }

    public DataLocation mainAccessToDirectory(Application app, DataLocation sourceLocation, FileAccessParams fap, String destDir) {
        boolean alreadyAccessed = this.alreadyAccessed(app, sourceLocation);
        if (!alreadyAccessed) {
            LOGGER.debug("Directory not accessed before, returning the same location");
            return sourceLocation;
        }
        DataAccessId faId = this.registerDataAccess(fap);
        DataLocation tgtLocation = sourceLocation;
        if (fap.getMode() != AccessParams.AccessMode.W) {
            LOGGER.debug("Directory " + faId.getDataId() + " mode contains R, waiting until the last writer has finished");
            this.waitForTask(faId.getDataId(), AccessParams.AccessMode.R);
            if (this.taskAnalyser.dataWasAccessedConcurrent(faId.getDataId())) {
                this.waitForConcurrent(faId.getDataId(), fap.getMode());
                this.taskAnalyser.removeFromConcurrentAccess(faId.getDataId());
            }
            tgtLocation = this.transferDirectoryOpen(faId);
        }
        if (fap.getMode() != AccessParams.AccessMode.R && fap.getMode() != AccessParams.AccessMode.C) {
            DataInstanceId daId;
            DataAccessId ra;
            LOGGER.debug("File " + faId.getDataId() + " mode contains W, register new writer");
            if (fap.getMode() == AccessParams.AccessMode.RW || fap.getMode() == AccessParams.AccessMode.CV) {
                ra = (RWAccessId)faId;
                daId = ((RWAccessId)ra).getWrittenDataInstance();
            } else {
                ra = (WAccessId)faId;
                daId = ((WAccessId)ra).getWrittenDataInstance();
            }
            String rename = daId.getRenaming();
            String path = ProtocolType.DIR_URI.getSchema() + Comm.getAppHost().getTempDirPath() + rename;
            try {
                SimpleURI uri = new SimpleURI(path);
                tgtLocation = DataLocation.createLocation(Comm.getAppHost(), uri);
            }
            catch (Exception e) {
                ErrorManager.error("ERROR: Invalid location URI " + path, e);
            }
            Comm.registerLocation(rename, tgtLocation);
        }
        if (DEBUG) {
            LOGGER.debug("Directory " + faId.getDataId() + " located on " + tgtLocation.toString());
        }
        return tgtLocation;
    }

    public boolean isCurrentRegisterValueValid(int hashCode) {
        LOGGER.debug("Checking if value of object with hashcode " + hashCode + " is valid");
        Semaphore sem = new Semaphore(0);
        IsObjectHereRequest request = new IsObjectHereRequest(hashCode, sem);
        if (!this.requestQueue.offer(request)) {
            ErrorManager.error("ERROR: AccessProcessor queue offer error on valid object value");
        }
        sem.acquireUninterruptibly();
        boolean isValid = request.getResponse();
        if (DEBUG) {
            if (isValid) {
                LOGGER.debug("Value of object with hashcode " + hashCode + " is valid");
            } else {
                LOGGER.debug("Value of object with hashcode " + hashCode + " is NOT valid");
            }
        }
        return isValid;
    }

    public Object mainAccessToObject(Application app, Object obj, int hashCode) {
        if (DEBUG) {
            LOGGER.debug("Requesting main access to object with hash code " + hashCode);
        }
        ObjectAccessParams oap = new ObjectAccessParams(app, AccessParams.AccessMode.RW, obj, hashCode);
        DataAccessId oaId = this.registerDataAccess(oap);
        DataInstanceId wId = ((RWAccessId)oaId).getWrittenDataInstance();
        String wRename = wId.getRenaming();
        if (DEBUG) {
            LOGGER.debug("Waiting for last writer of " + oaId.getDataId() + " with renaming " + wRename);
        }
        this.waitForTask(oaId.getDataId(), AccessParams.AccessMode.RW);
        if (this.taskAnalyser.dataWasAccessedConcurrent(oaId.getDataId())) {
            this.waitForConcurrent(oaId.getDataId(), AccessParams.AccessMode.RW);
            if (oaId.getDirection() != DataAccessId.Direction.R || oaId.getDirection() != DataAccessId.Direction.RW) {
                this.taskAnalyser.removeFromConcurrentAccess(oaId.getDataId());
            }
        }
        if (DEBUG) {
            LOGGER.debug("Request object transfer " + oaId.getDataId() + " with renaming " + wRename);
        }
        Object oUpdated = this.obtainObject(oaId);
        if (DEBUG) {
            LOGGER.debug("Object retrieved. Set new version to: " + wRename);
        }
        this.setObjectVersionValue(wRename, oUpdated);
        this.finishDataAccess(oap);
        return oUpdated;
    }

    public String mainAccessToExternalPSCO(Application app, String id, int hashCode) {
        if (DEBUG) {
            LOGGER.debug("Requesting main access to external object with hash code " + hashCode);
        }
        ObjectAccessParams oap = new ObjectAccessParams(app, AccessParams.AccessMode.RW, id, hashCode);
        DataAccessId oaId = this.registerDataAccess(oap);
        DataInstanceId wId = ((RWAccessId)oaId).getWrittenDataInstance();
        String wRename = wId.getRenaming();
        if (DEBUG) {
            LOGGER.debug("Waiting for last writer of " + oaId.getDataId() + " with renaming " + wRename);
        }
        this.waitForTask(oaId.getDataId(), AccessParams.AccessMode.RW);
        if (this.taskAnalyser.dataWasAccessedConcurrent(oaId.getDataId())) {
            this.waitForConcurrent(oaId.getDataId(), AccessParams.AccessMode.RW);
            if (oaId.getDirection() != DataAccessId.Direction.R || oaId.getDirection() != DataAccessId.Direction.RW) {
                this.taskAnalyser.removeFromConcurrentAccess(oaId.getDataId());
            }
        }
        String lastRenaming = ((RWAccessId)oaId).getReadDataInstance().getRenaming();
        String newId = Comm.getData(lastRenaming).getPscoId();
        return ProtocolType.PERSISTENT_URI.getSchema() + newId;
    }

    private String obtainBindingObject(RAccessId oaId) {
        LOGGER.debug("[AccessProcessor] Obtaining binding object with id " + oaId);
        Semaphore sem = new Semaphore(0);
        TransferBindingObjectRequest tor = new TransferBindingObjectRequest(oaId, sem);
        if (!this.requestQueue.offer(tor)) {
            ErrorManager.error("ERROR: AccessProcessor queue offer error on obtain object");
        }
        sem.acquireUninterruptibly();
        BindingObject bo = BindingObject.generate(tor.getTargetName());
        return bo.getName();
    }

    public String mainAccessToBindingObject(Application app, BindingObject bo, int hashCode) {
        if (DEBUG) {
            LOGGER.debug("Requesting main access to binding object with bo " + bo.toString() + " and hash code " + hashCode);
        }
        BindingObjectAccessParams oap = new BindingObjectAccessParams(app, AccessParams.AccessMode.R, bo, hashCode);
        DataAccessId oaId = this.registerDataAccess(oap);
        if (DEBUG) {
            LOGGER.debug("Waiting for last writer of " + oaId.getDataId());
        }
        this.waitForTask(oaId.getDataId(), AccessParams.AccessMode.R);
        if (this.taskAnalyser.dataWasAccessedConcurrent(oaId.getDataId())) {
            this.waitForConcurrent(oaId.getDataId(), AccessParams.AccessMode.R);
            if (oaId.getDirection() != DataAccessId.Direction.R || oaId.getDirection() != DataAccessId.Direction.RW) {
                this.taskAnalyser.removeFromConcurrentAccess(oaId.getDataId());
            }
        }
        String bindingObjectID = this.obtainBindingObject((RAccessId)oaId);
        this.finishDataAccess(oap);
        return bindingObjectID;
    }

    public void noMoreTasks(Application app) {
        Semaphore sem = new Semaphore(0);
        if (!this.requestQueue.offer(new EndOfAppRequest(app, sem))) {
            ErrorManager.error("ERROR: AccessProcessor queue offer error on no more tasks");
        }
        sem.acquireUninterruptibly();
        LOGGER.info("All tasks finished");
    }

    public boolean alreadyAccessed(Application app, DataLocation loc) {
        Semaphore sem = new Semaphore(0);
        AlreadyAccessedRequest request = new AlreadyAccessedRequest(app, loc, sem);
        if (!this.requestQueue.offer(request)) {
            ErrorManager.error("ERROR: AccessProcessor queue offer error on already accessed location");
        }
        sem.acquireUninterruptibly();
        return request.getResponse();
    }

    public void barrier(Application app) {
        Semaphore sem = new Semaphore(0);
        if (!this.requestQueue.offer(new BarrierRequest(app, sem))) {
            ErrorManager.error("ERROR: AccessProcessor queue offer error on wait for all tasks");
        }
        sem.acquireUninterruptibly();
        LOGGER.info("Barrier: End of waited all tasks");
    }

    public void barrierGroup(Application app, String groupName) throws COMPSsException {
        Semaphore sem = new Semaphore(0);
        BarrierGroupRequest request = new BarrierGroupRequest(app, groupName, sem);
        if (!this.requestQueue.offer(request)) {
            ErrorManager.error("ERROR: AccessProcessor queue offer error on wait for all tasks");
        }
        sem.acquireUninterruptibly();
        if (request.getException() != null) {
            LOGGER.debug("The thrown exception message is: " + request.getException().getMessage());
            throw new COMPSsException("Group " + groupName + " raised a COMPSs Exception ( " + request.getException().getMessage() + ")");
        }
        LOGGER.info("Group barrier: End of tasks of group " + groupName);
    }

    public void cancelApplicationTasks(Application app) {
        Long appId = app.getId();
        LOGGER.info("Cancelled all remaining tasks for application with id " + appId);
        Semaphore sem = new Semaphore(0);
        if (!this.requestQueue.offer(new CancelApplicationTasksRequest(app, sem))) {
            ErrorManager.error("ERROR: AccessProcessor queue offer error on wait for task");
        }
        LOGGER.debug("Waiting for finishing tasks cancellation " + appId);
        sem.acquireUninterruptibly();
        LOGGER.info("Tasks cancelled for application with id " + appId);
    }

    public void cancelTaskGroup(Application app, String groupName) {
        Long appId = app.getId();
        LOGGER.info("Cancel remaining tasks for application " + appId + " and group " + groupName);
        Semaphore sem = new Semaphore(0);
        if (!this.requestQueue.offer(new CancelTaskGroupRequest(app, groupName, sem))) {
            ErrorManager.error("ERROR: AccessProcessor queue offer error on wait for task");
        }
        LOGGER.debug("Waiting for cancellation of tasks in group " + groupName);
        sem.acquireUninterruptibly();
        LOGGER.info("Tasks cancelled for group " + groupName);
    }

    private void waitForTask(int dataId, AccessParams.AccessMode mode) {
        Semaphore sem = new Semaphore(0);
        if (!this.requestQueue.offer(new WaitForTaskRequest(dataId, mode, sem))) {
            ErrorManager.error("ERROR: AccessProcessor queue offer error on wait for task");
        }
        sem.acquireUninterruptibly();
        LOGGER.info("End of waited task for data " + dataId);
    }

    private void waitForConcurrent(int dataId, AccessParams.AccessMode accessMode) {
        Semaphore sem = new Semaphore(0);
        Semaphore semTasks = new Semaphore(0);
        WaitForConcurrentRequest request = new WaitForConcurrentRequest(dataId, accessMode, sem, semTasks);
        if (!this.requestQueue.offer(request)) {
            ErrorManager.error("ERROR: AccessProcessor queue offer error on wait for concurrent task");
        }
        sem.acquireUninterruptibly();
        int n = request.getNumWaitedTasks();
        semTasks.acquireUninterruptibly(n);
        LOGGER.info("End of waited concurrent task for data " + dataId);
    }

    private DataAccessId registerDataAccess(AccessParams access) {
        Semaphore sem = new Semaphore(0);
        RegisterDataAccessRequest request = new RegisterDataAccessRequest(access, sem);
        if (!this.requestQueue.offer(request)) {
            ErrorManager.error("ERROR: AccessProcessor queue offer error on register data access");
        }
        sem.acquireUninterruptibly();
        return request.getResponse();
    }

    public void setObjectVersionValue(String renaming, Object value) {
        SetObjectVersionValueRequest request = new SetObjectVersionValueRequest(renaming, value);
        if (!this.requestQueue.offer(request)) {
            ErrorManager.error("ERROR: AccessProcessor queue offer error on new object version value");
        }
    }

    public void setCurrentTaskGroup(String groupName, boolean implicitBarrier, Application app) {
        OpenTaskGroupRequest request = new OpenTaskGroupRequest(groupName, implicitBarrier, app);
        if (!this.requestQueue.offer(request)) {
            ErrorManager.error("ERROR: AccessProcessor queue offer error on new task group");
        }
    }

    public void closeCurrentTaskGroup(Application app) {
        CloseTaskGroupRequest request = new CloseTaskGroupRequest(app);
        if (!this.requestQueue.offer(request)) {
            ErrorManager.error("ERROR: AccessProcessor queue offer error on closure of task group");
        }
    }

    public String getLastRenaming(int code) {
        Semaphore sem = new Semaphore(0);
        GetLastRenamingRequest request = new GetLastRenamingRequest(code, sem);
        if (!this.requestQueue.offer(request)) {
            ErrorManager.error("ERROR: AccessProcessor queue offer error on get last renaming");
        }
        sem.acquireUninterruptibly();
        return request.getResponse();
    }

    public void unblockResultFiles(List<ResultFile> resFiles) {
        UnblockResultFilesRequest request = new UnblockResultFilesRequest(resFiles);
        if (!this.requestQueue.offer(request)) {
            ErrorManager.error("ERROR: AccessProcessor queue offer error on unblock result files");
        }
    }

    public void shutdown() {
        Semaphore sem = new Semaphore(0);
        if (!this.requestQueue.offer(new ShutdownRequest(sem))) {
            ErrorManager.error("ERROR: AccessProcessor queue offer error on shutdown");
        }
        sem.acquireUninterruptibly();
    }

    public String getCurrentTaskState() {
        Semaphore sem = new Semaphore(0);
        TasksStateRequest request = new TasksStateRequest(sem);
        if (!this.requestQueue.offer(request)) {
            ErrorManager.error("ERROR: AccessProcessor queue offer error on get current task state");
        }
        sem.acquireUninterruptibly();
        return request.getResponse();
    }

    public void markForDeletion(Application app, DataLocation loc, boolean enableReuse) {
        LOGGER.debug("Marking data " + loc + " for deletion");
        Semaphore sem = new Semaphore(0);
        if (enableReuse) {
            Semaphore semWait = new Semaphore(0);
            WaitForDataReadyToDeleteRequest request = new WaitForDataReadyToDeleteRequest(app, loc, sem, semWait);
            if (!this.requestQueue.offer(request)) {
                ErrorManager.error("ERROR: AccessProcessor queue offer error on wait for data ready to delete");
            }
            LOGGER.debug("Waiting for ready to delete request response...");
            sem.acquireUninterruptibly();
            int nPermits = request.getNumPermits();
            if (nPermits > 0) {
                LOGGER.debug("Waiting for " + nPermits + " tasks to finish...");
                semWait.acquireUninterruptibly(nPermits);
            }
        }
        LOGGER.debug("Sending delete request response for " + loc);
        if (!this.requestQueue.offer(new DeleteFileRequest(app, loc, sem, !enableReuse))) {
            ErrorManager.error("ERROR: AccessProcessor queue offer error on mark for deletion");
        }
        if (enableReuse) {
            LOGGER.debug("Waiting for delete request response...");
            sem.acquireUninterruptibly();
            LOGGER.debug("Data " + loc + " deleted.");
        }
    }

    public void markForBindingObjectDeletion(int code) {
        if (!this.requestQueue.offer(new DeleteBindingObjectRequest(code))) {
            ErrorManager.error("ERROR: AccessProcessor queue offer error on mark for deletion");
        }
    }

    private void transferFileRaw(DataAccessId faId, DataLocation location) {
        RAccessId faRId = (RAccessId)faId;
        Semaphore sem = new Semaphore(0);
        TransferRawFileRequest request = new TransferRawFileRequest(faRId, location, sem);
        if (!this.requestQueue.offer(request)) {
            ErrorManager.error("ERROR: AccessProcessor queue offer error on transfer file raw");
        }
        sem.acquireUninterruptibly();
        LOGGER.debug("Raw file transferred");
    }

    private DataLocation transferFileOpen(DataAccessId faId) {
        Semaphore sem = new Semaphore(0);
        TransferOpenFileRequest request = new TransferOpenFileRequest(faId, sem);
        if (!this.requestQueue.offer(request)) {
            ErrorManager.error("ERROR: AccessProcessor queue offer error on transfer file open");
        }
        sem.acquireUninterruptibly();
        LOGGER.debug("Open file transferred");
        return request.getLocation();
    }

    private DataLocation transferDirectoryOpen(DataAccessId faId) {
        Semaphore sem = new Semaphore(0);
        TransferOpenDirectoryRequest req = new TransferOpenDirectoryRequest(faId, sem);
        if (!this.requestQueue.offer(req)) {
            ErrorManager.error("ERROR: AccessProcessor queue offer error on transfer directory open");
        }
        sem.acquireUninterruptibly();
        LOGGER.debug("Open directory transferred");
        return req.getLocation();
    }

    private Object obtainObject(DataAccessId oaId) {
        Semaphore sem = new Semaphore(0);
        TransferObjectRequest tor = new TransferObjectRequest(oaId, sem);
        if (!this.requestQueue.offer(tor)) {
            ErrorManager.error("ERROR: AccessProcessor queue offer error on obtain object");
        }
        sem.acquireUninterruptibly();
        Object oUpdated = tor.getResponse();
        if (oUpdated == null) {
            LogicalData ld = tor.getTargetData();
            try {
                ld.loadFromStorage();
                oUpdated = ld.getValue();
            }
            catch (CannotLoadException e) {
                LOGGER.fatal("ERROR: Cannot load object from storage (file or PSCO): " + (ld == null ? "null" : ld.getName()), (Throwable)e);
                ErrorManager.fatal("ERROR: Cannot load object from storage (file or PSCO): " + (ld == null ? "null" : ld.getName()), e);
            }
        }
        return oUpdated;
    }

    public void getResultFiles(Application app) {
        Semaphore sem = new Semaphore(0);
        GetResultFilesRequest request = new GetResultFilesRequest(app, sem);
        if (!this.requestQueue.offer(request)) {
            ErrorManager.error("ERROR: AccessProcessor queue offer error on get result files");
        }
        sem.acquireUninterruptibly();
        UnblockResultFilesRequest urfr = new UnblockResultFilesRequest(request.getBlockedData());
        if (!this.requestQueue.offer(urfr)) {
            ErrorManager.error("ERROR: AccessProcessor queue offer error on unlock result files");
        }
    }

    public void deregisterObject(Object o) {
        if (!this.requestQueue.offer(new DeregisterObject(o))) {
            ErrorManager.error("ERROR: AccessProcessor queue offer error on deregister object");
        }
    }

    public void registerRemoteObject(Application app, int code, String dataId) {
        RegisterRemoteObjectDataRequest request = new RegisterRemoteObjectDataRequest(app, code, dataId);
        if (!this.requestQueue.offer(request)) {
            ErrorManager.error("ERROR: AccessProcessor queue offer error on register data");
        }
    }

    public void registerRemoteFile(Application app, DataLocation loc, String dataId) {
        RegisterRemoteFileDataRequest request = new RegisterRemoteFileDataRequest(app, loc, dataId);
        if (!this.requestQueue.offer(request)) {
            ErrorManager.error("ERROR: AccessProcessor queue offer error on register data");
        }
    }

    public void deleteAllApplicationDataRequest(Application app) {
        Long appId = app.getId();
        DeleteAllApplicationDataRequest request = new DeleteAllApplicationDataRequest(app);
        if (!this.requestQueue.offer(request)) {
            ErrorManager.error("ERROR: AccessProcessor queue offer error on delete all data from application " + appId);
        }
    }
}

