/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.types.allocatableactions;

import es.bsc.compss.components.impl.AccessProcessor;
import es.bsc.compss.scheduler.types.ActionOrchestrator;
import es.bsc.compss.scheduler.types.SchedulingInformation;
import es.bsc.compss.types.Task;
import es.bsc.compss.types.TaskState;
import es.bsc.compss.types.allocatableactions.ExecutionAction;
import es.bsc.compss.types.allocatableactions.MultiNodeGroup;
import es.bsc.compss.types.job.Job;
import es.bsc.compss.types.job.JobHistory;
import es.bsc.compss.types.job.JobStatusListener;
import es.bsc.compss.types.resources.Worker;
import es.bsc.compss.types.resources.WorkerResourceDescription;
import java.util.List;

public class MultiNodeExecutionAction
extends ExecutionAction {
    private final MultiNodeGroup group;
    private int actionIdInsideGroup = -1;

    public MultiNodeExecutionAction(SchedulingInformation schedulingInformation, ActionOrchestrator orchestrator, AccessProcessor ap, Task task, MultiNodeGroup group2) {
        super(schedulingInformation, orchestrator, ap, task);
        this.group = group2;
    }

    @Override
    public long getGroupPriority() {
        return this.group.isAnyActionRunning() ? 0L : 1L;
    }

    @Override
    protected void notifyCompleted() {
        if (this.actionIdInsideGroup == 1) {
            if (DEBUG) {
                LOGGER.debug("Notify completed of " + this + " to orchestrator " + this.orchestrator);
            }
            this.group.actionCompletion();
        }
        if (this.isPending()) {
            this.orchestrator.actionCompletion(this);
        }
    }

    @Override
    protected void notifyError() {
        if (this.actionIdInsideGroup == 1) {
            if (DEBUG) {
                LOGGER.debug("Notify error of " + this + " to orchestrator " + this.orchestrator);
            }
            this.group.actionError();
            this.orchestrator.actionError(this);
        } else if (this.isRunning()) {
            LOGGER.debug("Notify slave " + this + " to orchestrator " + this.orchestrator);
            this.orchestrator.actionError(this);
        }
    }

    @Override
    protected void doAction() {
        LOGGER.info("Registering action for task " + this.task.getId());
        this.group.setActionRunning();
        if (this.actionIdInsideGroup == -1) {
            this.actionIdInsideGroup = this.group.registerProcess(this);
        }
        this.executionErrors = 0;
        if (this.actionIdInsideGroup == 1) {
            LOGGER.info("Action registered as master for task " + this.task.getId() + " with groupId " + this.group.getGroupId());
            super.doAction();
        } else {
            LOGGER.info("Action registered as slave for task " + this.task.getId() + " with groupId " + this.group.getGroupId());
        }
    }

    @Override
    protected Job<?> submitJob(int transferGroupId, JobStatusListener listener) {
        Job<?> job;
        if (DEBUG) {
            LOGGER.debug(this.toString() + " starts job creation");
        }
        Worker<? extends WorkerResourceDescription> w = this.getAssignedResource().getResource();
        List<String> slaveNames = this.group.getSlavesNames();
        this.currentJob = job = w.newJob(this.task.getId(), this.task.getTaskDescription(), this.getAssignedImplementation(), slaveNames, listener);
        job.setTransferGroupId(transferGroupId);
        job.setHistory(JobHistory.NEW);
        return job;
    }

    @Override
    protected void stopAction() throws Exception {
        if (this.actionIdInsideGroup == 1) {
            LOGGER.info("Task " + this.task.getId() + " starts cancelling MultiNode master running job");
            super.stopAction();
        } else {
            LOGGER.info("Task " + this.task.getId() + " starts cancelling MultiNode slave running job");
        }
    }

    @Override
    protected void doCompleted() {
        if (this.actionIdInsideGroup == 1) {
            super.doCompleted();
        } else {
            this.getAssignedResource().profiledExecution(this.getAssignedImplementation(), this.profile);
            this.task.decreaseExecutionCount();
        }
    }

    @Override
    protected void doFailed() {
        if (this.actionIdInsideGroup == 1) {
            super.doFailed();
        } else {
            this.task.setStatus(TaskState.FAILED);
            this.task.decreaseExecutionCount();
        }
    }

    @Override
    public String toString() {
        return "MultiNodeExecutionAction (Task " + this.task.getId() + ", CE name " + this.task.getTaskDescription().getName() + ") with GroupId = " + this.group.getGroupId();
    }
}

