/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.types.implementations.definition;

import es.bsc.compss.types.implementations.Implementation;
import es.bsc.compss.types.implementations.OpenCLImplementation;
import es.bsc.compss.types.implementations.definition.ImplementationDefinition;
import es.bsc.compss.types.resources.MethodResourceDescription;

public class OpenCLDefinition
extends ImplementationDefinition<MethodResourceDescription> {
    private final String kernel;
    private final String workingDir;

    protected OpenCLDefinition(String signature, String kernel, String workingDir, MethodResourceDescription implConstraints) {
        super(signature, implConstraints);
        this.kernel = kernel;
        this.workingDir = workingDir;
    }

    @Override
    public Implementation getImpl(int coreId, int implId) {
        return new OpenCLImplementation(this.kernel, this.workingDir, coreId, implId, this.getSignature(), (MethodResourceDescription)this.getConstraints());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("OpenCL Implementation \n");
        sb.append("\t Signature: ").append(this.getSignature()).append("\n");
        sb.append("\t IO: ").append(!((MethodResourceDescription)this.getConstraints()).usesCPUs()).append("\n");
        sb.append("\t Kernel: ").append(this.kernel).append("\n");
        sb.append("\t Working directory: ").append(this.workingDir).append("\n");
        sb.append("\t Constraints: ").append(this.getConstraints());
        return sb.toString();
    }
}

