/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.local;

import es.bsc.compss.local.LocalParameter;
import es.bsc.compss.local.LocalParameterCollection;
import es.bsc.compss.local.LocalParameterDictCollection;
import es.bsc.compss.types.COMPSsMaster;
import es.bsc.compss.types.TaskDescription;
import es.bsc.compss.types.annotations.parameter.DataType;
import es.bsc.compss.types.execution.Invocation;
import es.bsc.compss.types.implementations.AbstractMethodImplementation;
import es.bsc.compss.types.implementations.Implementation;
import es.bsc.compss.types.implementations.TaskType;
import es.bsc.compss.types.job.Job;
import es.bsc.compss.types.job.JobListener;
import es.bsc.compss.types.parameter.CollectionParameter;
import es.bsc.compss.types.parameter.DictCollectionParameter;
import es.bsc.compss.types.parameter.Parameter;
import es.bsc.compss.types.resources.MethodResourceDescription;
import es.bsc.compss.types.resources.Resource;
import es.bsc.compss.types.resources.ResourceDescription;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class LocalJob
extends Job<COMPSsMaster>
implements Invocation {
    private final List<LocalParameter> arguments;
    private LocalParameter target;
    private LinkedList<LocalParameter> results;
    private MethodResourceDescription reqs;
    private final List<String> slaveWorkersNodeNames;
    private TaskType taskType;

    public LocalJob(int taskId, TaskDescription task, Implementation impl, Resource res, List<String> slaveWorkersNodeNames, JobListener listener) {
        super(taskId, task, impl, res, listener);
        Parameter p;
        this.taskType = impl.getTaskType();
        boolean hasTarget = this.taskParams.hasTargetObject();
        int numReturns = this.taskParams.getNumReturns();
        this.arguments = new LinkedList<LocalParameter>();
        this.results = new LinkedList();
        List<Parameter> params = task.getParameters();
        int paramsCount = params.size();
        for (int rIdx = 0; rIdx < numReturns; ++rIdx) {
            p = params.get(params.size() - numReturns + rIdx);
            this.results.add(this.generateLocalParameter(p));
        }
        paramsCount -= numReturns;
        if (hasTarget) {
            Parameter p2 = params.get(params.size() - numReturns - 1);
            this.target = this.generateLocalParameter(p2);
            --paramsCount;
        }
        for (int paramIdx = 0; paramIdx < paramsCount; ++paramIdx) {
            p = params.get(paramIdx);
            this.arguments.add(this.generateLocalParameter(p));
        }
        this.slaveWorkersNodeNames = slaveWorkersNodeNames;
        AbstractMethodImplementation absMethodImpl = (AbstractMethodImplementation)this.impl;
        this.reqs = absMethodImpl.getRequirements();
    }

    private LocalParameter generateLocalParameter(Parameter p) {
        if (p.getType() == DataType.COLLECTION_T) {
            CollectionParameter cp = (CollectionParameter)p;
            LocalParameterCollection lpc = new LocalParameterCollection(p);
            for (Parameter subParam : cp.getParameters()) {
                lpc.addParameter(this.generateLocalParameter(subParam));
            }
            return lpc;
        }
        if (p.getType() == DataType.DICT_COLLECTION_T) {
            DictCollectionParameter cp = (DictCollectionParameter)p;
            LocalParameterDictCollection lpdc = new LocalParameterDictCollection(p);
            for (Map.Entry<Parameter, Parameter> entry : cp.getParameters().entrySet()) {
                lpdc.addParameter(this.generateLocalParameter(entry.getKey()), this.generateLocalParameter(entry.getValue()));
            }
            return lpdc;
        }
        return new LocalParameter(p);
    }

    @Override
    public void submit() throws Exception {
        this.listener.allInputDataOnWorker(this);
        ((COMPSsMaster)this.getResourceNode()).runJob(this);
    }

    @Override
    public void cancelJob() throws Exception {
    }

    @Override
    public String getHostName() {
        return ((COMPSsMaster)this.getResourceNode()).getName();
    }

    @Override
    public TaskType getType() {
        return TaskType.METHOD;
    }

    @Override
    public TaskType getTaskType() {
        return this.taskType;
    }

    @Override
    public String toString() {
        return "LocalJob JobId" + this.jobId + " for task " + this.impl.getSignature();
    }

    @Override
    public AbstractMethodImplementation getMethodImplementation() {
        return (AbstractMethodImplementation)this.impl;
    }

    @Override
    public boolean isDebugEnabled() {
        return DEBUG;
    }

    public List<LocalParameter> getParams() {
        return this.arguments;
    }

    @Override
    public LocalParameter getTarget() {
        return this.target;
    }

    public List<LocalParameter> getResults() {
        return this.results;
    }

    @Override
    public ResourceDescription getRequirements() {
        return this.reqs;
    }

    @Override
    public List<String> getSlaveNodesNames() {
        return this.slaveWorkersNodeNames;
    }

    @Override
    public String getParallelismSource() {
        return this.taskParams.getParallelismSource();
    }
}

