/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.types.implementations;

import es.bsc.compss.types.implementations.AbstractMethodImplementation;
import es.bsc.compss.types.implementations.MethodType;
import es.bsc.compss.types.implementations.definition.DecafDefinition;
import es.bsc.compss.types.implementations.definition.ImplementationDefinition;
import es.bsc.compss.types.resources.MethodResourceDescription;
import java.io.Externalizable;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class DecafImplementation
extends AbstractMethodImplementation
implements Externalizable {
    private static final long serialVersionUID = 1L;
    public static final int NUM_PARAMS = 6;
    public static String SIGNATURE = "decaf.DECAF";
    public static final String SCRIPT_PATH = File.separator + "Runtime" + File.separator + "scripts" + File.separator + "system" + File.separator + "decaf" + File.separator + "run_decaf.sh";
    private String mpiRunner;
    private String dfScript;
    private String dfExecutor;
    private String dfLib;
    private String workingDir;
    private boolean failByEV;

    public DecafImplementation() {
    }

    public DecafImplementation(String dfScript, String dfExecutor, String dfLib, String workingDir, String mpiRunner, boolean failByEV, Integer coreId, Integer implementationId, String signature, MethodResourceDescription annot) {
        super(coreId, implementationId, signature, annot);
        this.mpiRunner = mpiRunner;
        this.workingDir = workingDir;
        this.dfScript = dfScript;
        this.dfExecutor = dfExecutor;
        this.dfLib = dfLib;
        this.failByEV = failByEV;
    }

    public String getDfScript() {
        return this.dfScript;
    }

    public String getDfExecutor() {
        return this.dfExecutor;
    }

    public String getDfLib() {
        return this.dfLib;
    }

    public String getWorkingDir() {
        return this.workingDir;
    }

    public String getMpiRunner() {
        return this.mpiRunner;
    }

    public boolean isFailByEV() {
        return this.failByEV;
    }

    @Override
    public MethodType getMethodType() {
        return MethodType.DECAF;
    }

    @Override
    public String getMethodDefinition() {
        StringBuilder sb = new StringBuilder();
        sb.append("[MPI RUNNER=").append(this.mpiRunner);
        sb.append(", DF_SCRIPT=").append(this.dfScript);
        sb.append(", DF_EXECUTOR=").append(this.dfExecutor);
        sb.append(", DF_LIBRARY=").append(this.dfLib);
        sb.append("]");
        return sb.toString();
    }

    @Override
    public ImplementationDefinition<?> getDefinition() {
        return new DecafDefinition(this.getSignature(), this.dfScript, this.dfExecutor, this.dfLib, this.workingDir, this.mpiRunner, this.failByEV, this.getRequirements());
    }

    @Override
    public String toString() {
        return super.toString() + " Decaf Method with script " + this.dfScript + ", executor " + this.dfScript + ", library " + this.dfLib + " and MPIrunner " + this.mpiRunner;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.mpiRunner = (String)in.readObject();
        this.dfScript = (String)in.readObject();
        this.dfExecutor = (String)in.readObject();
        this.dfLib = (String)in.readObject();
        this.workingDir = (String)in.readObject();
        this.failByEV = in.readBoolean();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeObject(this.mpiRunner);
        out.writeObject(this.dfScript);
        out.writeObject(this.dfExecutor);
        out.writeObject(this.dfLib);
        out.writeObject(this.workingDir);
        out.writeBoolean(this.failByEV);
    }
}

