/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.executor.utils;

import es.bsc.compss.binders.BindToMap;
import es.bsc.compss.binders.BindToResource;
import es.bsc.compss.binders.Unbinded;
import es.bsc.compss.executor.types.InvocationResources;
import es.bsc.compss.types.execution.ThreadBinder;
import es.bsc.compss.types.execution.exceptions.InvalidMapException;
import es.bsc.compss.types.execution.exceptions.UnsufficientAvailableComputingUnitsException;
import es.bsc.compss.types.resources.MethodResourceDescription;
import es.bsc.compss.types.resources.ResourceDescription;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ResourceManager {
    private static final Logger LOGGER = LogManager.getLogger("es.bsc.compss.Worker.ExecManager");
    private final ThreadBinder binderCPUs;
    private final ThreadBinder binderGPUs;
    private final ThreadBinder binderFPGAs;

    public ResourceManager(int cusCPU, String cpuMap, int cusGPU, String gpuMap, int cusFPGA, String fpgaMap) throws InvalidMapException {
        ThreadBinder binderFPGAsTmp;
        ThreadBinder binderGPUsTmp;
        ThreadBinder binderCPUsTmp;
        LOGGER.debug("Instantiate CPU Binder with " + cusCPU + " CUs");
        try {
            switch (cpuMap) {
                case "disabled": {
                    binderCPUsTmp = new Unbinded();
                    break;
                }
                case "automatic": {
                    String resourceMap = BindToMap.getResourceCpuDescription();
                    binderCPUsTmp = new BindToMap(cusCPU, resourceMap);
                    break;
                }
                default: {
                    binderCPUsTmp = new BindToMap(cusCPU, cpuMap);
                    break;
                }
            }
        }
        catch (Exception e) {
            LOGGER.warn("Could not load the desidered mapping policy for the CPU computing units. Using default policy (automatic)");
            String resourceMap = BindToMap.getResourceCpuDescription();
            binderCPUsTmp = new BindToMap(cusCPU, resourceMap);
        }
        this.binderCPUs = binderCPUsTmp;
        LOGGER.debug("Instantiate GPU Binder with " + cusGPU + " CUs");
        try {
            switch (gpuMap) {
                case "disabled": {
                    binderGPUsTmp = new Unbinded();
                    break;
                }
                case "automatic": {
                    binderGPUsTmp = new BindToResource(cusGPU);
                    break;
                }
                default: {
                    binderGPUsTmp = new BindToMap(cusGPU, gpuMap);
                    break;
                }
            }
        }
        catch (Exception e) {
            LOGGER.warn("Could not load the desidered mapping policy for the GPU computing units. Using default policy (automatic)");
            binderGPUsTmp = new BindToResource(cusGPU);
        }
        this.binderGPUs = binderGPUsTmp;
        LOGGER.debug("Instantiate FPGA Binder with " + cusFPGA + " CUs");
        try {
            switch (fpgaMap) {
                case "disabled": {
                    binderFPGAsTmp = new Unbinded();
                    break;
                }
                case "automatic": {
                    binderFPGAsTmp = new BindToResource(cusFPGA);
                    break;
                }
                default: {
                    binderFPGAsTmp = new BindToMap(cusFPGA, fpgaMap);
                    break;
                }
            }
        }
        catch (Exception e) {
            LOGGER.warn("Could not load the desidered mapping policy for the FPGA computing units. Using default policy (automatic)");
            binderFPGAsTmp = new BindToResource(cusFPGA);
        }
        this.binderFPGAs = binderFPGAsTmp;
    }

    public InvocationResources acquireResources(int jobId, ResourceDescription rd, InvocationResources previousAllocation) throws UnsufficientAvailableComputingUnitsException {
        int[] assignedFPGAs;
        int[] assignedGPUs;
        int[] assignedCPUs;
        int fpgas;
        int gpus;
        int cpus;
        try {
            MethodResourceDescription mrd = (MethodResourceDescription)rd;
            cpus = mrd.getTotalCPUComputingUnits();
            gpus = mrd.getTotalGPUComputingUnits();
            fpgas = mrd.getTotalFPGAComputingUnits();
        }
        catch (ClassCastException e) {
            cpus = 0;
            gpus = 0;
            fpgas = 0;
        }
        if (previousAllocation != null) {
            assignedCPUs = this.binderCPUs.bindComputingUnits(jobId, cpus, previousAllocation.getAssignedCPUs());
            assignedGPUs = this.binderGPUs.bindComputingUnits(jobId, gpus, previousAllocation.getAssignedGPUs());
            assignedFPGAs = this.binderFPGAs.bindComputingUnits(jobId, fpgas, previousAllocation.getAssignedFPGAs());
        } else {
            assignedCPUs = this.binderCPUs.bindComputingUnits(jobId, cpus, null);
            assignedGPUs = this.binderGPUs.bindComputingUnits(jobId, gpus, null);
            assignedFPGAs = this.binderFPGAs.bindComputingUnits(jobId, fpgas, null);
        }
        return new InvocationResources(assignedCPUs, assignedGPUs, assignedFPGAs);
    }

    public void releaseResources(int jobId) {
        this.binderCPUs.releaseComputingUnits(jobId);
        this.binderGPUs.releaseComputingUnits(jobId);
        this.binderFPGAs.releaseComputingUnits(jobId);
    }
}

