/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.invokers.types;

import es.bsc.compss.invokers.types.TypeValuePair;
import es.bsc.compss.types.annotations.parameter.DataType;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ExternalTaskStatus {
    private static final Logger LOGGER = LogManager.getLogger("es.bsc.compss.Worker.Executor");
    private final Integer exitValue;
    private final List<TypeValuePair> updatedParameters;

    public ExternalTaskStatus(Integer exitValue) {
        this.exitValue = exitValue;
        this.updatedParameters = new LinkedList<TypeValuePair>();
    }

    public ExternalTaskStatus(String[] line) {
        this.updatedParameters = new LinkedList<TypeValuePair>();
        this.exitValue = Integer.parseInt(line[2]);
        if (line.length > 3) {
            int numParams = Integer.parseInt(line[3]);
            if (4 + 2 * numParams != line.length) {
                LOGGER.warn("WARN: Skipping endTask parameters because of malformation.");
                numParams = (line.length - 4) / 2;
            }
            for (int i = 0; i < numParams; ++i) {
                int paramTypeOrdinalIndex = 0;
                try {
                    paramTypeOrdinalIndex = Integer.parseInt(line[4 + 2 * i]);
                }
                catch (NumberFormatException nfe) {
                    LOGGER.warn("WARN: Number format exception on " + line[4 + 2 * i] + ". Setting type 0", (Throwable)nfe);
                }
                DataType paramType = DataType.values()[paramTypeOrdinalIndex];
                String paramValue = line[5 + 2 * i];
                if (paramValue.equalsIgnoreCase("null")) {
                    paramValue = null;
                }
                this.addParameter(paramType, paramValue);
            }
        } else {
            LOGGER.warn("WARN: endTask message does not have task result parameters");
        }
    }

    public Integer getExitValue() {
        return this.exitValue;
    }

    public List<TypeValuePair> getUpdatedParameters() {
        return this.updatedParameters;
    }

    public int getNumParameters() {
        return this.updatedParameters.size();
    }

    public DataType getParameterType(int i) {
        if (i >= 0 && i < this.updatedParameters.size()) {
            return this.updatedParameters.get(i).getUpdatedParameterType();
        }
        return null;
    }

    public String getParameterValue(int i) {
        if (i >= 0 && i < this.updatedParameters.size()) {
            return (String)this.updatedParameters.get(i).getUpdatedParameterValue();
        }
        return null;
    }

    public LinkedList<Object> getParameterValues(int i) {
        if (i >= 0 && i < this.updatedParameters.size()) {
            return this.updatedParameters.get(i).getUpdatedParameterValues();
        }
        return null;
    }

    public List<Object> buildCollectionList(String collection) {
        ArrayDeque<Object> stack = new ArrayDeque<Object>();
        char[] chararray = collection.toCharArray();
        String temp = "";
        for (int i = 0; i < chararray.length; ++i) {
            if (chararray[i] == ')') {
                if (!temp.equals("")) {
                    stack.push(new CollectionBean(0, temp));
                    temp = "";
                }
                ArrayList<Object> tmplist = new ArrayList<Object>();
                while (true) {
                    Object object;
                    if ((object = stack.pop()) instanceof CollectionBean) {
                        CollectionBean b = (CollectionBean)object;
                        if (b.token != 1) {
                            tmplist.add(b.obj);
                            continue;
                        }
                        break;
                    }
                    tmplist.add(object);
                    if (stack.isEmpty()) break;
                }
                Collections.reverse(tmplist);
                stack.push(tmplist);
                continue;
            }
            if (chararray[i] == '(') {
                stack.push(new CollectionBean(1, Character.toString(chararray[i])));
                continue;
            }
            if (chararray[i] == ',') {
                if (temp.equals("")) continue;
                stack.push(new CollectionBean(0, temp));
                temp = "";
                continue;
            }
            temp = temp + Character.toString(chararray[i]);
        }
        return (List)stack.pop();
    }

    public List<Object> buildCollectionParameter(List<Object> collection) {
        LinkedList<Object> param = new LinkedList<Object>();
        for (Object element : collection) {
            List subParam = (List)element;
            if (subParam.size() == 2 && subParam.get(0) instanceof String) {
                DataType subElemType = DataType.values()[Integer.parseInt((String)subParam.get(0))];
                String value = (String)subParam.get(1);
                if (value.compareTo("null") != 0) {
                    param.add(new TypeValuePair(subElemType, (String)subParam.get(1)));
                    continue;
                }
                param.add(new TypeValuePair(subElemType, null));
                continue;
            }
            param.add(this.buildCollectionParameter(subParam));
        }
        return param;
    }

    public void addParameter(DataType type, String value) {
        if (type == DataType.COLLECTION_T && value != null) {
            TypeValuePair collectionParameter = new TypeValuePair(type);
            value = value.replace("[", "(");
            value = value.replace("]", ")");
            List<Object> collection = this.buildCollectionList(value);
            List<Object> parameterValue = this.buildCollectionParameter(collection);
            collectionParameter.setUpdatedParameterValue((LinkedList)parameterValue);
            this.updatedParameters.add(collectionParameter);
        } else {
            this.updatedParameters.add(new TypeValuePair(type, value));
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ExternalTaskStatus [ ");
        sb.append("ExitValue = ").append(this.exitValue).append(", ");
        sb.append("NumParameters = ").append(this.getNumParameters()).append(", ");
        sb.append("ParameterTypes = [");
        for (TypeValuePair tvp : this.updatedParameters) {
            sb.append(tvp.getUpdatedParameterType().ordinal()).append(" ");
        }
        sb.append("], ");
        sb.append("ParameterValues = [");
        for (TypeValuePair tvp : this.updatedParameters) {
            sb.append((String)tvp.getUpdatedParameterValue()).append(" ");
        }
        sb.append("]");
        sb.append(" ]");
        return sb.toString();
    }

    private static class CollectionBean {
        int token;
        Object obj;

        public CollectionBean(int token, Object o) {
            this.token = token;
            this.obj = o;
        }
    }
}

