/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.types;

import es.bsc.compss.scheduler.types.AllocatableAction;
import es.bsc.compss.types.Application;
import es.bsc.compss.types.TaskState;
import es.bsc.compss.types.parameter.DependencyParameter;
import es.bsc.compss.types.parameter.Parameter;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class AbstractTask
implements Comparable<AbstractTask> {
    private static final int FIRST_TASK_ID = 1;
    private static AtomicInteger nextTaskId = new AtomicInteger(1);
    private final Application app;
    private final int taskId;
    private TaskState status;
    private final List<AbstractTask> predecessors;
    private final List<AbstractTask> successors;
    private final List<AbstractTask> streamDataProducers;
    private final List<AbstractTask> streamDataConsumers;
    private int synchronizationId;
    private final List<AllocatableAction> executions;
    private final Map<AbstractTask, DependencyParameter> dependentTasks;
    private final List<Parameter> freeParams;

    public AbstractTask(Application app) {
        this.app = app;
        this.taskId = nextTaskId.getAndIncrement();
        this.status = TaskState.TO_ANALYSE;
        this.predecessors = new LinkedList<AbstractTask>();
        this.successors = new LinkedList<AbstractTask>();
        this.executions = new LinkedList<AllocatableAction>();
        this.streamDataProducers = new LinkedList<AbstractTask>();
        this.streamDataConsumers = new LinkedList<AbstractTask>();
        this.dependentTasks = new HashMap<AbstractTask, DependencyParameter>();
        this.freeParams = new LinkedList<Parameter>();
    }

    public static int getCurrentTaskCount() {
        return nextTaskId.get();
    }

    public void addDataDependency(AbstractTask producer, DependencyParameter dp) {
        producer.successors.add(this);
        this.predecessors.add(producer);
        this.dependentTasks.put(producer, dp);
    }

    public void addStreamDataDependency(AbstractTask producer) {
        producer.streamDataConsumers.add(this);
        this.streamDataProducers.add(producer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseDataDependents() {
        for (AbstractTask t : this.successors) {
            if (t.isReduction()) continue;
            AbstractTask abstractTask = t;
            synchronized (abstractTask) {
                t.removePredecessor(this);
            }
        }
        this.successors.clear();
    }

    public abstract boolean isReduction();

    public void removePredecessor(AbstractTask t) {
        this.predecessors.remove(t);
        this.dependentTasks.remove(t);
    }

    public List<AbstractTask> getSuccessors() {
        return this.successors;
    }

    public List<AbstractTask> getPredecessors() {
        return this.predecessors;
    }

    public DependencyParameter getDependencyParameters(AbstractTask t) {
        return this.dependentTasks.get(t);
    }

    public List<Parameter> getFreeParams() {
        return this.freeParams;
    }

    public void registerFreeParam(Parameter p) {
        this.freeParams.add(p);
    }

    public List<AbstractTask> getStreamProducers() {
        return this.streamDataProducers;
    }

    public List<AbstractTask> getStreamConsumers() {
        return this.streamDataConsumers;
    }

    public void setSynchronizationId(int syncId) {
        this.synchronizationId = syncId;
    }

    public int getSynchronizationId() {
        return this.synchronizationId;
    }

    public Application getApplication() {
        return this.app;
    }

    public int getId() {
        return this.taskId;
    }

    public TaskState getStatus() {
        return this.status;
    }

    public void setStatus(TaskState status) {
        this.status = status;
    }

    public void addExecution(AllocatableAction execution) {
        this.executions.add(execution);
    }

    public List<AllocatableAction> getExecutions() {
        return this.executions;
    }

    public abstract List<Parameter> getParameterDataToRemove();

    public abstract List<Parameter> getIntermediateParameters();

    public abstract List<Parameter> getUnusedIntermediateParameters();

    public abstract String getDotDescription();

    public abstract String getLegendDescription();

    public abstract String getColor();

    @Override
    public int compareTo(AbstractTask task) {
        if (task == null) {
            throw new NullPointerException();
        }
        return this.getId() - task.getId();
    }

    public boolean equals(Object o) {
        return o instanceof AbstractTask && this.taskId == ((AbstractTask)o).taskId;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("[[Task id: ").append(this.getId()).append("]");
        buffer.append(", [Status: ").append((Object)this.getStatus()).append("]");
        return buffer.toString();
    }
}

