/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.types;

import es.bsc.compss.COMPSsConstants;
import es.bsc.compss.api.TaskMonitor;
import es.bsc.compss.comm.Comm;
import es.bsc.compss.types.Application;
import es.bsc.compss.types.Task;
import es.bsc.compss.types.annotations.parameter.DataType;
import es.bsc.compss.types.annotations.parameter.Direction;
import es.bsc.compss.types.annotations.parameter.OnFailure;
import es.bsc.compss.types.colors.ColorConfiguration;
import es.bsc.compss.types.colors.ColorNode;
import es.bsc.compss.types.data.location.DataLocation;
import es.bsc.compss.types.data.location.ProtocolType;
import es.bsc.compss.types.parameter.CollectionParameter;
import es.bsc.compss.types.parameter.FileParameter;
import es.bsc.compss.types.parameter.Parameter;
import es.bsc.compss.types.uri.SimpleURI;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ReduceTask
extends Task {
    private final List<Task> tasks = new LinkedList<Task>();
    private int chunkSize;
    private double totalOperations;
    private final List<Parameter> partialsIn;
    private final List<Parameter> usedPartialsIn;
    private final List<Parameter> partialsOut;
    private final List<Parameter> usedPartialsOut;
    private final List<CollectionParameter> intermediateCollections;
    private CollectionParameter finalCol;
    private static final Logger LOGGER = LogManager.getLogger("es.bsc.compss.Components.TaskProcessor");

    public ReduceTask(Application app, COMPSsConstants.Lang lang, String signature, boolean isPrioritary, int numNodes, boolean isReduction, int reduceChunkSize, boolean isReplicated, boolean isDistributed, boolean hasTarget, int numReturns, List<Parameter> parameters, TaskMonitor monitor, OnFailure onFailure, long timeOut) {
        super(app, lang, signature, isPrioritary, numNodes, isReduction, isReplicated, isDistributed, hasTarget, numReturns, parameters, monitor, onFailure, timeOut);
        this.chunkSize = reduceChunkSize;
        this.totalOperations = 0.0;
        this.partialsIn = new ArrayList<Parameter>();
        this.usedPartialsIn = new ArrayList<Parameter>();
        this.partialsOut = new ArrayList<Parameter>();
        this.usedPartialsOut = new ArrayList<Parameter>();
        this.intermediateCollections = new ArrayList<CollectionParameter>();
        LOGGER.debug("[REDUCE-TASK] The REDUCE task has been created with chunk size " + this.chunkSize);
        try {
            this.createPartialParameters(parameters);
        }
        catch (IOException e) {
            LOGGER.debug("Exception detected when creating location for partials");
        }
    }

    public void createPartialParameters(List<Parameter> parameters) throws IOException {
        if (parameters.size() == 2) {
            CollectionParameter p = (CollectionParameter)parameters.get(0);
            Parameter finalParameter = parameters.get(1);
            if (p.getType() == DataType.COLLECTION_T) {
                List<Parameter> colList = p.getParameters();
                double completeOperations = 0.0;
                this.totalOperations = 0.0;
                double intermediateResults = 0.0;
                double accum = colList.size();
                while (accum > (double)this.chunkSize) {
                    completeOperations = Math.floor(accum / (double)this.chunkSize);
                    intermediateResults = accum % (double)this.chunkSize;
                    accum = completeOperations + intermediateResults;
                    this.totalOperations += accum;
                }
                for (int i = 0; i < (int)this.totalOperations; ++i) {
                    String partialId = "reduce" + i + "PartialResultTask" + this.getId();
                    String canonicalPath = new File(partialId).getCanonicalPath();
                    SimpleURI uri = new SimpleURI(ProtocolType.FILE_URI.getSchema() + canonicalPath);
                    DataLocation dl = DataLocation.createLocation(Comm.getAppHost(), uri);
                    this.partialsOut.add(new FileParameter(Direction.OUT, finalParameter.getStream(), finalParameter.getPrefix(), finalParameter.getName(), finalParameter.getType().toString(), finalParameter.getWeight(), finalParameter.isKeepRename(), dl, partialId));
                    this.partialsIn.add(new FileParameter(Direction.IN, finalParameter.getStream(), finalParameter.getPrefix(), finalParameter.getName(), finalParameter.getType().toString(), finalParameter.getWeight(), finalParameter.isKeepRename(), dl, partialId));
                    CollectionParameter cp = new CollectionParameter(partialId + "Collection", new ArrayList<Parameter>(), p.getDirection(), p.getStream(), p.getPrefix(), p.getName(), p.getContentType(), p.getWeight(), p.isKeepRename());
                    this.intermediateCollections.add(cp);
                }
                String finalId = "finalReduceTask" + this.getId();
                this.finalCol = new CollectionParameter(finalId, new ArrayList<Parameter>(), Direction.IN, p.getStream(), p.getPrefix(), p.getName(), p.getContentType(), p.getWeight(), p.isKeepRename());
            }
        }
    }

    public List<Parameter> getIntermediateInParameters() {
        return this.partialsIn;
    }

    public List<Parameter> getIntermediateUsedInParameters() {
        return this.usedPartialsIn;
    }

    public void setPartialInUsed(Parameter partial) {
        this.usedPartialsIn.add(partial);
        this.partialsIn.remove(partial);
    }

    public List<Parameter> getIntermediateOutParameters() {
        return this.partialsOut;
    }

    public List<Parameter> getIntermediateUsedOutParameters() {
        return this.usedPartialsOut;
    }

    public void setPartialOutUsed(Parameter partial) {
        this.usedPartialsOut.add(partial);
        this.partialsOut.remove(partial);
    }

    public List<CollectionParameter> getIntermediateCollections() {
        return this.intermediateCollections;
    }

    public CollectionParameter getFinalCollection() {
        return this.finalCol;
    }

    public List<Task> getTasks() {
        return this.tasks;
    }

    public int getChunkSize() {
        return this.chunkSize;
    }

    public void clearPartials() {
        this.partialsIn.clear();
        this.partialsOut.clear();
        this.intermediateCollections.clear();
    }

    @Override
    public List<Parameter> getUnusedIntermediateParameters() {
        this.partialsIn.addAll(this.partialsOut);
        return this.partialsIn;
    }

    public int getTotalOperations() {
        return (int)this.totalOperations;
    }

    @Override
    public String getColor() {
        int monitorTaskId = this.getTaskDescription().getCoreElement().getCoreId() + 1;
        ColorNode color = ColorConfiguration.getColors()[monitorTaskId % (ColorConfiguration.NUM_COLORS + 1)];
        return color.getFillColor();
    }

    @Override
    public List<Parameter> getParameterDataToRemove() {
        LinkedList<Parameter> dataToRemove = new LinkedList<Parameter>();
        dataToRemove.addAll(this.getIntermediateInParameters());
        dataToRemove.addAll(this.getIntermediateOutParameters());
        dataToRemove.addAll(this.getIntermediateCollections());
        return dataToRemove;
    }

    @Override
    public List<Parameter> getIntermediateParameters() {
        LinkedList<Parameter> interParams = new LinkedList<Parameter>();
        interParams.addAll(this.getIntermediateOutParameters());
        interParams.addAll(this.getIntermediateInParameters());
        interParams.addAll(this.getIntermediateCollections());
        interParams.add(this.finalCol);
        return interParams;
    }
}

