/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.types.accesses;

import es.bsc.compss.components.monitor.impl.EdgeType;
import es.bsc.compss.components.monitor.impl.GraphHandler;
import es.bsc.compss.types.AbstractTask;
import es.bsc.compss.types.CommutativeGroupTask;
import es.bsc.compss.types.Task;
import es.bsc.compss.types.accesses.DataAccessesInfo;
import es.bsc.compss.types.annotations.parameter.DataType;
import es.bsc.compss.types.data.accessparams.AccessParams;
import es.bsc.compss.types.parameter.DependencyParameter;
import es.bsc.compss.types.request.ap.RegisterDataAccessRequest;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public class StandardDataAccessesInfo
extends DataAccessesInfo {
    private AbstractTask lastWriter;
    private final List<Task> concurrentReaders = new ArrayList<Task>();

    public StandardDataAccessesInfo(DataType dataType) {
        super(dataType);
    }

    @Override
    public void completedProducer(AbstractTask task) {
        int producerTaskId = task.getId();
        if (this.lastWriter != null && this.lastWriter.getId() == producerTaskId) {
            this.lastWriter = null;
        }
    }

    @Override
    public AbstractTask getConstrainingProducer() {
        return this.lastWriter;
    }

    @Override
    public void readValue(Task task, DependencyParameter dp, boolean isConcurrent, GraphHandler gh) {
        if (this.concurrentReaders.isEmpty() || isConcurrent) {
            this.readDependency(task, dp, gh);
        } else {
            this.concurrentDependency(task, dp, gh);
        }
    }

    private void readDependency(Task task, DependencyParameter dp, GraphHandler gh) {
        int dataId = dp.getDataAccessId().getDataId();
        if (this.lastWriter != null && this.lastWriter != task) {
            CommutativeGroupTask commutativeGroup;
            if (DEBUG) {
                LOGGER.debug("Last writer for datum " + dataId + " is task " + this.lastWriter.getId());
                LOGGER.debug("Adding dependency between task " + this.lastWriter.getId() + " and task " + task.getId());
            }
            if (this.lastWriter instanceof Task && (commutativeGroup = ((Task)this.lastWriter).getCommutativeGroup(dp.getDataAccessId().getDataId())) != null) {
                task.addDataDependency(commutativeGroup, dp);
            }
            task.addDataDependency(this.lastWriter, dp);
        } else {
            if (DEBUG) {
                LOGGER.debug("There is no last writer for datum " + dataId);
            }
            task.registerFreeParam(dp);
        }
        if (IS_DRAW_GRAPH) {
            gh.drawEdges(task, dp, this.lastWriter);
            gh.checkIfPreviousGroupInGraph(dataId);
        }
    }

    private void concurrentDependency(Task task, DependencyParameter dp, GraphHandler gh) {
        int dataId = dp.getDataAccessId().getDataId();
        if (!this.concurrentReaders.contains(task)) {
            if (DEBUG) {
                LOGGER.debug("There was a concurrent access for datum " + dataId);
                LOGGER.debug("Adding dependency between concurrent list and task " + task.getId());
            }
            for (AbstractTask abstractTask : this.concurrentReaders) {
                task.addDataDependency(abstractTask, dp);
                if (!IS_DRAW_GRAPH) continue;
                gh.drawEdges(task, dp, abstractTask);
            }
        } else {
            if (DEBUG) {
                LOGGER.debug("There is no last writer for datum " + dataId);
            }
            task.registerFreeParam(dp);
            if (IS_DRAW_GRAPH) {
                gh.drawEdges(task, dp, null);
            }
        }
    }

    @Override
    public void writeValue(AbstractTask t, DependencyParameter dp, boolean isConcurrent, GraphHandler gh) {
        if (isConcurrent) {
            this.concurrentReaders.add((Task)t);
        } else {
            int dataId = dp.getDataAccessId().getDataId();
            LOGGER.info("Setting writer for data " + dataId);
            this.lastWriter = t;
            this.concurrentReaders.clear();
        }
    }

    @Override
    public void mainAccess(RegisterDataAccessRequest rdar, GraphHandler gh, int dataId, int dataVersion) {
        if (this.lastWriter != null) {
            if (IS_DRAW_GRAPH) {
                gh.addEdgeFromTaskToMain(this.lastWriter, EdgeType.DATA_DEPENDENCY, dataId, dataVersion);
            }
            if (this.lastWriter.isPending()) {
                this.lastWriter.addListener(rdar);
                rdar.addPendingOperation();
                if (rdar.getTaskAccessMode() == AccessParams.AccessMode.RW) {
                    this.lastWriter = null;
                }
            }
        }
        for (AbstractTask abstractTask : this.concurrentReaders) {
            if (IS_DRAW_GRAPH) {
                gh.addEdgeFromTaskToMain(abstractTask, EdgeType.DATA_DEPENDENCY, dataId, dataVersion);
            }
            if (abstractTask == null || !abstractTask.isPending()) continue;
            abstractTask.addListener(rdar);
            rdar.addPendingOperation();
        }
        this.concurrentReaders.clear();
    }

    @Override
    public boolean isFinalProducer(Task t) {
        return this.concurrentReaders.isEmpty() && this.lastWriter == t;
    }

    @Override
    public String toStringDetails() {
        StringBuilder sb = new StringBuilder();
        sb.append("concurrentReaders = [");
        for (AbstractTask abstractTask : this.concurrentReaders) {
            sb.append(abstractTask.getId()).append(" ");
        }
        sb.append("], ");
        sb.append("dataWriter = ").append(this.lastWriter != null ? Integer.valueOf(this.lastWriter.getId()) : "null");
        return sb.toString();
    }

    @Override
    public List<AbstractTask> getDataWriters() {
        LinkedList<AbstractTask> writers = new LinkedList<AbstractTask>();
        if (this.lastWriter != null) {
            writers.add(this.lastWriter);
        }
        return writers;
    }
}

