/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.types.implementations.definition;

import es.bsc.compss.types.CollectionLayout;
import es.bsc.compss.types.implementations.MethodType;
import es.bsc.compss.types.implementations.TaskType;
import es.bsc.compss.types.implementations.definition.AbstractMethodImplementationDefinition;
import es.bsc.compss.util.EnvironmentLoader;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.List;

public class PythonMPIDefinition
implements AbstractMethodImplementationDefinition {
    private static final long serialVersionUID = 1L;
    public static final int NUM_PARAMS = 8;
    private String declaringClass;
    private String methodName;
    private String mpiRunner;
    private String workingDir;
    private String mpiFlags;
    private boolean scaleByCU;
    private boolean failByEV;
    private CollectionLayout[] cls;

    public PythonMPIDefinition() {
    }

    public PythonMPIDefinition(String methodClass, String altMethodName, String workingDir, String mpiRunner, String mpiFlags, boolean scaleByCU, boolean failByEV, CollectionLayout[] cls) {
        this.declaringClass = methodClass;
        this.methodName = altMethodName;
        this.mpiRunner = mpiRunner;
        this.workingDir = workingDir;
        this.mpiFlags = mpiFlags;
        this.scaleByCU = scaleByCU;
        this.failByEV = failByEV;
        this.cls = cls;
    }

    public PythonMPIDefinition(String[] implTypeArgs, int offset) {
        this.declaringClass = EnvironmentLoader.loadFromEnvironment(implTypeArgs[offset]);
        this.methodName = EnvironmentLoader.loadFromEnvironment(implTypeArgs[offset + 1]);
        if (this.declaringClass == null || this.declaringClass.isEmpty()) {
            throw new IllegalArgumentException("Empty declaringClass annotation for PythonMPI " + this.methodName);
        }
        if (this.methodName == null || this.methodName.isEmpty()) {
            throw new IllegalArgumentException("Empty methodName annotation for method PythonMPI" + this.declaringClass);
        }
        this.workingDir = EnvironmentLoader.loadFromEnvironment(implTypeArgs[offset + 2]);
        this.mpiRunner = EnvironmentLoader.loadFromEnvironment(implTypeArgs[offset + 3]);
        this.mpiFlags = EnvironmentLoader.loadFromEnvironment(implTypeArgs[offset + 4]);
        this.scaleByCU = Boolean.parseBoolean(implTypeArgs[offset + 5]);
        this.failByEV = Boolean.parseBoolean(implTypeArgs[offset + 6]);
        int numLayouts = Integer.parseInt(implTypeArgs[offset + 7]);
        this.cls = new CollectionLayout[numLayouts];
        for (int i = 0; i < numLayouts; ++i) {
            int index = offset + 8 + i * 4;
            String pythonMPILayoutParam = EnvironmentLoader.loadFromEnvironment(implTypeArgs[index]);
            int pythonMPIBlockSize = Integer.parseInt(EnvironmentLoader.loadFromEnvironment(implTypeArgs[index + 1]));
            int pythonMPIBlockLen = Integer.parseInt(EnvironmentLoader.loadFromEnvironment(implTypeArgs[index + 2]));
            int pythonMPIBlockStride = Integer.parseInt(EnvironmentLoader.loadFromEnvironment(implTypeArgs[index + 3]));
            this.cls[i] = new CollectionLayout(pythonMPILayoutParam, pythonMPIBlockSize, pythonMPIBlockLen, pythonMPIBlockStride);
        }
    }

    @Override
    public void appendToArgs(List<String> lArgs, String auxParam) {
        lArgs.add(this.declaringClass);
        lArgs.add(this.methodName);
        lArgs.add(this.workingDir);
        lArgs.add(this.mpiRunner);
        lArgs.add(this.mpiFlags);
        lArgs.add(Boolean.toString(this.scaleByCU));
        lArgs.add(Boolean.toString(this.failByEV));
        lArgs.add(Integer.toString(this.cls.length));
        for (CollectionLayout cl : this.cls) {
            lArgs.add(cl.getParamName());
            lArgs.add(Integer.toString(cl.getBlockCount()));
            lArgs.add(Integer.toString(cl.getBlockLen()));
            lArgs.add(Integer.toString(cl.getBlockStride()));
        }
    }

    public String getDeclaringClass() {
        return this.declaringClass;
    }

    public String getAlternativeMethodName() {
        return this.methodName;
    }

    public void setAlternativeMethodName(String alternativeMethod) {
        this.methodName = alternativeMethod;
    }

    public String getWorkingDir() {
        return this.workingDir;
    }

    public String getMpiRunner() {
        return this.mpiRunner;
    }

    public String getMpiFlags() {
        return this.mpiFlags;
    }

    public boolean getScaleByCU() {
        return this.scaleByCU;
    }

    public boolean isFailByEV() {
        return this.failByEV;
    }

    public CollectionLayout[] getCollectionLayouts() {
        return this.cls;
    }

    @Override
    public MethodType getMethodType() {
        return MethodType.PYTHON_MPI;
    }

    @Override
    public String toMethodDefinitionFormat() {
        StringBuilder sb = new StringBuilder();
        sb.append("[DECLARING CLASS=").append(this.declaringClass);
        sb.append(", METHOD NAME=").append(this.methodName);
        sb.append(", MPI RUNNER=").append(this.mpiRunner);
        sb.append(", MPI FLAGS=").append(this.mpiFlags);
        sb.append(", SCALE_BY_CU=").append(this.scaleByCU);
        sb.append(", FAIL_BY_EV=").append(this.failByEV);
        sb.append(", Collection Layouts=").append(this.cls.length);
        return sb.toString();
    }

    @Override
    public String toShortFormat() {
        return super.toString() + " Python MPI Method declared in class " + this.declaringClass + "." + this.methodName + " with MPIrunner " + this.mpiRunner;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("PYTHON MPI Implementation \n");
        sb.append("\t Declaring class: ").append(this.declaringClass).append("\n");
        sb.append("\t Method name: ").append(this.methodName).append("\n");
        sb.append("\t MPI runner: ").append(this.mpiRunner).append("\n");
        sb.append("\t MPI flags: ").append(this.mpiFlags).append("\n");
        sb.append("\t Working directory: ").append(this.workingDir).append("\n");
        sb.append("\t Scale by Computing Units: ").append(this.scaleByCU).append("\n");
        sb.append("\t Fail by EV: ").append(this.failByEV).append("\n");
        sb.append("\t Collection Layouts: ").append("\n");
        for (CollectionLayout cl : this.cls) {
            sb.append("\t\t").append(cl).append("\n");
        }
        return sb.toString();
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.declaringClass = (String)in.readObject();
        this.methodName = (String)in.readObject();
        this.mpiRunner = (String)in.readObject();
        this.mpiFlags = (String)in.readObject();
        this.workingDir = (String)in.readObject();
        this.scaleByCU = in.readBoolean();
        this.failByEV = in.readBoolean();
        this.cls = (CollectionLayout[])in.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.declaringClass);
        out.writeObject(this.methodName);
        out.writeObject(this.mpiRunner);
        out.writeObject(this.mpiFlags);
        out.writeObject(this.workingDir);
        out.writeBoolean(this.scaleByCU);
        out.writeBoolean(this.failByEV);
        out.writeObject(this.cls);
    }

    @Override
    public TaskType getTaskType() {
        return TaskType.METHOD;
    }
}

